/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaQuery
extends Query {
    protected transient Extent candidateExtent = null;
    protected transient Collection candidateCollection = null;
    protected String singleString = null;

    public AbstractJavaQuery(ExecutionContext ec) {
        super(ec);
    }

    @Override
    public void setCandidates(Extent pcs) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (pcs == null) {
            NucleusLogger.QUERY.warn(LOCALISER.msg("021073"));
            return;
        }
        this.setSubclasses(pcs.hasSubclasses());
        this.setClass(pcs.getCandidateClass());
        this.candidateExtent = pcs;
        this.candidateCollection = null;
    }

    @Override
    public void setCandidates(Collection pcs) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (pcs == null) {
            NucleusLogger.QUERY.warn(LOCALISER.msg("021072"));
            return;
        }
        this.candidateExtent = null;
        this.candidateCollection = pcs;
    }

    public Extent getCandidateExtent() {
        return this.candidateExtent;
    }

    public Collection getCandidateCollection() {
        return this.candidateCollection;
    }

    @Override
    protected void discardCompiled() {
        super.discardCompiled();
        this.singleString = null;
    }

    @Override
    protected long performDeletePersistentAll(Map parameters) {
        if (this.candidateCollection != null && this.candidateCollection.isEmpty()) {
            return 0L;
        }
        return super.performDeletePersistentAll(parameters);
    }

    public abstract String getSingleStringQuery();

    public String toString() {
        return this.getSingleStringQuery();
    }

    protected boolean evaluateInMemory() {
        return this.getBooleanExtensionProperty("datanucleus.query.evaluateInMemory", false);
    }

    @Override
    public Set<String> getSupportedExtensions() {
        Set<String> supported = super.getSupportedExtensions();
        supported.add("datanucleus.query.evaluateInMemory");
        return supported;
    }
}

