/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.Map;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.JPQLSingleStringParser;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.JPQLCompiler;
import org.datanucleus.query.compiler.JavaQueryCompiler;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractJPQLQuery
extends AbstractJavaQuery {
    public AbstractJPQLQuery(ExecutionContext ec) {
        super(ec);
    }

    public AbstractJPQLQuery(ExecutionContext ec, AbstractJPQLQuery q) {
        super(ec);
        this.candidateClass = q != null ? q.candidateClass : null;
        this.candidateClassName = q != null ? q.candidateClassName : null;
        this.filter = q != null ? q.filter : null;
        this.imports = q != null ? q.imports : null;
        this.explicitVariables = q != null ? this.explicitVariables : null;
        this.explicitParameters = q != null ? this.explicitParameters : null;
        this.grouping = q != null ? q.grouping : null;
        this.ordering = q != null ? q.ordering : null;
        this.result = q != null ? q.result : null;
        this.resultClass = q != null ? q.resultClass : null;
        this.resultDistinct = q != null ? q.resultDistinct : false;
        this.range = q != null ? q.range : null;
        this.fromInclNo = q != null ? q.fromInclNo : 0L;
        this.toExclNo = q != null ? q.toExclNo : Long.MAX_VALUE;
        this.fromInclParam = q != null ? q.fromInclParam : null;
        String string = this.toExclParam = q != null ? q.toExclParam : null;
        if (q != null) {
            this.ignoreCache = q.ignoreCache;
        }
    }

    public AbstractJPQLQuery(ExecutionContext ec, String query) {
        super(ec);
        new JPQLSingleStringParser(this, query).parse();
    }

    public void setResult(String result) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (result == null) {
            this.result = null;
            this.resultDistinct = false;
            return;
        }
        String str = result.trim();
        if (str.toUpperCase().startsWith("DISTINCT ")) {
            this.resultDistinct = true;
            this.result = str.substring(8).trim();
        } else {
            this.resultDistinct = false;
            this.result = str;
        }
    }

    public String getSingleStringQuery() {
        if (this.singleString != null) {
            return this.singleString;
        }
        StringBuffer str = new StringBuffer();
        if (this.type == 1) {
            str.append("UPDATE " + this.from + " SET " + this.update + " ");
        } else if (this.type == 2) {
            str.append("DELETE ");
        } else {
            str.append("SELECT ");
        }
        if (this.result != null) {
            if (this.resultDistinct) {
                str.append("DISTINCT ");
            }
            str.append(this.result + " ");
        } else if (this.compilation != null && this.compilation.getCandidateAlias() != null) {
            str.append(this.compilation.getCandidateAlias() + " ");
        }
        if (this.from != null && this.update == null) {
            str.append("FROM " + this.from + " ");
        }
        if (this.filter != null) {
            str.append("WHERE " + this.filter + " ");
        }
        if (this.grouping != null) {
            str.append("GROUP BY " + this.grouping + " ");
        }
        if (this.having != null) {
            str.append("HAVING " + this.having + " ");
        }
        if (this.ordering != null) {
            str.append("ORDER BY " + this.ordering + " ");
        }
        this.singleString = str.toString().trim();
        return this.singleString;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        QueryCompilation cachedCompilation;
        if (this.compilation != null) {
            return;
        }
        QueryManager queryMgr = this.getQueryManager();
        if (this.useCaching() && (cachedCompilation = queryMgr.getQueryCompilationForQuery(this.getLanguage(), this.toString())) != null) {
            this.compilation = cachedCompilation;
            if (this.compilation.getExprResult() == null) {
                this.result = null;
            }
            this.checkParameterTypesAgainstCompilation(parameterValues);
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug(LOCALISER.msg("021044", (Object)this.getLanguage(), (Object)this.getSingleStringQuery()));
        }
        JPQLCompiler compiler = new JPQLCompiler(this.ec.getMetaDataManager(), this.ec.getClassLoaderResolver(), this.from, this.candidateClass, this.candidateCollection, this.filter, this.getParsedImports(), this.ordering, this.result, this.grouping, this.having, this.explicitParameters, this.update);
        this.compilation = ((JavaQueryCompiler)compiler).compile(parameterValues, this.subqueries);
        if (QueryUtils.queryReturnsSingleRow(this)) {
            this.compilation.setReturnsSingleRow();
        }
        if (this.compilation.getExprResult() == null) {
            this.result = null;
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(LOCALISER.msg("021045", (Object)this.getLanguage(), (Object)("" + (System.currentTimeMillis() - startTime))));
        }
        if (this.subqueries != null) {
            for (Map.Entry entry : this.subqueries.entrySet()) {
                Query.SubqueryDefinition subqueryDefinition = (Query.SubqueryDefinition)entry.getValue();
                Query subquery = subqueryDefinition.getQuery();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    NucleusLogger.QUERY.debug(LOCALISER.msg("021044", (Object)this.getLanguage(), (Object)((AbstractJPQLQuery)subquery).getSingleStringQuery()));
                }
                JPQLCompiler subCompiler = new JPQLCompiler(this.ec.getMetaDataManager(), this.ec.getClassLoaderResolver(), subquery.from, subquery.candidateClass, null, subquery.filter, this.getParsedImports(), subquery.ordering, subquery.result, subquery.grouping, subquery.having, null, null);
                subCompiler.setLinkToParentQuery(compiler, null);
                QueryCompilation subqueryCompilation = ((JavaQueryCompiler)subCompiler).compile(parameterValues, null);
                this.compilation.addSubqueryCompilation((String)entry.getKey(), subqueryCompilation);
                if (!NucleusLogger.QUERY.isDebugEnabled()) continue;
                NucleusLogger.QUERY.debug(LOCALISER.msg("021045", (Object)this.getLanguage(), (Object)("" + (System.currentTimeMillis() - startTime))));
            }
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(this.compilation.toString());
        }
        if (this.implicitParameters != null) {
            for (Object paramKey : this.implicitParameters.keySet()) {
                String paramName = "" + paramKey;
                this.applyImplicitParameterValueToCompilation(paramName, this.implicitParameters.get(paramName));
            }
        }
        this.checkParameterTypesAgainstCompilation(parameterValues);
        if (this.useCaching()) {
            queryMgr.addQueryCompilation(this.getLanguage(), this.toString(), this.compilation);
        }
    }

    public Class resolveClassDeclaration(String classDecl) {
        AbstractClassMetaData acmd = this.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForEntityName(classDecl);
        if (acmd != null) {
            classDecl = acmd.getFullClassName();
        }
        return super.resolveClassDeclaration(classDecl);
    }

    public String getLanguage() {
        return "JPQL";
    }
}

