/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractSetStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.ClassUtils;

public abstract class MapValueSetStore
extends AbstractSetStore {
    protected final MapStore mapStore;
    protected final JavaTypeMapping keyMapping;

    public MapValueSetStore(DatastoreContainerObject mapTable, AbstractMemberMetaData ownerMmd, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr, AbstractSetStoreSpecialization specialization) {
        super((StoreManager)mapTable.getStoreManager(), clr, specialization);
        this.containerTable = mapTable;
        this.mapStore = mapStore;
        this.ownerMapping = ownerMapping;
        this.keyMapping = keyMapping;
        this.elementMapping = valueMapping;
        this.elementType = this.elementMapping.getType();
        this.ownerMemberMetaData = ownerMmd;
        this.initialize(clr);
    }

    public MapValueSetStore(DatastoreClass mapTable, AbstractMemberMetaData ownerMmd, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr, AbstractSetStoreSpecialization specialization) {
        super((StoreManager)mapTable.getStoreManager(), clr, specialization);
        this.containerTable = mapTable;
        this.mapStore = mapStore;
        this.ownerMapping = ownerMapping;
        this.keyMapping = null;
        this.elementMapping = valueMapping;
        this.ownerMemberMetaData = ownerMmd;
        this.initialize(clr);
    }

    private void initialize(ClassLoaderResolver clr) {
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        Class valueCls = clr.classForName(this.elementType);
        this.emd = ClassUtils.isReferenceType(valueCls) ? this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(valueCls, null, clr) : this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(valueCls, clr);
        if (this.emd != null) {
            this.elementType = this.emd.getFullClassName();
            this.elementInfo = this.getElementInformationForClass();
        }
    }

    public boolean add(ObjectProvider sm, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its values collection");
    }

    public boolean addAll(ObjectProvider sm, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its values collection");
    }

    public boolean remove(ObjectProvider sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        return this.remove(sm, element);
    }

    public boolean removeAll(ObjectProvider sm, Collection elements, int size) {
        throw new NucleusUserException("Cannot remove values from a map through its values collection");
    }

    public void clear(ObjectProvider sm) {
        if (this.canClear()) {
            throw new NucleusUserException("Cannot clear a map through its values collection");
        }
        super.clear(sm);
    }

    protected abstract boolean canClear();

    protected abstract boolean remove(ObjectProvider var1, Object var2);

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier setRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar, boolean existsQuery) {
        throw new NucleusUserException("Cannot query sets obtained by Map.values()");
    }
}

