/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.SCOID;
import org.datanucleus.management.ManagementManager;
import org.datanucleus.management.ManagementServer;
import org.datanucleus.management.runtime.StoreManagerRuntime;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.store.DefaultCandidateExtent;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusConnectionImpl;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.NucleusSequenceImpl;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler2;
import org.datanucleus.store.autostart.AutoStartMechanism;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ConnectionManagerImpl;
import org.datanucleus.store.connection.DecryptionProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.DatastoreInitialisationException;
import org.datanucleus.store.exceptions.DatastoreReadOnlyException;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStoreManager
implements StoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final String storeManagerKey;
    protected final boolean readOnlyDatastore;
    protected final boolean fixedDatastore;
    protected AutoStartMechanism starter = null;
    protected boolean starterInitialised = false;
    protected final OMFContext omfContext;
    protected final ValueGenerationManager valueGenerationMgr;
    protected StoreManagerRuntime storeManagerRuntime;
    protected StoreDataManager storeDataMgr = new StoreDataManager();
    protected String autoStartMechanism = null;
    protected StorePersistenceHandler2 persistenceHandler2 = null;
    protected StoreSchemaHandler schemaHandler = null;
    protected ConnectionManager connectionMgr;
    protected String txConnectionFactoryName;
    protected String nontxConnectionFactoryName;

    protected AbstractStoreManager(String key, ClassLoaderResolver clr, OMFContext omfContext) {
        this.storeManagerKey = key;
        this.omfContext = omfContext;
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        this.readOnlyDatastore = conf.getBooleanProperty("datanucleus.readOnlyDatastore");
        this.fixedDatastore = conf.getBooleanProperty("datanucleus.fixedDatastore");
        this.autoStartMechanism = conf.getStringProperty("datanucleus.autoStartMechanism");
        this.registerConnectionMgr();
        omfContext.setStoreManager(this);
        this.valueGenerationMgr = new ValueGenerationManager();
        if (omfContext.getJMXManager() != null) {
            ManagementManager mgmtMgr = omfContext.getJMXManager();
            ManagementServer mgntServer = omfContext.getJMXManager().getManagementServer();
            this.storeManagerRuntime = new StoreManagerRuntime();
            String mbeanName = mgmtMgr.getDomainName() + ":InstanceName=" + mgmtMgr.getInstanceName() + ",Type=" + ClassUtils.getClassNameForClass(this.storeManagerRuntime.getClass()) + ",Name=StoreManagerRuntime";
            mgntServer.registerMBean(this.storeManagerRuntime, mbeanName);
        }
        this.registerConnectionFactory();
    }

    protected void registerConnectionMgr() {
        this.connectionMgr = new ConnectionManagerImpl(this.omfContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void registerConnectionFactory() {
        ConnectionFactory cf;
        ConfigurationElement cfElem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "true"});
        if (cfElem == null) throw new NucleusException("Error creating transactional connection factory. No connection factory plugin defined");
        this.txConnectionFactoryName = cfElem.getAttribute("name");
        try {
            cf = (ConnectionFactory)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "true"}, "class-name", new Class[]{OMFContext.class, String.class}, new Object[]{this.omfContext, "tx"});
            this.connectionMgr.registerConnectionFactory(this.txConnectionFactoryName, cf);
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug(LOCALISER.msg("032018", (Object)this.txConnectionFactoryName));
            }
        }
        catch (Exception e) {
            throw new NucleusException("Error creating transactional connection factory", e).setFatal();
        }
        cfElem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "false"});
        if (cfElem == null) return;
        this.nontxConnectionFactoryName = cfElem.getAttribute("name");
        try {
            cf = (ConnectionFactory)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "false"}, "class-name", new Class[]{OMFContext.class, String.class}, new Object[]{this.omfContext, "nontx"});
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug(LOCALISER.msg("032019", (Object)this.nontxConnectionFactoryName));
            }
            this.connectionMgr.registerConnectionFactory(this.nontxConnectionFactoryName, cf);
            return;
        }
        catch (Exception e) {
            throw new NucleusException("Error creating nontransactional connection factory", e).setFatal();
        }
    }

    @Override
    public void close() {
        this.valueGenerationMgr.clear();
        this.storeDataMgr.clear();
        this.starterInitialised = false;
        this.starter = null;
        if (this.persistenceHandler2 != null) {
            this.persistenceHandler2.close();
            this.persistenceHandler2 = null;
        }
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionMgr;
    }

    @Override
    public ManagedConnection getConnection(ExecutionContext ec) {
        ConnectionFactory connFactory = ec.getTransaction().isActive() ? this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName) : (this.nontxConnectionFactoryName != null ? this.connectionMgr.lookupConnectionFactory(this.nontxConnectionFactoryName) : this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName));
        return connFactory.getConnection(ec, ec.getTransaction(), null);
    }

    @Override
    public ManagedConnection getConnection(ExecutionContext ec, Map options) {
        ConnectionFactory connFactory = ec.getTransaction().isActive() ? this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName) : (this.nontxConnectionFactoryName != null ? this.connectionMgr.lookupConnectionFactory(this.nontxConnectionFactoryName) : this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName));
        return connFactory.getConnection(ec, ec.getTransaction(), options);
    }

    public ManagedConnection getConnection(int isolation_level) {
        ConnectionFactory connFactory = this.connectionMgr.lookupConnectionFactory(this.nontxConnectionFactoryName);
        HashMap<String, Integer> options = null;
        if (isolation_level >= 0) {
            options = new HashMap<String, Integer>();
            options.put("transaction.isolation", isolation_level);
        }
        return connFactory.getConnection(null, null, options);
    }

    @Override
    public String getConnectionDriverName() {
        return this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionDriverName");
    }

    @Override
    public String getConnectionURL() {
        return this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionURL");
    }

    @Override
    public String getConnectionUserName() {
        return this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionUserName");
    }

    @Override
    public String getConnectionPassword() {
        String decrypterName;
        PersistenceConfiguration conf = this.omfContext.getPersistenceConfiguration();
        String password = conf.getStringProperty("datanucleus.ConnectionPassword");
        if (password != null && (decrypterName = conf.getStringProperty("datanucleus.ConnectionPasswordDecrypter")) != null) {
            ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(null);
            try {
                Class decrypterCls = clr.classForName(decrypterName);
                DecryptionProvider decrypter = (DecryptionProvider)decrypterCls.newInstance();
                password = decrypter.decrypt(password);
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE.warn("Error invoking decrypter class " + decrypterName, e);
            }
        }
        return password;
    }

    @Override
    public Object getConnectionFactory() {
        return this.omfContext.getPersistenceConfiguration().getProperty("datanucleus.ConnectionFactory");
    }

    @Override
    public String getConnectionFactoryName() {
        return this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionFactoryName");
    }

    @Override
    public Object getConnectionFactory2() {
        return this.omfContext.getPersistenceConfiguration().getProperty("datanucleus.ConnectionFactory");
    }

    @Override
    public String getConnectionFactory2Name() {
        return this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionFactory2Name");
    }

    @Override
    public StoreManagerRuntime getRuntimeManager() {
        return this.storeManagerRuntime;
    }

    @Override
    public StorePersistenceHandler2 getPersistenceHandler() {
        return this.persistenceHandler2;
    }

    @Override
    public StoreSchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    @Override
    public NucleusSequence getNucleusSequence(ExecutionContext ec, SequenceMetaData seqmd) {
        return new NucleusSequenceImpl(ec, this, seqmd);
    }

    @Override
    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        ConnectionFactory cf = this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName);
        final boolean enlisted = ec.getTransaction().isActive();
        final ManagedConnection mc = cf.getConnection(enlisted ? ec : null, enlisted ? ec.getTransaction() : null, null);
        mc.lock();
        Runnable closeRunnable = new Runnable(){

            public void run() {
                mc.unlock();
                if (!enlisted) {
                    mc.close();
                }
            }
        };
        return new NucleusConnectionImpl(mc.getConnection(), closeRunnable);
    }

    @Override
    public ValueGenerationManager getValueGenerationManager() {
        return this.valueGenerationMgr;
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.omfContext.getApiAdapter();
    }

    @Override
    public String getStoreManagerKey() {
        return this.storeManagerKey;
    }

    @Override
    public String getQueryCacheKey() {
        return this.getStoreManagerKey();
    }

    @Override
    public OMFContext getOMFContext() {
        return this.omfContext;
    }

    public MetaDataManager getMetaDataManager() {
        return this.omfContext.getMetaDataManager();
    }

    @Override
    public Date getDatastoreDate() {
        throw new UnsupportedOperationException();
    }

    protected void registerStoreData(StoreData data) {
        this.storeDataMgr.registerStoreData(data);
        if (this.starter != null && this.starterInitialised) {
            this.starter.addClass(data);
        }
    }

    protected void deregisterAllStoreData() {
        this.storeDataMgr.clear();
        this.starterInitialised = false;
        this.clearAutoStarter();
    }

    protected void logConfiguration() {
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            PersistenceConfiguration conf = this.omfContext.getPersistenceConfiguration();
            NucleusLogger.DATASTORE.debug("======================= Datastore =========================");
            NucleusLogger.DATASTORE.debug("StoreManager : \"" + this.storeManagerKey + "\" (" + this.getClass().getName() + ")");
            if (this.autoStartMechanism != null) {
                String classNames = conf.getStringProperty("datanucleus.autoStartClassNames");
                NucleusLogger.DATASTORE.debug("AutoStart : mechanism=" + this.autoStartMechanism + ", mode=" + conf.getStringProperty("datanucleus.autoStartMechanismMode") + (classNames != null ? ", classes=" + classNames : ""));
            }
            String url = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionURL");
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("032020", (Object)this.storeManagerKey, (Object)url, (Object)(this.readOnlyDatastore ? "read-only" : "read-write"), (Object)(this.fixedDatastore ? ", fixed" : "")));
            Object[] queryLanguages = this.omfContext.getPluginManager().getAttributeValuesForExtension("org.datanucleus.store_query_query", "datastore", this.storeManagerKey, "name");
            NucleusLogger.DATASTORE.debug("Query Languages : " + (queryLanguages != null ? StringUtils.objectArrayToString(queryLanguages) : "none"));
            NucleusLogger.DATASTORE.debug("===========================================================");
        }
    }

    @Override
    public void printInformation(String category, PrintStream ps) throws Exception {
        if (category.equalsIgnoreCase("DATASTORE")) {
            String url = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionURL");
            ps.println(LOCALISER.msg("032020", (Object)this.storeManagerKey, (Object)url, (Object)(this.readOnlyDatastore ? "read-only" : "read-write"), (Object)(this.fixedDatastore ? ", fixed" : "")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseAutoStart(ClassLoaderResolver clr) throws DatastoreInitialisationException {
        if (this.starterInitialised) {
            return;
        }
        if (this.autoStartMechanism == null) {
            this.autoStartMechanism = "None";
            this.starterInitialised = true;
            return;
        }
        String autoStarterClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.autostart", "name", this.autoStartMechanism, "class-name");
        if (autoStarterClassName != null) {
            String mode = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.autoStartMechanismMode");
            Class[] argsClass = new Class[]{StoreManager.class, ClassLoaderResolver.class};
            Object[] args = new Object[]{this, clr};
            try {
                this.starter = (AutoStartMechanism)this.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.autostart", "name", this.autoStartMechanism, "class-name", argsClass, args);
                if (mode.equalsIgnoreCase("None")) {
                    this.starter.setMode(AutoStartMechanism.Mode.NONE);
                } else if (mode.equalsIgnoreCase("Checked")) {
                    this.starter.setMode(AutoStartMechanism.Mode.CHECKED);
                } else if (mode.equalsIgnoreCase("Quiet")) {
                    this.starter.setMode(AutoStartMechanism.Mode.QUIET);
                } else if (mode.equalsIgnoreCase("Ignored")) {
                    this.starter.setMode(AutoStartMechanism.Mode.IGNORED);
                }
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.error(StringUtils.getStringFromStackTrace(e));
            }
        }
        if (this.starter == null) {
            this.starterInitialised = true;
            return;
        }
        boolean illegalState = false;
        try {
            Collection existingData;
            if (!this.starter.isOpen()) {
                this.starter.open();
            }
            if ((existingData = this.starter.getAllClassData()) != null && existingData.size() > 0) {
                ArrayList<String> classesNeedingAdding = new ArrayList<String>();
                for (StoreData data : existingData) {
                    Class classFound;
                    block35: {
                        if (!data.isFCO()) continue;
                        classFound = null;
                        try {
                            classFound = clr.classForName(data.getName());
                        }
                        catch (ClassNotResolvedException cnre) {
                            if (data.getInterfaceName() == null) break block35;
                            try {
                                this.getOMFContext().getImplementationCreator().newInstance(clr.classForName(data.getInterfaceName()), clr);
                                classFound = clr.classForName(data.getName());
                            }
                            catch (ClassNotResolvedException cnre2) {
                                // empty catch block
                            }
                        }
                    }
                    if (classFound != null) {
                        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("032003", (Object)data.getName()));
                        classesNeedingAdding.add(data.getName());
                        if (data.getMetaData() != null) continue;
                        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(classFound, clr);
                        if (acmd != null) {
                            data.setMetaData(acmd);
                            continue;
                        }
                        String msg = LOCALISER.msg("034004", (Object)data.getName());
                        if (this.starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                            NucleusLogger.PERSISTENCE.error(msg);
                            throw new DatastoreInitialisationException(msg);
                        }
                        if (this.starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                            NucleusLogger.PERSISTENCE.warn(msg);
                            continue;
                        }
                        if (this.starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                        NucleusLogger.PERSISTENCE.warn(msg);
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034001", (Object)data.getName()));
                        this.starter.deleteClass(data.getName());
                        continue;
                    }
                    String msg = LOCALISER.msg("034000", (Object)data.getName());
                    if (this.starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new DatastoreInitialisationException(msg);
                    }
                    if (this.starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                        NucleusLogger.PERSISTENCE.warn(msg);
                        continue;
                    }
                    if (this.starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                    NucleusLogger.PERSISTENCE.warn(msg);
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034001", (Object)data.getName()));
                    this.starter.deleteClass(data.getName());
                }
                String[] classesToLoad = new String[classesNeedingAdding.size()];
                Iterator classesNeedingAddingIter = classesNeedingAdding.iterator();
                int n = 0;
                while (classesNeedingAddingIter.hasNext()) {
                    classesToLoad[n++] = (String)classesNeedingAddingIter.next();
                }
                try {
                    this.addClasses(classesToLoad, clr);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034002", e));
                    illegalState = true;
                }
            }
            Object var12_17 = null;
            if (this.starter.isOpen()) {
                this.starter.close();
            }
            if (illegalState) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034003"));
                this.starter = null;
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (this.starter.isOpen()) {
                this.starter.close();
            }
            if (illegalState) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034003"));
                this.starter = null;
            }
            throw throwable;
        }
        this.starterInitialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAutoStarter() {
        if (this.starter != null) {
            try {
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                this.starter.deleteAllClasses();
                Object var2_1 = null;
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
                throw throwable;
            }
        }
    }

    @Override
    public boolean managesClass(String className) {
        return this.storeDataMgr.managesClass(className);
    }

    @Override
    public void addClass(String className, ClassLoaderResolver clr) {
        this.addClasses(new String[]{className}, clr);
    }

    @Override
    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getOMFContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData classMetaData : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (classMetaData.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return;
            }
            StoreData sd = this.storeDataMgr.get(classMetaData.getFullClassName());
            if (sd != null) continue;
            this.registerStoreData(this.newStoreData(classMetaData, clr));
        }
    }

    protected StoreData newStoreData(ClassMetaData cmd, ClassLoaderResolver clr) {
        return new StoreData(cmd.getFullClassName(), cmd, 1, null);
    }

    @Override
    public void removeAllClasses(ClassLoaderResolver clr) {
    }

    @Override
    public String manageClassForIdentity(Object id, ClassLoaderResolver clr) {
        String className = null;
        if (id instanceof OID) {
            className = ((OID)id).getPcClass();
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getIdentityType() != IdentityType.DATASTORE) {
                throw new NucleusUserException(LOCALISER.msg("038001", id, (Object)cmd.getFullClassName()));
            }
        } else if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            className = this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
                throw new NucleusUserException(LOCALISER.msg("038001", id, (Object)cmd.getFullClassName()));
            }
        } else {
            throw new NucleusException("StoreManager.manageClassForIdentity called for id=" + id + " yet should only be called for datastore-identity/SingleFieldIdentity");
        }
        if (!this.managesClass(className)) {
            this.addClass(className, clr);
        }
        return className;
    }

    @Override
    public Extent getExtent(ExecutionContext ec, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, ec.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        if (!this.managesClass(c.getName())) {
            this.addClass(c.getName(), ec.getClassLoaderResolver());
        }
        return new DefaultCandidateExtent(ec, c, subclasses, cmd);
    }

    @Override
    public boolean supportsQueryLanguage(String language) {
        if (language == null) {
            return false;
        }
        String name = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{language, this.storeManagerKey}, "name");
        return name != null;
    }

    @Override
    public boolean supportsValueStrategy(String strategy) {
        ConfigurationElement elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategy, "true"});
        if (elem != null) {
            return true;
        }
        elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategy, this.storeManagerKey});
        return elem != null;
    }

    @Override
    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        Iterator<AbstractClassMetaData> iter;
        if (id == null) {
            return null;
        }
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        if (id instanceof OID) {
            return ((OID)id).getPcClass();
        }
        if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            return this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
        }
        Collection<AbstractClassMetaData> cmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName());
        if (cmds != null && (iter = cmds.iterator()).hasNext()) {
            AbstractClassMetaData cmd = iter.next();
            return cmd.getFullClassName();
        }
        return null;
    }

    @Override
    public boolean isStrategyDatastoreAttributed(IdentityStrategy identityStrategy, boolean datastoreIdentityField) {
        if (identityStrategy == null) {
            return false;
        }
        return identityStrategy == IdentityStrategy.IDENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getStrategyValue(ExecutionContext ec, AbstractClassMetaData cmd, int absoluteFieldNumber) {
        AbstractMemberMetaData mmd = null;
        String fieldName = null;
        IdentityStrategy strategy = null;
        String sequence = null;
        String valueGeneratorName = null;
        TableGeneratorMetaData tableGeneratorMetaData = null;
        SequenceMetaData sequenceMetaData = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            fieldName = mmd.getFullFieldName();
            strategy = mmd.getValueStrategy();
            sequence = mmd.getSequence();
            valueGeneratorName = mmd.getValueGeneratorName();
        } else {
            fieldName = cmd.getFullClassName() + " (datastore id)";
            strategy = cmd.getIdentityMetaData().getValueStrategy();
            sequence = cmd.getIdentityMetaData().getSequence();
            valueGeneratorName = cmd.getIdentityMetaData().getValueGeneratorName();
        }
        if (valueGeneratorName != null) {
            if (strategy == IdentityStrategy.INCREMENT) {
                tableGeneratorMetaData = this.getMetaDataManager().getMetaDataForTableGenerator(ec.getClassLoaderResolver(), valueGeneratorName);
                if (tableGeneratorMetaData == null) {
                    throw new NucleusUserException(LOCALISER.msg("038005", (Object)fieldName, (Object)valueGeneratorName));
                }
            } else if (strategy == IdentityStrategy.SEQUENCE && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(ec.getClassLoaderResolver(), valueGeneratorName)) == null) {
                throw new NucleusUserException(LOCALISER.msg("038006", (Object)fieldName, (Object)valueGeneratorName));
            }
        } else if (strategy == IdentityStrategy.SEQUENCE && sequence != null && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(ec.getClassLoaderResolver(), sequence)) == null) {
            NucleusLogger.VALUEGENERATION.warn("Field " + fieldName + " has been specified to use sequence " + sequence + " but there is no <sequence> specified in the MetaData. " + "Falling back to use a sequence in the datastore with this name directly.");
        }
        String strategyName = strategy.toString();
        if (strategy.equals(IdentityStrategy.CUSTOM)) {
            strategyName = strategy.getCustomName();
        } else if (strategy.equals(IdentityStrategy.NATIVE)) {
            strategyName = this.getStrategyForNative(cmd, absoluteFieldNumber);
        }
        String generatorName = null;
        String generatorNameKeyInManager = null;
        ConfigurationElement elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategyName, "true"});
        if (elem != null) {
            generatorNameKeyInManager = generatorName = elem.getAttribute("name");
        } else {
            elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeManagerKey});
            if (elem != null) {
                generatorName = elem.getAttribute("name");
            }
        }
        if (generatorNameKeyInManager == null) {
            generatorNameKeyInManager = absoluteFieldNumber >= 0 ? mmd.getFullFieldName() : cmd.getBaseAbstractClassMetaData().getFullClassName();
        }
        ValueGenerator generator = null;
        AbstractStoreManager abstractStoreManager = this;
        synchronized (abstractStoreManager) {
            generator = this.valueGenerationMgr.getValueGenerator(generatorNameKeyInManager);
            if (generator == null) {
                if (generatorName == null) {
                    throw new NucleusUserException(LOCALISER.msg("038004", strategy));
                }
                Properties props = this.getPropertiesForGenerator(cmd, absoluteFieldNumber, ec, sequenceMetaData, tableGeneratorMetaData);
                Class cls = null;
                if (elem != null) {
                    cls = this.omfContext.getPluginManager().loadClass(elem.getExtension().getPlugin().getSymbolicName(), elem.getAttribute("class-name"));
                }
                if (cls == null) {
                    throw new NucleusException("Cannot create Value Generator for strategy " + generatorName);
                }
                generator = this.valueGenerationMgr.createValueGenerator(generatorNameKeyInManager, cls, props, this, null);
            }
        }
        Object oid = this.getStrategyValueForGenerator(generator, ec);
        if (mmd != null) {
            Object convertedValue = TypeConversionHelper.convertTo(oid, mmd.getType());
            if (convertedValue == null) {
                throw new NucleusException(LOCALISER.msg("038003", (Object)mmd.getFullFieldName(), oid)).setFatal();
            }
            oid = convertedValue;
        }
        if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
            NucleusLogger.VALUEGENERATION.debug(LOCALISER.msg("038002", (Object)fieldName, (Object)strategy, (Object)generator.getClass().getName(), oid));
        }
        return oid;
    }

    protected String getStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber) {
        return "increment";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getStrategyValueForGenerator(ValueGenerator generator, final ExecutionContext ec) {
        Object oid = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractDatastoreGenerator) {
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
                    ManagedConnection mconn;

                    public ManagedConnection retrieveConnection() {
                        this.mconn = AbstractStoreManager.this.getConnection(ec);
                        return this.mconn;
                    }

                    public void releaseConnection() {
                        this.mconn.release();
                        this.mconn = null;
                    }
                };
                ((AbstractDatastoreGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        return oid;
    }

    protected Properties getPropertiesForGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ExecutionContext ec, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        ExtensionMetaData[] extensions = null;
        if (absoluteFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            extensions = mmd.getExtensions();
        } else {
            extensions = cmd.getIdentityMetaData().getExtensions();
        }
        Properties properties = new Properties();
        properties.setProperty("class-name", cmd.getFullClassName());
        properties.put("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
        if (cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber) != null) {
            properties.setProperty("field-name", cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber).getFullFieldName());
        }
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                properties.put(extensions[i].getKey(), extensions[i].getValue());
            }
        }
        return properties;
    }

    @Override
    public void performVersionCheck(ObjectProvider sm, Object versionDatastore, VersionMetaData versionMetaData) {
        boolean valid;
        Object versionObject = sm.getTransactionalVersion();
        if (versionObject == null) {
            return;
        }
        if (versionMetaData == null) {
            NucleusLogger.PERSISTENCE.info(sm.getClassMetaData().getFullClassName() + " has no version metadata so no check of version is required, since this will not have the version flag in its table");
            return;
        }
        if (versionMetaData.getVersionStrategy() == VersionStrategy.DATE_TIME) {
            valid = ((Timestamp)versionObject).getTime() == ((Timestamp)versionDatastore).getTime();
        } else if (versionMetaData.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
            valid = ((Number)versionObject).longValue() == ((Number)versionDatastore).longValue();
        } else {
            if (versionMetaData.getVersionStrategy() == VersionStrategy.STATE_IMAGE) {
                throw new NucleusUserException(LOCALISER.msg("032017", (Object)sm.getClassMetaData().getFullClassName(), (Object)versionMetaData.getVersionStrategy()));
            }
            throw new NucleusUserException(LOCALISER.msg("032017", (Object)sm.getClassMetaData().getFullClassName(), (Object)versionMetaData.getVersionStrategy()));
        }
        if (!valid) {
            String msg = LOCALISER.msg("032016", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)("" + versionDatastore), (Object)("" + versionObject));
            NucleusLogger.PERSISTENCE.error(msg);
            throw new NucleusOptimisticException(msg, sm.getObject());
        }
    }

    @Override
    public HashSet<String> getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        HashSet<String> subclasses = new HashSet<String>();
        String[] subclassNames = this.getMetaDataManager().getSubclassesForClass(className, includeDescendents);
        if (subclassNames != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                if (!this.storeDataMgr.managesClass(subclassNames[i])) {
                    this.addClass(subclassNames[i], clr);
                }
                subclasses.add(subclassNames[i]);
            }
        }
        return subclasses;
    }

    @Override
    public void notifyObjectIsOutdated(ObjectProvider sm) {
    }

    @Override
    public Store getBackingStoreForField(ClassLoaderResolver clr, AbstractMemberMetaData fmd, Class type) {
        throw new UnsupportedOperationException("Backing stores are not supported in this datastore");
    }

    @Override
    public Collection getSupportedOptions() {
        return Collections.EMPTY_SET;
    }

    public void assertReadOnlyForUpdateOfObject(ObjectProvider op) {
        PersistenceConfiguration conf = this.getOMFContext().getPersistenceConfiguration();
        if (this.readOnlyDatastore) {
            if (conf.getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(LOCALISER.msg("032004", (Object)op.toPrintableID()), op.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("032005", (Object)op.toPrintableID()));
            }
            return;
        }
    }

    @Override
    public StorePersistenceHandler2 getPersistenceHandler2() {
        return this.persistenceHandler2;
    }
}

