/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class StateManagerFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public static StateManager newStateManagerForHollow(ExecutionContext ec, Class pcClass, Object id) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pcClass);
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollow(id, null, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForHollowPreConstructed(ExecutionContext ec, Object id, Object pc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollowPreConstructed(id, pc);
        return sm;
    }

    public static StateManager newStateManagerForHollowPopulated(ExecutionContext ec, Class pcClass, Object id, FieldValues fv) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pcClass);
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollow(id, fv, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForPersistentClean(ExecutionContext ec, Object id, Object pc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPersistentClean(id, pc);
        return sm;
    }

    public static StateManager newStateManagerForHollowPopulatedAppId(ExecutionContext ec, Class pcClass, FieldValues fv) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pcClass);
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollowAppId(fv, stateManagerInitialization.getPCClass());
        return sm;
    }

    public static StateManager newStateManagerForEmbedded(ExecutionContext ec, Object pc, boolean copyPc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForEmbedded(pc, copyPc);
        return sm;
    }

    public static StateManager newStateManagerForPersistentNew(ExecutionContext ec, Object pc, FieldValues preInsertChanges) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPersistentNew(pc, preInsertChanges);
        return sm;
    }

    public static StateManager newStateManagerForTransactionalTransient(ExecutionContext ec, Object pc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForTransactionalTransient(pc);
        return sm;
    }

    public static StateManager newStateManagerForDetached(ExecutionContext ec, Object pc, Object id, Object version) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForDetached(pc, id, version);
        return sm;
    }

    public static StateManager newStateManagerForPNewToBeDeleted(ExecutionContext ec, Object pc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPNewToBeDeleted(pc);
        return sm;
    }

    public static StateManager newStateManagerForCachedPC(ExecutionContext ec, Object id, CachedPC cachedPC) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), cachedPC.getPersistableObject().getClass());
        StateManager sm = ec.getApiAdapter().newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForCachedPC(cachedPC, id, stateManagerInitialization.getPCClass());
        return sm;
    }

    protected static class Initialization {
        protected Class pcClass;
        protected AbstractClassMetaData cmd;

        protected Initialization(ClassLoaderResolver clr, MetaDataManager mdmgr, Class pcClass) {
            if (ClassUtils.isReferenceType(pcClass)) {
                this.cmd = mdmgr.getMetaDataForImplementationOfReference(pcClass, null, clr);
                this.pcClass = clr.classForName(this.cmd.getFullClassName(), pcClass.getClassLoader(), true);
            } else {
                try {
                    this.pcClass = clr.classForName(pcClass.getName(), pcClass.getClassLoader(), true);
                    this.cmd = mdmgr.getMetaDataForClass(pcClass, clr);
                }
                catch (ClassNotResolvedException e) {
                    throw new NucleusUserException(LOCALISER.msg("026015", (Object)pcClass.getName())).setFatal();
                }
            }
            if (this.cmd == null) {
                throw new NucleusUserException(LOCALISER.msg("026012", pcClass)).setFatal();
            }
        }

        protected Class getPCClass() {
            return this.pcClass;
        }

        protected AbstractClassMetaData getClassMetaData() {
            return this.cmd;
        }
    }
}

