/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class ObjectProviderFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public static ObjectProvider newForHollow(ExecutionContext ec, Class pcClass, Object id) {
        return StateManagerFactory.newStateManagerForHollow(ec, pcClass, id).getObjectProvider();
    }

    public static ObjectProvider newForHollowPreConstructed(ExecutionContext ec, Object id, Object pc) {
        return StateManagerFactory.newStateManagerForHollowPreConstructed(ec, id, pc).getObjectProvider();
    }

    public static ObjectProvider newForHollowPopulated(ExecutionContext ec, Class pcClass, Object id, FieldValues fv) {
        return StateManagerFactory.newStateManagerForHollowPopulated(ec, pcClass, id, fv).getObjectProvider();
    }

    public static ObjectProvider newForPersistentClean(ExecutionContext ec, Object id, Object pc) {
        return StateManagerFactory.newStateManagerForPersistentClean(ec, id, pc).getObjectProvider();
    }

    public static ObjectProvider newForHollowPopulatedAppId(ExecutionContext ec, Class pcClass, FieldValues fv) {
        return StateManagerFactory.newStateManagerForHollowPopulatedAppId(ec, pcClass, fv).getObjectProvider();
    }

    public static ObjectProvider newForEmbedded(ExecutionContext ec, Object pc, boolean copyPc) {
        return StateManagerFactory.newStateManagerForEmbedded(ec, pc, copyPc).getObjectProvider();
    }

    public static ObjectProvider newForPersistentNew(ExecutionContext ec, Object pc, FieldValues preInsertChanges) {
        return StateManagerFactory.newStateManagerForPersistentNew(ec, pc, preInsertChanges).getObjectProvider();
    }

    public static ObjectProvider newForTransactionalTransient(ExecutionContext ec, Object pc) {
        return StateManagerFactory.newStateManagerForTransactionalTransient(ec, pc).getObjectProvider();
    }

    public static ObjectProvider newForDetached(ExecutionContext ec, Object pc, Object id, Object version) {
        return StateManagerFactory.newStateManagerForDetached(ec, pc, id, version).getObjectProvider();
    }

    public static ObjectProvider newForPNewToBeDeleted(ExecutionContext ec, Object pc) {
        return StateManagerFactory.newStateManagerForPNewToBeDeleted(ec, pc).getObjectProvider();
    }

    public static ObjectProvider newForCachedPC(ExecutionContext ec, Object id, CachedPC cachedPC) {
        return StateManagerFactory.newStateManagerForCachedPC(ec, id, cachedPC).getObjectProvider();
    }

    protected static class Initialization {
        protected Class pcClass;
        protected AbstractClassMetaData cmd;

        protected Initialization(ClassLoaderResolver clr, MetaDataManager mdmgr, Class pcClass) {
            if (ClassUtils.isReferenceType(pcClass)) {
                this.cmd = mdmgr.getMetaDataForImplementationOfReference(pcClass, null, clr);
                this.pcClass = clr.classForName(this.cmd.getFullClassName(), pcClass.getClassLoader(), true);
            } else {
                try {
                    this.pcClass = clr.classForName(pcClass.getName(), pcClass.getClassLoader(), true);
                    this.cmd = mdmgr.getMetaDataForClass(pcClass, clr);
                }
                catch (ClassNotResolvedException e) {
                    throw new NucleusUserException(LOCALISER.msg("026015", (Object)pcClass.getName())).setFatal();
                }
            }
            if (this.cmd == null) {
                throw new NucleusUserException(LOCALISER.msg("026012", pcClass)).setFatal();
            }
        }

        protected Class getPCClass() {
            return this.pcClass;
        }

        protected AbstractClassMetaData getClassMetaData() {
            return this.cmd;
        }
    }
}

