/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.FetchPlan;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.JTAJCATransactionImpl;
import org.datanucleus.JTATransactionImpl;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.TransactionImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.ClassNotDetachableException;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.CommitStateTransitionException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ObjectDetachedException;
import org.datanucleus.exceptions.RollbackStateTransitionException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.identity.DatastoreUniqueOID;
import org.datanucleus.identity.IdentityTranslator;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;

public class ObjectManagerImpl
implements ObjectManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private final ObjectManagerFactoryImpl omf;
    private Object owner;
    private boolean closed;
    private FetchPlan fetchPlan;
    private ClassLoaderResolver clr = null;
    private CallbackHandler callbacks;
    private Level1Cache cache;
    private boolean ignoreCache;
    private Object objectLookingForStateManager = null;
    private StateManager foundStateManager = null;
    private Transaction tx;
    private Map<Object, StateManager> enlistedSMCache = new WeakValueMap();
    private Set txEnlistedIds = new HashSet();
    private List<StateManager> dirtySMs = new ArrayList<StateManager>(10);
    private List<StateManager> indirectDirtySMs = new ArrayList<StateManager>();
    HashSet<StateManager> managedRelationDirtySMs = null;
    private boolean managingRelations = false;
    private Set txKnownPersistedIds = new HashSet();
    private Set txKnownDeletedIds = new HashSet();
    private Set txFlushedNewIds = new HashSet();
    private Set txCachedIds = null;
    private boolean detachOnClose;
    private boolean detachAllOnCommit;
    private boolean detachAllOnRollback;
    private String attachPolicy;
    private boolean copyOnAttach;
    private boolean multithreaded;
    private Integer datastoreReadTimeoutMillis = null;
    private Integer datastoreWriteTimeoutMillis = null;
    private boolean flushing = false;
    private boolean runningDetachAllOnTxnEnd = false;
    private FetchGroupManager fetchGrpMgr;
    private ExecutionContext executionContext;
    private ThreadLocal contextInfoThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadContextInfo();
        }
    };
    private boolean runningPBRAtCommit = false;
    private StateManager[] detachAllOnTxnEndSMs = null;

    public ObjectManagerImpl(ObjectManagerFactoryImpl omf, Object owner, String userName, String password) {
        this.owner = owner;
        this.omf = omf;
        this.closed = false;
        this.executionContext = new ExecutionContextImpl(this);
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        this.clr = omf.getOMFContext().getClassLoaderResolver(contextLoader);
        try {
            ImplementationCreator ic = omf.getOMFContext().getImplementationCreator();
            if (ic != null) {
                this.clr.setRuntimeClassLoader(ic.getClassLoader());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010000", this, (Object)omf.getOMFContext().getStoreManager()));
        }
        PersistenceConfiguration config = omf.getOMFContext().getPersistenceConfiguration();
        this.setIgnoreCache(config.getBooleanProperty("datanucleus.IgnoreCache"));
        this.setDetachOnClose(config.getBooleanProperty("datanucleus.DetachOnClose"));
        this.setDetachAllOnCommit(config.getBooleanProperty("datanucleus.DetachAllOnCommit"));
        this.setDetachAllOnRollback(config.getBooleanProperty("datanucleus.DetachAllOnRollback"));
        this.setCopyOnAttach(config.getBooleanProperty("datanucleus.CopyOnAttach"));
        this.setAttachPolicy(config.getStringProperty("datanucleus.attachPolicy"));
        this.setMultithreaded(config.getBooleanProperty("datanucleus.Multithreaded"));
        this.setDatastoreReadTimeoutMillis(config.getIntProperty("datanucleus.datastoreReadTimeout"));
        this.fetchPlan = new FetchPlan(this.getExecutionContext(), this.clr).setMaxFetchDepth(omf.getIntProperty("datanucleus.maxFetchDepth"));
        this.initialiseLevel1Cache();
        this.tx = TransactionType.JTA.toString().equalsIgnoreCase(config.getStringProperty("datanucleus.TransactionType")) ? (this.getOMFContext().isJcaMode() ? new JTAJCATransactionImpl(this.getOMFContext(), this.getStoreManager(), this) : new JTATransactionImpl(this.getOMFContext(), this.getStoreManager(), this)) : new TransactionImpl(this.getOMFContext(), this.getStoreManager(), this.getExecutionContext());
        this.tx.bindTransactionEventListener(new TransactionEventListener(){

            public void transactionStarted() {
                ObjectManagerImpl.this.postBegin();
            }

            public void transactionRolledBack() {
                ObjectManagerImpl.this.postRollback();
            }

            public void transactionPreRollBack() {
                ObjectManagerImpl.this.preRollback();
            }

            public void transactionPreCommit() {
                ObjectManagerImpl.this.preCommit();
            }

            public void transactionFlushed() {
            }

            public void transactionEnded() {
            }

            public void transactionCommitted() {
                ObjectManagerImpl.this.postCommit();
            }
        });
        if (omf.hasLevel2Cache()) {
            this.txCachedIds = new HashSet();
        }
    }

    protected void initialiseLevel1Cache() {
        String level1Type = this.omf.getPersistenceConfiguration().getStringProperty("datanucleus.cache.level1.type");
        String level1ClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name");
        if (level1ClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("003001", (Object)level1Type)).setFatal();
        }
        try {
            this.cache = (Level1Cache)this.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name", null, null);
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003003", (Object)level1Type));
            }
        }
        catch (Exception e) {
            throw new NucleusUserException(LOCALISER.msg("003002", (Object)level1Type, (Object)level1ClassName), e).setFatal();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    public StoreManager getStoreManager() {
        return this.getOMFContext().getStoreManager();
    }

    public ObjectManagerFactoryImpl getObjectManagerFactory() {
        return this.omf;
    }

    public ApiAdapter getApiAdapter() {
        return this.getOMFContext().getApiAdapter();
    }

    public FetchPlan getFetchPlan() {
        this.assertIsOpen();
        return this.fetchPlan;
    }

    public Object getOwner() {
        return this.owner;
    }

    public OMFContext getOMFContext() {
        return this.omf.getOMFContext();
    }

    public MetaDataManager getMetaDataManager() {
        return this.getOMFContext().getMetaDataManager();
    }

    public Integer getDatastoreReadTimeoutMillis() {
        return this.datastoreReadTimeoutMillis;
    }

    public void setDatastoreReadTimeoutMillis(Integer val) {
        this.datastoreReadTimeoutMillis = val;
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        return this.datastoreWriteTimeoutMillis;
    }

    public void setDatastoreWriteTimeoutMillis(Integer val) {
        this.datastoreWriteTimeoutMillis = val;
    }

    public void setMultithreaded(boolean flag) {
        this.assertIsOpen();
        this.multithreaded = flag;
    }

    public boolean getMultithreaded() {
        this.assertIsOpen();
        return this.multithreaded;
    }

    public void setDetachOnClose(boolean flag) {
        this.assertIsOpen();
        this.detachOnClose = flag;
    }

    public boolean getDetachOnClose() {
        this.assertIsOpen();
        return this.detachOnClose;
    }

    public void setDetachAllOnCommit(boolean flag) {
        this.assertIsOpen();
        this.detachAllOnCommit = flag;
    }

    public boolean getDetachAllOnCommit() {
        this.assertIsOpen();
        return this.detachAllOnCommit;
    }

    public void setDetachAllOnRollback(boolean flag) {
        this.assertIsOpen();
        this.detachAllOnRollback = flag;
    }

    public boolean getDetachAllOnRollback() {
        this.assertIsOpen();
        return this.detachAllOnRollback;
    }

    public void setCopyOnAttach(boolean flag) {
        this.assertIsOpen();
        this.copyOnAttach = flag;
    }

    public boolean getCopyOnAttach() {
        this.assertIsOpen();
        return this.copyOnAttach;
    }

    public void setAttachPolicy(String policy) {
        this.assertIsOpen();
        this.attachPolicy = policy;
    }

    public String getAttachPolicy() {
        this.assertIsOpen();
        return this.attachPolicy;
    }

    public void setIgnoreCache(boolean flag) {
        this.assertIsOpen();
        this.ignoreCache = flag;
    }

    public boolean getIgnoreCache() {
        this.assertIsOpen();
        return this.ignoreCache;
    }

    public boolean isDelayDatastoreOperationsEnabled() {
        if (this.flushing || this.tx.isCommitting()) {
            return false;
        }
        if (this.tx.getOptimistic()) {
            return true;
        }
        return this.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.datastoreTransactionDelayOperations");
    }

    public boolean isInserting(Object pc) {
        StateManager sm = this.findStateManager(pc);
        if (sm == null) {
            return false;
        }
        return sm.isInserting();
    }

    public Transaction getTransaction() {
        this.assertIsOpen();
        return this.tx;
    }

    public synchronized void enlistInTransaction(StateManager sm) {
        this.assertActiveTransaction();
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015017", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)sm.getInternalObjectId().toString()));
        }
        if (this.omf.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit")) {
            if (this.getApiAdapter().isNew(sm.getObject())) {
                this.txFlushedNewIds.add(sm.getInternalObjectId());
            } else if (this.getApiAdapter().isPersistent(sm.getObject()) && !this.getApiAdapter().isDeleted(sm.getObject()) && !this.txFlushedNewIds.contains(sm.getInternalObjectId())) {
                this.txKnownPersistedIds.add(sm.getInternalObjectId());
            }
        }
        if (this.omf.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit") && !this.runningPBRAtCommit) {
            this.txEnlistedIds.add(sm.getInternalObjectId());
        }
        this.enlistedSMCache.put(sm.getInternalObjectId(), sm);
    }

    public synchronized void evictFromTransaction(StateManager sm) {
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015019", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.getIdentityAsString(sm.getInternalObjectId())));
        }
        if (this.enlistedSMCache.remove(sm.getInternalObjectId()) == null && NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("010023", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.getIdentityAsString(sm.getInternalObjectId())));
        }
    }

    public boolean isEnlistedInTransaction(Object id) {
        if (id == null) {
            return false;
        }
        return this.txEnlistedIds.contains(id);
    }

    public Object getAttachedObjectForId(Object id) {
        StateManager sm = this.enlistedSMCache.get(id);
        if (sm != null) {
            return sm.getObject();
        }
        sm = (StateManager)this.cache.get(id);
        if (sm != null) {
            return sm.getObject();
        }
        return null;
    }

    public synchronized void addStateManager(StateManager sm) {
        this.putObjectIntoCache(sm);
    }

    public synchronized void removeStateManager(StateManager sm) {
        Object pc = sm.getObject();
        this.removeObjectFromCache(pc, sm.getInternalObjectId());
        this.enlistedSMCache.remove(sm.getInternalObjectId());
    }

    public synchronized StateManager getStateManagerById(Object id) {
        this.assertIsOpen();
        return this.findStateManager(this.getObjectFromCache(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StateManager findStateManager(Object pc) {
        StateManager sm = null;
        Object previousLookingFor = this.objectLookingForStateManager;
        StateManager previousFound = this.foundStateManager;
        try {
            this.objectLookingForStateManager = pc;
            this.foundStateManager = null;
            ExecutionContext ec = this.getApiAdapter().getExecutionContext(pc);
            if (ec != null && this.getExecutionContext() != ec) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(pc)));
            }
            sm = this.foundStateManager;
            Object var7_6 = null;
            this.objectLookingForStateManager = previousLookingFor;
            this.foundStateManager = previousFound;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.objectLookingForStateManager = previousLookingFor;
            this.foundStateManager = previousFound;
            throw throwable;
        }
        return sm;
    }

    public synchronized void hereIsStateManager(StateManager sm, Object pc) {
        if (this.objectLookingForStateManager == pc) {
            this.foundStateManager = sm;
        }
    }

    public synchronized void close() {
        if (this.closed) {
            throw new NucleusUserException(LOCALISER.msg("010002"));
        }
        if (this.tx.isActive()) {
            throw new TransactionActiveOnCloseException(this);
        }
        this.nontransactionalUpdateCommit();
        if (this.detachOnClose) {
            this.performDetachOnClose();
        }
        ExecutionContext.LifecycleListener[] listener = this.omf.getOMFContext().getObjectManagerListeners();
        for (int i = 0; i < listener.length; ++i) {
            listener[i].preClose(this.getExecutionContext());
        }
        this.disconnectSMCache();
        this.disconnectLifecycleListener();
        this.fetchPlan.clearGroups().addGroup("default");
    }

    public void postClose() {
        this.closed = true;
        this.tx = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010001", this));
        }
    }

    public void disconnectSMCache() {
        HashSet cachedSMsClone = new HashSet(this.cache.values());
        for (StateManager sm : cachedSMsClone) {
            if (sm == null) continue;
            sm.disconnect();
        }
        this.cache.clear();
        if (NucleusLogger.CACHE.isDebugEnabled()) {
            NucleusLogger.CACHE.debug(LOCALISER.msg("003011"));
        }
    }

    protected void nontransactionalUpdateCommit() {
        if (!this.dirtySMs.isEmpty() && this.tx.getNontransactionalWrite() && !this.tx.isActive()) {
            for (StateManager sm : this.dirtySMs) {
                this.enlistedSMCache.put(sm.getInternalObjectId(), sm);
            }
            NucleusLogger.TRANSACTION.info("Non-tx updates are being committed to the datastore");
            this.tx.begin();
            this.tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            StateManager sm = this.findStateManager(obj);
            if (sm == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            sm.evict();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    public void evictObjects(Class cls, boolean subclasses) {
        this.assertIsOpen();
        ArrayList stateManagersToEvict = new ArrayList();
        stateManagersToEvict.addAll(this.cache.values());
        for (StateManager sm : stateManagersToEvict) {
            Object pc = sm.getObject();
            boolean evict = false;
            if (!subclasses && pc.getClass() == cls) {
                evict = true;
            } else if (subclasses && cls.isAssignableFrom(pc.getClass())) {
                evict = true;
            }
            if (!evict) continue;
            sm.evict();
            this.removeObjectFromCache(pc, this.getApiAdapter().getIdForObject(pc));
        }
    }

    public synchronized void evictAllObjects() {
        this.assertIsOpen();
        ArrayList stateManagersToEvict = new ArrayList();
        stateManagersToEvict.addAll(this.cache.values());
        for (StateManager sm : stateManagersToEvict) {
            Object pc = sm.getObject();
            sm.evict();
            this.removeObjectFromCache(pc, this.getApiAdapter().getIdForObject(pc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            StateManager sm = this.findStateManager(obj);
            if (sm == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj) && sm.isWaitingToBeFlushedToDatastore()) {
                Object var4_3 = null;
                this.clr.unsetPrimary();
                return;
            }
            sm.refresh();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
        Object var4_4 = null;
        this.clr.unsetPrimary();
    }

    public synchronized void refreshAllObjects() {
        this.assertIsOpen();
        HashSet<StateManager> toRefresh = new HashSet<StateManager>();
        toRefresh.addAll(this.enlistedSMCache.values());
        toRefresh.addAll(this.dirtySMs);
        toRefresh.addAll(this.indirectDirtySMs);
        if (!this.tx.isActive()) {
            toRefresh.addAll(this.cache.values());
        }
        ArrayList<RuntimeException> failures = null;
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            try {
                Object obj = iter.next();
                StateManager sm = this.getApiAdapter().isPersistable(obj) ? this.findStateManager(obj) : (StateManager)obj;
                sm.refresh();
            }
            catch (RuntimeException e) {
                if (failures == null) {
                    failures = new ArrayList<RuntimeException>();
                }
                failures.add(e);
            }
        }
        if (failures != null && !failures.isEmpty()) {
            throw new NucleusUserException(LOCALISER.msg("010037"), failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveObject(Object obj, boolean fgOnly) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            StateManager sm = this.findStateManager(obj);
            if (sm == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            sm.retrieve(fgOnly);
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    protected ThreadContextInfo acquireThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        ++threadInfo.referenceCounter;
        return threadInfo;
    }

    protected ThreadContextInfo getThreadContextInfo() {
        return (ThreadContextInfo)this.contextInfoThreadLocal.get();
    }

    protected void releaseThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        if (--threadInfo.referenceCounter <= 0) {
            threadInfo.referenceCounter = 0;
            if (threadInfo.attachedPCById != null) {
                threadInfo.attachedPCById.clear();
            }
            threadInfo.attachedPCById = null;
            this.contextInfoThreadLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object persistObject(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        if (obj == null) {
            return null;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            StateManager sm;
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap();
            }
            boolean detached = this.getApiAdapter().isDetached(obj);
            Object persistedPc = null;
            if (this.multithreaded) {
                Object object = obj;
                synchronized (object) {
                    persistedPc = this.persistObjectInternal(obj, null, null, -1, 0);
                }
            } else {
                persistedPc = this.persistObjectInternal(obj, null, null, -1, 0);
            }
            if ((sm = this.findStateManager(persistedPc)) != null) {
                if (this.indirectDirtySMs.contains(sm)) {
                    this.dirtySMs.add(sm);
                    this.indirectDirtySMs.remove(sm);
                } else if (!this.dirtySMs.contains(sm)) {
                    this.dirtySMs.add(sm);
                    if (this.txCachedIds != null) {
                        this.txCachedIds.add(sm.getInternalObjectId());
                    }
                }
                if (this.omf.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit") && (detached || this.getApiAdapter().isNew(persistedPc))) {
                    this.txKnownPersistedIds.add(sm.getInternalObjectId());
                }
            }
            Object object = persistedPc;
            Object var8_8 = null;
            this.nontransactionalUpdateCommit();
            this.releaseThreadContextInfo();
            return object;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.nontransactionalUpdateCommit();
            this.releaseThreadContextInfo();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] persistObjects(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Object[] persistedObjs = new Object[objs.length];
        try {
            this.getStoreManager().getPersistenceHandler2().batchStart(this.executionContext);
            ArrayList<RuntimeException> failures = null;
            for (int i = 0; i < objs.length; ++i) {
                try {
                    persistedObjs[i] = this.persistObject(objs[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new NucleusUserException(LOCALISER.msg("010039"), failures.toArray(new Exception[failures.size()]));
            }
            Object var7_6 = null;
            this.getStoreManager().getPersistenceHandler2().batchEnd(this.executionContext);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.getStoreManager().getPersistenceHandler2().batchEnd(this.executionContext);
            throw throwable;
        }
        return persistedObjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object persistObjectInternal(Object obj, FieldValues preInsertChanges, StateManager ownerSM, int ownerFieldNum, int objectType) {
        if (obj == null) {
            return null;
        }
        this.assertIsOpen();
        this.assertWritable();
        Object id = null;
        try {
            StateManager sm;
            ExecutionContext ec;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            if (!this.getApiAdapter().isDetached(obj) && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
            }
            if ((ec = this.getApiAdapter().getExecutionContext(obj)) != null && ec != this.getExecutionContext()) {
                throw new NucleusUserException(LOCALISER.msg("010007", obj));
            }
            Object persistedPc = obj;
            if (this.getApiAdapter().isDetached(obj)) {
                this.assertDetachable(obj);
                if (this.copyOnAttach) {
                    persistedPc = this.attachObjectCopy(obj, this.getApiAdapter().getIdForObject(obj) == null);
                } else {
                    this.attachObject(obj, this.getApiAdapter().getIdForObject(obj) == null);
                    persistedPc = obj;
                }
            } else if (this.getApiAdapter().isTransactional(obj) && !this.getApiAdapter().isPersistent(obj)) {
                sm = this.findStateManager(obj);
                if (sm == null) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
                }
                sm.makePersistentTransactionalTransient();
            } else if (!this.getApiAdapter().isPersistent(obj)) {
                sm = this.findStateManager(obj);
                if (sm == null) {
                    if (objectType != 0 && ownerSM != null) {
                        sm = StateManagerFactory.newStateManagerForEmbedded(this.getExecutionContext(), obj, false);
                        sm.addEmbeddedOwner(ownerSM, ownerFieldNum);
                        sm.setPcObjectType(objectType);
                        sm.makePersistent();
                        id = sm.getInternalObjectId();
                    } else {
                        sm = StateManagerFactory.newStateManagerForPersistentNew(this.getExecutionContext(), obj, preInsertChanges);
                        sm.makePersistent();
                        id = sm.getInternalObjectId();
                    }
                } else if (sm.getReferencedPC() == null) {
                    sm.makePersistent();
                    id = sm.getInternalObjectId();
                } else {
                    persistedPc = sm.getReferencedPC();
                }
            } else if (this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().getIdForObject(obj) == null) {
                sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
            } else if (this.getApiAdapter().isDeleted(obj)) {
                sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
            } else if (this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().isTransactional(obj) && this.getApiAdapter().isDirty(obj) && this.isDelayDatastoreOperationsEnabled()) {
                sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
            }
            if (id != null && this.txCachedIds != null) {
                this.txCachedIds.add(id);
            }
            Object object = persistedPc;
            Object var11_10 = null;
            this.clr.unsetPrimary();
            return object;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(Object obj) {
        StateManager sm = this.findStateManager(obj);
        if (sm != null) {
            if (this.indirectDirtySMs.contains(sm)) {
                this.indirectDirtySMs.remove(sm);
                this.dirtySMs.add(sm);
            } else if (!this.dirtySMs.contains(sm)) {
                this.dirtySMs.add(sm);
                if (this.txCachedIds != null) {
                    this.txCachedIds.add(sm.getInternalObjectId());
                }
            }
        }
        if (this.multithreaded) {
            Object object = obj;
            synchronized (object) {
                this.deleteObjectInternal(obj);
            }
        } else {
            this.deleteObjectInternal(obj);
        }
        if (this.omf.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit") && sm != null && this.getApiAdapter().isDeleted(obj)) {
            this.txKnownDeletedIds.add(sm.getInternalObjectId());
        }
        this.nontransactionalUpdateCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjectInternal(Object obj) {
        if (obj == null) {
            return;
        }
        this.assertIsOpen();
        this.assertWritable();
        try {
            StateManager sm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            Object pc = obj;
            if (this.getApiAdapter().isDetached(obj)) {
                pc = this.findObject(this.getApiAdapter().getIdForObject(obj), true, true, null);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010019", (Object)StringUtils.toJVMIDString(pc)));
            }
            if (this.getApiAdapter().getName().equals("JDO")) {
                if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010020"));
                }
                if (!this.getApiAdapter().isPersistent(pc) && this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010021"));
                }
            }
            if ((sm = this.findStateManager(pc)) == null) {
                if (!this.getApiAdapter().allowDeleteOfNonPersistentObject()) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(pc)));
                }
                sm = StateManagerFactory.newStateManagerForPNewToBeDeleted(this.getExecutionContext(), pc);
            }
            if (this.txCachedIds != null) {
                this.txCachedIds.add(sm.getInternalObjectId());
            }
            sm.deletePersistent();
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjects(Object[] objs) {
        if (objs == null) {
            return;
        }
        try {
            this.getStoreManager().getPersistenceHandler2().batchStart(this.executionContext);
            ArrayList<RuntimeException> failures = null;
            for (int i = 0; i < objs.length; ++i) {
                try {
                    this.deleteObject(objs[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new NucleusUserException(LOCALISER.msg("010040"), failures.toArray(new Exception[failures.size()]));
            }
            Object var6_5 = null;
            this.getStoreManager().getPersistenceHandler2().batchEnd(this.executionContext);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.getStoreManager().getPersistenceHandler2().batchEnd(this.executionContext);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makeObjectTransient(Object obj, FetchPlanState state) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010022", (Object)StringUtils.toJVMIDString(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj)) {
                StateManager sm = this.findStateManager(obj);
                sm.makeTransient(state);
            }
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeObjectTransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            StateManager sm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (this.getApiAdapter().isPersistent(obj)) {
                this.assertActiveTransaction();
            }
            if ((sm = this.findStateManager(obj)) == null) {
                sm = StateManagerFactory.newStateManagerForTransactionalTransient(this.getExecutionContext(), obj);
            }
            sm.makeTransactional();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeObjectNontransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            if (!this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().isTransactional(obj) && this.getApiAdapter().isDirty(obj)) {
                throw new NucleusUserException(LOCALISER.msg("010024"));
            }
            StateManager sm = this.findStateManager(obj);
            sm.makeNontransactional();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    public synchronized void attachObject(Object pc, boolean sco) {
        this.assertIsOpen();
        this.assertClassPersistable(pc.getClass());
        ApiAdapter api = this.getApiAdapter();
        Object id = api.getIdForObject(pc);
        if (id != null && this.isInserting(pc)) {
            return;
        }
        if (id == null && !sco) {
            this.persistObjectInternal(pc, null, null, -1, 0);
            return;
        }
        if (api.isDetached(pc)) {
            StateManager l1CachedSM = (StateManager)this.cache.get(id);
            if (l1CachedSM != null && l1CachedSM.getObject() != pc) {
                throw new NucleusUserException(LOCALISER.msg("010017", (Object)StringUtils.toJVMIDString(pc)));
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010016", (Object)StringUtils.toJVMIDString(pc)));
            }
        } else {
            return;
        }
        StateManager sm = StateManagerFactory.newStateManagerForDetached(this.getExecutionContext(), pc, id, api.getVersionForObject(pc));
        sm.attach(sco);
    }

    public synchronized Object attachObjectCopy(Object pc, boolean sco) {
        this.assertIsOpen();
        this.assertClassPersistable(pc.getClass());
        this.assertDetachable(pc);
        ApiAdapter api = this.getApiAdapter();
        Object id = api.getIdForObject(pc);
        if (id != null && this.isInserting(pc)) {
            return pc;
        }
        if (id == null && !sco) {
            return this.persistObjectInternal(pc, null, null, -1, 0);
        }
        if (api.isPersistent(pc)) {
            return pc;
        }
        Object pcTarget = null;
        if (sco) {
            boolean detached = this.getApiAdapter().isDetached(pc);
            StateManager smTarget = StateManagerFactory.newStateManagerForEmbedded(this.getExecutionContext(), pc, true);
            pcTarget = smTarget.getObject();
            if (detached) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010018", (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(pcTarget)));
                }
                smTarget.attachCopy(pc, sco);
            }
        } else {
            boolean detached = this.getApiAdapter().isDetached(pc);
            pcTarget = this.findObject(id, false, false, pc.getClass().getName());
            if (detached) {
                Object obj = null;
                HashMap attachedPCById = this.getThreadContextInfo().attachedPCById;
                if (attachedPCById != null) {
                    obj = attachedPCById.get(this.getApiAdapter().getIdForObject(pc));
                }
                if (obj != null) {
                    pcTarget = obj;
                } else {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010018", (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(pcTarget)));
                    }
                    this.findStateManager(pcTarget).attachCopy(pc, sco);
                    if (attachedPCById != null) {
                        attachedPCById.put(this.getApiAdapter().getIdForObject(pc), pcTarget);
                    }
                }
            }
        }
        return pcTarget;
    }

    public synchronized void detachObject(Object obj, FetchPlanState state) {
        StateManager sm;
        this.assertIsOpen();
        this.assertClassPersistable(obj.getClass());
        this.assertDetachable(obj);
        if (this.getApiAdapter().isDetached(obj)) {
            return;
        }
        if (!this.getApiAdapter().isPersistent(obj) && this.tx.isActive()) {
            this.persistObjectInternal(obj, null, null, -1, 0);
        }
        if ((sm = this.findStateManager(obj)) == null) {
            throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
        }
        sm.detach(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        this.assertIsOpen();
        this.assertClassPersistable(pc.getClass());
        Object thePC = pc;
        try {
            Object detached;
            this.clr.setPrimary(pc.getClass().getClassLoader());
            if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isDetached(pc)) {
                if (this.tx.isActive()) {
                    thePC = this.persistObjectInternal(pc, null, null, -1, 0);
                } else {
                    throw new NucleusUserException(LOCALISER.msg("010014"));
                }
            }
            if (this.getApiAdapter().isDetached(thePC)) {
                thePC = this.findObject(this.getApiAdapter().getIdForObject(thePC), false, true, null);
            }
            if ((detached = ((DetachState)state).getDetachedCopyObject(thePC)) == null) {
                StateManager sm = this.findStateManager(thePC);
                if (sm == null) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(thePC)));
                }
                detached = sm.detachCopy(state);
                ((DetachState)state).setDetachedCopyObject(detached, sm.getExternalObjectId(sm.getObject()));
            }
            Object object = detached;
            Object var7_6 = null;
            this.clr.unsetPrimary();
            return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    public void detachAll() {
        HashSet<StateManager> smsToDetach = new HashSet<StateManager>();
        smsToDetach.addAll(this.enlistedSMCache.values());
        smsToDetach.addAll(this.cache.values());
        FetchPlanState fps = new FetchPlanState();
        Iterator iter = smsToDetach.iterator();
        while (iter.hasNext()) {
            ((StateManager)iter.next()).detach(fps);
        }
    }

    public Object newInstance(Class cls) {
        this.assertIsOpen();
        if (this.getApiAdapter().isPersistable(cls) && !Modifier.isAbstract(cls.getModifiers())) {
            try {
                return cls.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new NucleusUserException(iae.toString(), iae);
            }
            catch (InstantiationException ie) {
                throw new NucleusUserException(ie.toString(), ie);
            }
        }
        this.assertHasImplementationCreator();
        return this.getOMFContext().getImplementationCreator().newInstance(cls, this.clr);
    }

    public boolean exists(Object obj) {
        if (obj == null) {
            return false;
        }
        Object id = this.getApiAdapter().getIdForObject(obj);
        if (id == null) {
            return false;
        }
        try {
            this.findObject(id, true, false, obj.getClass().getName());
        }
        catch (NucleusObjectNotFoundException onfe) {
            return false;
        }
        return true;
    }

    public Set getManagedObjects() {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        Collection<StateManager> sms = this.enlistedSMCache.values();
        for (StateManager sm : sms) {
            objs.add(sm.getObject());
        }
        return objs;
    }

    public Set getManagedObjects(Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        Collection<StateManager> sms = this.enlistedSMCache.values();
        block0: for (StateManager sm : sms) {
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i] != sm.getObject().getClass()) continue;
                objs.add(sm.getObject());
                continue block0;
            }
        }
        return objs;
    }

    public Set getManagedObjects(String[] states) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        Collection<StateManager> sms = this.enlistedSMCache.values();
        block0: for (StateManager sm : sms) {
            for (int i = 0; i < states.length; ++i) {
                if (!this.getApiAdapter().getObjectState(sm.getObject()).equals(states[i])) continue;
                objs.add(sm.getObject());
                continue block0;
            }
        }
        return objs;
    }

    public Set getManagedObjects(String[] states, Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        Collection<StateManager> sms = this.enlistedSMCache.values();
        Iterator<StateManager> smsIter = sms.iterator();
        block0: while (smsIter.hasNext()) {
            boolean matches = false;
            StateManager sm = smsIter.next();
            for (int i = 0; i < states.length; ++i) {
                if (this.getApiAdapter().getObjectState(sm.getObject()).equals(states[i])) {
                    int j = 0;
                    while (i < classes.length) {
                        if (classes[j] == sm.getObject().getClass()) {
                            matches = true;
                            objs.add(sm.getObject());
                            break;
                        }
                        ++i;
                    }
                }
                if (matches) continue block0;
            }
        }
        return objs;
    }

    public synchronized Object findObjectUsingAID(Class pcClass, FieldValues fv, boolean ignoreCache, boolean checkInheritance) {
        Object pc;
        Object oid;
        this.assertIsOpen();
        StateManager sm = StateManagerFactory.newStateManagerForHollowPopulatedAppId(this.getExecutionContext(), pcClass, fv);
        if (!ignoreCache) {
            oid = sm.getInternalObjectId();
            pc = this.getObjectFromCache(oid);
            if (pc != null) {
                sm = this.findStateManager(pc);
                sm.loadFieldValues(fv);
                return pc;
            }
            if (checkInheritance) {
                String[] subclasses;
                ApiAdapter api = this.getApiAdapter();
                if ((oid instanceof OID || api.isSingleFieldIdentity(oid)) && (subclasses = this.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
                    for (int i = 0; i < subclasses.length; ++i) {
                        if (api.isDatastoreIdentity(oid)) {
                            oid = OIDFactory.getInstance(this.getOMFContext(), subclasses[i], ((OID)oid).getKeyValue());
                        } else if (api.isSingleFieldIdentity(oid)) {
                            oid = api.getNewSingleFieldIdentity(oid.getClass(), this.clr.classForName(subclasses[i]), api.getTargetKeyForSingleFieldIdentity(oid));
                        }
                        pc = this.getObjectFromCache(oid);
                        if (pc == null) continue;
                        sm = this.findStateManager(pc);
                        sm.loadFieldValues(fv);
                        this.putObjectIntoLevel2Cache(sm, false);
                        return pc;
                    }
                }
            }
        }
        if (checkInheritance) {
            sm.checkInheritance(fv);
            if (!ignoreCache && (pc = this.getObjectFromCache(oid = sm.getInternalObjectId())) != null) {
                sm = this.findStateManager(pc);
                sm.loadFieldValues(fv);
                this.putObjectIntoLevel2Cache(sm, false);
                return pc;
            }
        }
        this.putObjectIntoCache(sm);
        if (this.txCachedIds != null && !this.txCachedIds.contains(sm.getInternalObjectId())) {
            this.putObjectIntoLevel2Cache(sm, false);
        }
        return sm.getObject();
    }

    public synchronized Object findObject(Object id, FieldValues fv, Class cls, boolean ignoreCache) {
        StateManager sm;
        this.assertIsOpen();
        boolean createdHollow = false;
        Object pc = null;
        if (!ignoreCache) {
            pc = this.getObjectFromCache(id);
        }
        if (pc == null) {
            pc = this.getStoreManager().getPersistenceHandler2().findObject(this.executionContext, id);
        }
        if (pc == null) {
            String className;
            String string = className = cls != null ? cls.getName() : null;
            if (cls == null) {
                className = this.getStoreManager().getClassNameForObjectID(id, this.clr, this.getExecutionContext());
                if (className == null) {
                    throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
                }
                if (id instanceof OID) {
                    id = OIDFactory.getInstance(this.getOMFContext(), className, ((OID)id).getKeyValue());
                    pc = this.getObjectFromCache(id);
                }
            }
            if (pc == null) {
                if (cls == null) {
                    try {
                        cls = this.clr.classForName(className, id.getClass().getClassLoader());
                    }
                    catch (ClassNotResolvedException e) {
                        String msg = LOCALISER.msg("010027", (Object)this.getIdentityAsString(id));
                        NucleusLogger.PERSISTENCE.warn(msg);
                        throw new NucleusUserException(msg, e);
                    }
                }
                createdHollow = true;
                StateManager sm2 = StateManagerFactory.newStateManagerForHollowPopulated(this.getExecutionContext(), cls, id, fv);
                pc = sm2.getObject();
                this.putObjectIntoCache(sm2);
                this.putObjectIntoLevel2Cache(sm2, false);
            }
        }
        if (pc != null && fv != null && !createdHollow && (sm = this.findStateManager(pc)) != null) {
            fv.fetchNonLoadedFields(sm);
        }
        return pc;
    }

    public synchronized Object[] findObjects(Object[] identities, boolean validate) {
        this.assertIsOpen();
        ApiAdapter api = this.getApiAdapter();
        Object[] objs = new Object[identities.length];
        Object[] ids = new Object[identities.length];
        ArrayList<Object> idsToFind = new ArrayList<Object>();
        for (int i = 0; i < identities.length; ++i) {
            if (identities[i] == null) {
                throw new NucleusUserException(LOCALISER.msg("010044"));
            }
            if (this.getOMFContext().getIdentityTranslator() != null) {
                IdentityTranslator translator = this.getOMFContext().getIdentityTranslator();
                ids[i] = translator.getIdentity(this.getExecutionContext(), identities[i]);
            } else {
                ids[i] = identities[i];
            }
            Object pc = this.getObjectFromCache(ids[i]);
            if (pc != null) {
                objs[i] = pc;
                if (!(ids[i] instanceof SCOID) || !api.isPersistent(pc) || api.isNew(pc) || api.isDeleted(pc) || api.isTransactional(pc)) continue;
                throw new NucleusUserException(LOCALISER.msg("010005"));
            }
            idsToFind.add(ids[i]);
        }
        Object[] foundPcs = null;
        foundPcs = this.getStoreManager().getPersistenceHandler2().findObjects(this.executionContext, idsToFind.toArray());
        int foundPcIdx = 0;
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            Object pc = objs[i];
            boolean fromCache = true;
            if (pc == null) {
                pc = foundPcs[foundPcIdx];
                ++foundPcIdx;
            }
            StateManager sm = null;
            if (pc == null) {
                String className = null;
                String originalClassName = null;
                boolean checkedClassName = false;
                if (id instanceof SCOID) {
                    throw new NucleusUserException(LOCALISER.msg("010006"));
                }
                if (id instanceof DatastoreUniqueOID) {
                    throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
                }
                if (api.isDatastoreIdentity(id) || api.isSingleFieldIdentity(id)) {
                    originalClassName = this.getStoreManager().manageClassForIdentity(id, this.getClassLoaderResolver());
                } else {
                    originalClassName = this.getStoreManager().getClassNameForObjectID(id, this.clr, this.getExecutionContext());
                    checkedClassName = true;
                }
                if (validate) {
                    String string = className = checkedClassName ? originalClassName : this.getStoreManager().getClassNameForObjectID(id, this.clr, this.getExecutionContext());
                    if (className == null) {
                        throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
                    }
                    if (originalClassName != null && !originalClassName.equals(className)) {
                        if (api.isDatastoreIdentity(id)) {
                            id = OIDFactory.getInstance(this.getOMFContext(), className, ((OID)id).getKeyValue());
                            pc = this.getObjectFromCache(id);
                        } else if (api.isSingleFieldIdentity(id)) {
                            id = api.getNewSingleFieldIdentity(id.getClass(), this.getClassLoaderResolver().classForName(className), api.getTargetKeyForSingleFieldIdentity(id));
                            pc = this.getObjectFromCache(id);
                        }
                    }
                } else {
                    className = originalClassName;
                }
                if (pc == null) {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                        sm = StateManagerFactory.newStateManagerForHollow(this.getExecutionContext(), pcClass, id);
                        pc = sm.getObject();
                        fromCache = false;
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id)));
                        throw new NucleusUserException(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id)), e);
                    }
                }
            }
            if (validate) {
                if (fromCache && pc != null && api.isTransactional(pc)) {
                    objs[i] = pc;
                    continue;
                }
                sm = this.findStateManager(pc);
                if (sm != null && !fromCache) {
                    this.putObjectIntoCache(sm);
                }
                try {
                    sm.validate();
                }
                catch (NucleusObjectNotFoundException onfe) {
                    this.removeObjectFromCache(sm.getObject(), sm.getInternalObjectId());
                    throw onfe;
                }
                if (sm.getObject() != pc) {
                    this.removeObjectFromCache(sm.getObject(), sm.getInternalObjectId());
                    fromCache = false;
                    pc = sm.getObject();
                }
            }
            objs[i] = pc;
            if (sm == null || fromCache) continue;
            this.putObjectIntoCache(sm);
            this.putObjectIntoLevel2Cache(sm, false);
        }
        return objs;
    }

    public synchronized Object findObject(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        this.assertIsOpen();
        if (id == null) {
            throw new NucleusUserException(LOCALISER.msg("010044"));
        }
        if (this.getOMFContext().getIdentityTranslator() != null) {
            IdentityTranslator translator = this.getOMFContext().getIdentityTranslator();
            id = translator.getIdentity(this.getExecutionContext(), id);
        }
        Object pc = this.getObjectFromCache(id);
        boolean fromCache = true;
        ApiAdapter api = this.getApiAdapter();
        if (id instanceof SCOID && pc != null && api.isPersistent(pc) && !api.isNew(pc) && !api.isDeleted(pc) && !api.isTransactional(pc)) {
            throw new NucleusUserException(LOCALISER.msg("010005"));
        }
        if (pc != null && api.isTransactional(pc)) {
            return pc;
        }
        StateManager sm = null;
        if (pc == null && (pc = this.getStoreManager().getPersistenceHandler2().findObject(this.executionContext, id)) == null) {
            String className = null;
            String originalClassName = null;
            boolean checkedClassName = false;
            if (id instanceof SCOID) {
                throw new NucleusUserException(LOCALISER.msg("010006"));
            }
            if (id instanceof DatastoreUniqueOID) {
                throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
            }
            if (api.isDatastoreIdentity(id) || api.isSingleFieldIdentity(id)) {
                originalClassName = this.getStoreManager().manageClassForIdentity(id, this.getClassLoaderResolver());
            } else if (objectClassName != null) {
                originalClassName = objectClassName;
            } else {
                originalClassName = this.getStoreManager().getClassNameForObjectID(id, this.clr, this.getExecutionContext());
                checkedClassName = true;
            }
            if (checkInheritance) {
                className = !checkedClassName ? this.getStoreManager().getClassNameForObjectID(id, this.clr, this.getExecutionContext()) : originalClassName;
                if (className == null) {
                    throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
                }
                if (originalClassName != null && !originalClassName.equals(className)) {
                    if (api.isDatastoreIdentity(id)) {
                        id = OIDFactory.getInstance(this.getOMFContext(), className, ((OID)id).getKeyValue());
                        pc = this.getObjectFromCache(id);
                    } else if (api.isSingleFieldIdentity(id)) {
                        id = api.getNewSingleFieldIdentity(id.getClass(), this.getClassLoaderResolver().classForName(className), api.getTargetKeyForSingleFieldIdentity(id));
                        pc = this.getObjectFromCache(id);
                    }
                }
            } else {
                className = originalClassName;
            }
            if (pc == null) {
                try {
                    Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                    if (Modifier.isAbstract(pcClass.getModifiers())) {
                        throw new NucleusObjectNotFoundException(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id), (Object)className));
                    }
                    sm = StateManagerFactory.newStateManagerForHollow(this.getExecutionContext(), pcClass, id);
                    pc = sm.getObject();
                    fromCache = false;
                    if (!checkInheritance && !validate) {
                        sm.markForInheritanceValidation();
                    }
                }
                catch (ClassNotResolvedException e) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id)));
                    throw new NucleusUserException(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id)), e);
                }
            }
        }
        if (validate) {
            if (sm == null) {
                sm = this.findStateManager(pc);
            }
            if (sm != null && !fromCache) {
                this.putObjectIntoCache(sm);
            }
            try {
                sm.validate();
            }
            catch (NucleusObjectNotFoundException onfe) {
                this.removeObjectFromCache(sm.getObject(), sm.getInternalObjectId());
                throw onfe;
            }
            if (sm.getObject() != pc) {
                fromCache = false;
                this.removeObjectFromCache(sm.getObject(), sm.getInternalObjectId());
            }
            if (!fromCache) {
                pc = sm.getObject();
            }
        }
        if (sm != null && !fromCache) {
            this.putObjectIntoCache(sm);
            this.putObjectIntoLevel2Cache(sm, false);
        }
        return pc;
    }

    public Object newObjectId(Class pcClass, Object key) {
        this.assertIsOpen();
        if (pcClass == null) {
            throw new NucleusUserException(LOCALISER.msg("010028"));
        }
        this.assertClassPersistable(pcClass);
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(pcClass, this.clr);
        if (cmd == null) {
            throw new NoPersistenceInformationException(pcClass.getName());
        }
        if (!this.getStoreManager().managesClass(cmd.getFullClassName())) {
            this.getStoreManager().addClass(cmd.getFullClassName(), this.clr);
        }
        Object id = null;
        if (cmd.usesSingleFieldIdentityClass()) {
            Class idType = this.clr.classForName(cmd.getObjectidClass());
            id = this.getApiAdapter().getNewSingleFieldIdentity(idType, pcClass, key);
        } else if (key instanceof String) {
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (Modifier.isAbstract(pcClass.getModifiers()) && cmd.getObjectidClass() != null) {
                    try {
                        Constructor c = this.clr.classForName(cmd.getObjectidClass()).getDeclaredConstructor(String.class);
                        id = c.newInstance((String)key);
                    }
                    catch (Exception e) {
                        String msg = LOCALISER.msg("010030", (Object)cmd.getObjectidClass(), (Object)cmd.getFullClassName());
                        NucleusLogger.PERSISTENCE.error(msg);
                        NucleusLogger.PERSISTENCE.error(e);
                        throw new NucleusUserException(msg);
                    }
                } else {
                    this.clr.classForName(pcClass.getName(), true);
                    id = this.getApiAdapter().getNewApplicationIdentityObjectId(pcClass, key);
                }
            } else {
                id = OIDFactory.getInstance(this.getOMFContext(), (String)key);
            }
        } else {
            throw new NucleusUserException(LOCALISER.msg("010029", (Object)pcClass.getName(), (Object)key.getClass().getName()));
        }
        return id;
    }

    public Object newObjectId(String className, Object pc) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, this.getClassLoaderResolver());
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            Object nextIdentifier = this.getStoreManager().getStrategyValue(this.getExecutionContext(), cmd, -1);
            return OIDFactory.getInstance(this.getOMFContext(), cmd.getFullClassName(), nextIdentifier);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getApiAdapter().getNewApplicationIdentityObjectId(pc, cmd);
        }
        return new SCOID(className);
    }

    public synchronized void clearDirty(StateManager sm) {
        this.dirtySMs.remove(sm);
        this.indirectDirtySMs.remove(sm);
    }

    public synchronized void clearDirty() {
        this.dirtySMs.clear();
        this.indirectDirtySMs.clear();
    }

    public synchronized void markDirty(StateManager sm, boolean directUpdate) {
        if (this.tx.isCommitting() && !this.tx.isActive()) {
            throw new NucleusException("Cannot change objects when transaction is no longer active.");
        }
        boolean isInDirty = this.dirtySMs.contains(sm);
        boolean isInIndirectDirty = this.indirectDirtySMs.contains(sm);
        if (!(this.isDelayDatastoreOperationsEnabled() || isInDirty || isInIndirectDirty || this.dirtySMs.size() < this.getOMFContext().getPersistenceConfiguration().getIntProperty("datanucleus.datastoreTransactionFlushLimit"))) {
            this.flushInternal(false);
        }
        if (directUpdate) {
            if (isInIndirectDirty) {
                this.indirectDirtySMs.remove(sm);
                this.dirtySMs.add(sm);
            } else if (!isInDirty) {
                this.dirtySMs.add(sm);
                if (this.txCachedIds != null) {
                    this.txCachedIds.add(sm.getInternalObjectId());
                }
            }
        } else if (!isInDirty && !isInIndirectDirty) {
            this.indirectDirtySMs.add(sm);
            if (this.txCachedIds != null) {
                this.txCachedIds.add(sm.getInternalObjectId());
            }
        }
    }

    public void markManagedRelationDirty(StateManager sm) {
        if (this.managedRelationDirtySMs == null) {
            this.managedRelationDirtySMs = new HashSet();
        }
        this.managedRelationDirtySMs.add(sm);
    }

    public boolean isManagingRelations() {
        return this.managingRelations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performManagedRelationships() {
        if (this.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && this.managedRelationDirtySMs != null && this.managedRelationDirtySMs.size() > 0) {
            try {
                this.managingRelations = true;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013000"));
                }
                if (this.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationshipsChecks")) {
                    for (StateManager sm : this.managedRelationDirtySMs) {
                        sm.checkManagedRelations();
                    }
                }
                for (StateManager sm : this.managedRelationDirtySMs) {
                    sm.processManagedRelations();
                    sm.clearManagedRelations();
                }
                this.managedRelationDirtySMs.clear();
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013001"));
                }
                Object var4_3 = null;
                this.managingRelations = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.managingRelations = false;
                throw throwable;
            }
        }
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    public void flush() {
        this.assertIsOpen();
        if (this.tx.isActive()) {
            this.performManagedRelationships();
            this.flushInternal(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flushInternal(boolean flushToDatastore) {
        this.assertIsOpen();
        if (this.tx.isActive()) {
            if (!flushToDatastore && this.dirtySMs.size() == 0 && this.indirectDirtySMs.size() == 0) {
                return;
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010003", this.dirtySMs.size() + this.indirectDirtySMs.size()));
            }
            this.flushing = true;
            try {
                StateManager sm;
                int i;
                Object[] toFlushIndirect;
                Object[] toFlushDirect;
                ArrayList<NucleusOptimisticException> optimisticFailures = null;
                List<StateManager> list = this.dirtySMs;
                synchronized (list) {
                    toFlushDirect = this.dirtySMs.toArray();
                    this.dirtySMs.clear();
                }
                List<StateManager> list2 = this.indirectDirtySMs;
                synchronized (list2) {
                    toFlushIndirect = this.indirectDirtySMs.toArray();
                    this.indirectDirtySMs.clear();
                }
                for (i = 0; i < toFlushDirect.length; ++i) {
                    sm = (StateManager)toFlushDirect[i];
                    try {
                        sm.flush();
                        continue;
                    }
                    catch (NucleusOptimisticException oe) {
                        if (optimisticFailures == null) {
                            optimisticFailures = new ArrayList<NucleusOptimisticException>();
                        }
                        optimisticFailures.add(oe);
                    }
                }
                for (i = 0; i < toFlushIndirect.length; ++i) {
                    sm = (StateManager)toFlushIndirect[i];
                    try {
                        sm.flush();
                        continue;
                    }
                    catch (NucleusOptimisticException oe) {
                        if (optimisticFailures == null) {
                            optimisticFailures = new ArrayList();
                        }
                        optimisticFailures.add(oe);
                    }
                }
                if (flushToDatastore) {
                    this.tx.flush();
                }
                if (optimisticFailures != null) {
                    throw new NucleusOptimisticException(LOCALISER.msg("010031"), optimisticFailures.toArray(new Throwable[optimisticFailures.size()]));
                }
                Object var9_13 = null;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010004"));
                }
                this.flushing = false;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010004"));
                }
                this.flushing = false;
                throw throwable;
            }
        }
    }

    public synchronized void postBegin() {
        int i;
        StateManager[] sms = this.dirtySMs.toArray(new StateManager[this.dirtySMs.size()]);
        for (i = 0; i < sms.length; ++i) {
            sms[i].preBegin(this.tx);
        }
        sms = this.indirectDirtySMs.toArray(new StateManager[this.indirectDirtySMs.size()]);
        for (i = 0; i < sms.length; ++i) {
            sms[i].preBegin(this.tx);
        }
    }

    public synchronized void preCommit() {
        this.flush();
        if (this.omf.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit")) {
            try {
                try {
                    this.runningPBRAtCommit = true;
                    this.performReachabilityAtCommit();
                    this.getTransaction().flush();
                }
                catch (Throwable t) {
                    NucleusLogger.PERSISTENCE.error(t);
                    if (t instanceof NucleusException) {
                        throw (NucleusException)t;
                    }
                    throw new NucleusException("Unexpected error during precommit", t);
                }
                Object var3_1 = null;
                this.runningPBRAtCommit = false;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.runningPBRAtCommit = false;
                throw throwable;
            }
        }
        if (this.omf.hasLevel2Cache()) {
            this.performLevel2CacheUpdateAtCommit();
        }
        if (this.detachAllOnCommit) {
            this.performDetachAllOnTxnEndPreparation();
        }
    }

    public boolean isObjectModifiedInTransaction(Object id) {
        if (this.txCachedIds != null) {
            return this.txCachedIds.contains(id);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLevel2CacheUpdateAtCommit() {
        Level2Cache l2Cache;
        Level2Cache level2Cache = l2Cache = this.omf.getLevel2Cache();
        synchronized (level2Cache) {
            for (Object id : this.txCachedIds) {
                StateManager sm = this.enlistedSMCache.get(id);
                if (sm == null) {
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004014", id, (Object)String.valueOf(l2Cache.getSize())));
                    }
                    l2Cache.evict(id);
                    continue;
                }
                if (this.getApiAdapter().isDeleted(sm.getObject())) {
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004007", (Object)StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId(), (Object)String.valueOf(l2Cache.getSize())));
                    }
                    l2Cache.evict(this.getApiAdapter().getIdForObject(sm.getObject()));
                    continue;
                }
                if (this.getApiAdapter().isDetached(sm.getObject())) continue;
                this.putObjectIntoLevel2CacheInternal(sm, true);
            }
            this.txCachedIds.clear();
        }
    }

    private void performReachabilityAtCommit() {
        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug(LOCALISER.msg("010032"));
        }
        if (this.txKnownPersistedIds.size() > 0 && this.txFlushedNewIds.size() > 0) {
            HashSet currentReachables = new HashSet();
            Object[] ids = this.txKnownPersistedIds.toArray();
            HashSet<Object> objectNotFound = new HashSet<Object>();
            for (int i = 0; i < ids.length; ++i) {
                if (this.txKnownDeletedIds.contains(ids[i])) continue;
                if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                    NucleusLogger.REACHABILITY.debug("Performing reachability algorithm on object with id \"" + ids[i] + "\"");
                }
                try {
                    StateManager sm = this.findStateManager(this.findObject(ids[i], true, true, null));
                    sm.runReachability(currentReachables);
                    if (i % 10000 != 0 && i != ids.length - 1) continue;
                    this.flushInternal(true);
                    continue;
                }
                catch (NucleusObjectNotFoundException ex) {
                    objectNotFound.add(ids[i]);
                }
            }
            this.txFlushedNewIds.removeAll(currentReachables);
            Object[] nonReachableIds = this.txFlushedNewIds.toArray();
            if (nonReachableIds != null && nonReachableIds.length > 0) {
                StateManager sm;
                int i;
                for (i = 0; i < nonReachableIds.length; ++i) {
                    if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                        NucleusLogger.REACHABILITY.debug(LOCALISER.msg("010033", nonReachableIds[i]));
                    }
                    try {
                        if (objectNotFound.contains(nonReachableIds[i])) continue;
                        sm = this.findStateManager(this.findObject(nonReachableIds[i], true, true, null));
                        sm.nullifyFields();
                        if (i % 10000 != 0 && i != nonReachableIds.length - 1) continue;
                        this.flushInternal(true);
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
                for (i = 0; i < nonReachableIds.length; ++i) {
                    try {
                        if (objectNotFound.contains(nonReachableIds[i])) continue;
                        sm = this.findStateManager(this.findObject(nonReachableIds[i], true, true, null));
                        sm.deletePersistent();
                        if (i % 10000 != 0 && i != nonReachableIds.length - 1) continue;
                        this.flushInternal(true);
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
            }
        }
        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug(LOCALISER.msg("010034"));
        }
    }

    private void performDetachAllOnTxnEndPreparation() {
        ArrayList<StateManager> sms = new ArrayList<StateManager>();
        Collection roots = this.fetchPlan.getDetachmentRoots();
        Class[] rootClasses = this.fetchPlan.getDetachmentRootClasses();
        if (roots != null && roots.size() > 0) {
            for (Object obj : roots) {
                sms.add(this.findStateManager(obj));
            }
        } else if (rootClasses != null && rootClasses.length > 0) {
            StateManager[] txSMs = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
            block3: for (int i = 0; i < txSMs.length; ++i) {
                for (int j = 0; j < rootClasses.length; ++j) {
                    if (txSMs[i].getObject().getClass() != rootClasses[j]) continue;
                    sms.add(txSMs[i]);
                    continue block3;
                }
            }
        } else {
            sms.addAll(this.cache.values());
        }
        Iterator smsIter = sms.iterator();
        while (smsIter.hasNext()) {
            StateManager sm = (StateManager)smsIter.next();
            Object pc = sm.getObject();
            if (pc == null || this.getApiAdapter().isDetached(pc) || this.getApiAdapter().isDeleted(pc)) continue;
            FetchPlanState state = new FetchPlanState();
            try {
                sm.loadFieldsInFetchPlan(state);
            }
            catch (NucleusObjectNotFoundException onfe) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010013", (Object)StringUtils.toJVMIDString(pc), sm.getInternalObjectId()));
                smsIter.remove();
            }
        }
        this.detachAllOnTxnEndSMs = sms.toArray(new StateManager[sms.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachAllOnTxnEnd() {
        try {
            this.runningDetachAllOnTxnEnd = true;
            StateManager[] smsToDetach = this.detachAllOnTxnEndSMs;
            DetachState state = new DetachState(this.getApiAdapter());
            for (int i = 0; i < smsToDetach.length; ++i) {
                Object pc = smsToDetach[i].getObject();
                if (pc == null) continue;
                smsToDetach[i].detach(state);
            }
            this.detachAllOnTxnEndSMs = null;
            Object var6_5 = null;
            this.runningDetachAllOnTxnEnd = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.runningDetachAllOnTxnEnd = false;
            throw throwable;
        }
    }

    public boolean isRunningDetachAllOnCommit() {
        return this.runningDetachAllOnTxnEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachOnClose() {
        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010011"));
        try {
            this.tx.begin();
            ArrayList toDetach = new ArrayList();
            toDetach.addAll(this.cache.values());
            for (StateManager sm : toDetach) {
                if (sm == null || sm.getObject() == null || sm.getObjectManager().getApiAdapter().isDeleted(sm.getObject())) continue;
                try {
                    sm.detach(new DetachState(this.getApiAdapter()));
                }
                catch (NucleusObjectNotFoundException onfe) {}
            }
            this.tx.commit();
            Object var6_5 = null;
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            throw throwable;
        }
        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010012"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postCommit() {
        if (this.detachAllOnCommit) {
            this.performDetachAllOnTxnEnd();
        }
        ArrayList<RuntimeException> failures = null;
        try {
            ApiAdapter api = this.getApiAdapter();
            StateManager[] sms = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
            for (int i = 0; i < sms.length; ++i) {
                try {
                    if (sms[i] == null || sms[i].getObject() == null || !api.isPersistent(sms[i].getObject()) && !api.isTransactional(sms[i].getObject())) continue;
                    sms[i].postCommit(this.getTransaction());
                    if (!this.detachAllOnCommit || !api.isDetachable(sms[i].getObject())) continue;
                    this.removeStateManager(sms[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            Object var7_6 = null;
            this.resetTransactionalVariables();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.resetTransactionalVariables();
            throw throwable;
        }
        if (failures != null && !failures.isEmpty()) {
            throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preRollback() {
        ArrayList<RuntimeException> failures = null;
        try {
            Collection<StateManager> sms = this.enlistedSMCache.values();
            for (StateManager sm : sms) {
                try {
                    sm.preRollback(this.getTransaction());
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            this.clearDirty();
            Object var7_6 = null;
            this.resetTransactionalVariables();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.resetTransactionalVariables();
            throw throwable;
        }
        if (failures != null && !failures.isEmpty()) {
            throw new RollbackStateTransitionException(failures.toArray(new Exception[failures.size()]));
        }
        if (this.detachAllOnRollback) {
            this.performDetachAllOnTxnEndPreparation();
        }
    }

    public synchronized void postRollback() {
        if (this.detachAllOnRollback) {
            this.performDetachAllOnTxnEnd();
        }
    }

    private void resetTransactionalVariables() {
        this.enlistedSMCache.clear();
        this.txEnlistedIds.clear();
        this.txKnownPersistedIds.clear();
        this.txKnownDeletedIds.clear();
        this.txFlushedNewIds.clear();
        this.dirtySMs.clear();
        this.indirectDirtySMs.clear();
        this.fetchPlan.resetDetachmentRoots();
        if (this.managedRelationDirtySMs != null) {
            this.managedRelationDirtySMs.clear();
        }
        if (this.txCachedIds != null) {
            this.txCachedIds.clear();
        }
    }

    public synchronized void replaceObjectId(Object pc, Object oldID, Object newID) {
        StateManager sm;
        if (pc == null || this.getApiAdapter().getIdForObject(pc) == null) {
            NucleusLogger.CACHE.warn(LOCALISER.msg("003006"));
            return;
        }
        Object o = this.cache.get(oldID);
        if (o != null) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003012", (Object)StringUtils.toJVMIDString(pc), (Object)this.getIdentityAsString(oldID), (Object)this.getIdentityAsString(newID)));
            }
            this.cache.remove(oldID);
        }
        if ((sm = this.findStateManager(pc)) != null) {
            this.putObjectIntoCache(sm);
        }
        if (this.enlistedSMCache.get(oldID) != null && sm != null) {
            this.enlistedSMCache.remove(oldID);
            this.enlistedSMCache.put(newID, sm);
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015018", (Object)StringUtils.toJVMIDString(pc), (Object)this.getIdentityAsString(oldID), (Object)this.getIdentityAsString(newID)));
            }
        }
        if (this.omf.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit")) {
            if (this.txEnlistedIds.remove(oldID)) {
                this.txEnlistedIds.add(newID);
            }
            if (this.txFlushedNewIds.remove(oldID)) {
                this.txFlushedNewIds.add(newID);
            }
            if (this.txKnownPersistedIds.remove(oldID)) {
                this.txKnownPersistedIds.add(newID);
            }
            if (this.txKnownDeletedIds.remove(oldID)) {
                this.txKnownDeletedIds.add(newID);
            }
        }
    }

    public synchronized void putObjectIntoCache(StateManager sm) {
        Object id = sm.getInternalObjectId();
        if (id == null || sm.getObject() == null) {
            NucleusLogger.CACHE.warn(LOCALISER.msg("003006"));
            return;
        }
        StateManager oldSM = this.cache.put(sm.getInternalObjectId(), sm);
        if (NucleusLogger.CACHE.isDebugEnabled()) {
            if (oldSM == null) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003004", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.getIdentityAsString(sm.getInternalObjectId()), (Object)StringUtils.booleanArrayToString(sm.getLoadedFields())));
            } else if (oldSM != sm) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003005", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.getIdentityAsString(sm.getInternalObjectId()), (Object)StringUtils.booleanArrayToString(sm.getLoadedFields())));
            }
        }
    }

    public synchronized void putObjectIntoLevel2Cache(StateManager sm, boolean updateIfPresent) {
        if (this.txCachedIds != null && !this.txCachedIds.contains(sm.getInternalObjectId())) {
            this.putObjectIntoLevel2CacheInternal(sm, updateIfPresent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void putObjectIntoLevel2CacheInternal(StateManager sm, boolean updateIfPresent) {
        if (sm.getClassMetaData().isCacheable()) {
            Object id = sm.getInternalObjectId();
            Level2Cache l2Cache = this.omf.getLevel2Cache();
            if (!updateIfPresent && l2Cache.containsOid(id)) {
                return;
            }
            Level2Cache level2Cache = l2Cache;
            synchronized (level2Cache) {
                CachedPC cachedPC = sm.cache();
                if (cachedPC != null) {
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        if (l2Cache.containsOid(id)) {
                            NucleusLogger.CACHE.debug(LOCALISER.msg("004013", (Object)StringUtils.toJVMIDString(sm.getObject()), id, (Object)StringUtils.booleanArrayToString(cachedPC.getLoadedFields()), (Object)StringUtils.objectArrayToString(cachedPC.getRelationFieldNames())));
                        } else {
                            NucleusLogger.CACHE.debug(LOCALISER.msg("004003", (Object)StringUtils.toJVMIDString(sm.getObject()), id, (Object)StringUtils.booleanArrayToString(cachedPC.getLoadedFields()), (Object)StringUtils.objectArrayToString(cachedPC.getRelationFieldNames())));
                        }
                    }
                    l2Cache.put(id, cachedPC);
                }
            }
        }
    }

    public synchronized void removeObjectFromLevel2Cache(Object id) {
        if (id != null) {
            Level2Cache l2Cache = this.omf.getLevel2Cache();
            l2Cache.evict(id);
        }
    }

    public synchronized void removeObjectFromCache(Object pc, Object id) {
        if (id != null) {
            Object pcRemoved;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003009", (Object)StringUtils.toJVMIDString(pc), (Object)this.getIdentityAsString(id), (Object)String.valueOf(this.cache.size())));
            }
            if ((pcRemoved = this.cache.remove(id)) == null && NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003010", (Object)StringUtils.toJVMIDString(pc), (Object)this.getIdentityAsString(id)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObjectFromCache(Object id) {
        Object pc = null;
        StateManager sm = (StateManager)this.cache.get(id);
        if (sm != null) {
            pc = sm.getObject();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003008", (Object)StringUtils.toJVMIDString(pc), (Object)this.getIdentityAsString(id), (Object)StringUtils.booleanArrayToString(sm.getLoadedFields()), (Object)("" + this.cache.size())));
            }
            sm.resetDetachState();
            return pc;
        }
        if (NucleusLogger.CACHE.isDebugEnabled()) {
            NucleusLogger.CACHE.debug(LOCALISER.msg("003007", (Object)this.getIdentityAsString(id), (Object)("" + this.cache.size())));
        }
        if (this.omf.hasLevel2Cache()) {
            Level2Cache l2Cache;
            Level2Cache level2Cache = l2Cache = this.omf.getLevel2Cache();
            synchronized (level2Cache) {
                CachedPC cachedPC = l2Cache.get(id);
                if (cachedPC != null) {
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004015", (Object)this.getIdentityAsString(id), (Object)StringUtils.booleanArrayToString(cachedPC.getLoadedFields()), (Object)StringUtils.objectArrayToString(cachedPC.getRelationFieldNames()), (Object)("" + l2Cache.getSize())));
                    }
                    sm = StateManagerFactory.newStateManagerForCachedPC(this.getExecutionContext(), id, cachedPC);
                    pc = sm.getObject();
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004006", (Object)this.getIdentityAsString(id), (Object)StringUtils.toJVMIDString(pc)));
                    }
                    if (this.tx.isActive() && this.tx.getOptimistic()) {
                        sm.makeNontransactional();
                    } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                        sm.makeNontransactional();
                    }
                    return pc;
                }
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004005", (Object)this.getIdentityAsString(id), (Object)("" + l2Cache.getSize())));
                }
            }
        }
        return null;
    }

    public String getIdentityAsString(Object id) {
        if (id == null) {
            return null;
        }
        if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            return this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id) + ":" + this.getApiAdapter().getTargetKeyForSingleFieldIdentity(id);
        }
        return id.toString();
    }

    public boolean getSerializeReadForClass(String className) {
        AbstractClassMetaData cmd;
        if (this.tx.getSerializeRead() != null) {
            return this.tx.getSerializeRead();
        }
        if (className != null && (cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr)) != null) {
            return cmd.isSerializeRead();
        }
        return false;
    }

    public synchronized Extent getExtent(Class pcClass, boolean subclasses) {
        Extent extent;
        this.assertIsOpen();
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        try {
            clr.setPrimary(pcClass.getClassLoader());
            this.assertClassPersistable(pcClass);
            extent = this.getStoreManager().getExtent(this.getExecutionContext(), pcClass, subclasses);
            Object var6_6 = null;
        }
        catch (NucleusException jpe) {
            try {
                throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                clr.unsetPrimary();
                throw throwable;
            }
        }
        clr.unsetPrimary();
        return extent;
    }

    public synchronized Query newQuery() {
        return this.getOMFContext().getQueryManager().newQuery("JDOQL", this.getExecutionContext(), null);
    }

    public void removeAllInstanceLifecycleListeners() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    public CallbackHandler getCallbackHandler() {
        if (this.callbacks != null) {
            return this.callbacks;
        }
        String callbackHandlerClassName = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.callbackhandler", "name", this.getOMFContext().getApi(), "class-name");
        if (callbackHandlerClassName != null) {
            try {
                this.callbacks = (CallbackHandler)this.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.callbackhandler", "name", this.getOMFContext().getApi(), "class-name", new Class[]{OMFContext.class}, new Object[]{this.getOMFContext()});
                return this.callbacks;
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.error(LOCALISER.msg("025000", (Object)callbackHandlerClassName, (Object)e));
            }
        }
        return null;
    }

    public void addListener(Object listener, Class[] classes) {
        this.assertIsOpen();
        if (listener == null) {
            return;
        }
        this.getCallbackHandler().addListener(listener, classes);
    }

    public void removeListener(Object listener) {
        this.assertIsOpen();
        if (listener != null) {
            this.getCallbackHandler().removeListener(listener);
        }
    }

    public void disconnectLifecycleListener() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("010002")).setFatal();
        }
    }

    public void assertClassPersistable(Class cls) {
        if (cls != null && !this.getOMFContext().getApiAdapter().isPersistable(cls) && !cls.isInterface()) {
            throw new ClassNotPersistableException(cls.getName());
        }
        if (!this.hasPersistenceInformationForClass(cls)) {
            throw new NoPersistenceInformationException(cls.getName());
        }
    }

    protected void assertDetachable(Object object) {
        if (object != null && !this.getApiAdapter().isDetachable(object)) {
            throw new ClassNotDetachableException(object.getClass().getName());
        }
    }

    protected void assertNotDetached(Object object) {
        if (object != null && this.getApiAdapter().isDetached(object)) {
            throw new ObjectDetachedException(object.getClass().getName());
        }
    }

    protected void assertActiveTransaction() {
        if (!this.tx.isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertWritable() {
        if (!this.getTransaction().isActive() && !this.getTransaction().getNontransactionalWrite()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertHasImplementationCreator() {
        if (this.getOMFContext().getImplementationCreator() == null) {
            throw new NucleusUserException(LOCALISER.msg("010035"));
        }
    }

    public boolean hasPersistenceInformationForClass(Class cls) {
        if (cls == null) {
            return false;
        }
        if (this.getMetaDataManager().getMetaDataForClass(cls, this.getClassLoaderResolver()) != null) {
            return true;
        }
        if (cls.isInterface()) {
            try {
                this.newInstance(cls);
            }
            catch (RuntimeException ex) {
                NucleusLogger.PERSISTENCE.warn(ex);
            }
            return this.getMetaDataManager().getMetaDataForClass(cls, this.getClassLoaderResolver()) != null;
        }
        return false;
    }

    protected FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this.getOMFContext());
        }
        return this.fetchGrpMgr;
    }

    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    protected void removeInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getOMFContext().getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getOMFContext().getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name);
    }

    public Set getFetchGroupsWithName(String name) {
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    class ThreadContextInfo {
        int referenceCounter = 0;
        HashMap attachedPCById = null;

        ThreadContextInfo() {
        }
    }
}

