/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.store.Extent;
import org.datanucleus.store.query.Query;

public abstract class AbstractSQLQuery
extends Query {
    protected final transient String inputSQL;
    protected transient String compiledSQL = null;
    protected QueryResultMetaData resultMetaData = null;

    public AbstractSQLQuery(ObjectManager om, AbstractSQLQuery query) {
        this(om, query.inputSQL);
    }

    public AbstractSQLQuery(ObjectManager om, String sqlText) {
        super(om);
        this.candidateClass = null;
        this.filter = null;
        this.imports = null;
        this.explicitVariables = null;
        this.explicitParameters = null;
        this.ordering = null;
        if (sqlText == null) {
            throw new NucleusUserException(LOCALISER.msg("059001"));
        }
        this.inputSQL = sqlText.replace("\n", " ").trim();
        String firstToken = new StringTokenizer(this.inputSQL, " ").nextToken();
        if (firstToken.equalsIgnoreCase("SELECT")) {
            this.type = 0;
        } else if (firstToken.equalsIgnoreCase("DELETE")) {
            this.type = (short)2;
            this.unique = true;
        } else if (firstToken.equalsIgnoreCase("INSERT") || firstToken.equalsIgnoreCase("UPDATE") || firstToken.equalsIgnoreCase("MERGE")) {
            this.type = 1;
            this.unique = true;
        } else {
            this.type = (short)3;
        }
        PersistenceConfiguration conf = om.getOMFContext().getPersistenceConfiguration();
        if (om.getApiAdapter().getName().equalsIgnoreCase("JDO") && !conf.getBooleanProperty("datanucleus.query.sql.allowAll") && !firstToken.equals("SELECT") && !firstToken.startsWith("select")) {
            throw new NucleusUserException(LOCALISER.msg("059002", (Object)this.inputSQL));
        }
    }

    public String getLanguage() {
        return "SQL";
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.compiledSQL = null;
    }

    public String getInputSQL() {
        return this.inputSQL;
    }

    public void setCandidates(Extent pcs) {
        throw new NucleusUserException(LOCALISER.msg("059004"));
    }

    public void setCandidates(Collection pcs) {
        throw new NucleusUserException(LOCALISER.msg("059005"));
    }

    public void setResult(String result) {
        throw new NucleusUserException(LOCALISER.msg("059006"));
    }

    public void setResultMetaData(QueryResultMetaData qrmd) {
        this.resultMetaData = qrmd;
        super.setResultClass(null);
    }

    public void setResultClass(Class result_cls) {
        super.setResultClass(result_cls);
        this.resultMetaData = null;
    }

    public void setRange(int fromIncl, int toExcl) {
        throw new NucleusUserException(LOCALISER.msg("059007"));
    }

    public void setSubclasses(boolean subclasses) {
        throw new NucleusUserException(LOCALISER.msg("059004"));
    }

    public void setFilter(String filter) {
        throw new NucleusUserException(LOCALISER.msg("059008"));
    }

    public void declareExplicitVariables(String variables) {
        throw new NucleusUserException(LOCALISER.msg("059009"));
    }

    public void declareExplicitParameters(String parameters) {
        throw new NucleusUserException(LOCALISER.msg("059016"));
    }

    public void declareImports(String imports) {
        throw new NucleusUserException(LOCALISER.msg("059026"));
    }

    public void setGrouping(String grouping) {
        throw new NucleusUserException(LOCALISER.msg("059010"));
    }

    public void setOrdering(String ordering) {
        throw new NucleusUserException(LOCALISER.msg("059011"));
    }

    protected long performDeletePersistentAll(Map parameters) {
        throw new NucleusUserException(LOCALISER.msg("059000"));
    }

    public Object executeWithArray(Object[] parameters) {
        HashMap<Integer, Object> parameterMap = new HashMap<Integer, Object>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                parameterMap.put(i + 1, parameters[i]);
            }
        }
        Map executionMap = this.prepareForExecution(parameterMap);
        return super.executeQuery(executionMap);
    }

    public Object executeWithMap(Map executeParameters) {
        Map executionMap = this.prepareForExecution(executeParameters);
        return super.executeQuery(executionMap);
    }

    protected Map prepareForExecution(Map executeParameters) {
        HashMap params = new HashMap();
        if (this.implicitParameters != null) {
            params.putAll(this.implicitParameters);
        }
        if (executeParameters != null) {
            params.putAll(executeParameters);
        }
        this.compileInternal(true, executeParameters);
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Object> expectedParams = new ArrayList<Object>();
        boolean complete = false;
        int charPos = 0;
        char[] statement = this.compiledSQL.toCharArray();
        StringBuffer paramName = null;
        int paramPos = 0;
        boolean colonParam = true;
        StringBuffer runtimeJdbcText = new StringBuffer();
        while (!complete) {
            char c = statement[charPos];
            boolean endOfParam = false;
            if (c == '?') {
                colonParam = false;
                ++paramPos;
                paramName = new StringBuffer();
            } else if (c == ':') {
                if (charPos > 0) {
                    char c2 = statement[charPos - 1];
                    if (!Character.isLetterOrDigit(c2)) {
                        colonParam = true;
                        ++paramPos;
                        paramName = new StringBuffer();
                    }
                } else {
                    colonParam = true;
                    ++paramPos;
                    paramName = new StringBuffer();
                }
            } else if (paramName != null) {
                if (Character.isLetterOrDigit(c)) {
                    paramName.append(c);
                } else {
                    endOfParam = true;
                }
            }
            if (paramName != null) {
                if (endOfParam) {
                    runtimeJdbcText.append('?');
                    runtimeJdbcText.append(c);
                }
            } else {
                runtimeJdbcText.append(c);
            }
            boolean bl = complete = ++charPos == this.compiledSQL.length();
            if (complete && paramName != null && !endOfParam) {
                runtimeJdbcText.append('?');
            }
            if (paramName == null || !complete && !endOfParam) continue;
            if (paramName.length() > 0) {
                if (colonParam) {
                    expectedParams.add(paramName.toString());
                } else {
                    try {
                        Integer n = Integer.valueOf(paramName.toString());
                        expectedParams.add(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NucleusUserException("SQL query " + this.inputSQL + " contains an invalid parameter specification " + paramName.toString());
                    }
                }
            } else if (!colonParam) {
                expectedParams.add(paramPos);
            }
            paramName = null;
        }
        this.compiledSQL = runtimeJdbcText.toString();
        if (expectedParams.size() > 0 && params == null) {
            throw new NucleusUserException(LOCALISER.msg("059028", (Object)this.inputSQL, (Object)("" + expectedParams.size())));
        }
        HashMap executeMap = new HashMap();
        if (params != null) {
            paramPos = 1;
            for (Object e : expectedParams) {
                if (!params.containsKey(e)) {
                    throw new NucleusUserException(LOCALISER.msg("059030", (Object)this.inputSQL, (Object)("" + e)));
                }
                executeMap.put(paramPos, params.get(e));
                paramNames.add("" + paramPos);
                ++paramPos;
            }
        }
        this.parameterNames = paramNames.toArray(new String[paramNames.size()]);
        return executeMap;
    }

    protected boolean shouldReturnSingleRow() {
        return this.unique;
    }
}

