/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.mapped.expression.ArrayExpression;
import org.datanucleus.store.mapped.expression.ArrayLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.util.NucleusLogger;

public class ArrayMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    private static Byte mappingSampleValue = new Byte("0");

    public Class getJavaType() {
        if (this.mmd != null) {
            return this.mmd.getType();
        }
        return null;
    }

    protected boolean containerIsStoredInSingleColumn() {
        if (super.containerIsStoredInSingleColumn()) {
            return true;
        }
        return this.mmd != null && this.mmd.hasArray() && this.mmd.getJoinMetaData() == null && MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.mmd);
    }

    public void postInsert(StateManager sm) {
        Object value = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value);
            return;
        }
        if (value == null) {
            return;
        }
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
            }
            if (!this.mmd.getType().getComponentType().isPrimitive()) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    if (sm.getObjectManager().getApiAdapter().isDetached(array[i]) || sm.getObjectManager().getApiAdapter().isPersistent(array[i])) continue;
                    throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), array[i]);
                }
            }
        } else {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007007", (Object)this.mmd.getFullFieldName()));
            }
            ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.mmd, null)).set(sm, value);
        }
    }

    public void insertPostProcessing(StateManager sm) {
    }

    public void postFetch(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        List elements = ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.mmd, null)).getArray(sm);
        if (elements != null) {
            boolean primitiveArray = this.mmd.getType().getComponentType().isPrimitive();
            Object array = Array.newInstance(this.mmd.getType().getComponentType(), elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                if (primitiveArray) {
                    if (element instanceof Boolean) {
                        Array.setBoolean(array, i, (Boolean)element);
                        continue;
                    }
                    if (element instanceof Byte) {
                        Array.setByte(array, i, (Byte)element);
                        continue;
                    }
                    if (element instanceof Character) {
                        Array.setChar(array, i, ((Character)element).charValue());
                        continue;
                    }
                    if (element instanceof Double) {
                        Array.setDouble(array, i, (Double)element);
                        continue;
                    }
                    if (element instanceof Float) {
                        Array.setFloat(array, i, ((Float)element).floatValue());
                        continue;
                    }
                    if (element instanceof Integer) {
                        Array.setInt(array, i, (Integer)element);
                        continue;
                    }
                    if (element instanceof Long) {
                        Array.setLong(array, i, (Long)element);
                        continue;
                    }
                    if (!(element instanceof Short)) continue;
                    Array.setShort(array, i, (Short)element);
                    continue;
                }
                Array.set(array, i, element);
            }
            if (elements.size() == 0) {
                sm.replaceField(this.mmd.getAbsoluteFieldNumber(), null, true);
            } else {
                sm.replaceField(this.mmd.getAbsoluteFieldNumber(), array, true);
            }
        } else {
            sm.replaceField(this.mmd.getAbsoluteFieldNumber(), null, true);
        }
    }

    public void postUpdate(StateManager sm) {
        Object value = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value);
            return;
        }
        if (value == null) {
            ((ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.mmd, null)).clear(sm);
            return;
        }
        if (!this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007008", (Object)this.mmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007009", (Object)this.mmd.getFullFieldName()));
        }
        ArrayStore backingStore = (ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.mmd, null);
        backingStore.clear(sm);
        backingStore.set(sm, value);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.getObjectManager().getApiAdapter().isLoaded(sm, this.mmd.getAbsoluteFieldNumber());
        Object value = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        ArrayStore backingStore = (ArrayStore)this.storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.mmd, null);
        backingStore.clear(sm);
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return mappingSampleValue;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(LOCALISER.msg("041026", (Object)this.mmd.getFullFieldName())).setFatal();
        }
        return new ArrayLiteral(qs, (JavaTypeMapping)this, value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(LOCALISER.msg("041026", (Object)this.mmd.getFullFieldName())).setFatal();
        }
        return new ArrayExpression(qs, this.datastoreContainer.getIdMapping(), te, (ArrayStore)this.storeMgr.getBackingStoreForField(qs.getClassLoaderResolver(), this.mmd, null), this.mmd.getName());
    }
}

