/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.StringUtils;

public class ArrayExpression
extends Expression {
    List<Expression> elements = new ArrayList<Expression>();

    public ArrayExpression(Expression[] elements) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                this.elements.add(elements[i]);
            }
        }
    }

    public Expression getElement(int index) {
        if (index < 0 || index >= this.elements.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements.get(index);
    }

    public int getArraySize() {
        return this.elements.size();
    }

    public Symbol bind(SymbolTable symtbl) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Expression expr = this.elements.get(i);
            expr.bind(symtbl);
        }
        return this.symbol;
    }

    public String toString() {
        return "ArrayExpression{" + StringUtils.collectionToString(this.elements) + "}";
    }
}

