/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.Type;
import org.datanucleus.store.types.TypeManager;

public class ExecutionContextImpl
implements ExecutionContext {
    ObjectManager om;

    public ExecutionContextImpl(ObjectManager om) {
        this.om = om;
    }

    public Object findObjectUsingAID(Type pcClass, final FieldValues2 fv, boolean ignoreCache, boolean checkInheritance) {
        return this.om.findObjectUsingAID(pcClass.getType(), new FieldValues(){

            public FetchPlan getFetchPlanForLoading() {
                return fv.getFetchPlanForLoading();
            }

            public void fetchNonLoadedFields(StateManager sm) {
                fv.fetchNonLoadedFields(sm.getObjectProvider());
            }

            public void fetchFields(StateManager sm) {
                fv.fetchFields(sm.getObjectProvider());
            }
        }, ignoreCache, checkInheritance);
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.om.getClassLoaderResolver();
    }

    public MetaDataManager getMetaDataManager() {
        return this.om.getMetaDataManager();
    }

    public Transaction getTransaction() {
        return this.om.getTransaction();
    }

    public TypeManager getTypeManager() {
        return this.om.getOMFContext().getTypeManager();
    }

    public ObjectProvider findObjectProvider(Object object) {
        StateManager sm = this.om.findStateManager(object);
        if (sm == null) {
            return null;
        }
        return sm.getObjectProvider();
    }

    public ObjectProvider findObjectProvider(Object object, boolean persist) {
        StateManager sm = this.om.findStateManager(object);
        if (sm == null && persist) {
            int objectType = 0;
            Object object2 = this.om.persistObjectInternal(object, null, null, -1, objectType);
            sm = this.om.findStateManager(object2);
        } else if (sm == null) {
            return null;
        }
        return sm.getObjectProvider();
    }

    public ApiAdapter getApiAdapter() {
        return this.om.getApiAdapter();
    }

    public ObjectProvider findObjectProviderForEmbedded(Object value, ObjectProvider owner, AbstractMemberMetaData mmd) {
        StateManager embeddedSM = this.om.findStateManager(value);
        if (embeddedSM == null) {
            embeddedSM = StateManagerFactory.newStateManagerForEmbedded(this.om, value, false);
        }
        if (embeddedSM.getEmbeddedOwners() == null || embeddedSM.getEmbeddedOwners().length == 0) {
            int absoluteFieldNumber = owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber();
            embeddedSM.getObjectProvider().addEmbeddedOwner(owner, absoluteFieldNumber);
            embeddedSM.setPcObjectType(1);
        }
        return embeddedSM.getObjectProvider();
    }

    public ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd) {
        Class pcClass = this.om.getClassLoaderResolver().classForName(mmd.getClassName());
        StateManager sm = StateManagerFactory.newStateManagerForHollow(this.om, pcClass, null);
        if (mmd.isEmbedded() || mmd.getEmbeddedMetaData() != null) {
            sm.initialiseForEmbedded(sm.getObject(), true);
        }
        return sm.getObjectProvider();
    }

    public ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd, Type effectiveType) {
        Class pcClass = this.om.getClassLoaderResolver().classForName(effectiveType.getName());
        StateManager sm = StateManagerFactory.newStateManagerForHollow(this.om, pcClass, null);
        if (mmd.isEmbedded() || mmd.getEmbeddedMetaData() != null) {
            sm.initialiseForEmbedded(sm.getObject(), true);
        }
        return sm.getObjectProvider();
    }

    public ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd, AbstractClassMetaData effectiveTypeCmd) {
        Class pcClass = this.om.getClassLoaderResolver().classForName(effectiveTypeCmd.getFullClassName());
        StateManager sm = StateManagerFactory.newStateManagerForHollow(this.om, pcClass, null);
        if (mmd.isEmbedded() || mmd.getEmbeddedMetaData() != null || effectiveTypeCmd.isEmbeddedOnly()) {
            sm.initialiseForEmbedded(sm.getObject(), true);
        }
        return sm.getObjectProvider();
    }

    public void deleteObjectInternal(Object pc) {
        this.om.deleteObjectInternal(pc);
    }

    public Object persistObjectInternal(Object pc, ObjectProvider ownerSM, int ownerFieldNum, int objectType) {
        if (ownerSM != null) {
            StateManager sm = this.om.findStateManager(ownerSM.getObject());
            return this.om.persistObjectInternal(pc, null, sm, ownerFieldNum, objectType);
        }
        return this.om.persistObjectInternal(pc, null, null, ownerFieldNum, objectType);
    }

    public boolean isClosed() {
        return this.om.isClosed();
    }
}

