/**********************************************************************
Copyright (c) 2009 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
   ...
**********************************************************************/
package org.datanucleus.store.query;

import java.util.ArrayList;
import java.util.List;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;

/**
 * Abstract implementation of a lazy load list for candidates.
 */
public abstract class AbstractCandidateLazyLoadList extends AbstractLazyLoadList
{
    /** ObjectManager handling the datastore access. */
    protected ObjectManager om;

    /** Collection of class metadata suitable for returned objects that haven't yet been fully processed. */
    protected List<AbstractClassMetaData> cmds = new ArrayList<AbstractClassMetaData>();

    public AbstractCandidateLazyLoadList(Class cls, boolean subclasses, ObjectManager om, String cacheType)
    {
        super(cacheType);
        this.om = om;

        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(cls, clr);
        cmds.add(acmd);
        if (subclasses)
        {
            // Add on any subclass objects
            String[] subclassNames = om.getMetaDataManager().getSubclassesForClass(cls.getName(), true);
            if (subclassNames != null)
            {
                for (int i=0;i<subclassNames.length;i++)
                {
                    AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(subclassNames[i], clr);
                    cmds.add(cmd);
                }
            }
        }
    }
}