/**********************************************************************
Copyright (c) 2004 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    Andy Jefferson - removed getUpdateInputParameter,getInsertionInputParameter
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

/**
 * Mapping for Index Columns.
 * This class is for internal use only. It should not be used in user mappings nor extended. 
 */
public final class IndexMapping extends SingleFieldMapping
{
    private static Integer mappingSampleValue = Integer.valueOf(0);

    /**
     * Accessor for a sample value for this field
     * @return Sample field value
     */
    public Object getSampleValue(ClassLoaderResolver clr)
    {
        return mappingSampleValue;
    }

    /**
     * Accessor for whether to include this column in any fetch statement
     * @return Whether to include the column when fetching.
     */
    public boolean includeInFetchStatement()
    {
        return false;
    }

    /**
     * Accessor for the type represented here, returning the class itself
     * @return This class.
     */
    public Class getJavaType()
    {
        return Integer.class;
    }

    /**
     * Accessor for a new literal for this mapping.
     * @param qs The QueryStatement
     * @param value The value of the object
     * @return The new literal
     */
    public ScalarExpression newLiteral(QueryExpression qs, Object value)
    {
        return new IntegerLiteral(qs, this, (Number)value);
    }

    /**
     * Accessor for a new literal for this mapping.
     * @param qs The QueryStatement
     * @param te The table Expression
     * @return The new literal
     */
    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te)
    {
        return new NumericExpression(qs, this, te);
    }
}