/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * Representation of temporal functions in java query languages.
 * @version $Revision: 1.11 $
 */
public class TemporalExpression extends ScalarExpression
{
    /**
     * @param qs The query statement
     */
    public TemporalExpression(QueryExpression qs)
    {
        super(qs);
    }

    /**
     * Returns the current date as an expression.
     * @return the result in a ScalarExpression instance
     */  
    public ScalarExpression currentDateMethod()
    {
        return qs.getStoreManager().getDatastoreAdapter().getCurrentDateMethod(qs);
    }

    /**
     * Returns the current time as an expression.
     * @return the result in a ScalarExpression instance
     */
    public ScalarExpression currentTimeMethod()
    {
        return qs.getStoreManager().getDatastoreAdapter().getCurrentTimeMethod(qs);
    }

    /**
     * Returns the current timestamp as an expression.
     * @return the result in a ScalarExpression instance
     */
    public ScalarExpression currentTimestampMethod()
    {
        return qs.getStoreManager().getDatastoreAdapter().getCurrentTimestampMethod(qs);
    }
}