/**********************************************************************
Copyright (c) 2002 Mike Martin (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.mapping.NullMapping;


/**
 * Representation of a Null literal in a Query.
 */
public class NullLiteral extends ScalarExpression implements Literal
{
    /**
     * Creates a null literal
     * @param qs the QueryExpression
     */
    public NullLiteral(QueryExpression qs)
    {
        super(qs);
        this.mapping = new NullMapping(qs.getStoreManager());
        st.append("NULL");
    }

    public Object getValue()
    {
        return null;
    }

    public ScalarExpression add(ScalarExpression expr)
    {
        return this;
    }

    public BooleanExpression eq(ScalarExpression expr)
    {
        if (expr instanceof NullLiteral)
        {
            return new BooleanLiteral(qs,mapping,true);
        }
        if (expr instanceof ObjectExpression)
        {
            return expr.eq(this);
        }
        return new BooleanExpression(expr, OP_IS, this);
    }

    public BooleanExpression noteq(ScalarExpression expr)
    {
        if (expr instanceof NullLiteral)
        {
            return new BooleanLiteral(qs,mapping,false);
        }
        if (expr instanceof ObjectExpression)
        {
            return expr.noteq(this);
        }
        return new BooleanExpression(expr, OP_ISNOT, this);
    }

    /**
     * Method to save a "raw" value that this literal represents.
     * This value differs from the literal value since that is of the same type as this literal.
     * @param val The raw value
     */
    public void setRawValue(Object val)
    {
    }

    /**
     * Accessor for the "raw" value that this literal represents.
     * This value differs from the literal value since that is of the same type as this literal.
     * @return The raw value
     */
    public Object getRawValue()
    {
        return null;
    }
}