/**********************************************************************
Copyright (c) 2005 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

/**
 * Interface that allows one datastore adapt pattern expressions
 * @version $Revision: 1.3 $
 */
public interface ExpressionPatternAdapter
{
    /**
     * Escape the characters of an expression expanded in word searches.
     * @param patternExpression The expression
     * @return the escaped string.
     **/
    ScalarExpression getEscapedPatternExpression(ScalarExpression patternExpression);
    
    /**
     * The pattern string for representing one character that is expanded in word searches.
     * Most of databases will use the underscore character.
     * @return the pattern string.
     **/
    String getPatternExpressionAnyCharacter();
    
    /**
     * The pattern string for representing zero or more characters that is expanded in word searches.
     * Most of databases will use the percent sign character.
     * @return the pattern string.
     **/
    String getPatternExpressionZeroMoreCharacters();
    
    /**
     * The character for escaping characters in pattern expressions.
     * @return the character.
     **/
    String getEscapePatternExpression();
    
    /**
     * The character for escaping characters in pattern expressions.
     * @return the character.
     **/
    String getEscapeCharacter();    
}

