/**********************************************************************
Copyright (c) 2009 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
   ...
**********************************************************************/
package org.datanucleus.store;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Transaction;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.types.TypeManager;

/**
 * Context of execution for persistence operations
 */
public interface ExecutionContext
{
    /**
     * TODO this is temporary. should be replaced when supporting any API/language  
     */
    Object findObjectUsingAID(Type pcClass, FieldValues2 fv, boolean ignoreCache, boolean checkInheritance);

    /**
     * Accessor for the MetaData Manager.
     * @return The MetaData Manager
     */
    MetaDataManager getMetaDataManager();
    
    /**
     * Accessor for the current transaction for this ExecutionContext.
     * @return The current transaction
     */
    Transaction getTransaction();

    /**
     * Accessor for the ClassLoader resolver to use in class loading issues.
     * @return The ClassLoader resolver
     */
    ClassLoaderResolver getClassLoaderResolver();
    
    /**
     * TODO should we keep this here? this is api/language dependent
     * @return
     */
    TypeManager getTypeManager();
    
    ObjectProvider findObjectProvider(Object object);

    ObjectProvider findObjectProvider(Object object, boolean persist);
    
    ApiAdapter getApiAdapter();
    
    ObjectProvider findObjectProviderForEmbedded(Object value, ObjectProvider owner, AbstractMemberMetaData mmd);
    
    ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd);

    ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd, Type effectiveType);

    ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd, AbstractClassMetaData effectiveTypeCmd);

    void deleteObjectInternal(Object pc);
    
    /**
     * Method to persist the passed object (internally).
     * @param pc The object
     * @param ownerSM StateManager of the owner when embedded
     * @param ownerFieldNum Field number in the owner where this is embedded (or -1 if not embedded)
     * @param objectType Type of object (see org.datanucleus.StateManager, e.g StateManager.PC)
     * @return The persisted object
     */
    Object persistObjectInternal(Object pc, ObjectProvider ownerSM, int ownerFieldNum, int objectType);
    
    boolean isClosed();
}