/**********************************************************************
Copyright (c) 2009 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.state;

import javax.jdo.spi.PersistenceCapable;

import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.util.StringUtils;

/**
 * Implementation of ObjectProvider for StateManager 
 */
public class ObjectProviderImpl implements ObjectProvider
{
    StateManager sm;

    public ObjectProviderImpl(StateManager sm)
    {
        this.sm = sm;
    }
    public AbstractClassMetaData getClassMetaData()
    {
        return sm.getClassMetaData();
    }

    public ExecutionContext getExecutionContext()
    {
        return sm.getObjectManager().getExecutionContext();
    }

    public Object provideField(int fieldNumber)
    {
        return sm.provideField(fieldNumber);
    }

    public void provideFields(int[] fieldNumbers, FieldManager fm)
    {
        sm.provideFields(fieldNumbers, fm);
    }

    public void replaceFields(int[] fieldNumbers, FieldManager fm)
    {
        sm.replaceFields(fieldNumbers, fm);
    }

    public void replaceField(int fieldNumber, Object value)
    {
        sm.replaceField(fieldNumber, value, false);
    }
    
    public void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm)
    {
        sm.replaceNonLoadedFields(fieldNumbers, fm);
    }
    
    public String toPrintableID()
    {
        return StringUtils.toJVMIDString(sm.getObject());
    }
    
    public Object wrapSCOField(int fieldNumber, Object value, boolean forInsert, boolean forUpdate, boolean replaceFieldIfChanged)
    {
        return sm.wrapSCOField(fieldNumber, value, forInsert, forUpdate, replaceFieldIfChanged);
    }
    
    public Object getObject()
    {
        return sm.getObject();
    }
    
    public Object getInternalObjectId()
    {
        return sm.getInternalObjectId();
    }
    
    public Object getExternalObjectId()
    {
        return sm.getExternalObjectId(sm.getObject());
    }
    public void deletePersistent()
    {
        sm.deletePersistent();
    }
    public String[] getDirtyFieldNames()
    {
        return sm.getDirtyFieldNames();
    }

    public int[] getDirtyFieldNumbers()
    {
        return sm.getDirtyFieldNumbers();
    }
    
    public ObjectProvider[] getEmbeddedOwners()
    {
        StateManager[] sms = sm.getEmbeddedOwners();
        if (sms==null)
        {
            return null;
        }
        ObjectProvider op[] = new ObjectProvider[sms.length];
        for (int i=0; i<sms.length; i++)
        {
            op[i] = sms[i].getObjectProvider();
        }
        return op;
    }
    
    public boolean isInserting()
    {
        return sm.isInserting();
    }
    
    public void loadUnloadedFields()
    {
        sm.loadUnloadedFields();
    }
    public void makeDirty(int fieldNumber)
    {
        sm.makeDirty(fieldNumber);
    }
    
    public void setAssociatedValue(Object key, Object value)
    {
        sm.setAssociatedValue(key, value);
    }
    
    public LifeCycleState getLifecycleState()
    {
        return ((AbstractStateManager)sm).getLifecycleState();
    }
    
    /**
     * Method to register an owner StateManager with this embedded/serialised object.
     * @param ownerSM The owning State Manager.
     * @param ownerFieldNumber The field number in the owner that the embedded/serialised object is stored as
     */
    public void addEmbeddedOwner(ObjectProvider ownerSM, int ownerFieldNumber)
    {
        sm.addEmbeddedOwner(((ObjectProviderImpl)ownerSM).sm, ownerFieldNumber);
    }
    
    public boolean isEmbedded()
    {
        return sm.isEmbedded();
    }
    
    public void copyFieldsFromObject(Object pc, int[] fieldNumbers)
    {
       sm.copyFieldsFromObject((PersistenceCapable)pc, fieldNumbers);
        
    }
}