/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.ArrayList;
import java.util.Iterator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.TableMismatchException;

public class TableExprAsSubjoins
extends LogicSetExpression {
    protected final ArrayList supertables = new ArrayList();

    public TableExprAsSubjoins(QueryExpression qs, DatastoreContainerObject mainTable, DatastoreIdentifier mainRangeVar) {
        super(qs, mainTable, mainRangeVar);
    }

    public String referenceColumn(DatastoreField col) {
        this.assertNotFrozen();
        DatastoreContainerObject table = col.getDatastoreContainerObject();
        if (!table.equals(this.mainTable)) {
            if (!(this.mainTable instanceof DatastoreClass) || !(table instanceof DatastoreClass)) {
                throw new TableMismatchException(col, this.mainTable);
            }
            if (!this.supertables.contains(table)) {
                this.supertables.add(table);
            }
        }
        if (((Object)this.mainAlias).toString().length() > 0) {
            return col.applySelectFunction(this.mainAlias + "." + col.getIdentifier());
        }
        return col.applySelectFunction(((Object)col.getIdentifier()).toString());
    }

    public String toString() {
        if (this.sqlText == null) {
            StringBuffer sb = new StringBuffer();
            DatastoreIdentifier mainTableName = this.mainTable.getIdentifier();
            Iterator i = this.supertables.iterator();
            if (i.hasNext()) {
                sb.append('(');
                if (this.getMainTable().getStoreManager().getDatastoreAdapter().supportsOption("ProjectionInTableReferenceJoins")) {
                    sb.append("SELECT * FROM ");
                }
                sb.append(this.mainTable.toString());
                while (i.hasNext()) {
                    DatastoreClass supertable = (DatastoreClass)i.next();
                    sb.append(" INNER JOIN ").append(((Object)supertable).toString());
                    sb.append(" ON ");
                    for (int j = 0; j < ((DatastoreClass)this.mainTable).getIdMapping().getNumberOfDatastoreMappings(); ++j) {
                        DatastoreIdentifier mainTableIDColumnName = ((DatastoreClass)this.mainTable).getIdMapping().getDatastoreMapping(j).getDatastoreField().getIdentifier();
                        if (j > 0) {
                            sb.append(" AND ");
                        }
                        sb.append(this.mainTable.toString()).append('.').append(mainTableIDColumnName);
                        sb.append(" = ");
                        sb.append(((Object)supertable).toString()).append('.').append(supertable.getIdMapping().getDatastoreMapping(j).getDatastoreField().getIdentifier());
                    }
                }
                sb.append(") ").append(this.mainAlias);
            } else {
                sb.append(this.mainTable.toString());
                if (!this.mainAlias.equals(mainTableName)) {
                    sb.append(' ').append(this.mainAlias);
                }
            }
            this.sqlText = sb.toString();
        }
        return this.sqlText;
    }
}

