/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreElementContainer;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.ObjectLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AppIDObjectIdFieldConsumer;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class PersistableMapping
extends OIDMapping
implements MappingCallbacks {
    protected JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    protected AbstractClassMetaData cmd;
    private int numberOfDatastoreFields = 0;

    public void initialize(AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(mmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (mapping == null) {
            throw new NucleusException("mapping argument in PersistenceCapableMapping.addJavaTypeMapping is null").setFatal();
        }
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    protected void prepareDatastoreMapping() {
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        if (this.roleForMember != 3 && this.roleForMember != 4 && this.roleForMember != 5 && this.roleForMember != 6) {
            AbstractClassMetaData refCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.mmd.getType(), clr);
            JavaTypeMapping referenceMapping = null;
            if (refCmd.getInheritanceMetaData() != null && refCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                AbstractClassMetaData[] cmds = this.storeMgr.getClassesManagingTableForClass(refCmd, clr);
                if (cmds != null && cmds.length > 0) {
                    if (cmds.length > 1) {
                        NucleusLogger.PERSISTENCE.warn("Field " + this.mmd.getFullFieldName() + " represents either a 1-1 relation, " + "or a N-1 relation where the other end uses \"subclass-table\" inheritance strategy and more " + "than 1 subclasses with a table. This is not fully supported by JPOX");
                    }
                } else {
                    return;
                }
                referenceMapping = this.storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIdMapping();
            } else {
                referenceMapping = this.storeMgr.getDatastoreClass(this.mmd.getType().getName(), clr).getIdMapping();
            }
            CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper(this.mmd, referenceMapping, true);
            int relationType = this.mmd.getRelationType(clr);
            boolean createDatastoreMappings = true;
            if (relationType == 6) {
                AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                createDatastoreMappings = relatedMmds[0].getJoinMetaData() == null;
            } else if (relationType == 2) {
                createDatastoreMappings = this.mmd.getMappedBy() == null;
            }
            for (int i = 0; i < referenceMapping.getNumberOfDatastoreMappings(); ++i) {
                DatastoreMapping refDatastoreMapping = referenceMapping.getDatastoreMapping(i);
                JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType());
                this.addJavaTypeMapping(mapping);
                if (createDatastoreMappings) {
                    ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refDatastoreMapping.getDatastoreField().getIdentifier());
                    if (colmd == null) {
                        throw new NucleusUserException(LOCALISER.msg("041038", refDatastoreMapping.getDatastoreField().getIdentifier(), (Object)this.toString())).setFatal();
                    }
                    MappingManager mmgr = this.storeMgr.getMappingManager();
                    DatastoreField col = mmgr.createDatastoreField(this.mmd, this.datastoreContainer, mapping, colmd, refDatastoreMapping.getDatastoreField(), clr);
                    DatastoreMapping datastoreMapping = mmgr.createDatastoreMapping(mapping, col, refDatastoreMapping.getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                    this.addDatastoreMapping(datastoreMapping);
                    continue;
                }
                mapping.setReferenceMapping(referenceMapping);
            }
        }
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    public int getNumberOfDatastoreMappings() {
        if (this.numberOfDatastoreFields == 0) {
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                this.numberOfDatastoreFields += this.javaTypeMappings[i].getNumberOfDatastoreMappings();
            }
        }
        return this.numberOfDatastoreFields;
    }

    public DatastoreMapping getDatastoreMapping(int index) {
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreMappings();
            for (int j = 0; j < numberDatastoreMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getDatastoreMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new NucleusException("Invalid index " + index + " for DataStoreMapping.").setFatal();
    }

    public DatastoreMapping[] getDatastoreMappings() {
        if (this.datastoreMappings.length == 0) {
            this.datastoreMappings = new DatastoreMapping[this.getNumberOfDatastoreMappings()];
            int currentIndex = 0;
            int numberJavaMappings = this.javaTypeMappings.length;
            for (int i = 0; i < numberJavaMappings; ++i) {
                int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreMappings();
                for (int j = 0; j < numberDatastoreMappings; ++j) {
                    this.datastoreMappings[currentIndex++] = this.javaTypeMappings[i].getDatastoreMapping(j);
                }
            }
        }
        return super.getDatastoreMappings();
    }

    public Object getValueForDatastoreMapping(ObjectManager om, int index, Object value) {
        if (this.cmd == null) {
            this.cmd = om.getMetaDataManager().getMetaDataForClass(this.getType(), om.getClassLoaderResolver());
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.cmd.getPKMemberPositions()[index]);
            StateManager sm = null;
            if (om != null) {
                sm = om.findStateManager(value);
            }
            if (sm == null) {
                if (mmd instanceof FieldMetaData) {
                    return ClassUtils.getValueOfFieldByReflection(value, mmd.getName());
                }
                return ClassUtils.getValueOfMethodByReflection(value, ClassUtils.getJavaBeanGetterName(mmd.getName(), false), null);
            }
            if (!mmd.isPrimaryKey()) {
                om.getApiAdapter().isLoaded(sm, mmd.getAbsoluteFieldNumber());
            }
            SingleValueFieldManager fm = new SingleValueFieldManager();
            sm.provideFields(new int[]{mmd.getAbsoluteFieldNumber()}, fm);
            return fm.fetchObjectField(mmd.getAbsoluteFieldNumber());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            // empty if block
        }
        return null;
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value) {
        this.setObject(om, ps, param, value, null, -1);
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        if (value == null) {
            this.setObjectAsNull(om, ps, param);
        } else {
            this.setObjectAsValue(om, ps, param, value, ownerSM, ownerFieldNumber);
        }
    }

    private void setObjectAsNull(ObjectManager om, Object ps, int[] param) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (mapping.getNumberOfDatastoreMappings() <= 0) continue;
            int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            mapping.setObject(om, ps, posMapping, null);
        }
    }

    private boolean hasDatastoreAttributedPrimaryKeyValues(MetaDataManager mdm, StoreManager srm, ClassLoaderResolver clr) {
        AbstractClassMetaData acmd;
        boolean hasDatastoreAttributedPrimaryKeyValues = false;
        if (this.mmd != null && this.roleForMember != 4 && this.roleForMember != 3 && this.roleForMember != 5 && this.roleForMember != 6 && (acmd = mdm.getMetaDataForClass(this.mmd.getType(), clr)).getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < acmd.getPKMemberPositions().length; ++i) {
                IdentityStrategy strategy = acmd.getMetaDataForManagedMemberAtAbsolutePosition(acmd.getPKMemberPositions()[i]).getValueStrategy();
                if (strategy == null) continue;
                hasDatastoreAttributedPrimaryKeyValues |= srm.isStrategyDatastoreAttributed(strategy, false);
            }
        }
        return hasDatastoreAttributedPrimaryKeyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObjectAsValue(ObjectManager om, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        ApiAdapter api = om.getApiAdapter();
        if (!api.isPersistable(value)) {
            throw new NucleusException(LOCALISER.msg("041016", value.getClass(), value)).setFatal();
        }
        StateManager sm = om.findStateManager(value);
        try {
            Object attachedValue;
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
            boolean hasDatastoreAttributedPrimaryKeyValues = this.hasDatastoreAttributedPrimaryKeyValues(om.getMetaDataManager(), storeMgr, clr);
            boolean inserted = false;
            if (ownerFieldNumber >= 0) {
                inserted = storeMgr.isObjectInserted(sm, ownerFieldNumber);
            } else if (this.mmd == null) {
                inserted = storeMgr.isObjectInserted(sm, this.type);
            }
            if (sm != null) {
                if (om.getApiAdapter().isDetached(value) && sm.getReferencedPC() != null && ownerSM != null && this.mmd != null) {
                    ownerSM.replaceField(ownerFieldNumber, sm.getReferencedPC(), true);
                }
                if (sm.isWaitingToBeFlushedToDatastore()) {
                    sm.flush();
                }
            } else if (om.getApiAdapter().isDetached(value) && (attachedValue = om.persistObjectInternal(value, null, null, -1, 0)) != value && ownerSM != null) {
                ownerSM.replaceField(ownerFieldNumber, attachedValue, true);
            }
            if (inserted || !om.isInserting(value) || !hasDatastoreAttributedPrimaryKeyValues && this.mmd != null && this.mmd.isPrimaryKey()) {
                Object id = api.getIdForObject(value);
                boolean requiresPersisting = false;
                if (om.getApiAdapter().isDetached(value) && ownerSM != null) {
                    if (ownerSM.isInserting()) {
                        if (!om.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore") && om.getObjectFromCache(api.getIdForObject(value)) == null) {
                            try {
                                Object obj = om.findObject(api.getIdForObject(value), true, false, value.getClass().getName());
                                if (obj != null) {
                                    StateManager objSM = om.findStateManager(obj);
                                    if (objSM != null) {
                                        om.evictFromTransaction(objSM);
                                    }
                                    om.removeObjectFromCache(value, api.getIdForObject(value));
                                }
                            }
                            catch (NucleusObjectNotFoundException onfe) {
                                requiresPersisting = true;
                            }
                        }
                    } else {
                        requiresPersisting = true;
                    }
                } else if (id == null) {
                    requiresPersisting = true;
                } else {
                    ObjectManager pcPM = om.getApiAdapter().getObjectManager(value);
                    if (pcPM != null && om != pcPM) {
                        throw new NucleusUserException(LOCALISER.msg("041015"), id);
                    }
                }
                if (requiresPersisting) {
                    if (this.mmd != null && !this.mmd.isCascadePersist() && !om.getApiAdapter().isDetached(value)) {
                        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                            NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
                        }
                        throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), value);
                    }
                    if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                        NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007007", this.mmd != null ? this.mmd.getFullFieldName() : null));
                    }
                    try {
                        Object pcNew = om.persistObjectInternal(value, null, null, -1, 0);
                        if (hasDatastoreAttributedPrimaryKeyValues) {
                            om.flushInternal(false);
                        }
                        id = api.getIdForObject(pcNew);
                        if (om.getApiAdapter().isDetached(value) && ownerSM != null) {
                            ownerSM.replaceField(ownerFieldNumber, pcNew, true);
                            int relationType = this.mmd.getRelationType(clr);
                            if (relationType == 6) {
                                if (NucleusLogger.PERSISTENCE.isInfoEnabled()) {
                                    NucleusLogger.PERSISTENCE.info("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional." + " Have just attached the N side so should really update the reference in the 1 side collection" + " to refer to this attached object. Not yet implemented");
                                }
                            } else if (relationType == 2) {
                                AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                                StateManager relatedSM = om.findStateManager(pcNew);
                                relatedSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), ownerSM.getObject(), true);
                            }
                        }
                    }
                    catch (NotYetFlushedException e) {
                        this.setObjectAsNull(om, ps, param);
                        throw new NotYetFlushedException(value);
                    }
                }
                if (sm != null) {
                    sm.setStoringPC();
                }
                if (this.getNumberOfDatastoreMappings() > 0) {
                    if (id instanceof OID) {
                        super.setObject(om, ps, param, id);
                    } else {
                        ((PersistenceCapable)value).jdoCopyKeyFieldsFromObjectId((PersistenceCapable.ObjectIdFieldConsumer)new AppIDObjectIdFieldConsumer(param, om, ps, this.javaTypeMappings), id);
                    }
                }
            } else {
                if (sm != null) {
                    sm.setStoringPC();
                }
                if (this.getNumberOfDatastoreMappings() > 0) {
                    this.setObjectAsNull(om, ps, param);
                    throw new NotYetFlushedException(value);
                }
            }
            Object var20_23 = null;
            if (sm != null) {
                sm.unsetStoringPC();
            }
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (sm != null) {
                sm.unsetStoringPC();
            }
            throw throwable;
        }
    }

    public Object getObject(ObjectManager om, Object rs, int[] param) {
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        if (storeMgr.getResultValueAtPosition(rs, this, param[0]) == null) {
            return null;
        }
        if (this.cmd == null) {
            this.cmd = om.getMetaDataManager().getMetaDataForClass(this.getType(), om.getClassLoaderResolver());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.getObjectForDatastoreIdentity(om, rs, param, this.cmd);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getObjectForApplicationIdentity(om, rs, param, this.cmd);
        }
        return null;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, this.getType());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.getNumberOfDatastoreMappings() > 0) {
            return new ObjectExpression(qs, this, te);
        }
        ClassLoaderResolver clr = qs.getClassLoaderResolver();
        MappedStoreManager srm = qs.getStoreManager();
        int relationType = this.mmd.getRelationType(clr);
        if (relationType == 2) {
            DatastoreClass targetTable = srm.getDatastoreClass(this.mmd.getTypeName(), clr);
            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
            JavaTypeMapping refMapping = targetTable.getMemberMapping(relatedMmds[0]);
            JavaTypeMapping selectMapping = targetTable.getIdMapping();
            DatastoreIdentifier targetTableIdentifier = srm.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "RELATED" + this.mmd.getAbsoluteFieldNumber());
            LogicSetExpression targetTe = qs.newTableExpression(targetTable, targetTableIdentifier);
            return new ObjectExpression(qs, this, te, refMapping, targetTe, selectMapping);
        }
        if (relationType == 6) {
            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
            if (this.mmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                DatastoreContainerObject targetTable = srm.getDatastoreContainerObject(relatedMmds[0]);
                JavaTypeMapping refMapping = null;
                JavaTypeMapping selectMapping = null;
                DatastoreElementContainer elementTable = (DatastoreElementContainer)targetTable;
                refMapping = elementTable.getElementMapping();
                selectMapping = elementTable.getOwnerMapping();
                DatastoreIdentifier targetTableIdentifier = srm.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "JOINTABLE" + this.mmd.getAbsoluteFieldNumber());
                LogicSetExpression targetTe = qs.newTableExpression(targetTable, targetTableIdentifier);
                return new ObjectExpression(qs, this, te, refMapping, targetTe, selectMapping);
            }
        }
        return null;
    }

    private Object getObjectForDatastoreIdentity(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd) {
        Object oid = super.getObject(om, rs, param);
        ApiAdapter api = om.getApiAdapter();
        if (api.isPersistable(oid)) {
            return oid;
        }
        return oid == null ? null : om.findObject(oid, false, true, null);
    }

    private Object createSingleFieldIdentity(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass, Class pcClass) {
        int paramNumber = param[0];
        try {
            MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
            Object idObj = storeMgr.getResultValueAtPosition(rs, this, paramNumber);
            if (idObj == null) {
                throw new NucleusException(LOCALISER.msg("041039")).setFatal();
            }
            Class keyType = om.getApiAdapter().getKeyTypeForSingleFieldIdentityType(objectIdClass);
            idObj = ClassUtils.convertValue(idObj, keyType);
            return om.getApiAdapter().getNewSingleFieldIdentity(objectIdClass, pcClass, idObj);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("041036", (Object)cmd.getObjectidClass(), (Object)e));
            return null;
        }
    }

    private Object createObjectIdInstanceReflection(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass) {
        Object fieldValue = null;
        try {
            Object id = objectIdClass.newInstance();
            int paramIndex = 0;
            for (int i = 0; i < cmd.getPKMemberPositions().length; ++i) {
                AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
                Field field = objectIdClass.getField(fmd.getName());
                MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
                JavaTypeMapping m = storeMgr.getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver()).getMemberMapping(fmd);
                for (int j = 0; j < m.getNumberOfDatastoreMappings(); ++j) {
                    Object obj;
                    if ((obj = storeMgr.getResultValueAtPosition(rs, this, param[paramIndex++])) instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)obj;
                        Class keyType = om.getApiAdapter().getKeyTypeForSingleFieldIdentityType(field.getType());
                        obj = ClassUtils.convertValue(bigDecimal, keyType);
                        if (!bigDecimal.subtract(new BigDecimal("" + obj)).equals(new BigDecimal("0"))) {
                            throw new NucleusException("Cannot convert retrieved BigInteger value to field of object id class!").setFatal();
                        }
                    }
                    fieldValue = obj;
                }
                field.set(id, fieldValue);
            }
            return id;
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("041037", (Object)cmd.getObjectidClass(), (Object)(this.mmd == null ? null : this.mmd.getName()), fieldValue, (Object)e));
            return null;
        }
    }

    private Object getObjectForAbstractClass(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class objectIdClass = clr.classForName(cmd.getObjectidClass());
        Class pcClass = clr.classForName(cmd.getFullClassName());
        Object id = cmd.usesSingleFieldIdentityClass() ? this.createSingleFieldIdentity(om, rs, param, cmd, objectIdClass, pcClass) : this.createObjectIdInstanceReflection(om, rs, param, cmd, objectIdClass);
        return om.findObject(id, false, true, null);
    }

    private Object getObjectForApplicationIdentity(ObjectManager om, final Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        if (((ClassMetaData)cmd).isAbstract() && cmd.getObjectidClass() != null) {
            return this.getObjectForAbstractClass(om, rs, param, cmd);
        }
        int totalFieldCount = cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers();
        StatementMappingIndex[] statementExpressionIndex = new StatementMappingIndex[totalFieldCount];
        int paramIndex = 0;
        final MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        DatastoreClass datastoreClass = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
        final int[] pkFieldNumbers = cmd.getPKMemberPositions();
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
            JavaTypeMapping m = datastoreClass.getMemberMapping(fmd);
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
            int[] expressionsIndex = new int[m.getNumberOfDatastoreMappings()];
            for (int j = 0; j < expressionsIndex.length; ++j) {
                expressionsIndex[j] = param[paramIndex++];
            }
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setColumnPositions(expressionsIndex);
        }
        final StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            resultMappings.addMappingForMember(pkFieldNumbers[i], statementExpressionIndex[pkFieldNumbers[i]]);
        }
        return om.findObjectUsingAID(clr.classForName(cmd.getFullClassName()), new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(pkFieldNumbers, storeMgr.getFieldManagerForResultProcessing(sm, rs, resultMappings));
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(pkFieldNumbers, storeMgr.getFieldManagerForResultProcessing(sm, rs, resultMappings));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, false, true);
    }

    public void postFetch(StateManager sm) {
    }

    public void postInsert(StateManager sm) {
        Object pc = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        int relationType = this.mmd.getRelationType(clr);
        if (pc != null) {
            boolean contained;
            Collection relatedColl;
            StateManager otherSM;
            if (relationType == 2) {
                AbstractMemberMetaData relatedMmd;
                StateManager otherSM2 = sm.getObjectManager().findStateManager(pc);
                Object relatedValue = otherSM2.provideField((relatedMmd = this.mmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc)).getAbsoluteFieldNumber());
                if (relatedValue == null) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041018", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmd.getFullFieldName()));
                    }
                    otherSM2.replaceField(relatedMmd.getAbsoluteFieldNumber(), sm.getObject(), false);
                } else if (relatedValue != sm.getObject()) {
                    throw new NucleusUserException(LOCALISER.msg("041020", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(relatedValue)));
                }
            } else if (relationType == 6 && relatedMmds[0].hasCollection() && (otherSM = sm.getObjectManager().findStateManager(pc)) != null && (relatedColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber())) != null && !(relatedColl instanceof SCOCollection) && !(contained = relatedColl.contains(sm.getObject()))) {
                NucleusLogger.PERSISTENCE.info(LOCALISER.msg("041022", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmds[0].getFullFieldName()));
            }
        }
    }

    public void postUpdate(StateManager sm) {
        ClassLoaderResolver clr;
        int relationType;
        StateManager otherSM;
        Object pc = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (pc == null) {
            return;
        }
        if (pc != null && (otherSM = sm.getObjectManager().findStateManager(pc)) == null && ((relationType = this.mmd.getRelationType(clr = sm.getObjectManager().getClassLoaderResolver())) == 2 || relationType == 6)) {
            sm.getObjectManager().persistObjectInternal(pc, null, null, -1, 0);
        }
    }

    public void preDelete(StateManager sm) {
        ObjectManager om = sm.getObjectManager();
        int fieldNumber = this.mmd.getAbsoluteFieldNumber();
        try {
            om.getApiAdapter().isLoaded(sm, fieldNumber);
        }
        catch (JDOObjectNotFoundException onfe) {
            return;
        }
        Object pc = sm.provideField(fieldNumber);
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        boolean dependent = this.mmd.isDependent();
        boolean hasFK = false;
        if (!dependent) {
            if (this.mmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (om.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
                hasFK = false;
            }
        }
        int relationType = this.mmd.getRelationType(clr);
        if (pc != null) {
            if (relationType == 1 || relationType == 2 && this.mmd.getMappedBy() == null) {
                if (dependent) {
                    boolean relatedObjectDeleted = om.getApiAdapter().isDeleted(pc);
                    if (this.isNullable() && !relatedObjectDeleted) {
                        sm.replaceField(fieldNumber, null, true);
                        sm.getStoreManager().getPersistenceHandler().updateObject(sm, new int[]{fieldNumber});
                    }
                    if (!relatedObjectDeleted) {
                        om.deleteObjectInternal(pc);
                    }
                } else {
                    StateManager otherSM;
                    AbstractMemberMetaData relatedMmd = this.mmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc);
                    if (relatedMmd != null && (otherSM = om.findStateManager(pc)) != null) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041019", (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(sm.getObject())));
                        }
                        otherSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), null, true);
                    }
                }
            } else if (relationType == 2 && this.mmd.getMappedBy() != null) {
                DatastoreClass relatedTable = storeMgr.getDatastoreClass(relatedMmds[0].getClassName(), clr);
                JavaTypeMapping relatedMapping = relatedTable.getMemberMapping(relatedMmds[0]);
                boolean isNullable = relatedMapping.isNullable();
                StateManager otherSM = om.findStateManager(pc);
                if (dependent) {
                    if (isNullable) {
                        otherSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), null, true);
                        otherSM.getStoreManager().getPersistenceHandler().updateObject(otherSM, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
                    }
                    om.deleteObjectInternal(pc);
                } else if (!hasFK && this.isNullable()) {
                    otherSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), null, true);
                    otherSM.getStoreManager().getPersistenceHandler().updateObject(otherSM, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
                }
            } else if (relationType == 6) {
                StateManager otherSM = om.findStateManager(pc);
                if (relatedMmds[0].getJoinMetaData() == null) {
                    if (!otherSM.isDeleting()) {
                        if (dependent) {
                            if (this.isNullable()) {
                                sm.replaceField(fieldNumber, null, true);
                                sm.getStoreManager().getPersistenceHandler().updateObject(sm, new int[]{fieldNumber});
                            }
                            if (!om.getApiAdapter().isDeleted(pc)) {
                                om.deleteObjectInternal(pc);
                            }
                        } else if (relatedMmds[0].hasCollection()) {
                            if (!om.getApiAdapter().isDeleted(otherSM.getObject()) && !otherSM.isDeleting()) {
                                om.markDirty(otherSM, false);
                                Collection otherColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                                if (otherColl != null) {
                                    NucleusLogger.PERSISTENCE.debug("ManagedRelationships : delete of object causes removal from collection at " + relatedMmds[0].getFullFieldName());
                                    otherColl.remove(sm.getObject());
                                }
                            }
                        } else if (relatedMmds[0].hasMap()) {
                            // empty if block
                        }
                    }
                } else if (dependent) {
                    om.deleteObjectInternal(pc);
                } else if (relatedMmds[0].hasCollection()) {
                    if (!om.getApiAdapter().isDeleted(otherSM.getObject()) && !otherSM.isDeleting()) {
                        om.markDirty(otherSM, false);
                        otherSM.isLoaded((PersistenceCapable)otherSM.getObject(), relatedMmds[0].getAbsoluteFieldNumber());
                        Collection otherColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                        if (otherColl != null) {
                            NucleusLogger.PERSISTENCE.debug("ManagedRelationships : delete of object causes removal from collection at " + relatedMmds[0].getFullFieldName());
                            otherColl.remove(sm.getObject());
                        }
                    }
                } else if (relatedMmds[0].hasMap()) {
                    // empty if block
                }
            }
        }
    }
}

