/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.NucleusLogger;

public abstract class MultiMapping
extends JavaTypeMapping {
    protected JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    protected int numberOfDatastoreMappings = 0;

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    public int getNumberOfDatastoreMappings() {
        if (this.numberOfDatastoreMappings == 0) {
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                this.numberOfDatastoreMappings += this.javaTypeMappings[i].getNumberOfDatastoreMappings();
            }
        }
        return this.numberOfDatastoreMappings;
    }

    public DatastoreMapping[] getDatastoreMappings() {
        if (this.datastoreMappings.length == 0) {
            this.datastoreMappings = new DatastoreMapping[this.getNumberOfDatastoreMappings()];
            int num = 0;
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                for (int j = 0; j < this.javaTypeMappings[i].getNumberOfDatastoreMappings(); ++j) {
                    this.datastoreMappings[num++] = this.javaTypeMappings[i].getDatastoreMapping(j);
                }
            }
        }
        return super.getDatastoreMappings();
    }

    public DatastoreMapping getDatastoreMapping(int index) {
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreMappings();
            for (int j = 0; j < numberDatastoreMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getDatastoreMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new NucleusException("Invalid index " + index + " for DataStoreMapping.").setFatal();
    }

    public int getMappingNumberForValue(ObjectManager om, Object value) {
        if (value == null) {
            return -1;
        }
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            Class cls = clr.classForName(this.javaTypeMappings[i].getType());
            if (!cls.isAssignableFrom(value.getClass())) continue;
            return i;
        }
        Class mappingJavaType = null;
        MetaDataManager mmgr = om.getStoreManager().getOMFContext().getMetaDataManager();
        boolean isPersistentInterface = mmgr.isPersistentInterface(this.getType());
        if (isPersistentInterface) {
            mappingJavaType = clr.classForName(this.getType());
        } else if (this.mmd != null && this.mmd.getFieldTypes() != null && this.mmd.getFieldTypes().length == 1 && (isPersistentInterface = mmgr.isPersistentInterface(this.mmd.getFieldTypes()[0]))) {
            mappingJavaType = clr.classForName(this.mmd.getFieldTypes()[0]);
        }
        if (mappingJavaType != null && mappingJavaType.isAssignableFrom(value.getClass())) {
            return -2;
        }
        return -1;
    }

    public void setObject(ObjectManager om, Object ps, int[] pos, Object value) {
        this.setObject(om, ps, pos, value, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(ObjectManager om, Object ps, int[] pos, Object value, StateManager ownerSM, int ownerFieldNumber) {
        int javaTypeMappingNumber = this.getMappingNumberForValue(om, value);
        if (value != null && javaTypeMappingNumber == -1) {
            throw new ClassCastException(LOCALISER.msg("041044", (Object)(this.mmd != null ? this.mmd.getFullFieldName() : ""), (Object)this.getType(), (Object)value.getClass().getName()));
        }
        if (value != null) {
            ApiAdapter api = om.getApiAdapter();
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            if (!om.isInserting(value)) {
                Object id = api.getIdForObject(value);
                boolean requiresPersisting = false;
                if (om.getApiAdapter().isDetached(value) && ownerSM != null) {
                    requiresPersisting = true;
                } else if (id == null) {
                    requiresPersisting = true;
                } else {
                    ObjectManager valueOM = api.getObjectManager(value);
                    if (valueOM != null && om != valueOM) {
                        throw new NucleusUserException(LOCALISER.msg("041015"), id);
                    }
                }
                if (requiresPersisting) {
                    Object pcNew = om.persistObjectInternal(value, null, null, -1, 0);
                    om.flushInternal(false);
                    id = api.getIdForObject(pcNew);
                    if (om.getApiAdapter().isDetached(value) && ownerSM != null) {
                        ownerSM.replaceField(ownerFieldNumber, pcNew, true);
                        int relationType = this.mmd.getRelationType(clr);
                        if (relationType == 2) {
                            StateManager relatedSM = om.findStateManager(pcNew);
                            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                            relatedSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), ownerSM.getObject(), true);
                        } else if (relationType == 6 && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional - should really update the reference in the relation. Not yet supported");
                        }
                    }
                }
                if (this.getNumberOfDatastoreMappings() <= 0) {
                    return;
                }
            }
        }
        if (pos == null) {
            return;
        }
        StateManager sm = null;
        if (value != null) {
            sm = om.findStateManager(value);
        }
        try {
            if (sm != null) {
                sm.setStoringPC();
            }
            int n = 0;
            NotYetFlushedException notYetFlushed = null;
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                if (n >= pos.length) {
                    n = 0;
                }
                int[] posMapping = this.javaTypeMappings[i].getReferenceMapping() != null ? new int[this.javaTypeMappings[i].getReferenceMapping().getNumberOfDatastoreMappings()] : new int[this.javaTypeMappings[i].getNumberOfDatastoreMappings()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = pos[n++];
                }
                try {
                    if (javaTypeMappingNumber == -2 || value != null && javaTypeMappingNumber == i) {
                        this.javaTypeMappings[i].setObject(om, ps, posMapping, value);
                        continue;
                    }
                    this.javaTypeMappings[i].setObject(om, ps, posMapping, null);
                    continue;
                }
                catch (NotYetFlushedException e) {
                    notYetFlushed = e;
                }
            }
            if (notYetFlushed != null) {
                throw notYetFlushed;
            }
            Object var17_19 = null;
            if (sm != null) {
                sm.unsetStoringPC();
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (sm != null) {
                sm.unsetStoringPC();
            }
            throw throwable;
        }
    }

    public Object getObject(ObjectManager om, Object rs, int[] pos) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            if (n >= pos.length) {
                n = 0;
            }
            int[] posMapping = this.javaTypeMappings[i].getReferenceMapping() != null ? new int[this.javaTypeMappings[i].getReferenceMapping().getNumberOfDatastoreMappings()] : new int[this.javaTypeMappings[i].getNumberOfDatastoreMappings()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = pos[n++];
            }
            Object value = null;
            try {
                value = this.javaTypeMappings[i].getObject(om, rs, posMapping);
            }
            catch (NullValueException e) {
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
            if (value == null) continue;
            if (value instanceof OID) {
                String className = this.javaTypeMappings[i].getReferenceMapping() != null ? this.javaTypeMappings[i].getReferenceMapping().getDatastoreMapping(0).getDatastoreField().getStoredJavaType() : this.javaTypeMappings[i].getDatastoreMapping(0).getDatastoreField().getStoredJavaType();
                value = OIDFactory.getInstance(om, className, ((OID)value).getKeyValue());
                return om.findObject(value, false, true, null);
            }
            if (!om.getClassLoaderResolver().classForName(this.getType()).isAssignableFrom(value.getClass())) continue;
            return value;
        }
        return null;
    }
}

