/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.cache;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryResultsCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractQueryResultsCache
implements QueryResultsCache {
    Map<String, List<Object>> cache = null;

    @Override
    public void close() {
        this.cache.clear();
        this.cache = null;
    }

    @Override
    public boolean contains(String queryKey) {
        return this.cache.containsKey(queryKey);
    }

    @Override
    public synchronized void evictAll() {
        this.cache.clear();
    }

    @Override
    public synchronized void evict(Query query) {
        String baseKey = QueryUtils.getKeyForQueryResultsCache(query, null);
        Iterator<String> iter = this.cache.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(baseKey)) continue;
            iter.remove();
        }
    }

    @Override
    public synchronized void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache(query, params);
        this.cache.remove(key);
    }

    @Override
    public List<Object> get(String queryKey) {
        return this.cache.get(queryKey);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public synchronized List<Object> put(String queryKey, List<Object> results) {
        return this.cache.put(queryKey, results);
    }

    @Override
    public int size() {
        return this.cache.size();
    }
}

