/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.management.ManagementManager;
import org.datanucleus.management.ManagementServer;
import org.datanucleus.management.runtime.QueryRuntime;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.cache.QueryCompilationCache;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManager.class.getClassLoader());
    OMFContext omfCtx;
    QueryCompilationCache queryCompilationCache = null;
    QueryDatastoreCompilationCache queryCompilationCacheDatastore = null;
    QueryResultsCache queryResultsCache = null;
    Map<String, Collection> queryMethodEvaluatorMap = new HashMap<String, Collection>();
    QueryRuntime queryRuntime = null;

    public QueryManager(OMFContext omfContext) {
        this.omfCtx = omfContext;
        if (omfContext.getJMXManager() != null) {
            ManagementManager mgmtMgr = omfContext.getJMXManager();
            ManagementServer mgntServer = omfContext.getJMXManager().getManagementServer();
            this.queryRuntime = new QueryRuntime();
            String mbeanName = mgmtMgr.getDomainName() + ":InstanceName=" + mgmtMgr.getInstanceName() + ",Type=" + ClassUtils.getClassNameForClass(this.queryRuntime.getClass()) + ",Name=QueryRuntime";
            mgntServer.registerMBean(this.queryRuntime, mbeanName);
        }
        this.initialiseQueryCaches();
    }

    protected void initialiseQueryCaches() {
        Constructor<?> ctr;
        Object[] ctrArgs;
        Class[] ctrArgsClasses;
        Class<?> cacheClass;
        String cacheClassName;
        PersistenceConfiguration conf = this.omfCtx.getPersistenceConfiguration();
        String cacheType = conf.getStringProperty("datanucleus.cache.queryCompilation.type");
        if (cacheType != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.omfCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("021500", (Object)cacheType)).setFatal();
            }
            try {
                cacheClass = Class.forName(cacheClassName);
                ctrArgsClasses = new Class[]{OMFContext.class};
                ctrArgs = new Object[]{this.omfCtx};
                ctr = cacheClass.getConstructor(ctrArgsClasses);
                this.queryCompilationCache = (QueryCompilationCache)ctr.newInstance(ctrArgs);
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("021502", (Object)cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("021501", (Object)cacheType, (Object)cacheClassName), e).setFatal();
            }
        }
        if ((cacheType = conf.getStringProperty("datanucleus.cache.queryCompilationDatastore.type")) != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.omfCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_compilation_store", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("021500", (Object)cacheType)).setFatal();
            }
            try {
                cacheClass = Class.forName(cacheClassName);
                ctrArgsClasses = new Class[]{OMFContext.class};
                ctrArgs = new Object[]{this.omfCtx};
                ctr = cacheClass.getConstructor(ctrArgsClasses);
                this.queryCompilationCacheDatastore = (QueryDatastoreCompilationCache)ctr.newInstance(ctrArgs);
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("021502", (Object)cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("021501", (Object)cacheType, (Object)cacheClassName), e).setFatal();
            }
        }
        if ((cacheType = conf.getStringProperty("datanucleus.cache.queryResults.type")) != null && !cacheType.equalsIgnoreCase("none")) {
            cacheClassName = this.omfCtx.getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_query_result", "name", cacheType, "class-name");
            if (cacheClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("021500", (Object)cacheType)).setFatal();
            }
            try {
                cacheClass = Class.forName(cacheClassName);
                ctrArgsClasses = new Class[]{OMFContext.class};
                ctrArgs = new Object[]{this.omfCtx};
                ctr = cacheClass.getConstructor(ctrArgsClasses);
                this.queryResultsCache = (QueryResultsCache)ctr.newInstance(ctrArgs);
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("021502", (Object)cacheClassName));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("021501", (Object)cacheType, (Object)cacheClassName), e).setFatal();
            }
        }
    }

    public void close() {
        if (this.queryCompilationCache != null) {
            this.queryCompilationCache.close();
            this.queryCompilationCache = null;
        }
        if (this.queryCompilationCacheDatastore != null) {
            this.queryCompilationCacheDatastore.close();
            this.queryCompilationCacheDatastore = null;
        }
        if (this.queryResultsCache != null) {
            this.queryResultsCache.close();
            this.queryResultsCache = null;
        }
        this.queryMethodEvaluatorMap.clear();
        this.queryMethodEvaluatorMap = null;
        this.queryRuntime = null;
    }

    public QueryRuntime getQueryRuntime() {
        return this.queryRuntime;
    }

    public Query newQuery(String language, ObjectManager om, Object query) {
        String impl;
        if (language == null) {
            return null;
        }
        String languageImpl = language;
        if (language.equalsIgnoreCase("JDOQL")) {
            impl = this.omfCtx.getPersistenceConfiguration().getStringProperty("datanucleus.query.JDOQL.implementation");
            if (impl != null) {
                languageImpl = impl;
            }
        } else if (language.equalsIgnoreCase("JPQL") && (impl = this.omfCtx.getPersistenceConfiguration().getStringProperty("datanucleus.query.JPQL.implementation")) != null) {
            languageImpl = impl;
        }
        try {
            if (query == null) {
                Class[] argsClass = new Class[]{ObjectManager.class};
                Object[] args = new Object[]{om};
                Query q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
                return q;
            }
            Query q = null;
            if (query instanceof String) {
                Class[] argsClass = new Class[]{ObjectManager.class, String.class};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            } else if (query instanceof Query) {
                Class[] argsClass = new Class[]{ObjectManager.class, query.getClass()};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            } else {
                Class[] argsClass = new Class[]{ObjectManager.class, Object.class};
                Object[] args = new Object[]{om, query};
                q = (Query)om.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{languageImpl, om.getStoreManager().getStoreManagerKey()}, "class-name", argsClass, args);
                if (q == null) {
                    throw new NucleusException("DataNucleus doesnt currently support queries of language " + language + " for this datastore");
                }
            }
            return q;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new NucleusException(t.getMessage(), t).setFatal();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), e).setFatal();
        }
    }

    public synchronized void addQueryCompilation(String language, String query, QueryCompilation compilation) {
        if (this.queryCompilationCache != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCache.put(queryKey, compilation);
        }
    }

    public synchronized QueryCompilation getQueryCompilationForQuery(String language, String query) {
        String queryKey;
        QueryCompilation compilation;
        if (this.queryCompilationCache != null && (compilation = this.queryCompilationCache.get(queryKey = language + ":" + query)) != null) {
            if (compilation != null && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021079", (Object)query, (Object)language));
            }
            return compilation;
        }
        return null;
    }

    public synchronized void addDatastoreQueryCompilation(String datastore, String language, String query, Object compilation) {
        if (this.queryCompilationCacheDatastore != null) {
            String queryKey = language + ":" + query;
            this.queryCompilationCacheDatastore.put(queryKey, compilation);
        }
    }

    public synchronized Object getDatastoreQueryCompilation(String datastore, String language, String query) {
        String queryKey;
        Object compilation;
        if (this.queryCompilationCacheDatastore != null && (compilation = this.queryCompilationCacheDatastore.get(queryKey = language + ":" + query)) != null) {
            if (compilation != null && NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug(LOCALISER.msg("021080", (Object)query, (Object)language, (Object)datastore));
            }
            return compilation;
        }
        return null;
    }

    public QueryResultsCache getQueryResultsCache() {
        return this.queryResultsCache;
    }

    public synchronized void addDatastoreQueryResult(Query query, Map params, List<Object> results) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            this.queryResultsCache.put(queryKey, results);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug("Caching query results for \"" + query + "\" size=" + results.size());
            }
        }
    }

    public synchronized List<Object> getDatastoreQueryResult(Query query, Map params) {
        if (this.queryResultsCache != null) {
            String queryKey = QueryUtils.getKeyForQueryResultsCache(query, params);
            return this.queryResultsCache.get(queryKey);
        }
        return null;
    }

    public InvocationEvaluator getInMemoryEvaluatorForMethod(Class type, String methodName) {
        Collection methods = this.queryMethodEvaluatorMap.get(methodName);
        if (methods != null) {
            for (InvocationEvaluator eval : methods) {
                if (!eval.supportsType(type)) continue;
                return eval;
            }
        } else {
            PluginManager pluginMgr = this.omfCtx.getPluginManager();
            String[] evaluatorNames = pluginMgr.getAttributeValuesForExtension("org.datanucleus.query_method_evaluators", "method", methodName, "class");
            if (evaluatorNames != null) {
                HashSet<InvocationEvaluator> evaluators = new HashSet<InvocationEvaluator>();
                InvocationEvaluator evalToUse = null;
                for (int i = 0; i < evaluatorNames.length; ++i) {
                    try {
                        InvocationEvaluator eval = (InvocationEvaluator)pluginMgr.createExecutableExtension("org.datanucleus.query_method_evaluators", new String[]{"method", "class"}, new String[]{methodName, evaluatorNames[i]}, "class", null, null);
                        evaluators.add(eval);
                        if (!eval.supportsType(type)) continue;
                        evalToUse = eval;
                        continue;
                    }
                    catch (Exception e) {
                        NucleusLogger.QUERY.warn("Extension org.datanucleus.query_method_evaluators has method=" + methodName + " referencing evaluator " + evaluatorNames[i] + " but an error occurred in construction : " + e.getMessage());
                    }
                }
                this.queryMethodEvaluatorMap.put(methodName, evaluators);
                return evalToUse;
            }
        }
        return null;
    }
}

