/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.exceptions.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractListStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.mapped.scostore.JoinListStoreSpecialization;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class JoinListStore
extends AbstractListStore {
    public JoinListStore(AbstractMemberMetaData fmd, ClassLoaderResolver clr, DatastoreContainerObject joinTable, JavaTypeMapping ownerMapping, JavaTypeMapping elementMapping, JavaTypeMapping orderMapping, JavaTypeMapping relationDiscriminatorMapping, String relationDiscriminatorValue, boolean elementsAreEmbedded, boolean elementsAreSerialised, JoinListStoreSpecialization specialization) {
        super((StoreManager)joinTable.getStoreManager(), clr, specialization);
        this.containerTable = joinTable;
        this.setOwner(fmd, clr);
        this.ownerMapping = ownerMapping;
        this.elementMapping = elementMapping;
        this.orderMapping = orderMapping;
        if (this.ownerMemberMetaData.getOrderMetaData() != null && !this.ownerMemberMetaData.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (orderMapping == null && this.indexedList) {
            throw new NucleusUserException(LOCALISER.msg("056044", (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)joinTable.toString()));
        }
        this.relationDiscriminatorMapping = relationDiscriminatorMapping;
        this.relationDiscriminatorValue = relationDiscriminatorValue;
        this.elementType = fmd.getCollection().getElementType();
        this.elementsAreEmbedded = elementsAreEmbedded;
        this.elementsAreSerialised = elementsAreSerialised;
        if (elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType(element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 3, clr, this.storeMgr.getMetaDataManager());
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null ? (!elementsAreEmbedded ? this.getElementInformationForClass() : null) : null;
            }
        }
    }

    private JoinListStoreSpecialization getSpecialization() {
        return (JoinListStoreSpecialization)this.specialization;
    }

    protected boolean internalAdd(StateManager sm, int start, boolean atEnd, Collection c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int shift = c.size();
        for (Object element : c) {
            StateManager elementSM;
            this.validateElementForWriting(sm, element, null);
            if (this.relationType != 4 || !sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") || (elementSM = sm.getObjectManager().findStateManager(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.JDO.info(LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), false);
                continue;
            }
            if (elementOwner == sm.getObject() || sm.getReferencedPC() != null) continue;
            throw new NucleusUserException(LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject()), (Object)StringUtils.toJVMIDString(elementOwner)));
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(sm) : size;
        return this.getSpecialization().internalAdd(sm, this, start, atEnd, c, currentListSize, shift);
    }

    public Object set(StateManager sm, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(sm, element, null);
        Object o = this.get(sm, index);
        this.getSpecialization().set(element, index, sm, this);
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement() && allowDependentField && o != null && !this.contains(sm, o)) {
            sm.getObjectManager().deleteObjectInternal(o);
        }
        return o;
    }

    public void update(StateManager sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(sm);
            this.addAll(sm, coll, 0);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(sm);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (((Object)existing).equals(coll)) {
            return;
        }
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    protected boolean internalRemove(StateManager ownerSM, Object element, int size) {
        boolean modified = false;
        if (this.indexedList) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.add(element);
            int[] indices = this.getIndicesOf(ownerSM, elements);
            for (int i = 0; i < indices.length; ++i) {
                this.removeAt(ownerSM, indices[i], size);
                modified = true;
            }
        } else {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                block7: {
                    try {
                        int[] rcs = this.getSpecialization().internalRemove(ownerSM, mconn, false, element, true, this);
                        if (rcs == null || rcs[0] <= 0) break block7;
                        modified = true;
                    }
                    catch (MappedDatastoreException sqe) {
                        String msg = LOCALISER.msg("056012", (Object)sqe.getMessage());
                        NucleusLogger.DATASTORE.error(msg, sqe.getCause());
                        throw new NucleusDataStoreException(msg, sqe, ownerSM.getObject());
                    }
                }
                Object var10_12 = null;
                mconn.release();
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                mconn.release();
                throw throwable;
            }
        }
        return modified;
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        int currentListSize = this.size(sm);
        int[] indices = this.getIndicesOf(sm, elements);
        return this.getSpecialization().removeAll(currentListSize, indices, elements, sm, this);
    }

    protected void removeAt(StateManager sm, int index, int size) {
        if (!this.indexedList) {
            throw new NucleusUserException("Cannot remove an element from a particular position with an ordered list since no indexes exist");
        }
        this.getSpecialization().removeAt(sm, index, size, this);
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTblExpr, DatastoreIdentifier listTableAlias, Class filteredElementType, ScalarExpression elementExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        if (!existsQuery) {
            LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, listTableAlias);
            if (!parentStmt.hasCrossJoin(ownTblExpr) && !stmt.getMainTableExpression().equals(ownTblExpr)) {
                stmt.crossJoin(ownTblExpr, true);
            }
            ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTblExpr);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        }
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), clr);
        DatastoreClass joiningClass = elementExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elementExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementTableAlias);
        if (elmTblExpr == null) {
            if (!(elementExpr instanceof UnboundVariable) && parentStmt != stmt) {
                elmTblExpr = parentStmt.getTableExpression(elementTableAlias);
            }
            if (elmTblExpr == null) {
                elmTblExpr = stmt.newTableExpression(elementTable, elementTableAlias);
            }
        }
        if (!parentStmt.getMainTableExpression().equals(elmTblExpr) && !parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        ScalarExpression elmListExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        if (elementExpr.getLogicSetExpression() != null && !elementTable.equals(elementExpr.getLogicSetExpression().getMainTable())) {
            if (existsQuery) {
                stmt.andCondition(elmListExpr.eq(elementExpr), true);
                return elmListExpr;
            }
            return elmListExpr;
        }
        if (existsQuery) {
            ScalarExpression elementIdExpr = elementTableID.newScalarExpression(stmt, elmTblExpr);
            stmt.andCondition(elmListExpr.eq(elementIdExpr), true);
            return elementIdExpr;
        }
        return elmListExpr;
    }
}

