/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.CharIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.ShortIdentity;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.JDOClassNameConstants;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.jdo.state.LifeCycleStateFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InvalidPrimaryKeyException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.JDOStateManagerImpl;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDOAdapter
implements ApiAdapter {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public String getName() {
        return "JDO";
    }

    public ObjectManager getObjectManager(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof PersistenceCapable) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            if (pm == null) {
                return null;
            }
            return ((JDOPersistenceManager)pm).getObjectManager();
        }
        if (obj instanceof PersistenceManager) {
            return ((JDOPersistenceManager)obj).getObjectManager();
        }
        return null;
    }

    public StateManager newStateManager(ObjectManager om, AbstractClassMetaData acmd) {
        return new JDOStateManagerImpl(om, acmd);
    }

    public LifeCycleState getLifeCycleState(int stateType) {
        return LifeCycleStateFactory.getLifeCycleState(stateType);
    }

    public boolean isPersistent(Object obj) {
        return JDOHelper.isPersistent((Object)obj);
    }

    public boolean isNew(Object obj) {
        return JDOHelper.isNew((Object)obj);
    }

    public boolean isDirty(Object obj) {
        return JDOHelper.isDirty((Object)obj);
    }

    public boolean isDeleted(Object obj) {
        return JDOHelper.isDeleted((Object)obj);
    }

    public boolean isDetached(Object obj) {
        return JDOHelper.isDetached((Object)obj);
    }

    public boolean isTransactional(Object obj) {
        return JDOHelper.isTransactional((Object)obj);
    }

    public boolean isPersistable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof PersistenceCapable;
    }

    public boolean isPersistable(Class cls) {
        if (cls == null) {
            return false;
        }
        return PersistenceCapable.class.isAssignableFrom(cls);
    }

    public boolean isDetachable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Detachable;
    }

    public String getObjectState(Object obj) {
        return JDOHelper.getObjectState((Object)obj).toString();
    }

    public Object getIdForObject(Object obj) {
        if (!this.isPersistable(obj)) {
            return null;
        }
        return ((PersistenceCapable)obj).jdoGetObjectId();
    }

    public Object getVersionForObject(Object obj) {
        if (!this.isPersistable(obj)) {
            return null;
        }
        return ((PersistenceCapable)obj).jdoGetVersion();
    }

    public boolean isValidPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, int noOfPkFields, MetaDataManager mmgr) {
        if (ClassUtils.isInnerClass(pkClass.getName()) && !Modifier.isStatic(pkClass.getModifiers())) {
            throw new InvalidPrimaryKeyException(LOCALISER, "019000", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (!Modifier.isPublic(pkClass.getModifiers())) {
            throw new InvalidPrimaryKeyException(LOCALISER, "019001", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (!Serializable.class.isAssignableFrom(pkClass)) {
            throw new InvalidPrimaryKeyException(LOCALISER, "019002", (Object)cmd.getFullClassName(), pkClass.getName());
        }
        if (this.isSingleFieldIdentityClass(pkClass.getName())) {
            if (noOfPkFields != 1) {
                throw new InvalidPrimaryKeyException(LOCALISER, "019003", (Object)cmd.getFullClassName());
            }
        } else {
            Method method;
            Constructor constructor;
            try {
                constructor = pkClass.getConstructor(new Class[0]);
                if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "019004", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException ex) {
                throw new InvalidPrimaryKeyException(LOCALISER, "019004", (Object)cmd.getFullClassName(), pkClass.getName());
            }
            try {
                constructor = pkClass.getConstructor(String.class);
                if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "019005", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            try {
                method = pkClass.getMethod("toString", new Class[0]);
                if (method == null || !Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().equals(Object.class)) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "019006", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            try {
                method = pkClass.getMethod("hashCode", new Class[0]);
                if (method == null || method.getDeclaringClass().equals(Object.class)) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "019007", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            try {
                method = pkClass.getMethod("equals", Object.class);
                if (method == null || method.getDeclaringClass().equals(Object.class)) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "019008", (Object)cmd.getFullClassName(), pkClass.getName());
                }
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            int noPkFields = this.processPrimaryKeyClass(pkClass, cmd, clr, mmgr);
            Collection superclasses = ClassUtils.getSuperclasses(pkClass);
            if (superclasses != null && superclasses.size() > 0) {
                for (Class supercls : superclasses) {
                    noPkFields += this.processPrimaryKeyClass(supercls, cmd, clr, mmgr);
                }
            }
            if (noOfPkFields != noPkFields && cmd.getIdentityType() == IdentityType.APPLICATION) {
                throw new InvalidPrimaryKeyException(LOCALISER, "019015", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)("" + noOfPkFields), "" + noPkFields);
            }
        }
        return true;
    }

    private int processPrimaryKeyClass(Class pkClass, AbstractClassMetaData cmd, ClassLoaderResolver clr, MetaDataManager mmgr) {
        int noOfPkFields = 0;
        Field[] fieldsInPkClass = pkClass.getDeclaredFields();
        for (int i = 0; i < fieldsInPkClass.length; ++i) {
            if (Modifier.isStatic(fieldsInPkClass[i].getModifiers())) continue;
            if (!fieldsInPkClass[i].getType().isPrimitive() && !Serializable.class.isAssignableFrom(fieldsInPkClass[i].getType())) {
                throw new InvalidPrimaryKeyException(LOCALISER, "019009", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            if (!Modifier.isPublic(fieldsInPkClass[i].getModifiers())) {
                throw new InvalidPrimaryKeyException(LOCALISER, "019010", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            AbstractMemberMetaData fieldInPcClass = cmd.getMetaDataForMember(fieldsInPkClass[i].getName());
            boolean found_field = false;
            if (fieldInPcClass == null) {
                throw new InvalidPrimaryKeyException(LOCALISER, "019011", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), fieldsInPkClass[i].getName());
            }
            if (fieldInPcClass.getTypeName().equals(fieldsInPkClass[i].getType().getName())) {
                found_field = true;
            }
            if (!found_field) {
                String fieldTypePkClass = fieldsInPkClass[i].getType().getName();
                AbstractClassMetaData ref_cmd = mmgr.getMetaDataForClassInternal(fieldInPcClass.getType(), clr);
                if (ref_cmd == null) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "019012", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)fieldsInPkClass[i].getName(), fieldInPcClass.getType().getName());
                }
                if (ref_cmd.getObjectidClass() == null && this.isSingleFieldIdentityClass(fieldTypePkClass)) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "019014", cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldTypePkClass, ref_cmd.getFullClassName());
                }
                if (!fieldTypePkClass.equals(ref_cmd.getObjectidClass())) {
                    throw new InvalidPrimaryKeyException(LOCALISER, "019013", cmd.getFullClassName(), pkClass.getName(), fieldsInPkClass[i].getName(), fieldTypePkClass, ref_cmd.getObjectidClass());
                }
                found_field = true;
            }
            if (!found_field) {
                throw new InvalidPrimaryKeyException(LOCALISER, "019012", (Object)cmd.getFullClassName(), (Object)pkClass.getName(), (Object)fieldsInPkClass[i].getName(), fieldInPcClass.getType().getName());
            }
            ++noOfPkFields;
        }
        return noOfPkFields;
    }

    public boolean isSingleFieldIdentity(Object id) {
        return id instanceof SingleFieldIdentity;
    }

    public boolean isSingleFieldIdentityClass(String className) {
        if (className == null || className.length() < 1) {
            return false;
        }
        return className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_BYTE_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_CHAR_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_INT_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_LONG_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_OBJECT_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_SHORT_IDENTITY) || className.equals(JDOClassNameConstants.JAVAX_JDO_IDENTITY_STRING_IDENTITY);
    }

    public String getSingleFieldIdentityClassNameForLong() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_LONG_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForInt() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_INT_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForShort() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_SHORT_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForByte() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_BYTE_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForChar() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_CHAR_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForString() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_STRING_IDENTITY;
    }

    public String getSingleFieldIdentityClassNameForObject() {
        return JDOClassNameConstants.JAVAX_JDO_IDENTITY_OBJECT_IDENTITY;
    }

    public Class getTargetClassForSingleFieldIdentity(Object id) {
        if (id instanceof SingleFieldIdentity) {
            return ((SingleFieldIdentity)id).getTargetClass();
        }
        return null;
    }

    public String getTargetClassNameForSingleFieldIdentity(Object id) {
        if (id instanceof SingleFieldIdentity) {
            return ((SingleFieldIdentity)id).getTargetClassName();
        }
        return null;
    }

    public Object getTargetKeyForSingleFieldIdentity(Object id) {
        if (id instanceof SingleFieldIdentity) {
            return ((SingleFieldIdentity)id).getKeyAsObject();
        }
        return null;
    }

    public Class getKeyTypeForSingleFieldIdentityType(Class idType) {
        if (idType == null) {
            return null;
        }
        if (!this.isSingleFieldIdentityClass(idType.getName())) {
            return null;
        }
        if (LongIdentity.class.isAssignableFrom(idType)) {
            return Long.class;
        }
        if (IntIdentity.class.isAssignableFrom(idType)) {
            return Integer.class;
        }
        if (ShortIdentity.class.isAssignableFrom(idType)) {
            return Short.class;
        }
        if (ByteIdentity.class.isAssignableFrom(idType)) {
            return Byte.class;
        }
        if (CharIdentity.class.isAssignableFrom(idType)) {
            return Character.class;
        }
        if (StringIdentity.class.isAssignableFrom(idType)) {
            return String.class;
        }
        if (ObjectIdentity.class.isAssignableFrom(idType)) {
            return Object.class;
        }
        return null;
    }

    public Object getNewSingleFieldIdentity(Class idType, Class pcType, Object value) {
        if (idType == null) {
            throw new NucleusException(LOCALISER.msg("029001", pcType)).setFatal();
        }
        if (pcType == null) {
            throw new NucleusException(LOCALISER.msg("029000", idType)).setFatal();
        }
        if (value == null) {
            throw new NucleusException(LOCALISER.msg("029003", idType, (Object)pcType)).setFatal();
        }
        if (!SingleFieldIdentity.class.isAssignableFrom(idType)) {
            throw new NucleusException(LOCALISER.msg("029002", (Object)idType.getName(), (Object)pcType.getName())).setFatal();
        }
        SingleFieldIdentity id = null;
        Class keyType = null;
        if (idType == LongIdentity.class) {
            keyType = Long.class;
            if (!(value instanceof Long)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Long")).setFatal();
            }
        } else if (idType == IntIdentity.class) {
            keyType = Integer.class;
            if (!(value instanceof Integer)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Integer")).setFatal();
            }
        } else if (idType == StringIdentity.class) {
            keyType = String.class;
            if (!(value instanceof String)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"String")).setFatal();
            }
        } else if (idType == ByteIdentity.class) {
            keyType = Byte.class;
            if (!(value instanceof Byte)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Byte")).setFatal();
            }
        } else if (idType == ShortIdentity.class) {
            keyType = Short.class;
            if (!(value instanceof Short)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Short")).setFatal();
            }
        } else if (idType == CharIdentity.class) {
            keyType = Character.class;
            if (!(value instanceof Character)) {
                throw new NucleusException(LOCALISER.msg("029004", (Object)idType.getName(), (Object)pcType.getName(), (Object)value.getClass().getName(), (Object)"Character")).setFatal();
            }
        } else {
            keyType = Object.class;
        }
        try {
            Class[] ctrArgs = new Class[]{Class.class, keyType};
            Constructor ctr = idType.getConstructor(ctrArgs);
            Object[] args = new Object[]{pcType, value};
            id = (SingleFieldIdentity)ctr.newInstance(args);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error("Error encountered while creating SingleFieldIdentity instance of type \"" + idType.getName() + "\"");
            NucleusLogger.PERSISTENCE.error(e);
            return null;
        }
        return id;
    }

    public Object getNewApplicationIdentityObjectId(ClassLoaderResolver clr, AbstractClassMetaData acmd, String value) {
        if (acmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new NucleusException("This class (" + acmd.getFullClassName() + ") doesn't use application-identity!");
        }
        Class targetClass = clr.classForName(acmd.getFullClassName());
        Class idType = clr.classForName(acmd.getObjectidClass());
        Object id = null;
        if (acmd.usesSingleFieldIdentityClass()) {
            try {
                Class[] ctrArgs = new Class[]{Class.class, String.class};
                Constructor ctr = idType.getConstructor(ctrArgs);
                Object[] args = new Object[]{targetClass, value};
                id = ctr.newInstance(args);
            }
            catch (Exception e) {
                throw new NucleusException("Error encountered while creating SingleFieldIdentity instance with key \"" + value + "\"", e);
            }
        } else if (Modifier.isAbstract(targetClass.getModifiers()) && acmd.getObjectidClass() != null) {
            try {
                Constructor c = clr.classForName(acmd.getObjectidClass()).getDeclaredConstructor(String.class);
                id = c.newInstance(value);
            }
            catch (Exception e) {
                String msg = LOCALISER.msg("010030", (Object)acmd.getObjectidClass(), (Object)acmd.getFullClassName());
                NucleusLogger.PERSISTENCE.error(msg);
                NucleusLogger.PERSISTENCE.error(e);
                throw new NucleusUserException(msg);
            }
        } else {
            clr.classForName(targetClass.getName(), true);
            id = NucleusJDOHelper.getJDOImplHelper().newObjectIdInstance(targetClass, (Object)value);
        }
        return id;
    }

    public Object getNewApplicationIdentityObjectId(Object pc, AbstractClassMetaData cmd) {
        if (pc == null || cmd == null) {
            return null;
        }
        Object id = ((PersistenceCapable)pc).jdoNewObjectIdInstance();
        if (!cmd.usesSingleFieldIdentityClass()) {
            ((PersistenceCapable)pc).jdoCopyKeyFieldsToObjectId(id);
        }
        return id;
    }

    public Object getNewApplicationIdentityObjectId(Class cls, Object key) {
        return NucleusJDOHelper.getJDOImplHelper().newObjectIdInstance(cls, key);
    }

    public boolean allowPersistOfDeletedObject() {
        return false;
    }

    public boolean allowDeleteOfNonPersistentObject() {
        return false;
    }

    public boolean allowReadFieldOfDeletedObject() {
        return false;
    }

    public boolean clearLoadedFlagsOnDeleteObject() {
        return true;
    }

    public boolean getDefaultCascadePersistForField() {
        return true;
    }

    public boolean getDefaultCascadeUpdateForField() {
        return true;
    }

    public boolean getDefaultCascadeDeleteForField() {
        return false;
    }

    public boolean getDefaultCascadeRefreshForField() {
        return false;
    }

    public Map getDefaultFactoryProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("datanucleus.NontransactionalRead", "true");
        props.put("datanucleus.NontransactionalWrite", "true");
        props.put("datanucleus.DetachAllOnCommit", "false");
        props.put("datanucleus.CopyOnAttach", "true");
        props.put("datanucleus.identifierFactory", "datanucleus2");
        props.put("datanucleus.persistenceByReachabilityAtCommit", "true");
        props.put("datanucleus.rdbms.stringDefaultLength", "256");
        props.put("datanucleus.rdbms.sql.allowAllSQLStatements", "false");
        return props;
    }

    public Object getObjectId(StateManager sm) {
        return sm.getObjectId((PersistenceCapable)sm.getObject());
    }

    public Object getVersion(StateManager sm) {
        return sm.getVersion((PersistenceCapable)sm.getObject());
    }

    public boolean isLoaded(StateManager sm, int fieldNumber) {
        return sm.isLoaded((PersistenceCapable)sm.getObject(), fieldNumber);
    }

    public Object getPersistenceManager(Object obj) {
        if (obj instanceof PersistenceCapable) {
            return ((PersistenceCapable)obj).jdoGetPersistenceManager();
        }
        return null;
    }

    public void makeFieldDirty(Object obj, String fieldName) {
        ((PersistenceCapable)obj).jdoMakeDirty(fieldName);
    }

    public RuntimeException getExceptionForException(String msg, Exception e) {
        return new JDOUserException(msg, (Throwable)e);
    }
}

