/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.Line2D;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class Line2dFloatMapping
extends SingleFieldMultiMapping {
    private static final Line2D.Float sampleValue = new Line2D.Float(0.0f, 0.0f, 1.0f, 1.0f);

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.addDatastoreFields();
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addDatastoreFields();
    }

    protected void addDatastoreFields() {
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Line2D.Float.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return sampleValue;
    }

    public Object getValueForDatastoreMapping(ObjectManager om, int index, Object value) {
        Line2D.Float line = (Line2D.Float)value;
        if (index == 0) {
            return line.getX1();
        }
        if (index == 1) {
            return line.getY1();
        }
        if (index == 2) {
            return line.getX2();
        }
        if (index == 3) {
            return line.getY2();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        Line2D.Float line = (Line2D.Float)value;
        if (line == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDatastoreMapping(i).setObject(preparedStatement, exprIndex[i], null);
            }
        } else {
            this.getDatastoreMapping(0).setFloat(preparedStatement, exprIndex[0], line.x1);
            this.getDatastoreMapping(1).setFloat(preparedStatement, exprIndex[1], line.y1);
            this.getDatastoreMapping(2).setFloat(preparedStatement, exprIndex[2], line.x2);
            this.getDatastoreMapping(3).setFloat(preparedStatement, exprIndex[3], line.y2);
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x1 = this.getDatastoreMapping(0).getFloat(resultSet, exprIndex[0]);
        float y1 = this.getDatastoreMapping(1).getFloat(resultSet, exprIndex[1]);
        float x2 = this.getDatastoreMapping(2).getFloat(resultSet, exprIndex[2]);
        float y2 = this.getDatastoreMapping(3).getFloat(resultSet, exprIndex[3]);
        return new Line2D.Float(x1, y1, x2, y2);
    }
}

