/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.util.Localiser;

public abstract class JavaTypeMapping {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected AbstractMemberMetaData mmd;
    protected int roleForMember = 0;
    protected DatastoreMapping[] datastoreMappings = new DatastoreMapping[0];
    protected DatastoreContainerObject datastoreContainer;
    protected MappedStoreManager storeMgr;
    protected String type;
    protected JavaTypeMapping referenceMapping;

    protected JavaTypeMapping() {
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        this.storeMgr = storeMgr;
        this.type = type;
    }

    public void initialize(AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        this.storeMgr = container.getStoreManager();
        this.mmd = mmd;
        this.datastoreContainer = container;
        this.type = this.roleForMember == 4 ? mmd.getArray().getElementType() : (this.roleForMember == 3 ? mmd.getCollection().getElementType() : (this.roleForMember == 5 ? mmd.getMap().getKeyType() : (this.roleForMember == 6 ? mmd.getMap().getValueType() : mmd.getType().getName())));
    }

    public int hashCode() {
        return this.mmd == null || this.datastoreContainer == null ? super.hashCode() : this.mmd.hashCode() ^ this.datastoreContainer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractContainerMapping other = (AbstractContainerMapping)obj;
        return this.mmd.equals(other.mmd) && this.datastoreContainer.equals(other.datastoreContainer);
    }

    public void setMemberMetaData(AbstractMemberMetaData mmd) {
        this.mmd = mmd;
    }

    public void setDatastoreContainer(DatastoreContainerObject table) {
        this.datastoreContainer = table;
    }

    public void setRoleForMember(int role) {
        this.roleForMember = role;
    }

    public AbstractMemberMetaData getMemberMetaData() {
        return this.mmd;
    }

    public int getRoleForMember() {
        return this.roleForMember;
    }

    public boolean isSerialised() {
        if (this.roleForMember == 3) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getCollection() != null ? this.mmd.getCollection().isSerializedElement() : false;
        }
        if (this.roleForMember == 4) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getArray() != null ? this.mmd.getArray().isSerializedElement() : false;
        }
        if (this.roleForMember == 5) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getMap() != null ? this.mmd.getMap().isSerializedKey() : false;
        }
        if (this.roleForMember == 6) {
            if (this.mmd == null) {
                return false;
            }
            return this.mmd.getMap() != null ? this.mmd.getMap().isSerializedValue() : false;
        }
        return this.mmd != null ? this.mmd.isSerialized() : false;
    }

    public boolean isNullable() {
        for (int i = 0; i < this.datastoreMappings.length; ++i) {
            if (this.datastoreMappings[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSimpleDatastoreRepresentation() {
        return true;
    }

    public DatastoreMapping[] getDatastoreMappings() {
        return this.datastoreMappings;
    }

    public DatastoreContainerObject getDatastoreContainer() {
        return this.datastoreContainer;
    }

    public DatastoreMapping getDatastoreMapping(int index) {
        return this.datastoreMappings[index];
    }

    public Object getValueForDatastoreMapping(ObjectManager om, int index, Object value) {
        return value;
    }

    public JavaTypeMapping getReferenceMapping() {
        return this.referenceMapping;
    }

    public void setReferenceMapping(JavaTypeMapping referenceMapping) {
        this.referenceMapping = referenceMapping;
    }

    public void addDatastoreMapping(DatastoreMapping datastoreMapping) {
        DatastoreMapping[] dm = this.datastoreMappings;
        this.datastoreMappings = new DatastoreMapping[this.datastoreMappings.length + 1];
        System.arraycopy(dm, 0, this.datastoreMappings, 0, dm.length);
        this.datastoreMappings[dm.length] = datastoreMapping;
    }

    public int getNumberOfDatastoreMappings() {
        return this.datastoreMappings.length;
    }

    public abstract Class getJavaType();

    public String getJavaTypeForDatastoreMapping(int index) {
        throw new UnsupportedOperationException("Datastore type mapping is not supported by: " + this.getClass());
    }

    public String getType() {
        return this.type;
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public boolean includeInUpdateStatement() {
        return true;
    }

    public boolean includeInInsertStatement() {
        return true;
    }

    protected String failureMessage(String method) {
        return LOCALISER.msg("041004", (Object)this.getClass().getName(), (Object)method);
    }

    public void setDefault(ObjectManager om, Object datastoreStatement, int[] exprIndex) {
        this.getDatastoreMapping(0).setObject(datastoreStatement, exprIndex[0], this.isNullable() ? null : this.getSampleValue(om.getClassLoaderResolver()));
    }

    public void setBoolean(ObjectManager om, Object datastoreStatement, int[] exprIndex, boolean value) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public boolean getBoolean(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("setBoolean")).setFatal();
    }

    public void setChar(ObjectManager om, Object datastoreStatement, int[] exprIndex, char value) {
        throw new NucleusException(this.failureMessage("setChar")).setFatal();
    }

    public char getChar(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getChar")).setFatal();
    }

    public void setByte(ObjectManager om, Object datastoreStatement, int[] exprIndex, byte value) {
        throw new NucleusException(this.failureMessage("setByte")).setFatal();
    }

    public byte getByte(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getByte")).setFatal();
    }

    public void setShort(ObjectManager om, Object datastoreStatement, int[] exprIndex, short value) {
        throw new NucleusException(this.failureMessage("setShort")).setFatal();
    }

    public short getShort(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getShort")).setFatal();
    }

    public void setInt(ObjectManager om, Object datastoreStatement, int[] exprIndex, int value) {
        throw new NucleusException(this.failureMessage("setInt")).setFatal();
    }

    public int getInt(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getInt")).setFatal();
    }

    public void setLong(ObjectManager om, Object datastoreStatement, int[] exprIndex, long value) {
        throw new NucleusException(this.failureMessage("setLong")).setFatal();
    }

    public long getLong(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getLong")).setFatal();
    }

    public void setFloat(ObjectManager om, Object datastoreStatement, int[] exprIndex, float value) {
        throw new NucleusException(this.failureMessage("setFloat")).setFatal();
    }

    public float getFloat(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getFloat")).setFatal();
    }

    public void setDouble(ObjectManager om, Object datastoreStatement, int[] exprIndex, double value) {
        throw new NucleusException(this.failureMessage("setDouble")).setFatal();
    }

    public double getDouble(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getDouble")).setFatal();
    }

    public void setString(ObjectManager om, Object datastoreStatement, int[] exprIndex, String value) {
        throw new NucleusException(this.failureMessage("setString")).setFatal();
    }

    public String getString(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getString")).setFatal();
    }

    public void setObject(ObjectManager om, Object datastoreStatement, int[] exprIndex, Object value, StateManager ownerSM, int ownerFieldNumber) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public void setObject(ObjectManager om, Object datastoreStatement, int[] exprIndex, Object value) {
        throw new NucleusException(this.failureMessage("setObject")).setFatal();
    }

    public Object getObject(ObjectManager om, Object datastoreResults, int[] exprIndex, StateManager ownerSM, int ownerFieldNumber) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    public Object getObject(ObjectManager om, Object datastoreResults, int[] exprIndex) {
        throw new NucleusException(this.failureMessage("getObject")).setFatal();
    }

    protected static ColumnMetaData[] getColumnMetaDataForMember(AbstractMemberMetaData mmd, int role) {
        if (mmd == null) {
            return null;
        }
        ColumnMetaData[] colmds = null;
        if (role == 3 || role == 4) {
            if (mmd.getJoinMetaData() != null && mmd.getElementMetaData() != null && mmd.getElementMetaData().getColumnMetaData() != null) {
                colmds = mmd.getElementMetaData().getColumnMetaData();
            }
        } else if (role == 5) {
            if (mmd.getJoinMetaData() != null && mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getColumnMetaData() != null) {
                colmds = mmd.getKeyMetaData().getColumnMetaData();
            }
        } else if (role == 6) {
            if (mmd.getJoinMetaData() != null && mmd.getValueMetaData() != null && mmd.getValueMetaData().getColumnMetaData() != null) {
                colmds = mmd.getValueMetaData().getColumnMetaData();
            }
        } else if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
            colmds = mmd.getColumnMetaData();
        }
        return colmds;
    }

    public abstract Object getSampleValue(ClassLoaderResolver var1);

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        throw new NucleusException(this.failureMessage("newLiteral")).setFatal();
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        throw new NucleusException(this.failureMessage("newScalarExpression")).setFatal();
    }
}

