/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.Ellipse2D;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class Ellipse2dFloatMapping
extends SingleFieldMultiMapping {
    private static final Ellipse2D.Float sampleValue = new Ellipse2D.Float(0.0f, 0.0f, 1.0f, 1.0f);

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.addDatastoreFields();
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addDatastoreFields();
    }

    protected void addDatastoreFields() {
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Ellipse2D.Float.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return sampleValue;
    }

    public Object getValueForDatastoreMapping(ObjectManager om, int index, Object value) {
        Ellipse2D.Float el = (Ellipse2D.Float)value;
        if (index == 0) {
            return el.getX();
        }
        if (index == 1) {
            return el.getY();
        }
        if (index == 2) {
            return el.getWidth();
        }
        if (index == 3) {
            return el.getHeight();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        Ellipse2D.Float ellipse = (Ellipse2D.Float)value;
        if (ellipse == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDatastoreMapping(i).setObject(preparedStatement, exprIndex[i], null);
            }
        } else {
            this.getDatastoreMapping(0).setFloat(preparedStatement, exprIndex[0], ellipse.x);
            this.getDatastoreMapping(1).setFloat(preparedStatement, exprIndex[1], ellipse.y);
            this.getDatastoreMapping(2).setFloat(preparedStatement, exprIndex[2], ellipse.width);
            this.getDatastoreMapping(3).setFloat(preparedStatement, exprIndex[3], ellipse.height);
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x = this.getDatastoreMapping(0).getFloat(resultSet, exprIndex[0]);
        float y = this.getDatastoreMapping(1).getFloat(resultSet, exprIndex[1]);
        float width = this.getDatastoreMapping(2).getFloat(resultSet, exprIndex[2]);
        float height = this.getDatastoreMapping(3).getFloat(resultSet, exprIndex[3]);
        return new Ellipse2D.Float(x, y, width, height);
    }
}

