/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.identity.SingleFieldPK;

public class IntFieldPK
extends SingleFieldPK {
    private int key;

    public IntFieldPK(Class pcClass, int key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public IntFieldPK(Class pcClass, Integer key) {
        super(pcClass);
        this.setKeyAsObject(key);
        this.key = key;
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public IntFieldPK(Class pcClass, String str) {
        super(pcClass);
        this.assertKeyNotNull(str);
        this.key = Integer.parseInt(str);
        this.hashCode = this.hashClassName() ^ this.key;
    }

    public IntFieldPK() {
    }

    public int getKey() {
        return this.key;
    }

    public String toString() {
        return Integer.toString(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        IntFieldPK other = (IntFieldPK)obj;
        return this.key == other.key;
    }

    public int compareTo(Object o) {
        if (o instanceof IntFieldPK) {
            IntFieldPK other = (IntFieldPK)o;
            return this.key - other.key;
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    protected Object createKeyAsObject() {
        return new Integer(this.key);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.key);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readInt();
    }
}

