/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchPlanForClass {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    final FetchPlan plan;
    final AbstractClassMetaData cmd;
    int[] memberNumbers;
    boolean dirty = true;
    Map<Integer, Set<FetchGroupMetaData>> fetchGroupsByMemberNumber = new HashMap<Integer, Set<FetchGroupMetaData>>();

    public FetchPlanForClass(AbstractClassMetaData cmd, FetchPlan fetchPlan) {
        this.cmd = cmd;
        this.plan = fetchPlan;
    }

    public final FetchPlan getFetchPlan() {
        return this.plan;
    }

    public final AbstractClassMetaData getAbstractClassMetaData() {
        return this.cmd;
    }

    void markDirty() {
        this.dirty = true;
        this.plan.invalidateCachedIsToCallPostLoadFetchPlan(this.cmd);
    }

    FetchPlanForClass getCopy(FetchPlan fp) {
        FetchPlanForClass fpCopy = new FetchPlanForClass(this.cmd, fp);
        if (this.memberNumbers != null) {
            fpCopy.memberNumbers = new int[this.memberNumbers.length];
            for (int i = 0; i < fpCopy.memberNumbers.length; ++i) {
                fpCopy.memberNumbers[i] = this.memberNumbers[i];
            }
        }
        fpCopy.dirty = this.dirty;
        return fpCopy;
    }

    public int getMaxRecursionDepthForMember(int memberNum) {
        HashSet<String> currentGroupNames = new HashSet<String>(this.plan.getGroups());
        FetchGroupMetaData[] fgmds = this.cmd.getFetchGroupMetaData(currentGroupNames);
        Set<FetchGroupMetaData> fetchGroupsContainingField = this.getFetchGroupsForMemberNumber(fgmds, memberNum);
        int recursionDepth = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNum).getRecursionDepth();
        if (recursionDepth == 0) {
            recursionDepth = 1;
        }
        String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNum).getName();
        for (FetchGroupMetaData fgmd : fetchGroupsContainingField) {
            AbstractMemberMetaData[] fmds = fgmd.getMemberMetaData();
            for (int i = 0; i < fmds.length; ++i) {
                AbstractMemberMetaData fmd = fmds[i];
                if (!fmd.getName().equals(fieldName) || fmd.getRecursionDepth() == 0) continue;
                recursionDepth = fmd.getRecursionDepth();
            }
        }
        return recursionDepth;
    }

    public boolean hasMember(int memberNumber) {
        if (this.dirty) {
            BitSet fieldsNumber = this.getMemberNumbersByBitSet();
            return fieldsNumber.get(memberNumber);
        }
        if (this.memberNumbers != null) {
            for (int i = 0; i < this.memberNumbers.length; ++i) {
                if (this.memberNumbers[i] != memberNumber) continue;
                return true;
            }
        }
        return false;
    }

    public int[] getMemberNumbers() {
        if (this.dirty) {
            this.dirty = false;
            BitSet fieldsNumber = this.getMemberNumbersByBitSet();
            int count = 0;
            for (int i = 0; i < fieldsNumber.length(); ++i) {
                if (!fieldsNumber.get(i)) continue;
                ++count;
            }
            this.memberNumbers = new int[count];
            int nextField = 0;
            for (int i = 0; i < fieldsNumber.length(); ++i) {
                if (!fieldsNumber.get(i)) continue;
                this.memberNumbers[nextField++] = i;
            }
        }
        return this.memberNumbers;
    }

    public BitSet getMemberNumbersByBitSet() {
        return this.getMemberNumbersByBitSet(this.cmd);
    }

    private BitSet getMemberNumbersByBitSet(AbstractClassMetaData cmd) {
        FetchPlanForClass fpc = this.plan.getFetchPlanForClass(cmd);
        BitSet bitSet = fpc.getMemberNumbersForFetchGroups(cmd.getFetchGroupMetaData());
        if (cmd.getPersistenceCapableSuperclass() != null) {
            AbstractClassMetaData superCmd = cmd.getSuperAbstractClassMetaData();
            this.plan.manageFetchPlanForClass(superCmd);
            FetchPlanForClass superFpc = this.plan.getFetchPlanForClass(superCmd);
            bitSet.or(superFpc.getMemberNumbersByBitSet(superCmd));
        } else {
            fpc.setAsNone(bitSet);
        }
        if (this.plan.dynamicGroups != null) {
            for (FetchGroup grp : this.plan.dynamicGroups) {
                if (!grp.getType().getName().equals(cmd.getFullClassName())) continue;
                Set<String> members = grp.getMembers();
                for (String memberName : members) {
                    int fieldPos = cmd.getAbsolutePositionOfMember(memberName);
                    if (fieldPos < 0) continue;
                    bitSet.set(fieldPos);
                }
            }
        }
        return bitSet;
    }

    private BitSet getMemberNumbersForFetchGroups(FetchGroupMetaData[] fgmds) {
        BitSet memberNumbers = new BitSet(0);
        if (fgmds != null) {
            for (int i = 0; i < fgmds.length; ++i) {
                if (!this.plan.groups.contains(fgmds[i].getName())) continue;
                memberNumbers.or(this.getMemberNumbersForFetchGroup(fgmds[i]));
            }
        }
        if (this.plan.groups.contains("default")) {
            this.setAsDefault(memberNumbers);
        }
        if (this.plan.groups.contains("all")) {
            this.setAsAll(memberNumbers);
        }
        if (this.plan.groups.contains("none")) {
            this.setAsNone(memberNumbers);
        }
        return memberNumbers;
    }

    private BitSet getMemberNumbersForFetchGroup(FetchGroupMetaData fgmd) {
        int i;
        BitSet memberNumbers = new BitSet(0);
        for (i = 0; i < fgmd.getMemberMetaData().length; ++i) {
            int fieldNumber = this.cmd.getAbsolutePositionOfMember(fgmd.getMemberMetaData()[i].getName());
            if (fieldNumber == -1) {
                String msg = LOCALISER.msg("006000", (Object)fgmd.getMemberMetaData()[i].getName(), (Object)fgmd.getName(), (Object)this.cmd.getFullClassName());
                NucleusLogger.PERSISTENCE.error(msg);
                throw new NucleusUserException(msg).setFatal();
            }
            memberNumbers.set(fieldNumber);
        }
        for (i = 0; i < fgmd.getFetchGroupMetaData().length; ++i) {
            String nestedGroupName = fgmd.getFetchGroupMetaData()[i].getName();
            if (nestedGroupName.equals("default")) {
                this.setAsDefault(memberNumbers);
                continue;
            }
            if (nestedGroupName.equals("all")) {
                this.setAsAll(memberNumbers);
                continue;
            }
            if (nestedGroupName.equals("none")) {
                this.setAsNone(memberNumbers);
                continue;
            }
            FetchGroupMetaData nestedFGMD = this.cmd.getFetchGroupMetaData(nestedGroupName);
            if (nestedFGMD == null) {
                throw new NucleusUserException(LOCALISER.msg("006001", (Object)fgmd.getFetchGroupMetaData()[i].getName(), (Object)fgmd.getName(), (Object)this.cmd.getFullClassName())).setFatal();
            }
            memberNumbers.or(this.getMemberNumbersForFetchGroup(nestedFGMD));
        }
        return memberNumbers;
    }

    private void setAsDefault(BitSet memberNums) {
        for (int i = 0; i < this.cmd.getDFGMemberPositions().length; ++i) {
            memberNums.set(this.cmd.getDFGMemberPositions()[i]);
        }
    }

    private void setAsAll(BitSet memberNums) {
        for (int i = 0; i < this.cmd.getNoOfManagedMembers(); ++i) {
            if (this.cmd.getMetaDataForManagedMemberAtPosition(i).getPersistenceModifier() == FieldPersistenceModifier.NONE) continue;
            memberNums.set(this.cmd.getAbsoluteMemberPositionForRelativePosition(i));
        }
    }

    private void setAsNone(BitSet memberNums) {
        for (int i = 0; i < this.cmd.getNoOfManagedMembers(); ++i) {
            AbstractMemberMetaData fmd = this.cmd.getMetaDataForMemberAtRelativePosition(i);
            if (!fmd.isPrimaryKey()) continue;
            memberNums.set(fmd.getAbsoluteFieldNumber());
        }
    }

    public boolean isToCallPostLoadFetchPlan(boolean[] loadedMembers) {
        BitSet cacheKey = new BitSet(loadedMembers.length);
        for (int i = 0; i < loadedMembers.length; ++i) {
            cacheKey.set(i, loadedMembers[i]);
        }
        Boolean result = this.plan.getCachedIsToCallPostLoadFetchPlan(this.cmd, cacheKey);
        if (result == null) {
            result = Boolean.FALSE;
            int[] fieldsInActualFetchPlan = this.getMemberNumbers();
            for (int i = 0; i < fieldsInActualFetchPlan.length; ++i) {
                int fieldNumber = fieldsInActualFetchPlan[i];
                String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getFullFieldName();
                if (loadedMembers[fieldNumber]) continue;
                if (this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).isDefaultFetchGroup() && this.plan.getGroups().contains("default")) {
                    result = Boolean.TRUE;
                    continue;
                }
                if (this.cmd.hasFetchGroupWithPostLoad()) {
                    Integer fieldNumberInteger = new Integer(fieldNumber);
                    Set<FetchGroupMetaData> fetchGroups = this.fetchGroupsByMemberNumber.get(fieldNumberInteger);
                    if (fetchGroups == null) {
                        fetchGroups = this.getFetchGroupsForMemberNumber(this.cmd.getFetchGroupMetaData(), fieldNumber);
                        this.fetchGroupsByMemberNumber.put(fieldNumberInteger, fetchGroups);
                    }
                    for (FetchGroupMetaData fgmd : fetchGroups) {
                        if (!fgmd.getPostLoad().booleanValue()) continue;
                        result = Boolean.TRUE;
                    }
                }
                if (this.plan.dynamicGroups == null) continue;
                Class cls = this.plan.clr.classForName(this.cmd.getFullClassName());
                for (FetchGroup group : this.plan.dynamicGroups) {
                    Set<String> groupMembers = group.getMembers();
                    if (!group.getType().isAssignableFrom(cls) || !groupMembers.contains(fieldName) || !group.getPostLoad()) continue;
                    result = Boolean.TRUE;
                }
            }
            if (result == null) {
                result = Boolean.FALSE;
            }
            this.plan.cacheIsToCallPostLoadFetchPlan(this.cmd, cacheKey, result);
        }
        return result;
    }

    private Set<FetchGroupMetaData> getFetchGroupsForMemberNumber(FetchGroupMetaData[] fgmds, int memberNum) {
        HashSet<FetchGroupMetaData> fetchGroups = new HashSet<FetchGroupMetaData>();
        if (fgmds != null) {
            for (int i = 0; i < fgmds.length; ++i) {
                int j;
                for (j = 0; j < fgmds[i].getMemberMetaData().length; ++j) {
                    if (!fgmds[i].getMemberMetaData()[j].getName().equals(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNum).getName())) continue;
                    fetchGroups.add(fgmds[i]);
                }
                for (j = 0; j < fgmds[i].getFetchGroupMetaData().length; ++j) {
                    fetchGroups.addAll(this.getFetchGroupsForMemberNumber(fgmds[i].getFetchGroupMetaData(), memberNum));
                }
            }
        }
        return fetchGroups;
    }
}

