/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.Line2D;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class Line2dDoubleMapping
extends SingleFieldMultiMapping {
    private static final Line2D.Double sampleValue = new Line2D.Double(0.0, 0.0, 1.0, 1.0);

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.addDatastoreField(ClassNameConstants.DOUBLE);
        this.addDatastoreField(ClassNameConstants.DOUBLE);
        this.addDatastoreField(ClassNameConstants.DOUBLE);
        this.addDatastoreField(ClassNameConstants.DOUBLE);
    }

    public Class getJavaType() {
        return Line2D.Double.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return sampleValue;
    }

    public Object getValueForDataStoreMapping(ObjectManager om, int index, Object value) {
        Line2D.Double line = (Line2D.Double)value;
        if (index == 0) {
            return line.getX1();
        }
        if (index == 1) {
            return line.getY1();
        }
        if (index == 2) {
            return line.getX2();
        }
        if (index == 3) {
            return line.getY2();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        Line2D line = (Line2D)value;
        if (line == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDataStoreMapping(i).setObject(preparedStatement, exprIndex[i], null);
            }
        } else {
            this.getDataStoreMapping(0).setDouble(preparedStatement, exprIndex[0], line.getX1());
            this.getDataStoreMapping(1).setDouble(preparedStatement, exprIndex[1], line.getY1());
            this.getDataStoreMapping(2).setDouble(preparedStatement, exprIndex[2], line.getX2());
            this.getDataStoreMapping(3).setDouble(preparedStatement, exprIndex[3], line.getY2());
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        double x1 = this.getDataStoreMapping(0).getDouble(resultSet, exprIndex[0]);
        double y1 = this.getDataStoreMapping(1).getDouble(resultSet, exprIndex[1]);
        double x2 = this.getDataStoreMapping(2).getDouble(resultSet, exprIndex[2]);
        double y2 = this.getDataStoreMapping(3).getDouble(resultSet, exprIndex[3]);
        return new Line2D.Double(x1, y1, x2, y2);
    }
}

