/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.PrimaryExpressionIsClassLiteralException;
import org.datanucleus.query.expression.PrimaryExpressionIsClassStaticFieldException;
import org.datanucleus.query.expression.PrimaryExpressionIsVariableException;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryExpression
extends Expression {
    SymbolTable symtbl;
    List<String> tuples;

    public PrimaryExpression(SymbolTable symtbl, List tuples) {
        this.symtbl = symtbl;
        this.tuples = tuples;
    }

    public PrimaryExpression(SymbolTable symtbl, Expression left, List tuples) {
        this.symtbl = symtbl;
        this.left = left;
        this.tuples = tuples;
    }

    public String getId() {
        StringBuffer str = new StringBuffer();
        for (String tuple : this.tuples) {
            if (str.length() > 0) {
                str.append('.');
            }
            str.append(tuple);
        }
        return str.toString();
    }

    public List<String> getTuples() {
        return this.tuples;
    }

    @Override
    public Symbol bind() {
        block20: {
            if (this.left != null) {
                this.left.bind();
            }
            if (this.symtbl.hasSymbol(this.getId())) {
                this.symbol = this.symtbl.getSymbol(this.getId());
            } else {
                if (this.left != null) {
                    return null;
                }
                try {
                    Class symbolType = this.symtbl.getType(this.tuples);
                    this.symbol = new PropertySymbol(this.getId(), symbolType);
                }
                catch (NucleusUserException nue) {
                    String className = this.getId();
                    try {
                        Class cls = this.symtbl.getSymbolResolver().resolveClass(className);
                        throw new PrimaryExpressionIsClassLiteralException(cls);
                    }
                    catch (ClassNotResolvedException cnre) {
                        if (className.indexOf(46) < 0) {
                            Class primaryCls = this.symtbl.getSymbolResolver().getPrimaryClass();
                            if (primaryCls == null) {
                                throw new NucleusUserException("Class name " + className + " could not be resolved");
                            }
                            try {
                                Field fld = primaryCls.getDeclaredField(className);
                                if (!Modifier.isStatic(fld.getModifiers())) {
                                    throw new NucleusUserException("Identifier " + className + " is unresolved (not a static field)");
                                }
                                throw new PrimaryExpressionIsClassStaticFieldException(fld);
                            }
                            catch (NoSuchFieldException nsfe) {
                                if (this.symtbl.getSymbolResolver().supportsImplicitVariables() && this.left == null) {
                                    throw new PrimaryExpressionIsVariableException(this.symtbl, className);
                                }
                                throw new NucleusUserException("Class name " + className + " could not be resolved");
                            }
                        }
                        try {
                            String staticFieldName = className.substring(className.lastIndexOf(46) + 1);
                            className = className.substring(0, className.lastIndexOf(46));
                            Class cls = this.symtbl.getSymbolResolver().resolveClass(className);
                            try {
                                Field fld = cls.getDeclaredField(staticFieldName);
                                if (!Modifier.isStatic(fld.getModifiers())) {
                                    throw new NucleusUserException("Identifier " + className + "." + staticFieldName + " is unresolved (not a static field)");
                                }
                                throw new PrimaryExpressionIsClassStaticFieldException(fld);
                            }
                            catch (NoSuchFieldException nsfe) {
                                throw new NucleusUserException("Identifier " + className + "." + staticFieldName + " is unresolved (not a static field)");
                            }
                        }
                        catch (ClassNotResolvedException cnre2) {
                            if (this.symtbl.getSymbolResolver().supportsImplicitVariables() && this.left == null) {
                                VariableExpression varExpr = new VariableExpression(this.symtbl, className);
                                varExpr.bind();
                                this.left = varExpr;
                                this.tuples.remove(0);
                                break block20;
                            }
                            throw nue;
                        }
                    }
                }
            }
        }
        return this.symbol;
    }

    public String toString() {
        if (this.left != null) {
            return "PrimaryExpression{" + this.left + "." + this.getId() + "}" + (this.alias != null ? " AS " + this.alias : "");
        }
        return "PrimaryExpression{" + this.getId() + "}" + (this.alias != null ? " AS " + this.alias : "");
    }
}

