/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.query.JDOQLSingleStringParser;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.JDOQLCompiler;
import org.datanucleus.query.compiler.JavaQueryCompiler;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractJDOQLQuery
extends AbstractJavaQuery {
    public AbstractJDOQLQuery(ObjectManager om) {
        super(om);
    }

    public AbstractJDOQLQuery(ObjectManager om, AbstractJDOQLQuery q) {
        this(om);
        this.candidateClass = q != null ? q.candidateClass : null;
        this.candidateClassName = q != null ? q.candidateClassName : null;
        this.filter = q != null ? q.filter : null;
        this.imports = q != null ? q.imports : null;
        this.explicitVariables = q != null ? this.explicitVariables : null;
        this.explicitParameters = q != null ? this.explicitParameters : null;
        this.grouping = q != null ? q.grouping : null;
        this.ordering = q != null ? q.ordering : null;
        this.result = q != null ? q.result : null;
        this.resultClass = q != null ? q.resultClass : null;
        this.resultClassName = q != null ? q.resultClassName : null;
        this.resultDistinct = q != null ? q.resultDistinct : false;
        this.range = q != null ? q.range : null;
        this.fromInclNo = q != null ? q.fromInclNo : 0L;
        this.toExclNo = q != null ? q.toExclNo : Long.MAX_VALUE;
        this.fromInclParam = q != null ? q.fromInclParam : null;
        String string = this.toExclParam = q != null ? q.toExclParam : null;
        if (q != null) {
            this.ignoreCache = q.ignoreCache;
        }
    }

    public AbstractJDOQLQuery(ObjectManager om, String query) {
        this(om);
        new JDOQLSingleStringParser(this, query).parse();
        if (this.candidateClassName != null) {
            try {
                this.candidateClass = this.getParsedImports().resolveClassDeclaration(this.candidateClassName, om.getClassLoaderResolver(), null);
                this.candidateClassName = this.candidateClass.getName();
            }
            catch (ClassNotResolvedException e) {
                NucleusLogger.QUERY.warn("Candidate class for JDOQL single-string query (" + this.candidateClassName + ") could not be resolved", e);
            }
        }
    }

    public void setGrouping(String grouping) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.grouping = null;
        this.setHaving(null);
        if (grouping != null && grouping.length() > 0) {
            if (grouping.indexOf("HAVING") >= 0) {
                this.setHaving(grouping.substring(grouping.indexOf("HAVING") + 7));
                this.grouping = grouping.substring(0, grouping.indexOf("HAVING") - 1);
            } else if (grouping.indexOf("having") >= 0) {
                this.setHaving(grouping.substring(grouping.indexOf("having") + 7));
                this.grouping = grouping.substring(0, grouping.indexOf("having") - 1);
            } else {
                this.grouping = grouping.trim();
            }
        }
    }

    public void setResult(String result) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (result == null) {
            this.result = null;
            this.resultDistinct = false;
            return;
        }
        String str = result.trim();
        if (str.startsWith("distinct ") || str.startsWith("DISTINCT ")) {
            this.resultDistinct = true;
            this.result = str.substring(8).trim();
        } else {
            this.resultDistinct = false;
            this.result = str;
        }
    }

    public String getSingleStringQuery() {
        if (this.singleString != null) {
            return this.singleString;
        }
        StringBuffer str = new StringBuffer("SELECT ");
        if (this.unique) {
            str.append("UNIQUE ");
        }
        if (this.result != null) {
            if (this.resultDistinct) {
                str.append("DISTINCT ");
            }
            str.append(this.result + " ");
        }
        if (this.resultClassName != null) {
            str.append("INTO " + this.resultClassName + " ");
        }
        if (this.from != null) {
            str.append("FROM " + this.from + " ");
        } else if (this.candidateClassName != null) {
            str.append("FROM " + this.candidateClassName + " ");
            if (!this.subclasses) {
                str.append("EXCLUDE SUBCLASSES ");
            }
        }
        if (this.filter != null) {
            str.append("WHERE " + this.filter + " ");
        }
        if (this.explicitVariables != null) {
            str.append("VARIABLES " + this.explicitVariables + " ");
        }
        if (this.explicitParameters != null) {
            str.append("PARAMETERS " + this.explicitParameters + " ");
        }
        if (this.imports != null) {
            str.append(this.imports + " ");
        }
        if (this.grouping != null) {
            str.append("GROUP BY " + this.grouping + " ");
        }
        if (this.having != null) {
            str.append("HAVING " + this.having + " ");
        }
        if (this.ordering != null) {
            str.append("ORDER BY " + this.ordering + " ");
        }
        if (this.range != null) {
            str.append("RANGE " + this.range);
        } else if (this.fromInclNo > 0L || this.toExclNo != Long.MAX_VALUE) {
            str.append("RANGE " + this.fromInclNo + "," + this.toExclNo);
        }
        this.singleString = str.toString().trim();
        return this.singleString;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        QueryCompilation cachedCompilation;
        if (this.compilation != null) {
            return;
        }
        QueryManager queryMgr = this.getQueryManager();
        if (this.useCaching() && (cachedCompilation = queryMgr.getQueryCompilationForQuery(this.getLanguage(), this.toString())) != null) {
            this.compilation = cachedCompilation;
            this.checkParameterTypesAgainstCompilation(parameterValues);
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug(LOCALISER.msg("021044", (Object)this.getLanguage(), (Object)this.getSingleStringQuery()));
        }
        JDOQLCompiler compiler = new JDOQLCompiler(this.om.getMetaDataManager(), this.om.getClassLoaderResolver(), this.from, this.candidateClass, this.candidateCollection, this.filter, this.getParsedImports(), this.ordering, this.result, this.grouping, this.having, this.explicitParameters, this.explicitVariables);
        this.compilation = ((JavaQueryCompiler)compiler).compile(parameterValues, this.subqueries);
        if (QueryUtils.queryReturnsSingleRow(this)) {
            this.compilation.setReturnsSingleRow();
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(LOCALISER.msg("021045", (Object)this.getLanguage(), (Object)("" + (System.currentTimeMillis() - startTime))));
        }
        if (this.subqueries != null) {
            for (Map.Entry entry : this.subqueries.entrySet()) {
                Query.SubqueryDefinition subqueryDefinition = (Query.SubqueryDefinition)entry.getValue();
                Query subquery = subqueryDefinition.getQuery();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    startTime = System.currentTimeMillis();
                    NucleusLogger.QUERY.debug(LOCALISER.msg("021044", (Object)this.getLanguage(), (Object)((AbstractJDOQLQuery)subquery).getSingleStringQuery()));
                }
                compiler = new JDOQLCompiler(this.om.getMetaDataManager(), this.om.getClassLoaderResolver(), subquery.from, subquery.candidateClass, null, subquery.filter, this.getParsedImports(), subquery.ordering, subquery.result, subquery.grouping, subquery.having, null, null);
                QueryCompilation subqueryCompilation = ((JavaQueryCompiler)compiler).compile(parameterValues, null);
                if (QueryUtils.queryReturnsSingleRow(subquery)) {
                    subqueryCompilation.setReturnsSingleRow();
                }
                this.compilation.addSubqueryCompilation((String)entry.getKey(), subqueryCompilation);
                if (!NucleusLogger.QUERY.isDebugEnabled()) continue;
                NucleusLogger.QUERY.debug(LOCALISER.msg("021045", (Object)this.getLanguage(), (Object)("" + (System.currentTimeMillis() - startTime))));
            }
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(this.compilation.toString());
        }
        this.checkParameterTypesAgainstCompilation(parameterValues);
        if (this.useCaching()) {
            queryMgr.addQueryCompilation(this.getLanguage(), this.toString(), this.compilation);
        }
    }

    public String getLanguage() {
        return "JDOQL";
    }
}

