/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.util.Localiser;

public abstract class BaseContainerStore {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected MappedStoreManager storeMgr;
    protected DatastoreAdapter dba;
    protected JavaTypeMapping ownerMapping;
    protected AbstractMemberMetaData ownerMemberMetaData;
    protected int relationType;
    protected boolean allowsNull = false;

    protected BaseContainerStore(StoreManager storeMgr) {
        this.storeMgr = (MappedStoreManager)storeMgr;
        this.dba = this.storeMgr.getDatastoreAdapter();
    }

    protected void setOwner(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        this.ownerMemberMetaData = mmd;
        if (this.ownerMemberMetaData.hasExtension("allow-nulls") && this.ownerMemberMetaData.getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
            this.allowsNull = true;
        }
        this.relationType = this.ownerMemberMetaData.getRelationType(clr);
    }

    public MappedStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean isEmbeddedMapping(JavaTypeMapping mapping) {
        return !InterfaceMapping.class.isAssignableFrom(mapping.getClass()) && !OIDMapping.class.isAssignableFrom(mapping.getClass());
    }

    public StateManager getStateManagerForEmbeddedPCObject(StateManager sm, Object obj, AbstractMemberMetaData ownerFmd) {
        ObjectManager om = sm.getObjectManager();
        StateManager objSM = om.findStateManager(obj);
        if (objSM == null) {
            objSM = StateManagerFactory.newStateManagerForEmbedded(om, obj, false);
            objSM.addEmbeddedOwner(sm, ownerFmd.getAbsoluteFieldNumber());
        }
        return objSM;
    }

    protected boolean allowsBatching() {
        return this.storeMgr.allowsBatching();
    }

    public int getRelationType() {
        return this.relationType;
    }

    public AbstractMemberMetaData getOwnerMemberMetaData() {
        return this.ownerMemberMetaData;
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }
}

