/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ObjectManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.OID;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.util.ClassUtils;

public class PersistableIdMapping
extends PersistableMapping {
    public PersistableIdMapping(PersistableMapping pcMapping) {
        this.initialize(pcMapping.dba, pcMapping.type);
        this.datastoreContainer = pcMapping.datastoreContainer;
        this.javaTypeMappings = new JavaTypeMapping[pcMapping.javaTypeMappings.length];
        System.arraycopy(pcMapping.javaTypeMappings, 0, this.javaTypeMappings, 0, this.javaTypeMappings.length);
    }

    public Object getObject(ObjectManager om, Object rs, int[] param) {
        Object value = super.getObject(om, rs, param);
        if (value != null) {
            ApiAdapter api = om.getApiAdapter();
            return api.getIdForObject(value);
        }
        return null;
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value) {
        if (value == null) {
            super.setObject(om, ps, param, value);
            return;
        }
        if (this.cmd == null) {
            this.cmd = om.getMetaDataManager().getMetaDataForClass(this.getType(), om.getClassLoaderResolver());
        }
        if (value instanceof OID) {
            Object key = ((OID)value).getKeyValue();
            if (key instanceof String) {
                this.getJavaTypeMapping()[0].setString(om, ps, param, (String)key);
            } else {
                this.getJavaTypeMapping()[0].setObject(om, ps, param, key);
            }
        } else if (om.getApiAdapter().isSingleFieldIdentity(value)) {
            Object key = om.getApiAdapter().getTargetKeyForSingleFieldIdentity(value);
            if (key instanceof String) {
                this.getJavaTypeMapping()[0].setString(om, ps, param, (String)key);
            } else {
                this.getJavaTypeMapping()[0].setObject(om, ps, param, key);
            }
        } else {
            String[] pkMemberNames = this.cmd.getPrimaryKeyMemberNames();
            for (int i = 0; i < pkMemberNames.length; ++i) {
                Object pkMemberValue = ClassUtils.getValueForIdentityField(value, pkMemberNames[i]);
                if (pkMemberValue instanceof Byte) {
                    this.getDataStoreMapping(i).setByte(ps, param[i], (Byte)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Character) {
                    this.getDataStoreMapping(i).setChar(ps, param[i], ((Character)pkMemberValue).charValue());
                    continue;
                }
                if (pkMemberValue instanceof Integer) {
                    this.getDataStoreMapping(i).setInt(ps, param[i], (Integer)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Long) {
                    this.getDataStoreMapping(i).setLong(ps, param[i], (Long)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Short) {
                    this.getDataStoreMapping(i).setShort(ps, param[i], (Short)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof String) {
                    this.getDataStoreMapping(i).setString(ps, param[i], (String)pkMemberValue);
                    continue;
                }
                this.getDataStoreMapping(i).setObject(ps, param[i], pkMemberValue);
            }
        }
    }
}

