/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.sql.Timestamp;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SqlTemporalExpression;
import org.datanucleus.store.mapped.expression.SqlTimestampLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public abstract class ObjectAsTimestampMapping
extends SingleFieldMapping {
    public abstract Class getJavaType();

    public String getJavaTypeForDatastoreMapping(int index) {
        return ClassNameConstants.JAVA_SQL_TIMESTAMP;
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], this.objectToTimestamp(value));
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
        Object value = null;
        if (datastoreValue != null) {
            value = this.timestampToObject((Timestamp)datastoreValue);
        }
        return value;
    }

    protected abstract Timestamp objectToTimestamp(Object var1);

    protected abstract Object timestampToObject(Timestamp var1);

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return new SqlTimestampLiteral(qs, (JavaTypeMapping)this, (Timestamp)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return new SqlTemporalExpression(qs, this, te);
    }
}

