/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Map;
import java.util.Set;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOContainer;
import org.datanucleus.sco.SCOMap;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MapExpression;
import org.datanucleus.store.mapped.expression.MapLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.NucleusLogger;

public class MapMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    public Class getJavaType() {
        return Map.class;
    }

    public void postInsert(StateManager sm) {
        Map value = (Map)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value.keySet());
                SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
            }
            ApiAdapter api = sm.getObjectManager().getApiAdapter();
            Set entries = value.entrySet();
            for (Map.Entry entry : entries) {
                if (api.isPersistable(entry.getKey()) && !api.isPersistent(entry.getKey()) && !api.isDetached(entry.getKey())) {
                    throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || api.isPersistent(entry.getValue()) || api.isDetached(entry.getValue())) continue;
                throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), entry.getValue());
            }
        } else {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007007", (Object)this.mmd.getFullFieldName()));
            }
            if (value.size() > 0) {
                MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
                ((MapStore)storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.mmd, value.getClass())).putAll(sm, value);
                this.replaceFieldWithWrapper(sm, value, false, false);
            } else {
                this.replaceFieldWithWrapper(sm, null, false, false);
            }
        }
    }

    public void postUpdate(StateManager sm) {
        ObjectManager om = sm.getObjectManager();
        MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
        Map value = (Map)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting(om, value.keySet());
                SCOUtils.validateObjectsForWriting(om, value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (value instanceof SCOContainer) {
            SCOContainer sco = (SCOContainer)((Object)value);
            if (sm.getObject() == sco.getOwner() && this.mmd.getName().equals(sco.getFieldName())) {
                sco.flush();
                return;
            }
            if (sco.getOwner() != null) {
                throw new NucleusException("Owned second-class object was somehow assigned to a field other than its owner's").setFatal();
            }
        }
        if (!this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007008", (Object)this.mmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007009", (Object)this.mmd.getFullFieldName()));
        }
        MapStore store = (MapStore)storeMgr.getBackingStoreForField(om.getClassLoaderResolver(), this.mmd, value.getClass());
        store.clear(sm);
        store.putAll(sm, value);
        this.replaceFieldWithWrapper(sm, value, false, false);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.getObjectManager().getApiAdapter().isLoaded(sm, this.mmd.getAbsoluteFieldNumber());
        Map value = (Map)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (value == null || value.isEmpty()) {
            return;
        }
        if (!(value instanceof SCO)) {
            value = (Map)sm.wrapSCOField(this.mmd.getAbsoluteFieldNumber(), value, false, false, true);
        }
        value.clear();
        ((SCOMap)((Object)value)).flush();
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(LOCALISER.msg("041025", (Object)this.mmd.getFullFieldName())).setFatal();
        }
        return new MapLiteral(qs, (JavaTypeMapping)this, (Map)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(LOCALISER.msg("041025", (Object)this.mmd.getFullFieldName())).setFatal();
        }
        MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
        return new MapExpression(qs, this.datastoreContainer.getIDMapping(), te, (MapStore)storeMgr.getBackingStoreForField(qs.getClassLoaderResolver(), this.mmd, null), this.mmd.getName());
    }
}

