/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Collection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.sco.SCOContainer;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.CollectionExpression;
import org.datanucleus.store.mapped.expression.CollectionLiteral;
import org.datanucleus.store.mapped.expression.CollectionSubqueryExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.util.NucleusLogger;

public class CollectionMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    public Class getJavaType() {
        return Collection.class;
    }

    public void postInsert(StateManager sm) {
        Collection value = (Collection)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value);
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        Object[] collElements = value.toArray();
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
            }
            for (int i = 0; i < collElements.length; ++i) {
                if (sm.getObjectManager().getApiAdapter().isDetached(collElements[i]) || sm.getObjectManager().getApiAdapter().isPersistent(collElements[i])) continue;
                throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), collElements[i]);
            }
        } else {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007007", (Object)this.mmd.getFullFieldName()));
            }
            boolean needsAttaching = false;
            for (int i = 0; i < collElements.length; ++i) {
                if (!sm.getObjectManager().getApiAdapter().isDetached(collElements[i])) continue;
                needsAttaching = true;
                break;
            }
            if (needsAttaching) {
                SCO collWrapper = this.replaceFieldWithWrapper(sm, null, false, false);
                collWrapper.attachCopy(value);
            } else if (value.size() > 0) {
                MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
                ((CollectionStore)storeMgr.getBackingStoreForField(sm.getObjectManager().getClassLoaderResolver(), this.mmd, value.getClass())).addAll(sm, value, 0);
                this.replaceFieldWithWrapper(sm, value, false, false);
            } else {
                this.replaceFieldWithWrapper(sm, null, false, false);
            }
        }
    }

    public void postUpdate(StateManager sm) {
        ObjectManager om = sm.getObjectManager();
        MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
        Collection value = (Collection)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting(om, value);
            return;
        }
        if (value == null) {
            ((CollectionStore)storeMgr.getBackingStoreForField(om.getClassLoaderResolver(), this.mmd, null)).clear(sm);
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (value instanceof SCOContainer) {
            SCOContainer sco = (SCOContainer)((Object)value);
            if (sm.getObject() == sco.getOwner() && this.mmd.getName().equals(sco.getFieldName())) {
                sco.flush();
                return;
            }
            if (sco.getOwner() != null) {
                throw new NucleusException(LOCALISER.msg("CollectionMapping.WrongOwnerError")).setFatal();
            }
        }
        if (!this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007008", (Object)this.mmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
            NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007009", (Object)this.mmd.getFullFieldName()));
        }
        CollectionStore backingStore = (CollectionStore)storeMgr.getBackingStoreForField(om.getClassLoaderResolver(), this.mmd, value.getClass());
        backingStore.update(sm, value);
        this.replaceFieldWithWrapper(sm, value, false, false);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.getObjectManager().getApiAdapter().isLoaded(sm, this.mmd.getAbsoluteFieldNumber());
        Collection value = (Collection)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        boolean isDependentElement = this.mmd.getCollection().isDependentElement();
        boolean hasJoin = this.mmd.getJoinMetaData() != null;
        boolean hasFK = false;
        if (!hasJoin) {
            if (this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().getForeignKeyMetaData() != null) {
                hasFK = true;
            } else if (this.mmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(sm.getObjectManager().getClassLoaderResolver());
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
        }
        if (sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
            hasFK = false;
        }
        if (isDependentElement || hasJoin || !hasFK) {
            if (!(value instanceof SCO)) {
                value = (Collection)sm.wrapSCOField(this.mmd.getAbsoluteFieldNumber(), value, false, false, true);
            }
            value.clear();
            ((SCOCollection)((Object)value)).flush();
        }
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(LOCALISER.msg("041025", (Object)this.mmd.getFullFieldName())).setFatal();
        }
        if (value instanceof Queryable) {
            return new CollectionSubqueryExpression(qs, ((Queryable)value).newQueryStatement());
        }
        return new CollectionLiteral(qs, (JavaTypeMapping)this, (Collection)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new NucleusUserException(LOCALISER.msg("041025", (Object)this.mmd.getFullFieldName())).setFatal();
        }
        MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
        return new CollectionExpression(qs, this.datastoreContainer.getIDMapping(), te, (CollectionStore)storeMgr.getBackingStoreForField(qs.getClassLoaderResolver(), this.mmd, null), this.mmd.getName());
    }
}

