/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MacroString;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.ViewUtils;

public abstract class AbstractClassMetaData
extends MetaData {
    protected static Localiser LOCALISER_API = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerImpl.class.getClassLoader());
    protected final String name;
    protected String entityName;
    protected IdentityType identityType = IdentityType.DATASTORE;
    protected ClassPersistenceModifier persistenceModifier = ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    protected String persistenceCapableSuperclass;
    protected String objectidClass;
    protected boolean requiresExtent = true;
    protected boolean detachable = false;
    protected boolean embeddedOnly = false;
    protected String catalog;
    protected String schema;
    protected String table;
    protected boolean cacheable = true;
    protected final String fullName;
    protected VersionMetaData versionMetaData;
    protected IdentityMetaData identityMetaData;
    protected boolean identitySpecified = false;
    protected InheritanceMetaData inheritanceMetaData;
    protected PrimaryKeyMetaData primaryKeyMetaData;
    protected List listeners = null;
    protected Boolean excludeSuperClassListeners = null;
    protected Boolean excludeDefaultListeners = null;
    protected FetchGroupMetaData[] fetchGroupMetaData;
    protected Map<String, FetchGroupMetaData> fetchGroupMetaDataByName;
    protected AbstractClassMetaData pcSuperclassMetaData = null;
    protected boolean metaDataComplete = false;
    protected boolean serializeRead = false;
    protected Collection<QueryMetaData> queries = null;
    protected Collection<QueryResultMetaData> queryResultMetaData = null;
    protected JoinMetaData[] joinMetaData;
    protected IndexMetaData[] indexMetaData;
    protected ForeignKeyMetaData[] foreignKeyMetaData;
    protected UniqueMetaData[] uniqueMetaData;
    protected List members = new ArrayList();
    protected List<ColumnMetaData> unmappedColumns = null;
    protected List<JoinMetaData> joins = new ArrayList<JoinMetaData>();
    protected List<ForeignKeyMetaData> foreignKeys = new ArrayList<ForeignKeyMetaData>();
    protected List<IndexMetaData> indexes = new ArrayList<IndexMetaData>();
    protected List<UniqueMetaData> uniqueConstraints = new ArrayList<UniqueMetaData>();
    protected List<FetchGroupMetaData> fetchGroups = new ArrayList<FetchGroupMetaData>();
    protected AbstractMemberMetaData[] managedMembers;
    protected AbstractMemberMetaData[] overriddenMembers;
    protected Map<String, Integer> memberPositionsByName;
    protected int[] allMemberPositions;
    protected int[] pkMemberPositions;
    protected int[] nonPkMemberPositions;
    protected boolean[] nonPkMemberFlags;
    protected int[] dfgMemberPositions;
    protected boolean[] dfgMemberFlags;
    protected int[] scoMutableMemberPositions;
    protected boolean[] scoMutableMemberFlags;
    protected int[] scoNonContainerMemberPositions = null;
    protected int[] relationPositions = null;
    protected int noOfInheritedManagedMembers = 0;
    protected boolean usesSingleFieldIdentityClass;
    protected int memberCount;
    protected boolean implementationOfPersistentDefinition = false;
    boolean populating = false;
    boolean initialising = false;
    protected Boolean fetchGroupMetaWithPostLoad;
    protected transient boolean persistentInterfaceImplNeedingTableFromSuperclass = false;
    protected transient boolean persistentInterfaceImplNeedingTableFromSubclass = false;
    protected int[] secondClassContainerMemberPositions = null;

    protected AbstractClassMetaData(PackageMetaData parent, String name) {
        super(parent);
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidMetaDataException(LOCALISER, "044061", (Object)parent.name);
        }
        this.name = name;
        this.fullName = ClassUtils.createFullClassName(parent.name, name);
    }

    public AbstractClassMetaData(InterfaceMetaData imd, String implClassName, boolean copyMembers) {
        this((PackageMetaData)imd.parent, implClassName);
        this.setRequiresExtent(imd.requiresExtent);
        this.setDetachable(imd.detachable);
        this.setTable(imd.table);
        this.setCatalog(imd.catalog);
        this.setSchema(imd.schema);
        this.setEntityName(imd.entityName);
        this.setObjectIdClass(imd.objectidClass);
        this.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
        this.setEmbeddedOnly(imd.embeddedOnly);
        this.setIdentityType(imd.identityType);
        this.implementationOfPersistentDefinition = true;
        if (copyMembers) {
            this.copyMembersFromInterface(imd);
        }
        this.setVersionMetaData(imd.versionMetaData);
        this.setIdentityMetaData(imd.identityMetaData);
        this.setPrimaryKeyMetaData(imd.primaryKeyMetaData);
        if (imd.inheritanceMetaData != null) {
            if (imd.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
                this.persistentInterfaceImplNeedingTableFromSuperclass = true;
            } else if (imd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                this.persistentInterfaceImplNeedingTableFromSubclass = true;
            }
            InheritanceMetaData inhmd = new InheritanceMetaData();
            inhmd.setStrategy(InheritanceStrategy.NEW_TABLE);
            if (imd.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
                for (AbstractClassMetaData acmd = imd.getSuperAbstractClassMetaData(); acmd != null; acmd = acmd.getSuperAbstractClassMetaData()) {
                    if (acmd.getInheritanceMetaData() == null || acmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.NEW_TABLE) continue;
                    if (acmd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
                        inhmd.setDiscriminatorMetaData(new DiscriminatorMetaData(acmd.getInheritanceMetaData().getDiscriminatorMetaData()));
                    }
                    inhmd.setJoinMetaData(acmd.getInheritanceMetaData().getJoinMetaData());
                    break;
                }
            } else if (imd.inheritanceMetaData.getStrategy() == InheritanceStrategy.NEW_TABLE) {
                if (imd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
                    inhmd.setDiscriminatorMetaData(new DiscriminatorMetaData(imd.getInheritanceMetaData().getDiscriminatorMetaData()));
                }
                inhmd.setJoinMetaData(imd.getInheritanceMetaData().getJoinMetaData());
            }
            this.setInheritanceMetaData(inhmd);
        }
        if (imd.joinMetaData != null) {
            for (int i = 0; i < imd.joinMetaData.length; ++i) {
                this.addJoin(imd.joinMetaData[i]);
            }
        }
        if (imd.foreignKeyMetaData != null) {
            for (int i = 0; i < imd.foreignKeyMetaData.length; ++i) {
                this.addForeignKey(imd.foreignKeyMetaData[i]);
            }
        }
        if (imd.indexMetaData != null) {
            for (int i = 0; i < imd.indexMetaData.length; ++i) {
                this.addIndex(imd.indexMetaData[i]);
            }
        }
        if (imd.uniqueMetaData != null) {
            for (int i = 0; i < imd.uniqueMetaData.length; ++i) {
                this.addUniqueConstraint(imd.uniqueMetaData[i]);
            }
        }
        if (imd.fetchGroupMetaData != null) {
            for (int i = 0; i < imd.fetchGroupMetaData.length; ++i) {
                this.addFetchGroup(imd.fetchGroupMetaData[i]);
            }
        }
        if (this.queries != null) {
            Iterator<QueryMetaData> iter = this.queries.iterator();
            this.addQuery(iter.next());
        }
        if (imd.listeners != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.addAll(imd.listeners);
        }
    }

    public AbstractClassMetaData(ClassMetaData cmd, String implClassName) {
        this((PackageMetaData)cmd.parent, implClassName);
        this.setRequiresExtent(cmd.requiresExtent);
        this.setDetachable(cmd.detachable);
        this.setCatalog(cmd.catalog);
        this.setSchema(cmd.schema);
        this.setTable(cmd.table);
        this.setEntityName(cmd.entityName);
        this.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
        this.setEmbeddedOnly(cmd.embeddedOnly);
        this.setIdentityType(cmd.identityType);
        this.setPersistenceCapableSuperclass(cmd.getFullClassName());
        this.implementationOfPersistentDefinition = true;
        for (int i = 0; i < cmd.getMemberCount(); ++i) {
            FieldMetaData fmd = new FieldMetaData((MetaData)this, cmd.getMetaDataForManagedMemberAtAbsolutePosition(i));
            fmd.persistenceModifier = FieldPersistenceModifier.NONE;
            fmd.primaryKey = Boolean.FALSE;
            fmd.defaultFetchGroup = Boolean.FALSE;
            this.addMember(fmd);
        }
    }

    public boolean isImplementationOfPersistentDefinition() {
        return this.implementationOfPersistentDefinition;
    }

    protected void copyMembersFromInterface(InterfaceMetaData imd) {
        for (int i = 0; i < imd.getMemberCount(); ++i) {
            FieldMetaData fmd = new FieldMetaData((MetaData)this, imd.getMetaDataForManagedMemberAtAbsolutePosition(i));
            this.addMember(fmd);
        }
    }

    protected void checkInitialised() {
        if (!this.isInitialised()) {
            throw new NucleusException(LOCALISER.msg("044069", (Object)this.fullName)).setFatal();
        }
    }

    protected void checkPopulated() {
        if (!this.isPopulated() && !this.isInitialised()) {
            throw new NucleusException(LOCALISER.msg("044070", (Object)this.fullName)).setFatal();
        }
    }

    protected Class loadClass(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr) {
        Class cls;
        if (clr == null) {
            NucleusLogger.METADATA.warn(LOCALISER.msg("044067", (Object)this.fullName));
            clr = mmgr.getOMFContext().getClassLoaderResolver(null);
        }
        try {
            cls = clr.classForName(this.fullName, primary, false);
            if (cls == null) {
                NucleusLogger.METADATA.error(LOCALISER.msg("044080", (Object)this.fullName));
                throw new InvalidMetaDataException(LOCALISER, "044080", (Object)this.fullName);
            }
        }
        catch (ClassNotResolvedException cnre) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044080", (Object)this.fullName));
            throw new InvalidMetaDataException(LOCALISER, "044080", (Object)this.fullName);
        }
        return cls;
    }

    protected void determineIdentity() {
        if (this.identityType == null) {
            if (this.objectidClass != null) {
                this.identityType = IdentityType.APPLICATION;
            } else {
                int noOfPkKeys = 0;
                for (AbstractMemberMetaData mmd : this.members) {
                    if (!mmd.isPrimaryKey()) continue;
                    ++noOfPkKeys;
                }
                this.identityType = noOfPkKeys == 1 ? IdentityType.APPLICATION : IdentityType.DATASTORE;
            }
        }
    }

    protected void determineSuperClassName(ClassLoaderResolver clr, Class cls, MetaDataManager mmgr) {
        if (this.persistenceCapableSuperclass != null) {
            this.persistenceCapableSuperclass = ClassUtils.createFullClassName(((PackageMetaData)this.parent).name, this.persistenceCapableSuperclass);
        }
        String realPcSuperclassName = null;
        Collection superclasses = null;
        superclasses = cls.isInterface() ? ClassUtils.getSuperinterfaces(cls) : ClassUtils.getSuperclasses(cls);
        if (!superclasses.isEmpty()) {
            for (Class superclass : superclasses) {
                AbstractClassMetaData superCmd = mmgr.getMetaDataForClassInternal(superclass, clr);
                if (superCmd == null || superCmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) continue;
                realPcSuperclassName = superclass.getName();
                break;
            }
        }
        if (this.persistenceCapableSuperclass != null && !this.persistenceCapableSuperclass.equals(realPcSuperclassName)) {
            try {
                AbstractClassMetaData superCmd = mmgr.getMetaDataForClassInternal(clr.classForName(this.persistenceCapableSuperclass), clr);
                if (superCmd == null || superCmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                    throw new InvalidMetaDataException(LOCALISER, "044083", (Object)this.name, this.persistenceCapableSuperclass);
                }
            }
            catch (ClassNotResolvedException cnre) {
                throw new InvalidMetaDataException(LOCALISER, "044088", (Object)this.name, this.persistenceCapableSuperclass);
            }
            if (realPcSuperclassName != null) {
                throw new InvalidMetaDataException(LOCALISER, "044087", (Object)this.name, (Object)realPcSuperclassName, this.persistenceCapableSuperclass);
            }
            throw new InvalidMetaDataException(LOCALISER, "044082", (Object)this.name, this.persistenceCapableSuperclass);
        }
        if (this.persistenceCapableSuperclass == null && realPcSuperclassName != null) {
            this.persistenceCapableSuperclass = realPcSuperclassName;
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(LOCALISER.msg("044089", (Object)this.name, (Object)this.persistenceCapableSuperclass));
            }
        }
        this.validateSuperClass(clr, cls, superclasses, mmgr);
        if (this.persistenceCapableSuperclass != null && !this.isDetachable() && this.pcSuperclassMetaData.isDetachable()) {
            this.detachable = true;
        }
    }

    private void validateSuperClass(ClassLoaderResolver clr, Class cls, Collection superclasses, MetaDataManager mmgr) {
        if (this.persistenceCapableSuperclass != null) {
            Class pcsc = null;
            try {
                pcsc = clr.classForName(this.persistenceCapableSuperclass);
            }
            catch (ClassNotResolvedException cnre) {
                throw new InvalidMetaDataException(LOCALISER, "044081", (Object)this.name, this.persistenceCapableSuperclass);
            }
            if (this.persistenceCapableSuperclass.equals(this.fullName) || !pcsc.isAssignableFrom(cls)) {
                throw new InvalidMetaDataException(LOCALISER, "044082", (Object)this.name, this.persistenceCapableSuperclass);
            }
            if (mmgr != null) {
                this.pcSuperclassMetaData = mmgr.getMetaDataForClassInternal(pcsc, clr);
                if (this.pcSuperclassMetaData == null) {
                    throw new InvalidMetaDataException(LOCALISER, "044083", (Object)this.name, this.persistenceCapableSuperclass);
                }
            } else {
                String superclass_pkg_name = this.persistenceCapableSuperclass.substring(0, this.persistenceCapableSuperclass.lastIndexOf(46));
                PackageMetaData pmd = this.getPackageMetaData().getFileMetaData().getPackage(superclass_pkg_name);
                if (pmd != null) {
                    String superclass_class_name = this.persistenceCapableSuperclass.substring(this.persistenceCapableSuperclass.lastIndexOf(46) + 1);
                    this.pcSuperclassMetaData = pmd.getClass(superclass_class_name);
                }
            }
            if (this.pcSuperclassMetaData == null) {
                throw new InvalidMetaDataException(LOCALISER, "044084", (Object)this.name, this.persistenceCapableSuperclass);
            }
            if (!this.pcSuperclassMetaData.isPopulated() && !this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.populate(clr, cls.getClassLoader(), mmgr);
            }
        } else if (!superclasses.isEmpty()) {
            for (Class superclass : superclasses) {
                AbstractClassMetaData superCmd = mmgr.getMetaDataForClassInternal(superclass, clr);
                if (superCmd == null || superCmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) continue;
                throw new InvalidMetaDataException(LOCALISER, "044091", (Object)this.fullName, superclass.getName());
            }
        }
    }

    protected void validateUserInputForIdentity() {
        if (this.pcSuperclassMetaData != null) {
            AbstractClassMetaData baseCmd = this.getBaseAbstractClassMetaData();
            IdentityMetaData imd = baseCmd.getIdentityMetaData();
            if (baseCmd.identitySpecified && this.identitySpecified && imd != null && imd.getValueStrategy() != null && this.identityMetaData != null && this.identityMetaData.getValueStrategy() != null && this.identityMetaData.getValueStrategy() != imd.getValueStrategy()) {
                throw new InvalidMetaDataException(LOCALISER, "044094", (Object)this.fullName, (Object)this.identityMetaData.getValueStrategy(), imd.getValueStrategy());
            }
        }
    }

    public AbstractClassMetaData getBaseAbstractClassMetaData() {
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getBaseAbstractClassMetaData();
        }
        return this;
    }

    protected String getBaseInheritanceStrategy() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getStrategyForTree() != null) {
            return this.inheritanceMetaData.getStrategyForTree();
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getBaseInheritanceStrategy();
        }
        return null;
    }

    protected void inheritIdentity() {
        if (this.objectidClass != null) {
            this.objectidClass = ClassUtils.createFullClassName(((PackageMetaData)this.parent).name, this.objectidClass);
        }
        if (this.persistenceCapableSuperclass != null) {
            if (this.objectidClass != null) {
                String superObjectIdClass = this.pcSuperclassMetaData.getObjectidClass();
                if (superObjectIdClass == null || !this.objectidClass.equals(superObjectIdClass)) {
                    throw new InvalidMetaDataException(LOCALISER, "044085", (Object)this.name, this.persistenceCapableSuperclass);
                }
                NucleusLogger.METADATA.warn(LOCALISER.msg("044086", (Object)this.name, (Object)this.persistenceCapableSuperclass));
            } else {
                this.objectidClass = this.pcSuperclassMetaData.getObjectidClass();
            }
            if (this.identityType == null) {
                this.identityType = this.pcSuperclassMetaData.getIdentityType();
            }
            if (!this.identityType.equals(this.pcSuperclassMetaData.getIdentityType())) {
                throw new InvalidMetaDataException(LOCALISER, "044093", (Object)this.fullName);
            }
        }
    }

    protected AbstractMemberMetaData newDefaultedProperty(String name) {
        return new PropertyMetaData((MetaData)this, name);
    }

    protected void validateUserInputForInheritanceMetaData() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            AbstractClassMetaData superCmd = AbstractClassMetaData.getClassManagingTableForClass(this);
            if (superCmd == null) {
                throw new InvalidMetaDataException(LOCALISER, "044099", (Object)this.fullName);
            }
            DiscriminatorMetaData superDismd = superCmd.getInheritanceMetaData().getDiscriminatorMetaData();
            if (superDismd == null) {
                throw new InvalidMetaDataException(LOCALISER, "044100", (Object)this.fullName, superCmd.fullName);
            }
            DiscriminatorMetaData dismd = this.inheritanceMetaData.getDiscriminatorMetaData();
            if (superDismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP && (dismd == null || dismd.getValue() == null)) {
                throw new InvalidMetaDataException(LOCALISER, "044102", (Object)this.fullName, (Object)superCmd.fullName, superDismd.getColumnName());
            }
        }
    }

    protected void validateUnmappedColumns() {
        if (this.unmappedColumns != null && this.unmappedColumns.size() > 0) {
            for (ColumnMetaData colmd : this.unmappedColumns) {
                if (colmd.getName() == null) {
                    throw new InvalidMetaDataException(LOCALISER, "044119", (Object)this.getFullClassName());
                }
                if (colmd.getJdbcType() != null) continue;
                throw new InvalidMetaDataException(LOCALISER, "044120", (Object)colmd.getName(), this.getFullClassName());
            }
        }
    }

    private static AbstractClassMetaData getClassManagingTableForClass(AbstractClassMetaData cmd) {
        if (cmd == null) {
            return null;
        }
        InheritanceMetaData imd = cmd.getInheritanceMetaData();
        if (imd == null) {
            return cmd;
        }
        if (imd.getStrategy() == InheritanceStrategy.NEW_TABLE) {
            return cmd;
        }
        if (imd.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return AbstractClassMetaData.getClassManagingTableForClass(cmd.getSuperAbstractClassMetaData());
        }
        return null;
    }

    public AbstractClassMetaData getSuperAbstractClassMetaData() {
        return this.pcSuperclassMetaData;
    }

    protected void determineObjectIdClass(MetaDataManager mmgr) {
        int no_of_pk_fields;
        ApiAdapter api = mmgr.getApiAdapter();
        if (this.objectidClass == null && this.persistenceCapableSuperclass == null && this.identityType == IdentityType.APPLICATION) {
            no_of_pk_fields = 0;
            AbstractMemberMetaData fmd_pk = null;
            for (AbstractMemberMetaData fmd : this.members) {
                if (!fmd.isPrimaryKey()) continue;
                fmd_pk = fmd;
                ++no_of_pk_fields;
            }
            if (no_of_pk_fields > 1 || no_of_pk_fields == 0) {
                NucleusLogger.METADATA.error(LOCALISER.msg("044065", (Object)this.fullName, (Object)("" + no_of_pk_fields)));
                throw new InvalidMetaDataException(LOCALISER, "044065", (Object)this.fullName, "" + no_of_pk_fields);
            }
            Class pk_type = fmd_pk.getType();
            if (Byte.class.isAssignableFrom(pk_type) || Byte.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = api.getSingleFieldIdentityClassNameForByte();
            } else if (Character.class.isAssignableFrom(pk_type) || Character.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = api.getSingleFieldIdentityClassNameForChar();
            } else if (Integer.class.isAssignableFrom(pk_type) || Integer.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = api.getSingleFieldIdentityClassNameForInt();
            } else if (Long.class.isAssignableFrom(pk_type) || Long.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = api.getSingleFieldIdentityClassNameForLong();
            } else if (Short.class.isAssignableFrom(pk_type) || Short.TYPE.isAssignableFrom(pk_type)) {
                this.objectidClass = api.getSingleFieldIdentityClassNameForShort();
            } else if (String.class.isAssignableFrom(pk_type)) {
                this.objectidClass = api.getSingleFieldIdentityClassNameForString();
            } else if (Object.class.isAssignableFrom(pk_type)) {
                this.objectidClass = api.getSingleFieldIdentityClassNameForObject();
            } else {
                NucleusLogger.METADATA.error(LOCALISER.msg("044066", (Object)this.fullName, (Object)pk_type.getName()));
                throw new InvalidMetaDataException(LOCALISER, "044066", (Object)this.fullName, pk_type.getName());
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(LOCALISER.msg("044064", (Object)this.fullName, (Object)this.objectidClass));
            }
        }
        if ((no_of_pk_fields = this.getNoOfPopulatedPKMembers()) == 0 && this.identityType == IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "044077", (Object)this.fullName, this.objectidClass);
        }
    }

    protected void validateObjectIdClass(ClassLoaderResolver clr, MetaDataManager mmgr) {
        if (this.objectidClass != null && this.getPersistenceCapableSuperclass() == null) {
            int no_of_pk_fields = this.getNoOfPopulatedPKMembers();
            ApiAdapter api = mmgr.getApiAdapter();
            Class obj_cls = null;
            try {
                obj_cls = clr.classForName(this.objectidClass);
            }
            catch (ClassNotResolvedException cnre) {
                throw new InvalidMetaDataException(LOCALISER, "044079", (Object)this.fullName, this.objectidClass);
            }
            boolean validated = false;
            HashSet<NucleusException> errors = new HashSet<NucleusException>();
            try {
                if (api.isValidPrimaryKeyClass(obj_cls, this, clr, no_of_pk_fields, mmgr)) {
                    validated = true;
                }
            }
            catch (NucleusException ex) {
                errors.add(ex);
            }
            if (!validated) {
                throw new NucleusUserException(LOCALISER_API.msg("019016", (Object)obj_cls.getName()), errors.toArray(new Throwable[errors.size()]));
            }
        }
    }

    public abstract void populate(ClassLoaderResolver var1, ClassLoader var2, MetaDataManager var3);

    public abstract void initialise(ClassLoaderResolver var1, MetaDataManager var2);

    protected void initialiseMemberPositionInformation(MetaDataManager mmgr) {
        AbstractMemberMetaData mmd;
        int i;
        this.memberCount = this.noOfInheritedManagedMembers + this.managedMembers.length;
        this.dfgMemberFlags = new boolean[this.memberCount];
        this.scoMutableMemberFlags = new boolean[this.memberCount];
        this.nonPkMemberFlags = new boolean[this.memberCount];
        int pk_field_count = 0;
        int dfg_field_count = 0;
        int scm_field_count = 0;
        for (i = 0; i < this.memberCount; ++i) {
            AbstractMemberMetaData mmd2 = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
            if (mmd2.isPrimaryKey()) {
                ++pk_field_count;
            } else {
                this.nonPkMemberFlags[i] = true;
            }
            if (mmd2.isDefaultFetchGroup()) {
                this.dfgMemberFlags[i] = true;
                ++dfg_field_count;
            }
            if (!mmd2.calcIsSecondClassMutable(mmgr)) continue;
            this.scoMutableMemberFlags[i] = true;
            ++scm_field_count;
        }
        if (pk_field_count > 0 && this.identityType != IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "044078", (Object)this.fullName, (Object)new Integer(pk_field_count), this.identityType);
        }
        if (pk_field_count > 0) {
            this.pkMemberPositions = new int[pk_field_count];
            int pk_num = 0;
            for (i = 0; i < this.memberCount; ++i) {
                mmd = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
                if (!mmd.isPrimaryKey()) continue;
                this.pkMemberPositions[pk_num++] = i;
            }
        } else if (pk_field_count == 0 && this.identityType == IdentityType.APPLICATION) {
            throw new InvalidMetaDataException(LOCALISER, "044077", (Object)this.fullName, this.objectidClass);
        }
        this.nonPkMemberPositions = new int[this.memberCount - pk_field_count];
        int npkf = 0;
        for (i = 0; i < this.memberCount; ++i) {
            mmd = this.getMetaDataForManagedMemberAtAbsolutePositionInternal(i);
            if (mmd.isPrimaryKey()) continue;
            this.nonPkMemberPositions[npkf++] = i;
        }
        this.dfgMemberPositions = new int[dfg_field_count];
        this.scoMutableMemberPositions = new int[scm_field_count];
        int dfg_num = 0;
        int scm_num = 0;
        for (i = 0; i < this.memberCount; ++i) {
            if (this.dfgMemberFlags[i]) {
                this.dfgMemberPositions[dfg_num++] = i;
            }
            if (!this.scoMutableMemberFlags[i]) continue;
            this.scoMutableMemberPositions[scm_num++] = i;
        }
    }

    protected void determineInheritanceMetaData(MetaDataManager mmgr) {
        if (this.inheritanceMetaData == null) {
            if (this.pcSuperclassMetaData != null) {
                AbstractClassMetaData baseCmd = this.getBaseAbstractClassMetaData();
                if (baseCmd.getInheritanceMetaData() != null && baseCmd.getInheritanceMetaData().getStrategyForTree() != null) {
                    String treeStrategy = this.getBaseInheritanceStrategy();
                    if (treeStrategy.equals("JOINED")) {
                        this.inheritanceMetaData = new InheritanceMetaData();
                        this.inheritanceMetaData.setStrategy(InheritanceStrategy.NEW_TABLE);
                        return;
                    }
                    if (treeStrategy.equals("SINGLE_TABLE")) {
                        this.inheritanceMetaData = new InheritanceMetaData();
                        this.inheritanceMetaData.setStrategy(InheritanceStrategy.SUPERCLASS_TABLE);
                        return;
                    }
                    if (treeStrategy.equals("TABLE_PER_CLASS")) {
                        this.inheritanceMetaData = new InheritanceMetaData();
                        this.inheritanceMetaData.setStrategy(InheritanceStrategy.COMPLETE_TABLE);
                        return;
                    }
                }
                if (baseCmd.getInheritanceMetaData() != null && baseCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                    this.inheritanceMetaData = new InheritanceMetaData();
                    this.inheritanceMetaData.setStrategy(InheritanceStrategy.COMPLETE_TABLE);
                } else if (this.pcSuperclassMetaData.getInheritanceMetaData() != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    this.inheritanceMetaData = new InheritanceMetaData();
                    this.inheritanceMetaData.setStrategy(InheritanceStrategy.NEW_TABLE);
                } else if (mmgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.defaultInheritanceStrategy").equalsIgnoreCase("TABLE_PER_CLASS")) {
                    this.inheritanceMetaData = new InheritanceMetaData();
                    this.inheritanceMetaData.setStrategy(InheritanceStrategy.NEW_TABLE);
                } else {
                    this.inheritanceMetaData = new InheritanceMetaData();
                    this.inheritanceMetaData.setStrategy(InheritanceStrategy.SUPERCLASS_TABLE);
                }
            } else {
                this.inheritanceMetaData = new InheritanceMetaData();
                this.inheritanceMetaData.setStrategy(InheritanceStrategy.NEW_TABLE);
            }
            return;
        }
        if (this.inheritanceMetaData.getStrategy() == null) {
            if (this.inheritanceMetaData.getStrategyForTree() != null) {
                String treeStrategy = this.inheritanceMetaData.getStrategyForTree();
                if (treeStrategy.equalsIgnoreCase("SINGLE_TABLE")) {
                    this.inheritanceMetaData.strategy = InheritanceStrategy.NEW_TABLE;
                } else if (treeStrategy.equalsIgnoreCase("TABLE_PER_CLASS")) {
                    this.inheritanceMetaData.strategy = InheritanceStrategy.COMPLETE_TABLE;
                } else if (treeStrategy.equalsIgnoreCase("JOINED")) {
                    this.inheritanceMetaData.strategy = InheritanceStrategy.SUPERCLASS_TABLE;
                }
                return;
            }
            if (this.pcSuperclassMetaData != null) {
                String treeStrategy = this.getBaseInheritanceStrategy();
                InheritanceStrategy baseStrategy = null;
                if (treeStrategy != null && treeStrategy.equalsIgnoreCase("SINGLE_TABLE")) {
                    baseStrategy = InheritanceStrategy.SUPERCLASS_TABLE;
                } else if (treeStrategy != null && treeStrategy.equalsIgnoreCase("TABLE_PER_CLASS")) {
                    baseStrategy = InheritanceStrategy.COMPLETE_TABLE;
                } else if (treeStrategy != null && treeStrategy.equalsIgnoreCase("JOINED")) {
                    baseStrategy = InheritanceStrategy.NEW_TABLE;
                } else {
                    AbstractClassMetaData baseCmd = this.getBaseAbstractClassMetaData();
                    if (baseCmd.getInheritanceMetaData() != null) {
                        baseStrategy = baseCmd.getInheritanceMetaData().getStrategy();
                    }
                }
                this.inheritanceMetaData.strategy = baseStrategy == InheritanceStrategy.COMPLETE_TABLE ? InheritanceStrategy.COMPLETE_TABLE : (this.pcSuperclassMetaData.getInheritanceMetaData() != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE ? InheritanceStrategy.NEW_TABLE : (mmgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.defaultInheritanceStrategy").equalsIgnoreCase("TABLE_PER_CLASS") ? InheritanceStrategy.NEW_TABLE : InheritanceStrategy.SUPERCLASS_TABLE));
            } else {
                this.inheritanceMetaData.strategy = InheritanceStrategy.NEW_TABLE;
            }
        }
    }

    protected void applyDefaultDiscriminatorValueWhenNotSpecified() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            AbstractClassMetaData superCmd = AbstractClassMetaData.getClassManagingTableForClass(this);
            if (superCmd == null) {
                throw new NucleusUserException("Class " + this.getFullClassName() + " is defined as having \"superclass-table\" inheritance and there is no known superclass with its own table. Duhhhhhhh");
            }
            if (superCmd.getInheritanceMetaData() != null) {
                DiscriminatorMetaData superDismd = superCmd.getInheritanceMetaData().getDiscriminatorMetaData();
                DiscriminatorMetaData dismd = this.inheritanceMetaData.getDiscriminatorMetaData();
                if (superDismd != null && superDismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP && (dismd == null || dismd.getValue() == null)) {
                    if (dismd == null) {
                        dismd = this.inheritanceMetaData.newDiscriminatorMetadata();
                    }
                    if (NucleusLogger.METADATA.isDebugEnabled()) {
                        NucleusLogger.METADATA.debug("No discriminator value specified for " + this.getFullClassName() + " so using fully-qualified class name");
                    }
                    dismd.setValue(this.getFullClassName());
                }
            }
        }
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, ClassLoaderResolver clr, MetaDataManager mmgr) {
        HashMap viewReferences = new HashMap();
        this.getReferencedClassMetaData(orderedCMDs, referencedCMDs, viewReferences, clr, mmgr);
    }

    private void getReferencedClassMetaData(final List orderedCMDs, final Set referencedCMDs, final Map viewReferences, final ClassLoaderResolver clr, final MetaDataManager mmgr) {
        if (!referencedCMDs.contains(this)) {
            String viewDefStr;
            AbstractClassMetaData id_cmd;
            referencedCMDs.add(this);
            for (int i = 0; i < this.managedMembers.length; ++i) {
                AbstractMemberMetaData mmd = this.managedMembers[i];
                mmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr, mmgr);
            }
            if (this.persistenceCapableSuperclass != null) {
                AbstractClassMetaData super_cmd = this.getSuperAbstractClassMetaData();
                super_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr, mmgr);
            }
            if (this.objectidClass != null && (id_cmd = mmgr.getMetaDataForClass(this.objectidClass, clr)) != null) {
                id_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr, mmgr);
            }
            if ((viewDefStr = this.getValueForExtension("view-definition")) != null) {
                MacroString viewDef = new MacroString(this.fullName, this.getValueForExtension("view-imports"), viewDefStr);
                viewDef.substituteMacros(new MacroString.MacroHandler(){

                    public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                        if (!AbstractClassMetaData.this.getFullClassName().equals(im.className)) {
                            AbstractClassMetaData.this.addViewReference(viewReferences, im.className);
                            AbstractClassMetaData view_cmd = mmgr.getMetaDataForClass(im.className, clr);
                            view_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, viewReferences, clr, mmgr);
                        }
                    }

                    public void onParameterMacro(MacroString.ParameterMacro pm) {
                        throw new NucleusUserException("Parameter macros not allowed in view definitions: " + pm);
                    }
                }, clr);
            }
            orderedCMDs.add(this);
        }
    }

    private void addViewReference(Map viewReferences, String referenced_name) {
        if (this.fullName.equals(referenced_name)) {
            HashSet<String> referencedSet = (HashSet<String>)viewReferences.get(referenced_name);
            if (referencedSet == null) {
                referencedSet = new HashSet<String>();
                viewReferences.put(this.fullName, referencedSet);
            }
            referencedSet.add(referenced_name);
            ViewUtils.checkForCircularViewReferences(viewReferences, this.fullName, referenced_name, null);
        }
    }

    public int getNoOfQueries() {
        return this.queries.size();
    }

    public QueryMetaData[] getQueries() {
        return this.queries == null ? null : this.queries.toArray(new QueryMetaData[this.queries.size()]);
    }

    public QueryResultMetaData[] getQueryResultMetaData() {
        if (this.queryResultMetaData == null) {
            return null;
        }
        return this.queryResultMetaData.toArray(new QueryResultMetaData[this.queryResultMetaData.size()]);
    }

    public final VersionMetaData getVersionMetaData() {
        return this.versionMetaData;
    }

    public final boolean hasVersionStrategy() {
        return this.versionMetaData != null && this.versionMetaData.getVersionStrategy() != null && this.versionMetaData.getVersionStrategy() != VersionStrategy.NONE;
    }

    public final VersionMetaData getVersionMetaDataForTable() {
        VersionMetaData vermd;
        if (this.pcSuperclassMetaData != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE && (vermd = this.pcSuperclassMetaData.getVersionMetaDataForTable()) != null) {
            return vermd;
        }
        return this.versionMetaData;
    }

    public final DiscriminatorMetaData getDiscriminatorMetaDataForTable() {
        DiscriminatorMetaData superDismd;
        if (this.pcSuperclassMetaData != null && this.pcSuperclassMetaData.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE && (superDismd = this.pcSuperclassMetaData.getDiscriminatorMetaDataForTable()) != null) {
            return superDismd;
        }
        return this.inheritanceMetaData != null ? this.inheritanceMetaData.getDiscriminatorMetaData() : null;
    }

    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getDiscriminatorMetaData() != null) {
            return this.inheritanceMetaData.getDiscriminatorMetaData();
        }
        if (this.getSuperAbstractClassMetaData() != null) {
            return this.getSuperAbstractClassMetaData().getDiscriminatorMetaData();
        }
        return null;
    }

    public final boolean hasDiscriminatorStrategy() {
        DiscriminatorStrategy strategy = this.getDiscriminatorStrategy();
        return strategy != null && strategy != DiscriminatorStrategy.NONE;
    }

    public final DiscriminatorStrategy getDiscriminatorStrategy() {
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getDiscriminatorMetaData() != null && this.inheritanceMetaData.getDiscriminatorMetaData().getStrategy() != null) {
            return this.inheritanceMetaData.getDiscriminatorMetaData().getStrategy();
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getDiscriminatorStrategy();
        }
        return null;
    }

    public final DiscriminatorStrategy getDiscriminatorStrategyForTable() {
        if (this.inheritanceMetaData == null) {
            return null;
        }
        if (this.inheritanceMetaData.getStrategy() == InheritanceStrategy.NEW_TABLE && this.inheritanceMetaData.getDiscriminatorMetaData() != null) {
            return this.inheritanceMetaData.getDiscriminatorMetaData().getStrategy();
        }
        if (this.getSuperAbstractClassMetaData() != null) {
            return this.getSuperAbstractClassMetaData().getDiscriminatorStrategy();
        }
        return null;
    }

    public final JoinMetaData[] getJoinMetaData() {
        return this.joinMetaData;
    }

    public final FetchGroupMetaData[] getFetchGroupMetaData() {
        return this.fetchGroupMetaData;
    }

    public FetchGroupMetaData[] getFetchGroupMetaData(Collection groupNames) {
        HashSet<FetchGroupMetaData> results = new HashSet<FetchGroupMetaData>();
        for (String groupname : groupNames) {
            FetchGroupMetaData fgmd = this.getFetchGroupMetaData(groupname);
            if (fgmd == null) continue;
            results.add(fgmd);
        }
        FetchGroupMetaData[] result = new FetchGroupMetaData[results.size()];
        results.toArray(result);
        return result;
    }

    public FetchGroupMetaData getFetchGroupMetaData(String groupname) {
        FetchGroupMetaData fgmd = this.fetchGroupMetaDataByName.get(groupname);
        if (fgmd == null && this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getFetchGroupMetaData(groupname);
        }
        return fgmd;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(IdentityType type) {
        if (this.isPopulated() || this.isInitialised()) {
            throw new NucleusUserException("Already populated/initialised");
        }
        this.identityType = type;
    }

    public final IndexMetaData[] getIndexMetaData() {
        return this.indexMetaData;
    }

    public final ForeignKeyMetaData[] getForeignKeyMetaData() {
        return this.foreignKeyMetaData;
    }

    public final UniqueMetaData[] getUniqueMetaData() {
        return this.uniqueMetaData;
    }

    public final List getUnmappedColumns() {
        return this.unmappedColumns;
    }

    public String getName() {
        return this.name;
    }

    public String getFullClassName() {
        return this.fullName;
    }

    public String getObjectidClass() {
        return this.objectidClass;
    }

    public AbstractClassMetaData setObjectIdClass(String objectidClass) {
        this.objectidClass = StringUtils.isWhitespace(objectidClass) ? this.objectidClass : objectidClass;
        return this;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public AbstractClassMetaData setEntityName(String name) {
        this.entityName = StringUtils.isWhitespace(name) ? this.entityName : name;
        return this;
    }

    public String getCatalog() {
        if (this.catalog == null) {
            return ((PackageMetaData)this.parent).getCatalog();
        }
        return this.catalog;
    }

    public AbstractClassMetaData setCatalog(String catalog) {
        this.catalog = StringUtils.isWhitespace(catalog) ? this.catalog : catalog;
        return this;
    }

    public String getSchema() {
        if (this.schema == null) {
            return ((PackageMetaData)this.parent).getSchema();
        }
        return this.schema;
    }

    public AbstractClassMetaData setSchema(String schema) {
        this.schema = StringUtils.isWhitespace(schema) ? this.schema : schema;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public AbstractClassMetaData setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? this.table : table;
        return this;
    }

    public boolean isRequiresExtent() {
        return this.requiresExtent;
    }

    public AbstractClassMetaData setRequiresExtent(boolean flag) {
        this.requiresExtent = flag;
        return this;
    }

    public AbstractClassMetaData setRequiresExtent(String flag) {
        if (!StringUtils.isWhitespace(flag)) {
            this.requiresExtent = Boolean.parseBoolean(flag);
        }
        return this;
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public AbstractClassMetaData setDetachable(boolean flag) {
        this.detachable = flag;
        return this;
    }

    public AbstractClassMetaData setDetachable(String flag) {
        if (!StringUtils.isWhitespace(flag)) {
            this.detachable = Boolean.parseBoolean(flag);
        }
        return this;
    }

    public boolean isCacheable() {
        if (this.hasExtension("cacheable")) {
            return !this.getValueForExtension("cacheable").equalsIgnoreCase("false");
        }
        return this.cacheable;
    }

    public AbstractClassMetaData setCacheable(boolean cache) {
        this.cacheable = cache;
        return this;
    }

    public AbstractClassMetaData setCacheable(String cache) {
        if (!StringUtils.isWhitespace(cache)) {
            this.cacheable = Boolean.parseBoolean(cache);
        }
        return this;
    }

    public boolean isEmbeddedOnly() {
        return this.embeddedOnly;
    }

    public AbstractClassMetaData setEmbeddedOnly(boolean flag) {
        this.embeddedOnly = flag;
        return this;
    }

    public AbstractClassMetaData setEmbeddedOnly(String flag) {
        if (!StringUtils.isWhitespace(flag)) {
            this.embeddedOnly = Boolean.parseBoolean(flag);
        }
        return this;
    }

    public final IdentityMetaData getIdentityMetaData() {
        return this.identityMetaData;
    }

    public final IdentityMetaData getBaseIdentityMetaData() {
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getBaseIdentityMetaData();
        }
        return this.identityMetaData;
    }

    public final InheritanceMetaData getInheritanceMetaData() {
        return this.inheritanceMetaData;
    }

    public final PrimaryKeyMetaData getPrimaryKeyMetaData() {
        return this.primaryKeyMetaData;
    }

    public PackageMetaData getPackageMetaData() {
        if (this.parent != null) {
            return (PackageMetaData)this.parent;
        }
        return null;
    }

    public String getPackageName() {
        return this.getPackageMetaData().getName();
    }

    public int getNoOfMembers() {
        return this.members.size();
    }

    public AbstractMemberMetaData getMetaDataForMemberAtRelativePosition(int index) {
        if (index < 0 || index >= this.members.size()) {
            return null;
        }
        return (AbstractMemberMetaData)this.members.get(index);
    }

    public ClassPersistenceModifier getPersistenceModifier() {
        return this.persistenceModifier;
    }

    public AbstractClassMetaData setPersistenceModifier(ClassPersistenceModifier modifier) {
        this.persistenceModifier = modifier;
        return this;
    }

    public String getPersistenceCapableSuperclass() {
        return this.persistenceCapableSuperclass;
    }

    public void setPersistenceCapableSuperclass(String pcSuperclassName) {
        this.persistenceCapableSuperclass = pcSuperclassName;
    }

    public boolean usesSingleFieldIdentityClass() {
        return this.usesSingleFieldIdentityClass;
    }

    public boolean isMetaDataComplete() {
        return this.metaDataComplete;
    }

    public boolean isSerializeRead() {
        return this.serializeRead;
    }

    public boolean isSameOrAncestorOf(AbstractClassMetaData cmd) {
        this.checkInitialised();
        if (cmd == null) {
            return false;
        }
        if (this.fullName.equals(cmd.fullName)) {
            return true;
        }
        for (AbstractClassMetaData parent = cmd.getSuperAbstractClassMetaData(); parent != null; parent = parent.getSuperAbstractClassMetaData()) {
            if (!this.fullName.equals(parent.fullName)) continue;
            return true;
        }
        return false;
    }

    public String[] getPrimaryKeyMemberNames() {
        if (this.identityType != IdentityType.APPLICATION) {
            return null;
        }
        ArrayList<String> memberNames = new ArrayList<String>();
        for (AbstractMemberMetaData mmd : this.members) {
            if (mmd.primaryKey != Boolean.TRUE) continue;
            memberNames.add(mmd.name);
        }
        if (memberNames.size() > 0) {
            return memberNames.toArray(new String[memberNames.size()]);
        }
        memberNames = null;
        return this.pcSuperclassMetaData.getPrimaryKeyMemberNames();
    }

    public boolean hasMember(String memberName) {
        for (AbstractMemberMetaData mmd : this.members) {
            if (!mmd.getName().equals(memberName)) continue;
            return true;
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.hasMember(memberName);
        }
        return false;
    }

    public AbstractMemberMetaData getMetaDataForMember(String name) {
        if (name == null) {
            return null;
        }
        for (AbstractMemberMetaData mmd : this.members) {
            if (!mmd.getName().equals(name)) continue;
            return mmd;
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getMetaDataForMember(name);
        }
        return null;
    }

    public int getNoOfManagedMembers() {
        if (this.managedMembers == null) {
            return 0;
        }
        return this.managedMembers.length;
    }

    public AbstractMemberMetaData[] getManagedMembers() {
        this.checkInitialised();
        return this.managedMembers;
    }

    public AbstractMemberMetaData getMetaDataForManagedMemberAtPosition(int position) {
        this.checkInitialised();
        if (this.managedMembers == null) {
            return null;
        }
        if (position < 0 || position >= this.managedMembers.length) {
            return null;
        }
        return this.managedMembers[position];
    }

    public int getNoOfOverriddenMembers() {
        if (this.overriddenMembers == null) {
            return 0;
        }
        return this.overriddenMembers.length;
    }

    public AbstractMemberMetaData[] getOverriddenMembers() {
        this.checkInitialised();
        return this.overriddenMembers;
    }

    public AbstractMemberMetaData getOverriddenMember(int position) {
        this.checkInitialised();
        if (this.overriddenMembers == null) {
            return null;
        }
        if (position < 0 || position >= this.overriddenMembers.length) {
            return null;
        }
        return this.overriddenMembers[position];
    }

    public AbstractMemberMetaData getOverriddenMember(String name) {
        this.checkInitialised();
        if (this.overriddenMembers == null) {
            return null;
        }
        for (int i = 0; i < this.overriddenMembers.length; ++i) {
            if (!this.overriddenMembers[i].getName().equals(name)) continue;
            return this.overriddenMembers[i];
        }
        return null;
    }

    protected AbstractMemberMetaData getMemberBeingOverridden(String name) {
        for (AbstractMemberMetaData apmd : this.members) {
            if (!apmd.name.equals(name) || !apmd.fieldBelongsToClass()) continue;
            return apmd;
        }
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getMemberBeingOverridden(name);
        }
        return null;
    }

    public int getNoOfInheritedManagedMembers() {
        this.checkInitialised();
        return this.noOfInheritedManagedMembers;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public AbstractMemberMetaData getMetaDataForManagedMemberAtAbsolutePosition(int abs_position) {
        this.checkInitialised();
        return this.getMetaDataForManagedMemberAtAbsolutePositionInternal(abs_position);
    }

    protected AbstractMemberMetaData getMetaDataForManagedMemberAtAbsolutePositionInternal(int abs_position) {
        if (abs_position < this.noOfInheritedManagedMembers) {
            if (this.pcSuperclassMetaData == null) {
                return null;
            }
            AbstractMemberMetaData mmd = this.pcSuperclassMetaData.getMetaDataForManagedMemberAtAbsolutePositionInternal(abs_position);
            if (mmd != null) {
                for (int i = 0; i < this.overriddenMembers.length; ++i) {
                    if (!this.overriddenMembers[i].getName().equals(mmd.getName()) || !this.overriddenMembers[i].getClassName().equals(mmd.getClassName())) continue;
                    return this.overriddenMembers[i];
                }
                return mmd;
            }
            return null;
        }
        if (abs_position - this.noOfInheritedManagedMembers >= this.managedMembers.length) {
            return null;
        }
        return this.managedMembers[abs_position - this.noOfInheritedManagedMembers];
    }

    public int getAbsoluteMemberPositionForRelativePosition(int relativePosition) {
        return this.noOfInheritedManagedMembers + relativePosition;
    }

    public int getRelativePositionOfMember(String memberName) {
        this.checkInitialised();
        if (memberName == null) {
            return -1;
        }
        Integer i = this.memberPositionsByName.get(memberName);
        return i == null ? -1 : i;
    }

    public int getAbsolutePositionOfMember(String memberName) {
        this.checkInitialised();
        if (memberName == null) {
            return -1;
        }
        int i = this.getRelativePositionOfMember(memberName);
        if (i < 0) {
            if (this.pcSuperclassMetaData != null) {
                i = this.pcSuperclassMetaData.getAbsolutePositionOfMember(memberName);
            }
        } else {
            i += this.noOfInheritedManagedMembers;
        }
        return i;
    }

    public int getAbsolutePositionOfMember(String className, String memberName) {
        this.checkInitialised();
        if (memberName == null) {
            return -1;
        }
        int i = -1;
        if (className.equals(this.getFullClassName())) {
            i = this.getRelativePositionOfMember(memberName);
        }
        if (i < 0) {
            if (this.pcSuperclassMetaData != null) {
                i = this.pcSuperclassMetaData.getAbsolutePositionOfMember(className, memberName);
            }
        } else {
            i += this.noOfInheritedManagedMembers;
        }
        return i;
    }

    private int getNoOfPopulatedPKMembers() {
        if (this.pcSuperclassMetaData != null) {
            return this.pcSuperclassMetaData.getNoOfPopulatedPKMembers();
        }
        Iterator fields_iter = this.members.iterator();
        int noOfPks = 0;
        while (fields_iter.hasNext()) {
            AbstractMemberMetaData mmd = (AbstractMemberMetaData)fields_iter.next();
            if (!mmd.isPrimaryKey()) continue;
            ++noOfPks;
        }
        return noOfPks;
    }

    public int getNoOfPrimaryKeyMembers() {
        if (this.pkMemberPositions == null) {
            return 0;
        }
        return this.pkMemberPositions.length;
    }

    public int[] getAllMemberPositions() {
        this.checkInitialised();
        if (this.allMemberPositions == null) {
            this.allMemberPositions = new int[this.memberCount];
            for (int i = 0; i < this.memberCount; ++i) {
                this.allMemberPositions[i] = i;
            }
        }
        return this.allMemberPositions;
    }

    public int[] getPKMemberPositions() {
        this.checkInitialised();
        return this.pkMemberPositions;
    }

    public int[] getNonPKMemberPositions() {
        this.checkInitialised();
        return this.nonPkMemberPositions;
    }

    public boolean[] getNonPKMemberFlags() {
        this.checkInitialised();
        return this.nonPkMemberFlags;
    }

    public int[] getDFGMemberPositions() {
        this.checkInitialised();
        return this.dfgMemberPositions;
    }

    public boolean[] getDFGMemberFlags() {
        this.checkInitialised();
        return this.dfgMemberFlags;
    }

    public int[] getBasicMemberPositions(ClassLoaderResolver clr, MetaDataManager mmgr) {
        Iterator iter = this.members.iterator();
        int numBasics = 0;
        while (iter.hasNext()) {
            AbstractMemberMetaData mmd = (AbstractMemberMetaData)iter.next();
            if (mmd.getRelationType(clr) != 0 || mmd.isPersistentInterface(clr, mmgr) || Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType()) || mmd.getType().isArray()) continue;
            ++numBasics;
        }
        int[] inheritedBasicPositions = null;
        if (this.pcSuperclassMetaData != null) {
            inheritedBasicPositions = this.pcSuperclassMetaData.getBasicMemberPositions(clr, mmgr);
        }
        int[] basicPositions = new int[numBasics + (inheritedBasicPositions != null ? inheritedBasicPositions.length : 0)];
        int number = 0;
        if (inheritedBasicPositions != null) {
            for (int i = 0; i < inheritedBasicPositions.length; ++i) {
                basicPositions[number++] = inheritedBasicPositions[i];
            }
        }
        for (AbstractMemberMetaData mmd : this.members) {
            if (mmd.getRelationType(clr) != 0 || mmd.isPersistentInterface(clr, mmgr) || Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType()) || mmd.getType().isArray()) continue;
            basicPositions[number++] = mmd.getAbsoluteFieldNumber();
        }
        return basicPositions;
    }

    public int[] getMultivaluedMemberPositions() {
        Iterator iter = this.members.iterator();
        int numMultivalues = 0;
        while (iter.hasNext()) {
            AbstractMemberMetaData mmd = (AbstractMemberMetaData)iter.next();
            if (!mmd.getType().isArray() && !Collection.class.isAssignableFrom(mmd.getType()) && !Map.class.isAssignableFrom(mmd.getType())) continue;
            ++numMultivalues;
        }
        int[] inheritedMultivaluePositions = null;
        if (this.pcSuperclassMetaData != null) {
            inheritedMultivaluePositions = this.pcSuperclassMetaData.getMultivaluedMemberPositions();
        }
        int[] multivaluePositions = new int[numMultivalues + (inheritedMultivaluePositions != null ? inheritedMultivaluePositions.length : 0)];
        int number = 0;
        if (inheritedMultivaluePositions != null) {
            for (int i = 0; i < inheritedMultivaluePositions.length; ++i) {
                multivaluePositions[number++] = inheritedMultivaluePositions[i];
            }
        }
        for (AbstractMemberMetaData mmd : this.members) {
            if (!mmd.getType().isArray() && !Collection.class.isAssignableFrom(mmd.getType()) && !Map.class.isAssignableFrom(mmd.getType())) continue;
            multivaluePositions[number++] = mmd.getAbsoluteFieldNumber();
        }
        return multivaluePositions;
    }

    public int[] getSCOMutableMemberPositions() {
        this.checkInitialised();
        return this.scoMutableMemberPositions;
    }

    public int[] getSCONonContainerMemberPositions() {
        this.checkInitialised();
        if (this.scoNonContainerMemberPositions == null) {
            int numberNonContainerSCOFields = 0;
            for (int i = 0; i < this.scoMutableMemberPositions.length; ++i) {
                AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.scoMutableMemberPositions[i]);
                if (Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType())) continue;
                ++numberNonContainerSCOFields;
            }
            int[] noncontainerMemberPositions = new int[numberNonContainerSCOFields];
            int nonContNum = 0;
            for (int i = 0; i < this.scoMutableMemberPositions.length; ++i) {
                AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.scoMutableMemberPositions[i]);
                if (Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType())) continue;
                noncontainerMemberPositions[nonContNum++] = this.scoMutableMemberPositions[i];
            }
            this.scoNonContainerMemberPositions = noncontainerMemberPositions;
        }
        return this.scoNonContainerMemberPositions;
    }

    public int[] getSCOContainerMemberPositions() {
        this.checkInitialised();
        if (this.secondClassContainerMemberPositions == null) {
            int numberContainerSCOFields = 0;
            for (int i = 0; i < this.scoMutableMemberPositions.length; ++i) {
                AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.scoMutableMemberPositions[i]);
                if (!Collection.class.isAssignableFrom(mmd.getType()) && !Map.class.isAssignableFrom(mmd.getType())) continue;
                ++numberContainerSCOFields;
            }
            int[] containerMemberPositions = new int[numberContainerSCOFields];
            int contNum = 0;
            for (int i = 0; i < this.scoMutableMemberPositions.length; ++i) {
                AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.scoMutableMemberPositions[i]);
                if (!Collection.class.isAssignableFrom(mmd.getType()) && !Map.class.isAssignableFrom(mmd.getType())) continue;
                containerMemberPositions[contNum++] = this.scoMutableMemberPositions[i];
            }
            this.secondClassContainerMemberPositions = containerMemberPositions;
        }
        return this.secondClassContainerMemberPositions;
    }

    public boolean[] getSCOMutableMemberFlags() {
        this.checkInitialised();
        return this.scoMutableMemberFlags;
    }

    public boolean hasRelations(ClassLoaderResolver clr, MetaDataManager mmgr) {
        return this.getRelationMemberPositions(clr, mmgr).length > 0;
    }

    public int[] getRelationMemberPositions(ClassLoaderResolver clr, MetaDataManager mmgr) {
        if (this.relationPositions == null) {
            int i;
            int numRelationsSuperclass;
            int[] superclassRelationPositions = null;
            if (this.pcSuperclassMetaData != null) {
                superclassRelationPositions = this.pcSuperclassMetaData.getRelationMemberPositions(clr, mmgr);
            }
            int numRelations = numRelationsSuperclass = superclassRelationPositions != null ? superclassRelationPositions.length : 0;
            for (int i2 = 0; i2 < this.managedMembers.length; ++i2) {
                if (this.managedMembers[i2].getRelationType(clr) == 0 && !this.managedMembers[i2].isPersistentInterface(clr, mmgr)) continue;
                ++numRelations;
            }
            this.relationPositions = new int[numRelations];
            int num = 0;
            if (numRelationsSuperclass > 0) {
                for (i = 0; i < superclassRelationPositions.length; ++i) {
                    this.relationPositions[num++] = superclassRelationPositions[i];
                }
            }
            if (numRelations > numRelationsSuperclass) {
                for (i = 0; i < this.managedMembers.length; ++i) {
                    if (this.managedMembers[i].getRelationType(clr) == 0 && !this.managedMembers[i].isPersistentInterface(clr, mmgr)) continue;
                    this.relationPositions[num++] = this.managedMembers[i].getAbsoluteFieldNumber();
                }
            }
        }
        return this.relationPositions;
    }

    public int[] getBidirectionalRelationMemberPositions(ClassLoaderResolver clr, MetaDataManager mmgr) {
        if (this.relationPositions == null) {
            this.getRelationMemberPositions(clr, mmgr);
        }
        int numBidirs = 0;
        for (int i = 0; i < this.relationPositions.length; ++i) {
            AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.relationPositions[i]);
            int relationType = mmd.getRelationType(clr);
            if (relationType != 2 && relationType != 4 && relationType != 6 && relationType != 5) continue;
            ++numBidirs;
        }
        int[] bidirRelations = new int[numBidirs];
        numBidirs = 0;
        for (int i = 0; i < this.relationPositions.length; ++i) {
            AbstractMemberMetaData mmd = this.getMetaDataForManagedMemberAtAbsolutePosition(this.relationPositions[i]);
            int relationType = mmd.getRelationType(clr);
            if (relationType != 2 && relationType != 4 && relationType != 6 && relationType != 5) continue;
            bidirRelations[numBidirs] = mmd.getAbsoluteFieldNumber();
        }
        return bidirRelations;
    }

    public void setSerializeRead(boolean serialise) {
        this.serializeRead = serialise;
    }

    public void setMetaDataComplete() {
        this.metaDataComplete = true;
    }

    public void addQuery(QueryMetaData qmd) {
        if (qmd == null) {
            return;
        }
        if (this.queries == null) {
            this.queries = new HashSet<QueryMetaData>();
        }
        this.queries.add(qmd);
        qmd.parent = this;
    }

    public QueryMetaData newQueryMetadata(String queryName) {
        QueryMetaData qmd = new QueryMetaData(queryName);
        this.addQuery(qmd);
        return qmd;
    }

    public void addQueryResultMetaData(QueryResultMetaData resultMetaData) {
        if (this.queryResultMetaData == null) {
            this.queryResultMetaData = new HashSet<QueryResultMetaData>();
        }
        if (!this.queryResultMetaData.contains(resultMetaData)) {
            this.queryResultMetaData.add(resultMetaData);
            resultMetaData.parent = this;
        }
    }

    public void addIndex(IndexMetaData idxmd) {
        if (idxmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        this.indexes.add(idxmd);
        idxmd.parent = this;
    }

    public IndexMetaData newIndexMetadata() {
        IndexMetaData idxmd = new IndexMetaData();
        this.addIndex(idxmd);
        return idxmd;
    }

    public void addForeignKey(ForeignKeyMetaData fkmd) {
        if (fkmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        this.foreignKeys.add(fkmd);
        fkmd.parent = this;
    }

    public ForeignKeyMetaData newForeignKeyMetadata() {
        ForeignKeyMetaData fkmd = new ForeignKeyMetaData();
        this.addForeignKey(fkmd);
        return fkmd;
    }

    public void addUniqueConstraint(UniqueMetaData unimd) {
        if (unimd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        this.uniqueConstraints.add(unimd);
        unimd.parent = this;
    }

    public UniqueMetaData newUniqueMetadata() {
        UniqueMetaData unimd = new UniqueMetaData();
        this.addUniqueConstraint(unimd);
        return unimd;
    }

    public final void addUnmappedColumn(ColumnMetaData colmd) {
        if (this.unmappedColumns == null) {
            this.unmappedColumns = new ArrayList<ColumnMetaData>();
        }
        this.unmappedColumns.add(colmd);
        colmd.parent = this;
    }

    public ColumnMetaData newUnmappedColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        this.addUnmappedColumn(colmd);
        return colmd;
    }

    public FieldMetaData newFieldMetadata(String fieldName) {
        FieldMetaData fmd = new FieldMetaData((MetaData)this, fieldName);
        this.addMember(fmd);
        return fmd;
    }

    public PropertyMetaData newPropertyMetadata(String propName) {
        PropertyMetaData pmd = new PropertyMetaData((MetaData)this, propName);
        this.addMember(pmd);
        return pmd;
    }

    public void addMember(AbstractMemberMetaData mmd) {
        if (mmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("adding field/property " + mmd.getName() + " when already initialised!");
        }
        Iterator iter = this.members.iterator();
        while (iter.hasNext()) {
            AbstractMemberMetaData md = (AbstractMemberMetaData)iter.next();
            if (mmd.getName().equals(md.getName()) && (mmd instanceof PropertyMetaData && md instanceof PropertyMetaData || mmd instanceof FieldMetaData && md instanceof FieldMetaData)) {
                throw new NucleusUserException(LOCALISER.msg("044090", (Object)this.fullName, (Object)mmd.getName()));
            }
            String existingName = md.getName();
            boolean existingIsProperty = md instanceof PropertyMetaData;
            if (existingIsProperty && (existingName = ((PropertyMetaData)md).getFieldName()) == null) {
                existingName = md.getName();
            }
            String newName = mmd.getName();
            boolean newIsProperty = mmd instanceof PropertyMetaData;
            if (newIsProperty && (newName = ((PropertyMetaData)mmd).getFieldName()) == null) {
                newName = mmd.getName();
            }
            if (!existingName.equals(newName)) continue;
            if (existingIsProperty && newIsProperty) {
                throw new NucleusUserException(LOCALISER.msg("044090", (Object)this.fullName, (Object)mmd.getName()));
            }
            if (existingIsProperty && !newIsProperty) {
                NucleusLogger.METADATA.info("Ignoring metadata for field " + mmd.getFullFieldName() + " since we already have MetaData for the property " + md.getFullFieldName());
                return;
            }
            if (existingIsProperty || !newIsProperty) continue;
            NucleusLogger.METADATA.info("Ignoring existing metadata for field " + md.getFullFieldName() + " since now we have MetaData for the property " + mmd.getFullFieldName());
            iter.remove();
        }
        mmd.parent = this;
        this.members.add(mmd);
    }

    public void addFetchGroup(FetchGroupMetaData fgmd) {
        if (fgmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        this.fetchGroups.add(fgmd);
        fgmd.parent = this;
    }

    public FetchGroupMetaData newFetchGroupMetaData(String name) {
        FetchGroupMetaData fgmd = new FetchGroupMetaData(name);
        this.addFetchGroup(fgmd);
        return fgmd;
    }

    public void addJoin(JoinMetaData jnmd) {
        if (jnmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new NucleusUserException("Already initialised");
        }
        this.joins.add(jnmd);
        jnmd.parent = this;
    }

    public JoinMetaData newJoinMetaData() {
        JoinMetaData joinmd = new JoinMetaData();
        this.addJoin(joinmd);
        return joinmd;
    }

    public void addListener(EventListenerMetaData listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.parent = this;
        }
    }

    public EventListenerMetaData getListenerForClass(String className) {
        if (this.listeners == null) {
            return null;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            EventListenerMetaData elmd = (EventListenerMetaData)this.listeners.get(i);
            if (!elmd.getClassName().equals(className)) continue;
            return elmd;
        }
        return null;
    }

    public List getListeners() {
        return this.listeners;
    }

    public void excludeSuperClassListeners() {
        this.excludeSuperClassListeners = Boolean.TRUE;
    }

    public boolean isExcludeSuperClassListeners() {
        return this.excludeSuperClassListeners != null && this.excludeSuperClassListeners == Boolean.TRUE;
    }

    public void excludeDefaultListeners() {
        this.excludeDefaultListeners = Boolean.TRUE;
    }

    public boolean isExcludeDefaultListeners() {
        return this.excludeDefaultListeners != null && this.excludeDefaultListeners == Boolean.TRUE;
    }

    public final void setVersionMetaData(VersionMetaData versionMetaData) {
        this.versionMetaData = versionMetaData;
        if (this.versionMetaData != null) {
            this.versionMetaData.parent = this;
        }
    }

    public VersionMetaData newVersionMetadata() {
        VersionMetaData vermd = new VersionMetaData();
        this.setVersionMetaData(vermd);
        return vermd;
    }

    public final void setIdentityMetaData(IdentityMetaData identityMetaData) {
        this.identityMetaData = identityMetaData;
        if (this.identityMetaData != null) {
            this.identityMetaData.parent = this;
        }
        this.identitySpecified = true;
    }

    public IdentityMetaData newIdentityMetadata() {
        IdentityMetaData idmd = new IdentityMetaData();
        this.setIdentityMetaData(idmd);
        return idmd;
    }

    public final void setInheritanceMetaData(InheritanceMetaData inheritanceMetaData) {
        this.inheritanceMetaData = inheritanceMetaData;
        if (this.inheritanceMetaData != null) {
            this.inheritanceMetaData.parent = this;
        }
    }

    public InheritanceMetaData newInheritanceMetadata() {
        InheritanceMetaData inhmd = new InheritanceMetaData();
        this.setInheritanceMetaData(inhmd);
        return inhmd;
    }

    public final void setPrimaryKeyMetaData(PrimaryKeyMetaData primaryKeyMetaData) {
        this.primaryKeyMetaData = primaryKeyMetaData;
        if (this.primaryKeyMetaData != null) {
            this.primaryKeyMetaData.parent = this;
        }
    }

    public PrimaryKeyMetaData newPrimaryKeyMetadata() {
        PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
        this.setPrimaryKeyMetaData(pkmd);
        return pkmd;
    }

    public final boolean hasFetchGroupWithPostLoad() {
        if (this.fetchGroupMetaWithPostLoad == null) {
            this.fetchGroupMetaWithPostLoad = Boolean.FALSE;
            for (int i = 0; i < this.fetchGroupMetaData.length; ++i) {
                if (!this.fetchGroupMetaData[i].getPostLoad().booleanValue()) continue;
                this.fetchGroupMetaWithPostLoad = Boolean.TRUE;
                break;
            }
        }
        if (this.getSuperAbstractClassMetaData() != null) {
            return this.getSuperAbstractClassMetaData().hasFetchGroupWithPostLoad() || this.fetchGroupMetaWithPostLoad != false;
        }
        return this.fetchGroupMetaWithPostLoad;
    }

    MetaDataManager getMetaDataManager() {
        if (this.parent != null && this.parent.getParent() != null) {
            return this.getPackageMetaData().getFileMetaData().getMetaDataManager();
        }
        return null;
    }
}

