/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Collection;
import java.util.Map;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOContainer;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class AttachFieldManager
extends AbstractFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private final StateManager smAttached;
    private final boolean[] secondClassMutableFields;
    private final boolean[] fieldsToAttach;
    private final boolean persistent;
    private final boolean cascadeAttach;
    boolean copy = true;

    public AttachFieldManager(StateManager smAttached, boolean[] secondClassMutableFields, boolean[] fieldsToAttach, boolean persistent, boolean cascadeAttach, boolean copy) {
        this.smAttached = smAttached;
        this.secondClassMutableFields = secondClassMutableFields;
        this.fieldsToAttach = fieldsToAttach;
        this.persistent = persistent;
        this.cascadeAttach = cascadeAttach;
        this.copy = copy;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractClassMetaData cmd = this.smAttached.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.hasExtension("attach") && mmd.getValueForExtension("attach").equalsIgnoreCase("never")) {
            this.smAttached.replaceField(fieldNumber, null, true);
            return;
        }
        ApiAdapter api = this.smAttached.getObjectManager().getApiAdapter();
        if (value == null) {
            Object oldValue = null;
            if (mmd.isDependent() && this.persistent) {
                try {
                    this.smAttached.loadFieldFromDatastore(fieldNumber);
                }
                catch (Exception e) {
                    // empty catch block
                }
                oldValue = this.smAttached.provideField(fieldNumber);
            }
            if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
                this.smAttached.replaceField(fieldNumber, null, true);
                this.smAttached.makeDirty(fieldNumber);
            }
            if (mmd.isDependent() && !mmd.isEmbedded() && oldValue != null && value == null && api.isPersistable(oldValue)) {
                this.smAttached.flush();
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026026", oldValue, (Object)mmd.getFullFieldName()));
                this.smAttached.getObjectManager().deleteObjectInternal(oldValue);
            }
        } else if (this.secondClassMutableFields[fieldNumber]) {
            if (mmd.isSerialized()) {
                this.smAttached.replaceField(fieldNumber, value, true);
                this.smAttached.makeDirty(fieldNumber);
            } else {
                SCO sco;
                Object oldValue = this.smAttached.provideField(fieldNumber);
                if (oldValue == null && !this.smAttached.getLoadedFields()[fieldNumber] && this.persistent) {
                    this.smAttached.loadField(fieldNumber);
                    oldValue = this.smAttached.provideField(fieldNumber);
                }
                if (oldValue == null || oldValue != null && !(oldValue instanceof SCO)) {
                    if (NucleusLogger.JDO.isDebugEnabled()) {
                        NucleusLogger.JDO.debug(LOCALISER.msg("026029", (Object)StringUtils.toJVMIDString(this.smAttached.getObject()), this.smAttached.getInternalObjectId(), (Object)mmd.getName()));
                    }
                    if ((sco = SCOUtils.newSCOInstance(this.smAttached, mmd, mmd.getType(), null, null, false, false, false)) instanceof SCOContainer) {
                        ((SCOContainer)sco).load();
                    }
                    this.smAttached.replaceField(fieldNumber, sco, true);
                } else {
                    sco = (SCO)oldValue;
                }
                if (this.cascadeAttach) {
                    if (this.copy) {
                        sco.attachCopy(value);
                    } else if (sco instanceof Collection) {
                        SCOUtils.attachForCollection(this.smAttached, ((Collection)value).toArray(), SCOUtils.collectionHasElementsWithoutIdentity(mmd));
                    } else if (sco instanceof Map) {
                        SCOUtils.attachForMap(this.smAttached, ((Map)value).entrySet(), SCOUtils.mapHasKeysWithoutIdentity(mmd), SCOUtils.mapHasValuesWithoutIdentity(mmd));
                    } else {
                        sco.initialise(value, false, false);
                    }
                }
                if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
                    this.smAttached.makeDirty(fieldNumber);
                }
            }
        } else if (api.isPersistable(value)) {
            if (this.cascadeAttach) {
                boolean sco;
                boolean bl = sco = mmd.getEmbeddedMetaData() != null || mmd.isSerialized() || mmd.isEmbedded();
                if (this.copy) {
                    Object pcObj = this.smAttached.getObjectManager().attachObjectCopy(value, sco);
                    this.smAttached.replaceField(fieldNumber, pcObj, true);
                } else {
                    this.smAttached.getObjectManager().attachObject(value, sco);
                }
                if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
                    this.smAttached.makeDirty(fieldNumber);
                } else if (sco && value != null && this.smAttached.getObjectManager().getApiAdapter().isDirty(value)) {
                    this.smAttached.makeDirty(fieldNumber);
                }
            } else if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
                this.smAttached.makeDirty(fieldNumber);
            }
        } else if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            this.smAttached.replaceField(fieldNumber, value, true);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeBooleanField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeByteField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeCharField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeDoubleField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeFloatField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeIntField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeLongField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeShortField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (this.fieldsToAttach[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeStringField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }
}

