/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.sco.backed;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.sco.NullsNotAllowedException;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.sco.SCOCollectionIterator;
import org.datanucleus.sco.SCOMtoN;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.sco.queued.AddOperation;
import org.datanucleus.sco.queued.ClearOperation;
import org.datanucleus.sco.queued.QueuedOperation;
import org.datanucleus.sco.queued.RemoveOperation;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class TreeSet
extends java.util.TreeSet
implements SCOCollection,
SCOMtoN,
Cloneable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private transient StateManager ownerSM;
    private transient String fieldName;
    private transient int fieldNumber;
    private transient boolean allowNulls;
    protected CollectionStore backingStore;
    protected java.util.TreeSet delegate;
    protected boolean useCache = true;
    protected boolean isCacheLoaded = false;
    boolean queued = false;
    private ArrayList queuedOperations = null;

    public TreeSet(StateManager ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.fieldName = fieldName;
        this.allowNulls = false;
        if (ownerSM == null) {
            this.delegate = new java.util.TreeSet();
        }
        if (ownerSM != null) {
            Comparator comparator;
            AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
            this.fieldNumber = fmd.getAbsoluteFieldNumber();
            this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, fmd);
            this.queued = SCOUtils.useContainerQueueing(ownerSM);
            this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName);
            if (!SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                try {
                    ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
                    this.backingStore = (CollectionStore)ownerSM.getStoreManager().getBackingStoreForField(clr, fmd, java.util.TreeSet.class);
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
            }
            this.delegate = (comparator = SCOUtils.getComparator(fmd, ownerSM.getObjectManager().getClassLoaderResolver())) != null ? new java.util.TreeSet(comparator) : new java.util.TreeSet();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, fieldName, this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, fieldName)));
            }
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
            if (SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getCollection().elementIsPersistent()) {
                ObjectManager om = this.ownerSM.getObjectManager();
                for (Object pc : c) {
                    StateManager objSM = om.findStateManager(pc);
                    if (objSM != null) continue;
                    objSM = StateManagerFactory.newStateManagerForEmbedded(om, pc, false);
                    objSM.addEmbeddedOwner(this.ownerSM, this.fieldNumber);
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.addAll(c);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.clear();
                this.addAll(c);
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.delegate.clear();
                this.delegate.addAll(c);
            }
        }
    }

    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.fieldName)) {
            this.loadFromStore();
        }
    }

    public Object getValue() {
        this.loadFromStore();
        return this.delegate;
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName));
            }
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    public void flush() {
        if (this.queued && this.queuedOperations != null) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023005", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName));
            }
            for (QueuedOperation op : this.queuedOperations) {
                op.perform(this.backingStore, this.ownerSM);
            }
            this.queuedOperations.clear();
            this.queuedOperations = null;
        }
    }

    protected void addQueuedOperation(QueuedOperation op) {
        if (this.queuedOperations == null) {
            this.queuedOperations = new ArrayList();
        }
        this.queuedOperations.add(op);
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
            this.fieldName = null;
            this.backingStore = null;
        }
    }

    public void makeDirty() {
        if (this.ownerSM != null) {
            this.ownerSM.getObjectManager().getApiAdapter().makeFieldDirty(this.ownerSM.getObject(), this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.TreeSet detached = new java.util.TreeSet();
        SCOUtils.detachCopyForCollection(this.ownerSM, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        HashSet attachedElements = new HashSet(c.size());
        SCOUtils.attachRemoveDeletedElements(this.ownerSM.getObjectManager().getApiAdapter(), this, c, elementsWithoutIdentity);
        SCOUtils.attachCopyForCollection(this.ownerSM, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.attachAddNewElements(this.ownerSM.getObjectManager().getApiAdapter(), this, attachedElements, elementsWithoutIdentity);
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            java.util.TreeSet tree = new java.util.TreeSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                tree.remove(iter.next());
            }
            return tree.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set c = (Set)o;
        return c.size() == this.size() && this.containsAll((Collection)c);
    }

    public Object first() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.first();
        }
        if (!this.useCache) {
            Iterator iter = this.iterator();
            return iter.next();
        }
        this.loadFromStore();
        return this.delegate.first();
    }

    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache);
    }

    public SortedSet headSet(Object toElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headSet(toElement);
        }
        if (!this.useCache) {
            throw new NucleusUserException("JPOX doesn't currently support TreeSet.headSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.headSet(toElement);
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.subSet(fromElement, toElement);
        }
        if (!this.useCache) {
            throw new NucleusUserException("JPOX doesn't currently support TreeSet.subSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.subSet(fromElement, toElement);
    }

    public SortedSet tailSet(Object fromElement) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headSet(fromElement);
        }
        if (!this.useCache) {
            throw new NucleusUserException("JPOX doesn't currently support TreeSet.tailSet() when not using cached collections");
        }
        this.loadFromStore();
        return this.delegate.headSet(fromElement);
    }

    public Object last() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.last();
        }
        if (!this.useCache) {
            Iterator iter = this.iterator();
            Object last = null;
            while (iter.hasNext()) {
                last = iter.next();
            }
            return last;
        }
        this.loadFromStore();
        return this.delegate.last();
    }

    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    public Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    public Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    public boolean add(Object element) {
        if (element == null && !this.allowNulls) {
            throw new NullsNotAllowedException(this.ownerSM, this.fieldName);
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.ownerSM != null && this.ownerSM.getRelationshipManager() != null) {
            this.ownerSM.getRelationshipManager().relationAdd(this.fieldNumber, element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                this.addQueuedOperation(new AddOperation(element));
            } else {
                try {
                    this.backingStore.add(this.ownerSM, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"add", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean addAll(Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.ownerSM != null && this.ownerSM.getRelationshipManager() != null) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerSM.getRelationshipManager().relationAdd(this.fieldNumber, iter.next());
            }
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    this.addQueuedOperation(new AddOperation(iter.next()));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                this.addQueuedOperation(new ClearOperation());
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        this.delegate.clear();
    }

    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        boolean delegateSuccess = this.delegate.remove(element);
        if (this.ownerSM != null && this.ownerSM.getRelationshipManager() != null) {
            this.ownerSM.getRelationshipManager().relationRemove(this.fieldNumber, element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.addQueuedOperation(new RemoveOperation(element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerSM, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"remove", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean removeAll(Collection elements) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.ownerSM != null && this.ownerSM.getRelationshipManager() != null) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerSM.getRelationshipManager().relationRemove(this.fieldNumber, iter.next());
            }
        }
        if (this.backingStore != null) {
            int size;
            boolean backingSuccess = true;
            int n = size = this.useCache ? this.delegate.size() : -1;
            if (this.queued && !this.ownerSM.getObjectManager().isFlushing()) {
                backingSuccess = false;
                for (Object element : elements) {
                    if (!this.contains(element)) continue;
                    backingSuccess = true;
                    this.addQueuedOperation(new RemoveOperation(element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerSM, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"removeAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
            this.delegate.removeAll(elements);
            return backingSuccess;
        }
        return this.delegate.removeAll(elements);
    }

    public synchronized boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.TreeSet(this.delegate);
        }
        return new java.util.TreeSet(this.delegate);
    }
}

