/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.node;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.query.symbol.Symbol;

public class Node {
    public static final int LITERAL = 0;
    public static final int INVOKE = 1;
    public static final int NAME = 2;
    public static final int IDENTIFIER = 3;
    public static final int OPERATOR = 4;
    public static final int CREATOR = 5;
    public static final int CLASS = 6;
    public static final int PARAMETER = 7;
    public static final int CAST = 8;
    public static final int ARRAY = 9;
    protected int nodeType;
    protected Object nodeValue;
    private int cursorPos = -1;
    protected Symbol symbol;
    protected Node parent;
    protected List childNodes = new ArrayList();
    protected List properties = null;

    public Node(int nodeType) {
        this.nodeType = nodeType;
    }

    public Node(int nodeType, Object nodeValue) {
        this.nodeType = nodeType;
        this.nodeValue = nodeValue;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public Object getNodeValue() {
        return this.nodeValue;
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public List getProperties() {
        return this.properties;
    }

    public void addProperty(Node node) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(node);
    }

    public List getChildNodes() {
        return this.childNodes;
    }

    public Node insertChildNode(Node node) {
        this.childNodes.add(0, node);
        return node;
    }

    public Node appendChildNode(Node node) {
        this.childNodes.add(node);
        return node;
    }

    public Node[] appendChildNode(Node[] node) {
        this.childNodes.add(node);
        return node;
    }

    public Node[][] appendChildNode(Node[][] node) {
        this.childNodes.add(node);
        return node;
    }

    public Node getChildNode(int index) {
        return (Node)this.childNodes.get(index);
    }

    public Node getFirstChild() {
        this.cursorPos = 0;
        if (this.childNodes.size() < 1) {
            return null;
        }
        return (Node)this.childNodes.get(0);
    }

    public Node getNextChild() {
        ++this.cursorPos;
        if (this.childNodes.size() <= this.cursorPos) {
            return null;
        }
        return (Node)this.childNodes.get(this.cursorPos);
    }

    public boolean hasNextChild() {
        return this.cursorPos + 1 < this.childNodes.size();
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public String getNodeId() {
        StringBuffer sb = new StringBuffer();
        for (Node node = this; node != null && node.getNodeType() == 3; node = node.getParent()) {
            if (sb.length() > 0) {
                sb.insert(0, ".");
            }
            sb.insert(0, node.getNodeValue());
        }
        return sb.toString();
    }

    public String getNodeChildId() {
        StringBuffer sb = new StringBuffer();
        for (Node node = this; node != null && node.getNodeType() == 3; node = node.getFirstChild()) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(node.getNodeValue());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.printTree(0));
        return sb.toString();
    }

    private String printTree(int indentation) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.indent(indentation));
        String nodeTypeStr = null;
        if (this.nodeType == 0) {
            nodeTypeStr = "LITERAL";
        } else if (this.nodeType == 1) {
            nodeTypeStr = "INVOKE";
        } else if (this.nodeType == 2) {
            nodeTypeStr = "NAME";
        } else if (this.nodeType == 3) {
            nodeTypeStr = "IDENTIFIER";
        } else if (this.nodeType == 4) {
            nodeTypeStr = "OPERATOR";
        } else if (this.nodeType == 5) {
            nodeTypeStr = "CREATOR";
        } else if (this.nodeType == 6) {
            nodeTypeStr = "CLASS";
        } else if (this.nodeType == 7) {
            nodeTypeStr = "PARAMETER";
        } else if (this.nodeType == 8) {
            nodeTypeStr = "CAST";
        } else if (this.nodeType == 9) {
            nodeTypeStr = "ARRAY";
        }
        sb.append("[" + nodeTypeStr + " : " + this.nodeValue);
        if (this.childNodes.size() > 0) {
            if (this.nodeType == 0 || this.nodeType == 3) {
                sb.append(".");
            } else {
                sb.append(this.indent(indentation));
                sb.append("{");
            }
            for (int i = 0; i < this.childNodes.size(); ++i) {
                sb.append(((Node)this.childNodes.get(i)).printTree(indentation + 1));
                if (i >= this.childNodes.size() - 1) continue;
                sb.append(",");
            }
            if (this.nodeType != 0 && this.nodeType != 3) {
                sb.append(this.indent(indentation));
                sb.append("}");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String indent(int indentation) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (int i = 0; i < 4 * indentation; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

