/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.util.Localiser;

public abstract class Expression {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected Operator op;
    protected Expression left;
    protected Expression right;
    protected Symbol symbol;
    public static final DyadicOperator OP_OR = new DyadicOperator("OR", 0, true);
    public static final DyadicOperator OP_AND = new DyadicOperator("AND", 1, true);
    public static final MonadicOperator OP_NOT = new MonadicOperator("NOT ", 2);
    public static final DyadicOperator OP_EQ = new DyadicOperator("=", 3, false);
    public static final DyadicOperator OP_NOTEQ = new DyadicOperator("<>", 3, false);
    public static final DyadicOperator OP_LT = new DyadicOperator("<", 3, false);
    public static final DyadicOperator OP_LTEQ = new DyadicOperator("<=", 3, false);
    public static final DyadicOperator OP_GT = new DyadicOperator(">", 3, false);
    public static final DyadicOperator OP_GTEQ = new DyadicOperator(">=", 3, false);
    public static final DyadicOperator OP_LIKE = new DyadicOperator("LIKE", 3, false);
    public static final DyadicOperator OP_BETWEEN = new DyadicOperator("BETWEEN", 3, false);
    public static final DyadicOperator OP_IS = new DyadicOperator("IS", 3, false);
    public static final DyadicOperator OP_ISNOT = new DyadicOperator("IS NOT", 3, false);
    public static final DyadicOperator OP_IN = new DyadicOperator("IN", 3, false);
    public static final DyadicOperator OP_ADD = new DyadicOperator("+", 4, true);
    public static final DyadicOperator OP_SUB = new DyadicOperator("-", 4, false);
    public static final DyadicOperator OP_CONCAT = new DyadicOperator("||", 4, true);
    public static final DyadicOperator OP_MUL = new DyadicOperator("*", 5, true);
    public static final DyadicOperator OP_DIV = new DyadicOperator("/", 5, false);
    public static final DyadicOperator OP_MOD = new DyadicOperator("%", 5, false);
    public static final MonadicOperator OP_NEG = new MonadicOperator("NEG", 6);
    public static final MonadicOperator OP_COM = new MonadicOperator("~", 6);
    public static final MonadicOperator OP_DISTINCT = new MonadicOperator("DISTINCT", 6);

    protected Expression() {
    }

    protected Expression(MonadicOperator op, Expression operand) {
        this.op = op;
        this.left = operand;
    }

    protected Expression(Expression operand1, DyadicOperator op, Expression operand2) {
        this.op = op;
        this.left = operand1;
        this.right = operand2;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Object evaluate(ExpressionEvaluator eval) {
        return eval.evaluate(this);
    }

    public abstract Symbol bind();

    public static class DyadicOperator
    extends Operator {
        private final boolean isAssociative;

        public DyadicOperator(String symbol, int precedence, boolean isAssociative) {
            super(" " + symbol + " ", precedence);
            this.isAssociative = isAssociative;
        }

        public boolean isHigherThanLeftSide(Operator op) {
            if (op == null) {
                return false;
            }
            return this.precedence > op.precedence;
        }

        public boolean isHigherThanRightSide(Operator op) {
            if (op == null) {
                return false;
            }
            if (this.precedence == op.precedence) {
                return !this.isAssociative;
            }
            return this.precedence > op.precedence;
        }
    }

    public static class MonadicOperator
    extends Operator {
        public MonadicOperator(String symbol, int precedence) {
            super(symbol, precedence);
        }

        public boolean isHigherThan(Operator op) {
            if (op == null) {
                return false;
            }
            return this.precedence > op.precedence;
        }
    }

    public static class Operator {
        protected final String symbol;
        protected final int precedence;

        public Operator(String symbol, int precedence) {
            this.symbol = symbol;
            this.precedence = precedence;
        }

        public String toString() {
            return this.symbol;
        }
    }
}

