/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.xml;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.EntityResolverFactory;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetaDataParser
extends DefaultHandler {
    protected static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final MetaDataManager mgr;
    protected final boolean validate;
    SAXParser parser = null;

    public MetaDataParser(MetaDataManager mgr, boolean validate) {
        this.mgr = mgr;
        this.validate = validate;
    }

    public MetaData parseMetaDataURL(URL url, String handlerName) {
        if (url == null) {
            String msg = LOCALISER.msg("044031");
            NucleusLogger.METADATA.error(msg);
            throw new NucleusException(msg);
        }
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(url.getFile()));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (in == null) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044032", (Object)url.toString()));
            throw new NucleusException(LOCALISER.msg("044032", (Object)url.toString()));
        }
        return this.parseMetaDataStream(in, url.toString(), handlerName);
    }

    public MetaData parseMetaDataFile(String fileName, String handlerName) {
        InputStream in = null;
        try {
            in = new URL(fileName).openStream();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(fileName));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (in == null) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044032", (Object)fileName));
            throw new NucleusException(LOCALISER.msg("044032", (Object)fileName));
        }
        return this.parseMetaDataStream(in, fileName, handlerName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized MetaData parseMetaDataStream(InputStream in, String filename, String handlerName) {
        MetaData e5;
        if (in == null) {
            throw new NullPointerException("input stream is null");
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044030", (Object)filename, (Object)handlerName, (Object)(this.validate ? "true" : "false")));
        }
        try {
            try {
                if (this.parser == null) {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setValidating(this.validate);
                    factory.setNamespaceAware(this.validate);
                    if (this.validate) {
                        try {
                            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.getRegisteredSchemas(this.mgr.getOMFContext().getPluginManager()));
                            if (schema != null) {
                                try {
                                    factory.setSchema(schema);
                                }
                                catch (UnsupportedOperationException e2) {
                                    NucleusLogger.METADATA.info(e2.getMessage());
                                }
                            }
                        }
                        catch (Exception e3) {
                            NucleusLogger.METADATA.info(e3.getMessage());
                        }
                        try {
                            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
                        }
                        catch (Exception e4) {
                            NucleusLogger.METADATA.info(e4.getMessage());
                        }
                    }
                    this.parser = factory.newSAXParser();
                }
                DefaultHandler handler = null;
                EntityResolver entityResolver = null;
                try {
                    entityResolver = EntityResolverFactory.getInstance(this.mgr.getOMFContext().getPluginManager(), handlerName);
                    if (entityResolver != null) {
                        this.parser.getXMLReader().setEntityResolver(entityResolver);
                    }
                    Class[] argTypes = new Class[]{MetaDataManager.class, String.class, EntityResolver.class};
                    Object[] argValues = new Object[]{this.mgr, filename, entityResolver};
                    handler = (DefaultHandler)this.mgr.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.metadata_handler", "name", handlerName, "class-name", argTypes, argValues);
                    if (handler == null) {
                        throw new NucleusUserException(LOCALISER.msg("044028", (Object)handlerName)).setFatal();
                    }
                }
                catch (Exception e5) {
                    String msg = LOCALISER.msg("044029", (Object)handlerName, (Object)e5.getMessage());
                    throw new NucleusException(msg, e5);
                }
                this.parser.parse(in, handler);
                e5 = ((AbstractMetaDataHandler)handler).getMetaData();
                Object var9_17 = null;
            }
            catch (NucleusException e6) {
                throw e6;
            }
            catch (Exception e7) {
                Exception cause = e7;
                if (e7 instanceof SAXException) {
                    SAXException se = (SAXException)e7;
                    cause = se.getException();
                }
                cause = e7.getCause() == null ? cause : e7.getCause();
                NucleusLogger.METADATA.error(LOCALISER.msg("044040", (Object)filename, (Object)cause));
                if (cause instanceof InvalidMetaDataException) {
                    throw (InvalidMetaDataException)cause;
                }
                String message = LOCALISER.msg("044033", e7);
                throw new NucleusException(message, cause);
            }
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ignore) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ignore) {
            // empty catch block
            return e5;
        }
        in.close();
        return e5;
    }

    private Source[] getRegisteredSchemas(PluginManager pm) {
        ConfigurationElement[] elems = pm.getConfigurationElementsForExtension("org.datanucleus.metadata_entityresolver", null, null);
        HashSet<StreamSource> sources = new HashSet<StreamSource>();
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i].getAttribute("type") != null) continue;
            InputStream in = MetaDataParser.class.getResourceAsStream(elems[i].getAttribute("url"));
            if (in == null) {
                NucleusLogger.METADATA.warn("local resource \"" + elems[i].getAttribute("url") + "\" does not exist!!!");
            }
            sources.add(new StreamSource(in));
        }
        return sources.toArray(new Source[sources.size()]);
    }
}

