/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataMerger;
import org.datanucleus.metadata.MetadataFileType;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.annotations.AnnotationManager;
import org.datanucleus.metadata.annotations.AnnotationManagerImpl;
import org.datanucleus.metadata.xml.MetaDataParser;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaDataManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final OMFContext omfContext;
    protected final AnnotationManager annotationManager;
    protected MetaDataParser metaDataParser = null;
    protected boolean validateMetaData = true;
    protected Collection classesWithoutPersistenceInfo = new HashSet();
    protected Map<String, FileMetaData> fileMetaDataByURLString = new HashMap<String, FileMetaData>();
    protected Map classMetaDataByClass = new HashMap();
    protected Map classMetaDataByEntityName = new HashMap();
    protected Map classMetaDataByDiscriminatorName = new HashMap();
    protected Map<String, Set<String>> directSubclassesByClass = new HashMap<String, Set<String>>();
    protected Map queryMetaDataByName = null;
    protected Map fetchPlanMetaDataByName = null;
    protected Map sequenceMetaDataByPackageSequence = null;
    protected Map tableGeneratorMetaDataByPackageSequence = null;
    protected Map queryResultMetaDataByName = null;
    protected int userMetaDataNumber = 0;
    protected boolean supportsORM = true;
    protected ArrayList utilisedFileMetaData = new ArrayList();

    public MetaDataManager(OMFContext ctxt) {
        this.omfContext = ctxt;
        this.setValidate(this.omfContext.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.validate"));
        this.annotationManager = new AnnotationManagerImpl(this);
        Set supportedClasses = this.omfContext.getTypeManager().getSupportedSecondClassTypes();
        Iterator iter = supportedClasses.iterator();
        while (iter.hasNext()) {
            this.classesWithoutPersistenceInfo.add(iter.next());
        }
        if (this.omfContext.getStoreManager() != null) {
            Boolean configOrm;
            this.supportsORM = this.omfContext.getStoreManager().getSupportedOptions().contains("ORM");
            if (this.supportsORM && (configOrm = this.omfContext.getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.metadata.supportORM")) != null && !configOrm.booleanValue()) {
                this.supportsORM = false;
            }
        }
    }

    public void close() {
        this.classMetaDataByClass.clear();
        this.classMetaDataByClass = null;
        this.fileMetaDataByURLString.clear();
        this.fileMetaDataByURLString = null;
        this.classesWithoutPersistenceInfo.clear();
        this.classesWithoutPersistenceInfo = null;
        this.directSubclassesByClass.clear();
        this.directSubclassesByClass = null;
        if (this.classMetaDataByEntityName != null) {
            this.classMetaDataByEntityName.clear();
            this.classMetaDataByEntityName = null;
        }
        if (this.classMetaDataByDiscriminatorName != null) {
            this.classMetaDataByDiscriminatorName.clear();
            this.classMetaDataByDiscriminatorName = null;
        }
        if (this.queryMetaDataByName != null) {
            this.queryMetaDataByName.clear();
            this.queryMetaDataByName = null;
        }
        if (this.fetchPlanMetaDataByName != null) {
            this.fetchPlanMetaDataByName.clear();
            this.fetchPlanMetaDataByName = null;
        }
        if (this.sequenceMetaDataByPackageSequence != null) {
            this.sequenceMetaDataByPackageSequence.clear();
            this.sequenceMetaDataByPackageSequence = null;
        }
        if (this.tableGeneratorMetaDataByPackageSequence != null) {
            this.tableGeneratorMetaDataByPackageSequence.clear();
            this.tableGeneratorMetaDataByPackageSequence = null;
        }
        if (this.queryResultMetaDataByName != null) {
            this.queryResultMetaDataByName.clear();
            this.queryResultMetaDataByName = null;
        }
    }

    public boolean supportsORM() {
        return this.supportsORM;
    }

    public boolean isEnhancing() {
        return this.getOMFContext().getContext() == 2;
    }

    public void setValidate(boolean validate) {
        this.validateMetaData = validate;
    }

    public OMFContext getOMFContext() {
        return this.omfContext;
    }

    public ApiAdapter getApiAdapter() {
        return this.omfContext.getApiAdapter();
    }

    protected void logConfiguration() {
        NucleusLogger.METADATA.debug("MetaDataManager : Input=(XML, Annotations), XML-Validation=" + this.validateMetaData);
    }

    public FileMetaData[] loadMetadataFiles(String[] metadataFiles, ClassLoader loader) {
        ClassLoaderResolver clr;
        Collection<FileMetaData> fileMetaData;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044005", (Object)StringUtils.objectArrayToString(metadataFiles)));
        }
        if ((fileMetaData = this.loadFiles(metadataFiles, clr = this.omfContext.getClassLoaderResolver(loader))).size() > 0) {
            this.initialiseFileMetaDataForUse(fileMetaData, clr);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public FileMetaData[] loadClasses(String[] classNames, ClassLoader loader) {
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044006", (Object)StringUtils.objectArrayToString(classNames)));
        }
        ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(loader);
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<Exception> exceptions = new HashSet<Exception>();
        for (int i = 0; i < classNames.length; ++i) {
            try {
                Class cls = clr.classForName(classNames[i]);
                AbstractClassMetaData cmd = (AbstractClassMetaData)this.classMetaDataByClass.get(classNames[i]);
                if (cmd == null) {
                    FileMetaData filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                    if (filemd != null) {
                        this.registerFile("annotations:" + classNames[i], filemd, clr);
                        fileMetaData.add(filemd);
                        continue;
                    }
                    cmd = this.getMetaDataForClass(cls, clr);
                    if (cmd == null) {
                        NucleusLogger.METADATA.info(LOCALISER.msg("044017", (Object)classNames[i]));
                        continue;
                    }
                    fileMetaData.add(cmd.getPackageMetaData().getFileMetaData());
                    continue;
                }
                fileMetaData.add(cmd.getPackageMetaData().getFileMetaData());
                continue;
            }
            catch (ClassNotResolvedException e) {
                NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                continue;
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044016"), exceptions.toArray(new Throwable[exceptions.size()]), null);
        }
        if (fileMetaData.size() > 0) {
            this.initialiseFileMetaDataForUse(fileMetaData, clr);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public FileMetaData[] loadJar(String jarFileName, ClassLoader loader) {
        FileMetaData filemd;
        String[] jarClassNames;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044009", (Object)jarFileName));
        }
        ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(loader);
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<String> mappingFiles = new HashSet<String>();
        HashSet<String> classNames = new HashSet<String>();
        String[] packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile(jarFileName);
        if (packageJdoFiles != null) {
            for (int i = 0; i < packageJdoFiles.length; ++i) {
                mappingFiles.add(packageJdoFiles[i]);
            }
        }
        if ((jarClassNames = ClassUtils.getClassNamesForJarFile(jarFileName)) != null) {
            for (int i = 0; i < jarClassNames.length; ++i) {
                classNames.add(jarClassNames[i]);
            }
        }
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (mappingFiles != null && mappingFiles.size() > 0) {
            for (String mappingFileName : mappingFiles) {
                try {
                    Enumeration files = clr.getResources(mappingFileName, Thread.currentThread().getContextClassLoader());
                    while (files.hasMoreElements()) {
                        URL url = (URL)files.nextElement();
                        if (url == null || this.fileMetaDataByURLString.get(url.toString()) != null || (filemd = this.parseFile(url)) == null) continue;
                        this.registerFile(url.toString(), filemd, clr);
                        fileMetaData.add(filemd);
                    }
                }
                catch (InvalidMetaDataException imde) {
                    NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(imde));
                    exceptions.add(imde);
                }
                catch (IOException ioe) {
                    NucleusLogger.METADATA.error(LOCALISER.msg("044027", (Object)jarFileName, (Object)mappingFileName, (Object)ioe.getMessage()), ioe);
                }
            }
        }
        if (classNames.size() > 0) {
            for (String className : classNames) {
                AbstractClassMetaData cmd = (AbstractClassMetaData)this.classMetaDataByClass.get(className);
                if (cmd != null) continue;
                try {
                    Class cls = clr.classForName(className);
                    filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                    if (filemd == null) continue;
                    fileMetaData.add(filemd);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044026", (Object)jarFileName), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        if (fileMetaData.size() > 0) {
            this.initialiseFileMetaDataForUse(fileMetaData, clr);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public FileMetaData[] loadPersistenceUnit(PersistenceUnitMetaData pumd, ClassLoader loader) {
        int i;
        HashSet jarFileNames;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044007", (Object)pumd.getName()));
        }
        ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(loader);
        HashSet<Exception> exceptions = new HashSet<Exception>();
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<String> mappingFiles = new HashSet<String>();
        HashSet<String> classNames = new HashSet<String>();
        mappingFiles.add("META-INF/orm.xml");
        if (pumd.getMappingFiles() != null) {
            mappingFiles.addAll(pumd.getMappingFiles());
        }
        if (this.omfContext.getApi().equalsIgnoreCase("JDO") && (jarFileNames = pumd.getJarFiles()) != null) {
            for (Object jarFile : jarFileNames) {
                String[] packageJdoFiles;
                if (jarFile instanceof String) {
                    packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile((String)jarFile);
                    if (packageJdoFiles == null) continue;
                    for (i = 0; i < packageJdoFiles.length; ++i) {
                        mappingFiles.add(packageJdoFiles[i]);
                    }
                    continue;
                }
                if (!(jarFile instanceof URL) || (packageJdoFiles = ClassUtils.getPackageJdoFilesForJarFile((URL)jarFile)) == null) continue;
                for (i = 0; i < packageJdoFiles.length; ++i) {
                    mappingFiles.add(packageJdoFiles[i]);
                }
            }
        }
        if (pumd.getClassNames() != null) {
            classNames.addAll(pumd.getClassNames());
        }
        if (this.getOMFContext().getContext() == 1 && (jarFileNames = pumd.getJarFiles()) != null) {
            for (Object jarFile : jarFileNames) {
                String[] jarClassNames;
                if (jarFile instanceof String) {
                    jarClassNames = ClassUtils.getClassNamesForJarFile((String)jarFile);
                    if (jarClassNames == null) continue;
                    for (i = 0; i < jarClassNames.length; ++i) {
                        classNames.add(jarClassNames[i]);
                    }
                    continue;
                }
                if (!(jarFile instanceof URL) || (jarClassNames = ClassUtils.getClassNamesForJarFile((URL)jarFile)) == null) continue;
                for (i = 0; i < jarClassNames.length; ++i) {
                    classNames.add(jarClassNames[i]);
                }
            }
        }
        if (mappingFiles != null && mappingFiles.size() > 0) {
            for (String mappingFileName : mappingFiles) {
                try {
                    Enumeration files = clr.getResources(mappingFileName, Thread.currentThread().getContextClassLoader());
                    while (files.hasMoreElements()) {
                        FileMetaData filemd;
                        URL url = (URL)files.nextElement();
                        if (url == null || this.fileMetaDataByURLString.get(url.toString()) != null || (filemd = this.parseFile(url)) == null) continue;
                        this.registerFile(url.toString(), filemd, clr);
                        fileMetaData.add(filemd);
                    }
                }
                catch (InvalidMetaDataException imde) {
                    NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(imde));
                    exceptions.add(imde);
                }
                catch (IOException ioe) {
                    NucleusLogger.METADATA.error(LOCALISER.msg("044027", (Object)pumd.getName(), (Object)mappingFileName, (Object)ioe.getMessage()), ioe);
                }
            }
        }
        if (classNames.size() > 0) {
            for (String className : classNames) {
                AbstractClassMetaData cmd = (AbstractClassMetaData)this.classMetaDataByClass.get(className);
                if (cmd != null) continue;
                try {
                    Class cls = clr.classForName(className);
                    FileMetaData filemd = this.loadAnnotationsForClass(cls, clr, true, false);
                    if (filemd == null) continue;
                    fileMetaData.add(filemd);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044026", (Object)pumd.getName()), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        if (fileMetaData.size() > 0) {
            this.initialiseFileMetaDataForUse(fileMetaData, clr);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
        return fileMetaData.toArray(new FileMetaData[fileMetaData.size()]);
    }

    public void loadUserMetaData(FileMetaData fileMetaData, ClassLoader loader) {
        if (fileMetaData == null) {
            return;
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044008"));
        }
        ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(loader);
        fileMetaData.setFilename("User_Metadata_" + this.userMetaDataNumber);
        ++this.userMetaDataNumber;
        this.registerFile(fileMetaData.getFilename(), fileMetaData, clr);
        ArrayList<FileMetaData> filemds = new ArrayList<FileMetaData>();
        filemds.add(fileMetaData);
        this.initialiseFileMetaDataForUse(filemds, clr);
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044010"));
        }
    }

    protected void initialiseFileMetaDataForUse(Collection fileMetaData, ClassLoaderResolver clr) {
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044018"));
        }
        for (FileMetaData filemd : fileMetaData) {
            if (filemd.isInitialised()) continue;
            this.populateFileMetaData(filemd, clr, null);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044019"));
        }
        for (FileMetaData filemd : fileMetaData) {
            if (filemd.isInitialised()) continue;
            try {
                this.initialiseFileMetaData(filemd, clr, null);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.error(StringUtils.getStringFromStackTrace(e));
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044020"), exceptions.toArray(new Throwable[exceptions.size()]));
        }
    }

    public Collection<FileMetaData> loadFiles(String[] metadataFiles, ClassLoaderResolver clr) {
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        HashSet<Exception> exceptions = new HashSet<Exception>();
        for (int i = 0; i < metadataFiles.length; ++i) {
            try {
                URL fileURL = null;
                try {
                    File file = new File(metadataFiles[i]);
                    fileURL = file.toURI().toURL();
                    if (!file.exists()) {
                        fileURL = clr.getResource(metadataFiles[i], null);
                    }
                }
                catch (Exception mue) {
                    fileURL = clr.getResource(metadataFiles[i], null);
                }
                FileMetaData filemd = this.fileMetaDataByURLString.get(fileURL.toString());
                if (fileURL != null && filemd == null) {
                    filemd = this.parseFile(fileURL);
                    if (filemd != null) {
                        this.registerFile(fileURL.toString(), filemd, clr);
                        fileMetaData.add(filemd);
                        continue;
                    }
                    throw new NucleusUserException(LOCALISER.msg("044015", (Object)metadataFiles[i]));
                }
                fileMetaData.add(filemd);
                continue;
            }
            catch (Exception e) {
                exceptions.add(e);
                e.printStackTrace();
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044016"), exceptions.toArray(new Throwable[exceptions.size()]), null);
        }
        return fileMetaData;
    }

    public boolean isClassPersistable(String className) {
        AbstractClassMetaData acmd = this.readMetaDataForClass(className);
        if (acmd == null) {
            return false;
        }
        return acmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE;
    }

    public FileMetaData[] getFileMetaData() {
        Collection<FileMetaData> filemds = this.fileMetaDataByURLString.values();
        return filemds.toArray(new FileMetaData[filemds.size()]);
    }

    public Collection getClassesWithMetaData() {
        return Collections.unmodifiableCollection(this.classMetaDataByClass.keySet());
    }

    public boolean hasMetaDataForClass(String className) {
        if (className == null) {
            return false;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return false;
        }
        return this.classMetaDataByClass.get(className) != null;
    }

    protected boolean isClassWithoutPersistenceInfo(String className) {
        if (className == null) {
            return true;
        }
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            return true;
        }
        return this.classesWithoutPersistenceInfo.contains(className);
    }

    public synchronized AbstractClassMetaData getMetaDataForClass(String className, ClassLoaderResolver clr) {
        if (className == null) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(className)) {
            return null;
        }
        Class c = null;
        try {
            c = clr == null ? Class.forName(className) : clr.classForName(className, null, false);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (ClassNotResolvedException cnre) {
            // empty catch block
        }
        if (c == null) {
            return null;
        }
        return this.getMetaDataForClass(c, clr);
    }

    public synchronized AbstractClassMetaData getMetaDataForClass(Class c, ClassLoaderResolver clr) {
        if (c == null) {
            return null;
        }
        if (this.isClassWithoutPersistenceInfo(c.getName())) {
            return null;
        }
        AbstractClassMetaData cmd = null;
        cmd = c.isInterface() ? this.getClassMetaDataForImplementationOfPersistentInterface(c.getName()) : this.getMetaDataForClassInternal(c, clr);
        if (cmd != null) {
            this.populateAbstractClassMetaData(cmd, clr, c.getClassLoader());
            this.initialiseAbstractClassMetaData(cmd, clr);
            if (this.utilisedFileMetaData.size() > 0) {
                ArrayList utilisedFileMetaData1 = (ArrayList)this.utilisedFileMetaData.clone();
                this.utilisedFileMetaData.clear();
                for (FileMetaData filemd : utilisedFileMetaData1) {
                    this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                }
                if (this.utilisedFileMetaData.size() > 0) {
                    ArrayList utilisedFileMetaData2 = (ArrayList)this.utilisedFileMetaData.clone();
                    this.utilisedFileMetaData.clear();
                    for (FileMetaData filemd : utilisedFileMetaData2) {
                        this.initialiseFileMetaData(filemd, clr, c.getClassLoader());
                    }
                }
            }
        } else if (!c.isInterface()) {
            this.classesWithoutPersistenceInfo.add(c.getName());
        }
        this.utilisedFileMetaData.clear();
        return cmd;
    }

    public synchronized AbstractClassMetaData getMetaDataForEntityName(String entityName) {
        return (AbstractClassMetaData)this.classMetaDataByEntityName.get(entityName);
    }

    public synchronized AbstractClassMetaData getMetaDataForDiscriminator(String discriminator) {
        return (AbstractClassMetaData)this.classMetaDataByDiscriminatorName.get(discriminator);
    }

    public AbstractClassMetaData readMetaDataForClass(String className) {
        return (AbstractClassMetaData)this.classMetaDataByClass.get(className);
    }

    public AbstractMemberMetaData readMetaDataForMember(String className, String memberName) {
        AbstractClassMetaData cmd = this.readMetaDataForClass(className);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public abstract AbstractClassMetaData getMetaDataForClassInternal(Class var1, ClassLoaderResolver var2);

    protected void registerMetaDataForClass(String fullClassName, AbstractClassMetaData cmd) {
        this.classMetaDataByClass.put(fullClassName, cmd);
        this.directSubclassesByClass.clear();
    }

    public String[] getSubclassesForClass(String className, boolean includeDescendents) {
        HashSet subclassNames = new HashSet();
        this.provideSubclassesForClass(className, includeDescendents, subclassNames);
        if (subclassNames.size() > 0) {
            return subclassNames.toArray(new String[subclassNames.size()]);
        }
        return null;
    }

    private void provideSubclassesForClass(String className, boolean includeDescendents, Collection consumer) {
        Set directSubClasses = this.directSubclassesByClass.get(className);
        if (directSubClasses == null) {
            directSubClasses = this.computeDirectSubclassesForClass(className);
            this.directSubclassesByClass.put(className, directSubClasses);
        }
        consumer.addAll(directSubClasses);
        if (includeDescendents) {
            Iterator subClassNameIter = directSubClasses.iterator();
            while (subClassNameIter.hasNext()) {
                this.provideSubclassesForClass((String)subClassNameIter.next(), includeDescendents, consumer);
            }
        }
    }

    private Set computeDirectSubclassesForClass(String className) {
        HashSet<String> result = new HashSet<String>();
        Collection cmds = this.classMetaDataByClass.values();
        for (AbstractClassMetaData acmd : cmds) {
            ClassMetaData cmd;
            if (!(acmd instanceof ClassMetaData) || (cmd = (ClassMetaData)acmd).getPersistenceCapableSuperclass() == null || !cmd.getPersistenceCapableSuperclass().equals(className)) continue;
            result.add(cmd.getFullClassName());
        }
        return result;
    }

    public String[] getClassesImplementingInterface(String interfaceName, ClassLoaderResolver clr) {
        HashSet classes = new HashSet();
        Class intfClass = clr.classForName(interfaceName);
        HashSet<String> generatedClassNames = new HashSet<String>();
        Collection cmds = this.classMetaDataByClass.values();
        Iterator cmdIter = cmds.iterator();
        boolean isPersistentInterface = false;
        while (cmdIter.hasNext()) {
            AbstractClassMetaData acmd = (AbstractClassMetaData)cmdIter.next();
            Class implClass = null;
            try {
                implClass = clr.classForName(acmd.getFullClassName());
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
            if (implClass != null) {
                if (acmd instanceof ClassMetaData) {
                    this.initialiseAbstractClassMetaData(acmd, clr);
                    if (!intfClass.isAssignableFrom(implClass) || ((ClassMetaData)acmd).isAbstractPersistenceCapable()) continue;
                    classes.add(implClass);
                    continue;
                }
                if (!(acmd instanceof InterfaceMetaData) || !intfClass.isAssignableFrom(implClass)) continue;
                isPersistentInterface = true;
                continue;
            }
            if (!this.isPersistentInterfaceImplementation(interfaceName, acmd.getFullClassName())) continue;
            isPersistentInterface = true;
            generatedClassNames.add(acmd.getFullClassName());
        }
        if (isPersistentInterface && this.omfContext.getImplementationCreator() != null) {
            classes.add(this.omfContext.getImplementationCreator().newInstance(intfClass, this, clr).getClass());
            int numClasses = classes.size() + generatedClassNames.size();
            String[] classNames = new String[numClasses];
            Iterator iter = classes.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            iter = generatedClassNames.iterator();
            while (iter.hasNext()) {
                classNames[i++] = (String)iter.next();
            }
            return classNames;
        }
        if (classes.size() > 0) {
            TreeSet classesSorted = new TreeSet(new InterfaceClassComparator());
            Iterator classesIter = classes.iterator();
            while (classesIter.hasNext()) {
                classesSorted.add(classesIter.next());
            }
            String[] classNames = new String[classesSorted.size()];
            Iterator iter = classesSorted.iterator();
            int i = 0;
            while (iter.hasNext()) {
                classNames[i++] = ((Class)iter.next()).getName();
            }
            return classNames;
        }
        return null;
    }

    protected void addORMDataToClass(Class c, ClassLoaderResolver clr) {
    }

    void addAnnotationsDataToClass(Class c, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        ClassMetaData annotCmd;
        if (cmd.getPackageMetaData() != null && cmd.getPackageMetaData().getFileMetaData() != null && cmd.getPackageMetaData().getFileMetaData().getType() == MetadataFileType.ANNOTATIONS) {
            return;
        }
        FileMetaData filemd = this.loadAnnotationsForClass(c, clr, false, false);
        if (filemd != null && (annotCmd = filemd.getPackage(0).getClass(0)) != null) {
            MetaDataMerger.mergeClassAnnotationsData(cmd, annotCmd);
        }
    }

    public ClassMetaData getMetaDataForImplementationOfReference(Class referenceClass, Object implValue, ClassLoaderResolver clr) {
        if (referenceClass == null || !referenceClass.isInterface() && referenceClass != Object.class) {
            return null;
        }
        ClassMetaData intfMetaData = this.getClassMetaDataForImplementationOfPersistentInterface(referenceClass.getName());
        if (intfMetaData != null) {
            return intfMetaData;
        }
        ClassMetaData cmd = null;
        Set classMetaDataClasses = this.classMetaDataByClass.keySet();
        block2: for (String class_name : classMetaDataClasses) {
            AbstractClassMetaData acmd_cls = (AbstractClassMetaData)this.classMetaDataByClass.get(class_name);
            if (!(acmd_cls instanceof ClassMetaData)) continue;
            try {
                Class<?> cls = referenceClass.getClassLoader().loadClass(class_name);
                if (!referenceClass.isAssignableFrom(cls)) continue;
                cmd = (ClassMetaData)acmd_cls;
                if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) {
                    return cmd;
                }
                AbstractClassMetaData cmd_superclass = cmd.getSuperAbstractClassMetaData();
                while (cmd_superclass != null && referenceClass.isAssignableFrom(clr.classForName(((ClassMetaData)cmd_superclass).getFullClassName()))) {
                    cmd = (ClassMetaData)cmd_superclass;
                    if (implValue != null && cmd.getFullClassName().equals(implValue.getClass().getName())) continue block2;
                    if ((cmd_superclass = cmd_superclass.getSuperAbstractClassMetaData()) != null) continue;
                }
            }
            catch (Exception e) {}
        }
        return cmd;
    }

    public AbstractMemberMetaData getMetaDataForMember(String className, String memberName, ClassLoaderResolver clr) {
        if (className == null || memberName == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataForClass(className, clr);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public AbstractMemberMetaData getMetaDataForMember(Class c, ClassLoaderResolver clr, String memberName) {
        if (c == null || memberName == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.getMetaDataForClass(c, clr);
        return cmd != null ? cmd.getMetaDataForMember(memberName) : null;
    }

    public QueryMetaData getMetaDataForQuery(Class cls, ClassLoaderResolver clr, String queryName) {
        if (queryName == null || this.queryMetaDataByName == null) {
            return null;
        }
        String query_key = queryName;
        if (cls != null) {
            query_key = cls.getName() + "_" + queryName;
        }
        return (QueryMetaData)this.queryMetaDataByName.get(query_key);
    }

    public FetchPlanMetaData getMetaDataForFetchPlan(String name) {
        if (name == null || this.fetchPlanMetaDataByName == null) {
            return null;
        }
        return (FetchPlanMetaData)this.fetchPlanMetaDataByName.get(name);
    }

    public SequenceMetaData getMetaDataForSequence(ClassLoaderResolver clr, String seqName) {
        if (seqName == null || this.sequenceMetaDataByPackageSequence == null) {
            return null;
        }
        return (SequenceMetaData)this.sequenceMetaDataByPackageSequence.get(seqName);
    }

    public TableGeneratorMetaData getMetaDataForTableGenerator(ClassLoaderResolver clr, String genName) {
        if (genName == null || this.tableGeneratorMetaDataByPackageSequence == null) {
            return null;
        }
        return (TableGeneratorMetaData)this.tableGeneratorMetaDataByPackageSequence.get(genName);
    }

    public QueryResultMetaData getMetaDataForQueryResult(String name) {
        if (name == null || this.queryResultMetaDataByName == null) {
            return null;
        }
        return (QueryResultMetaData)this.queryResultMetaDataByName.get(name);
    }

    public InterfaceMetaData getMetaDataForInterface(Class c, ClassLoaderResolver clr) {
        return null;
    }

    public boolean isPersistentInterface(String name) {
        return false;
    }

    public boolean isPersistentInterfaceImplementation(String interfaceName, String implName) {
        return false;
    }

    public boolean isPersistentDefinitionImplementation(String implName) {
        return false;
    }

    public String getImplementationNameForPersistentInterface(String interfaceName) {
        return null;
    }

    public ClassMetaData getClassMetaDataForImplementationOfPersistentInterface(String interfaceName) {
        return null;
    }

    public void registerPersistentInterface(InterfaceMetaData imd, Class implClass, ClassLoaderResolver clr) {
    }

    public void registerImplementationOfAbstractClass(ClassMetaData cmd, Class implClass, ClassLoaderResolver clr) {
    }

    public PersistenceUnitMetaData getMetaDataForPersistenceUnit(String unitName) {
        PersistenceFileMetaData[] files = this.parsePersistenceFiles();
        if (files == null) {
            throw new NucleusUserException(LOCALISER.msg("044046"));
        }
        for (int i = 0; i < files.length; ++i) {
            PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
            if (unitmds == null) continue;
            for (int j = 0; j < unitmds.length; ++j) {
                if (!unitmds[j].getName().equals(unitName)) continue;
                return unitmds[j];
            }
        }
        return null;
    }

    public PersistenceFileMetaData[] parsePersistenceFiles() {
        String filename = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.persistenceXmlFilename");
        if (filename != null) {
            try {
                URL fileURL = new URL(filename);
                if (this.metaDataParser == null) {
                    this.metaDataParser = new MetaDataParser(this, this.validateMetaData);
                }
                MetaData permd = this.metaDataParser.parseMetaDataURL(fileURL, "persistence");
                return new PersistenceFileMetaData[]{(PersistenceFileMetaData)permd};
            }
            catch (MalformedURLException mue) {
                NucleusLogger.METADATA.error("Error reading user-specified persistence.xml file " + filename, mue);
            }
        }
        HashSet<MetaData> metadata = new HashSet<MetaData>();
        ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(null);
        try {
            Enumeration files = clr.getResources("META-INF/persistence.xml", Thread.currentThread().getContextClassLoader());
            if (!files.hasMoreElements()) {
                return null;
            }
            while (files.hasMoreElements()) {
                URL fileURL = (URL)files.nextElement();
                if (this.metaDataParser == null) {
                    this.metaDataParser = new MetaDataParser(this, this.validateMetaData);
                }
                MetaData permd = this.metaDataParser.parseMetaDataURL(fileURL, "persistence");
                metadata.add(permd);
            }
        }
        catch (IOException ioe) {
            NucleusLogger.METADATA.warn(StringUtils.getStringFromStackTrace(ioe));
        }
        return metadata.toArray(new PersistenceFileMetaData[metadata.size()]);
    }

    protected abstract FileMetaData parseFile(URL var1);

    public abstract void registerFile(String var1, FileMetaData var2, ClassLoaderResolver var3);

    protected void registerSequencesForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            SequenceMetaData[] seqmds = pmd.getSequences();
            if (seqmds == null) continue;
            if (this.sequenceMetaDataByPackageSequence == null) {
                this.sequenceMetaDataByPackageSequence = new HashMap();
            }
            for (int j = 0; j < seqmds.length; ++j) {
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getFullyQualifiedName(), seqmds[j]);
                this.sequenceMetaDataByPackageSequence.put(seqmds[j].getName(), seqmds[j]);
            }
        }
    }

    protected void registerTableGeneratorsForFile(FileMetaData filemd) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            TableGeneratorMetaData[] tgmds = pmd.getTableGenerators();
            if (tgmds == null) continue;
            if (this.tableGeneratorMetaDataByPackageSequence == null) {
                this.tableGeneratorMetaDataByPackageSequence = new HashMap();
            }
            for (int j = 0; j < tgmds.length; ++j) {
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getFullyQualifiedName(), tgmds[j]);
                this.tableGeneratorMetaDataByPackageSequence.put(tgmds[j].getName(), tgmds[j]);
            }
        }
    }

    protected void registerQueryResultMetaDataForFile(FileMetaData filemd) {
        int i;
        QueryResultMetaData[] fqrmds = filemd.getQueryResultMetaData();
        if (fqrmds != null) {
            if (this.queryResultMetaDataByName == null) {
                this.queryResultMetaDataByName = new HashMap();
            }
            for (i = 0; i < fqrmds.length; ++i) {
                this.queryResultMetaDataByName.put(fqrmds[i].getName(), fqrmds[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            PackageMetaData pmd = filemd.getPackage(i);
            for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryResultMetaData[] qrmds = cmd.getQueryResultMetaData();
                if (qrmds == null) continue;
                if (this.queryResultMetaDataByName == null) {
                    this.queryResultMetaDataByName = new HashMap();
                }
                for (int k = 0; k < qrmds.length; ++k) {
                    this.queryResultMetaDataByName.put(qrmds[k].getName(), qrmds[k]);
                }
            }
        }
    }

    protected void registerQueriesForFile(FileMetaData filemd) {
        int i;
        QueryMetaData[] queries = filemd.getQueries();
        if (queries != null) {
            if (this.queryMetaDataByName == null) {
                this.queryMetaDataByName = new HashMap();
            }
            for (i = 0; i < queries.length; ++i) {
                String scope = queries[i].getScope();
                String key = queries[i].getName();
                if (scope != null) {
                    key = scope + "_" + key;
                }
                this.queryMetaDataByName.put(key, queries[i]);
            }
        }
        for (i = 0; i < filemd.getNoOfPackages(); ++i) {
            String key;
            String scope;
            int k;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                QueryMetaData[] classQueries = cmd.getQueries();
                if (classQueries == null) continue;
                if (this.queryMetaDataByName == null) {
                    this.queryMetaDataByName = new HashMap();
                }
                for (k = 0; k < classQueries.length; ++k) {
                    scope = classQueries[k].getScope();
                    key = classQueries[k].getName();
                    if (scope != null) {
                        key = scope + "_" + key;
                    }
                    this.queryMetaDataByName.put(key, classQueries[k]);
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData intfmd = pmd.getInterface(j);
                QueryMetaData[] interfaceQueries = intfmd.getQueries();
                if (interfaceQueries == null) continue;
                if (this.queryMetaDataByName == null) {
                    this.queryMetaDataByName = new HashMap();
                }
                for (k = 0; k < interfaceQueries.length; ++k) {
                    scope = interfaceQueries[k].getScope();
                    key = interfaceQueries[k].getName();
                    if (scope != null) {
                        key = scope + "_" + key;
                    }
                    this.queryMetaDataByName.put(key, interfaceQueries[k]);
                }
            }
        }
    }

    protected void registerFetchPlansForFile(FileMetaData filemd) {
        FetchPlanMetaData[] fetchPlans = filemd.getFetchPlans();
        if (fetchPlans != null) {
            if (this.fetchPlanMetaDataByName == null) {
                this.fetchPlanMetaDataByName = new HashMap();
            }
            for (int i = 0; i < fetchPlans.length; ++i) {
                this.fetchPlanMetaDataByName.put(fetchPlans[i].getName(), fetchPlans[i]);
            }
        }
    }

    protected void populateFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        filemd.setMetaDataManager(this);
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            AbstractClassMetaData cmd;
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                cmd = pmd.getClass(j);
                this.populateAbstractClassMetaData(cmd, clr, primary);
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                cmd = pmd.getInterface(j);
                this.populateAbstractClassMetaData(cmd, clr, primary);
            }
        }
    }

    protected void initialiseFileMetaData(FileMetaData filemd, ClassLoaderResolver clr, ClassLoader primary) {
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            pmd.initialise(clr);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                try {
                    this.initialiseClassMetaData(cmd, clr.classForName(cmd.getFullClassName(), primary), clr);
                    continue;
                }
                catch (NucleusException ne) {
                    throw ne;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData imd = pmd.getInterface(j);
                try {
                    this.initialiseInterfaceMetaData(imd, clr, primary);
                    continue;
                }
                catch (NucleusException jpex) {
                    throw jpex;
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseClassMetaData(ClassMetaData cmd, Class cls, ClassLoaderResolver clr) {
        ClassMetaData classMetaData = cmd;
        synchronized (classMetaData) {
            if (this.getOMFContext().getContext() == 1 && cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE && !this.getOMFContext().getApiAdapter().isPersistable(cls)) {
                throw new NucleusUserException(LOCALISER.msg("044059", (Object)cls.getName()));
            }
            this.populateAbstractClassMetaData(cmd, clr, cls.getClassLoader());
            this.initialiseAbstractClassMetaData(cmd, clr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseInterfaceMetaData(InterfaceMetaData imd, ClassLoaderResolver clr, ClassLoader primary) {
        InterfaceMetaData interfaceMetaData = imd;
        synchronized (interfaceMetaData) {
            this.populateAbstractClassMetaData(imd, clr, primary);
            this.initialiseAbstractClassMetaData(imd, clr);
        }
    }

    protected FileMetaData loadAnnotationsForClass(Class cls, ClassLoaderResolver clr, boolean register, boolean populate) {
        if (this.isClassWithoutPersistenceInfo(cls.getName())) {
            return null;
        }
        String clsPackageName = ClassUtils.getPackageNameForClass(cls);
        if (clsPackageName == null) {
            return null;
        }
        FileMetaData filemd = new FileMetaData();
        filemd.setType(MetadataFileType.ANNOTATIONS);
        filemd.setMetaDataManager(this);
        PackageMetaData pmd = filemd.newPackageMetadata(clsPackageName);
        AbstractClassMetaData cmd = this.annotationManager.getMetaDataForClass(cls, pmd, clr);
        if (cmd != null) {
            if (register) {
                this.registerFile("annotations:" + cls.getName(), filemd, clr);
                if (populate) {
                    this.populateFileMetaData(filemd, clr, cls.getClassLoader());
                }
            }
            return filemd;
        }
        return null;
    }

    protected void populateAbstractClassMetaData(final AbstractClassMetaData acmd, final ClassLoaderResolver clr, final ClassLoader loader) {
        if (!acmd.isPopulated() && !acmd.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        acmd.populate(clr, loader);
                    }
                    catch (NucleusException ne) {
                        throw ne;
                    }
                    catch (Exception e) {
                        throw new NucleusUserException("Exception during population of metadata for " + acmd.getFullClassName(), e);
                    }
                    return null;
                }
            });
        }
    }

    protected void initialiseAbstractClassMetaData(final AbstractClassMetaData acmd, final ClassLoaderResolver clr) {
        if (!acmd.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        acmd.initialise(clr);
                    }
                    catch (NucleusException ne) {
                        throw ne;
                    }
                    catch (Exception e) {
                        throw new NucleusUserException("Exception during initialisation of metadata for " + acmd.getFullClassName(), e);
                    }
                    return null;
                }
            });
        }
    }

    public List<AbstractClassMetaData> getReferencedClasses(String[] classNames, ClassLoaderResolver clr) {
        ArrayList<AbstractClassMetaData> cmds = new ArrayList<AbstractClassMetaData>();
        for (int i = 0; i < classNames.length; ++i) {
            Class cls = null;
            try {
                cls = clr.classForName(classNames[i]);
                if (cls.isInterface()) continue;
                AbstractClassMetaData cmd = this.getMetaDataForClass(classNames[i], clr);
                if (cmd == null) {
                    NucleusLogger.DATASTORE.warn("Class Invalid " + classNames[i]);
                    throw new NoPersistenceInformationException(classNames[i]);
                }
                cmds.addAll(this.getReferencedClassMetaData(cmd, clr));
                continue;
            }
            catch (ClassNotResolvedException cnre) {
                NucleusLogger.DATASTORE.warn("Class " + classNames[i] + " not found so being ignored");
            }
        }
        return cmds;
    }

    protected List<AbstractClassMetaData> getReferencedClassMetaData(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        ArrayList<AbstractClassMetaData> orderedCMDs = new ArrayList<AbstractClassMetaData>();
        HashSet referencedCMDs = new HashSet();
        cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr);
        return orderedCMDs;
    }

    private class InterfaceClassComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null || o2 == null) {
                return Integer.MIN_VALUE;
            }
            Class cls1 = (Class)o1;
            Class cls2 = (Class)o2;
            return cls1.hashCode() - cls2.hashCode();
        }
    }
}

