/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class InterfaceMetaData
extends AbstractClassMetaData {
    public InterfaceMetaData(PackageMetaData parent, String name) {
        super(parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise(ClassLoaderResolver clr) {
        if (this.populating || this.initialising) {
            return;
        }
        try {
            int i;
            this.initialising = true;
            this.checkPopulated();
            if (this.isInitialised()) {
                Object var9_2 = null;
                this.initialising = false;
                return;
            }
            if (this.pcSuperclassMetaData != null && !this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.initialise(clr);
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(LOCALISER.msg("044076", (Object)this.fullName));
            }
            this.validateObjectIdClass(clr);
            Iterator fields_iter = this.members.iterator();
            int no_of_managed_fields = 0;
            int no_of_overridden_fields = 0;
            while (fields_iter.hasNext()) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)fields_iter.next();
                fmd.initialise(clr);
                if (!fmd.isJdoField()) continue;
                if (fmd.fieldBelongsToClass()) {
                    ++no_of_managed_fields;
                    continue;
                }
                ++no_of_overridden_fields;
            }
            this.managedMembers = new AbstractMemberMetaData[no_of_managed_fields];
            this.overriddenMembers = new AbstractMemberMetaData[no_of_overridden_fields];
            fields_iter = this.members.iterator();
            int field_id = 0;
            int overridden_field_id = 0;
            this.memberPositionsByName = new HashMap();
            while (fields_iter.hasNext()) {
                AbstractMemberMetaData fmd = (AbstractMemberMetaData)fields_iter.next();
                if (!fmd.isJdoField()) continue;
                if (fmd.fieldBelongsToClass()) {
                    fmd.setFieldId(field_id);
                    this.managedMembers[field_id] = fmd;
                    this.memberPositionsByName.put(fmd.getName(), new Integer(field_id));
                    ++field_id;
                    continue;
                }
                this.overriddenMembers[overridden_field_id++] = fmd;
            }
            if (this.pcSuperclassMetaData != null) {
                if (!this.pcSuperclassMetaData.isInitialised()) {
                    this.pcSuperclassMetaData.initialise(clr);
                }
                this.noOfInheritedManagedMembers = this.pcSuperclassMetaData.getNoOfInheritedManagedMembers() + this.pcSuperclassMetaData.getNoOfManagedMembers();
            }
            this.initialiseMemberPositionInformation();
            this.joinMetaData = new JoinMetaData[this.joins.size()];
            for (i = 0; i < this.joinMetaData.length; ++i) {
                this.joinMetaData[i] = (JoinMetaData)this.joins.get(i);
                this.joinMetaData[i].initialise(clr);
            }
            this.indexMetaData = new IndexMetaData[this.indexes.size()];
            for (i = 0; i < this.indexMetaData.length; ++i) {
                this.indexMetaData[i] = (IndexMetaData)this.indexes.get(i);
                this.indexMetaData[i].initialise(clr);
            }
            this.foreignKeyMetaData = new ForeignKeyMetaData[this.foreignKeys.size()];
            for (i = 0; i < this.foreignKeyMetaData.length; ++i) {
                this.foreignKeyMetaData[i] = (ForeignKeyMetaData)this.foreignKeys.get(i);
                this.foreignKeyMetaData[i].initialise(clr);
            }
            this.uniqueMetaData = new UniqueMetaData[this.uniqueConstraints.size()];
            for (i = 0; i < this.uniqueMetaData.length; ++i) {
                this.uniqueMetaData[i] = (UniqueMetaData)this.uniqueConstraints.get(i);
                this.uniqueMetaData[i].initialise(clr);
            }
            this.fetchGroupMetaData = new FetchGroupMetaData[this.fetchGroups.size()];
            this.fetchGroupMetaDataByName = new HashMap();
            for (i = 0; i < this.fetchGroupMetaData.length; ++i) {
                this.fetchGroupMetaData[i] = (FetchGroupMetaData)this.fetchGroups.get(i);
                this.fetchGroupMetaData[i].initialise(clr);
                this.fetchGroupMetaDataByName.put(this.fetchGroupMetaData[i].getName(), this.fetchGroupMetaData[i]);
            }
            if (this.identityType == IdentityType.DATASTORE && this.identityMetaData == null) {
                if (this.pcSuperclassMetaData != null) {
                    IdentityMetaData superImd = this.pcSuperclassMetaData.getIdentityMetaData();
                    this.identityMetaData = new IdentityMetaData();
                    this.identityMetaData.setColumnName(superImd.getColumnName());
                    this.identityMetaData.setValueStrategy(superImd.getValueStrategy());
                    this.identityMetaData.setSequence(superImd.getSequence());
                } else {
                    this.identityMetaData = new IdentityMetaData();
                }
            }
            if (this.versionMetaData != null) {
                this.versionMetaData.initialise(clr);
            }
            if (this.identityMetaData != null) {
                this.identityMetaData.initialise(clr);
            }
            if (this.inheritanceMetaData != null) {
                this.inheritanceMetaData.initialise(clr);
            }
            if (this.identityType == IdentityType.APPLICATION) {
                this.usesSingleFieldIdentityClass = this.getMetaDataManager().getApiAdapter().isSingleFieldIdentityClass(this.getObjectidClass());
            }
            this.joins.clear();
            this.joins = null;
            this.fetchGroups.clear();
            this.fetchGroups = null;
            this.foreignKeys.clear();
            this.foreignKeys = null;
            this.indexes.clear();
            this.indexes = null;
            this.uniqueConstraints.clear();
            this.uniqueConstraints = null;
            this.setInitialised();
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            this.initialising = false;
            throw throwable;
        }
        Object var9_3 = null;
        this.initialising = false;
    }

    public synchronized void populate(ClassLoaderResolver clr, ClassLoader primary) {
        if (this.isInitialised() || this.isPopulated()) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044068", (Object)this.name));
            throw new NucleusException(LOCALISER.msg("044068", (Object)this.fullName)).setFatal();
        }
        if (this.populating) {
            return;
        }
        try {
            try {
                if (NucleusLogger.METADATA.isDebugEnabled()) {
                    NucleusLogger.METADATA.debug(LOCALISER.msg("044075", (Object)this.fullName));
                }
                this.populating = true;
                Class cls = this.loadClass(clr, primary);
                if (!this.isMetaDataComplete()) {
                    this.getMetaDataManager().addAnnotationsDataToClass(cls, this, clr);
                }
                this.getMetaDataManager().addORMDataToClass(cls, clr);
                if (ClassUtils.isInnerClass(this.fullName) && !Modifier.isStatic(cls.getModifiers()) && this.persistenceModifier == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                    throw new InvalidMetaDataException(LOCALISER, "044063", (Object)this.fullName);
                }
                this.determineSuperClassName(clr, cls);
                this.inheritIdentity();
                this.determineIdentity();
                this.validateUserInputForIdentity();
                this.addMetaDataForMembersNotInMetaData(cls);
                if (this.objectidClass == null) {
                    this.populatePropertyMetaData(clr, cls, true, primary);
                    this.determineObjectIdClass();
                    this.populatePropertyMetaData(clr, cls, false, primary);
                } else {
                    this.populatePropertyMetaData(clr, cls, true, primary);
                    this.populatePropertyMetaData(clr, cls, false, primary);
                    this.determineObjectIdClass();
                }
                this.validateUserInputForInheritanceMetaData();
                this.determineInheritanceMetaData();
                this.setPopulated();
            }
            catch (RuntimeException e) {
                NucleusLogger.METADATA.debug(e);
                throw e;
            }
            Object var5_5 = null;
            this.populating = false;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.populating = false;
            throw throwable;
        }
    }

    protected AbstractMemberMetaData newDefaultedProperty(String name) {
        return new PropertyMetaData((MetaData)this, name);
    }

    protected void populatePropertyMetaData(ClassLoaderResolver clr, Class cls, boolean pkFields, ClassLoader primary) {
        Collections.sort(this.members);
        for (AbstractMemberMetaData fmd : this.members) {
            if (pkFields != fmd.isPrimaryKey()) continue;
            Class fieldCls = cls;
            if (!fmd.fieldBelongsToClass()) {
                try {
                    fieldCls = clr.classForName(fmd.getClassName(), primary);
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClassName = this.getPackageName() + "." + fmd.getClassName();
                    try {
                        fieldCls = clr.classForName(fieldClassName, primary);
                        fmd.setClassName(fieldClassName);
                    }
                    catch (ClassNotResolvedException cnre2) {
                        NucleusLogger.METADATA.error(LOCALISER.msg("044080", (Object)fieldClassName));
                        throw new InvalidMetaDataException(LOCALISER, "044080", (Object)fieldClassName);
                    }
                }
            }
            Method cls_method = null;
            try {
                try {
                    cls_method = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fmd.getName(), true), new Class[0]);
                }
                catch (Exception e) {
                    cls_method = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(fmd.getName(), false), new Class[0]);
                }
            }
            catch (Exception e) {
                throw new InvalidMetaDataException(LOCALISER, "044072", (Object)this.fullName, fmd.getFullFieldName());
            }
            fmd.populate(clr, null, cls_method, primary);
        }
    }

    protected void addMetaDataForMembersNotInMetaData(Class cls) {
        Collections.sort(this.members);
        try {
            Method[] clsMethods = cls.getDeclaredMethods();
            block2: for (int i = 0; i < clsMethods.length; ++i) {
                String fieldName;
                if (!clsMethods[i].getDeclaringClass().getName().equals(this.fullName) || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || ClassUtils.isInnerClass(clsMethods[i].getName()) || Modifier.isStatic(clsMethods[i].getModifiers()) || Collections.binarySearch(this.members, fieldName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName())) >= 0) continue;
                String setterName = ClassUtils.getJavaBeanSetterName(fieldName);
                for (int j = 0; j < clsMethods.length; ++j) {
                    if (!clsMethods[j].getName().equals(setterName)) continue;
                    NucleusLogger.METADATA.debug(LOCALISER.msg("044060", (Object)fieldName, (Object)this.name));
                    AbstractMemberMetaData mmd = this.newDefaultedProperty(fieldName);
                    this.members.add(mmd);
                    Collections.sort(this.members);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            NucleusLogger.METADATA.error(e.getMessage(), e);
            throw new NucleusUserException(e.getMessage());
        }
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<interface name=\"" + this.name + "\"\n");
        if (this.identityType != null) {
            sb.append(prefix).append("       identity-type=\"" + this.identityType + "\"\n");
        }
        if (this.objectidClass != null) {
            sb.append(prefix).append("       objectid-class=\"" + this.objectidClass + "\"\n");
        }
        if (!this.requiresExtent) {
            sb.append(prefix).append("       requires-extent=\"false\"");
        }
        if (this.embeddedOnly) {
            sb.append(prefix).append("       embedded-only=\"true\"\n");
        }
        if (this.detachable) {
            sb.append(prefix).append("       detachable=\"true\"\n");
        }
        if (this.table != null) {
            sb.append(prefix).append("       table=\"" + this.table + "\"\n");
        }
        sb.append(">\n");
        if (this.identityMetaData != null) {
            sb.append(this.identityMetaData.toString(prefix + indent, indent));
        }
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.inheritanceMetaData != null) {
            sb.append(this.inheritanceMetaData.toString(prefix + indent, indent));
        }
        if (this.versionMetaData != null) {
            sb.append(this.versionMetaData.toString(prefix + indent, indent));
        }
        if (this.joins != null) {
            for (i = 0; i < this.joins.size(); ++i) {
                JoinMetaData jmd = (JoinMetaData)this.joins.get(i);
                sb.append(jmd.toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeys != null) {
            for (i = 0; i < this.foreignKeys.size(); ++i) {
                ForeignKeyMetaData fkmd = (ForeignKeyMetaData)this.foreignKeys.get(i);
                sb.append(fkmd.toString(prefix + indent, indent));
            }
        }
        if (this.indexes != null) {
            for (i = 0; i < this.indexes.size(); ++i) {
                IndexMetaData imd = (IndexMetaData)this.indexes.get(i);
                sb.append(imd.toString(prefix + indent, indent));
            }
        }
        if (this.uniqueConstraints != null) {
            for (i = 0; i < this.uniqueConstraints.size(); ++i) {
                UniqueMetaData unimd = (UniqueMetaData)this.uniqueConstraints.get(i);
                sb.append(unimd.toString(prefix + indent, indent));
            }
        }
        if (this.members != null) {
            for (i = 0; i < this.members.size(); ++i) {
                PropertyMetaData pmd = (PropertyMetaData)this.members.get(i);
                sb.append(pmd.toString(prefix + indent, indent));
            }
        }
        if (this.queries != null) {
            for (QueryMetaData q : this.queries) {
                sb.append(q.toString(prefix + indent, indent));
            }
        }
        if (this.fetchGroups != null) {
            for (int i2 = 0; i2 < this.fetchGroups.size(); ++i2) {
                FetchGroupMetaData fgmd = (FetchGroupMetaData)this.fetchGroups.get(i2);
                sb.append(fgmd.toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</interface>\n");
        return sb.toString();
    }
}

