/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datanucleus.query.expression.CastExpression;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.node.ParameterNode;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionCompiler {
    SymbolTable symtbl;

    public void setSymbolTable(SymbolTable symtbl) {
        this.symtbl = symtbl;
    }

    public Expression compileOrderExpression(Node node) {
        if (this.isOperator(node, "order")) {
            if (node.getChildNodes().size() > 1) {
                return new OrderExpression(this.symtbl, this.compileExpression(node.getFirstChild()), (String)node.getNextChild().getNodeValue());
            }
            if (node.getChildNodes().size() == 1) {
                return new OrderExpression(this.symtbl, this.compileExpression(node.getFirstChild()));
            }
        }
        return this.compileExpression(node.getFirstChild());
    }

    public Expression compileFromExpression(Node node) {
        if (node.getNodeType() == 6) {
            Node aliasNode = node.getFirstChild();
            ClassExpression clsExpr = new ClassExpression(this.symtbl, (String)aliasNode.getNodeValue());
            JoinExpression currentJoinExpr = null;
            for (Node childNode : node.getChildNodes()) {
                if (childNode.getNodeType() != 4) continue;
                String joinType = (String)childNode.getNodeValue();
                int joinTypeId = 0;
                if (joinType.equals("JOIN_INNER_FETCH")) {
                    joinTypeId = 2;
                } else if (joinType.equals("JOIN_OUTER_FETCH")) {
                    joinTypeId = 3;
                } else if (joinType.equals("JOIN_OUTER")) {
                    joinTypeId = 1;
                }
                Node joinedNode = childNode.getFirstChild();
                Node joinedAliasNode = childNode.getNextChild();
                PrimaryExpression primExpr = (PrimaryExpression)this.compilePrimaryExpression(joinedNode);
                JoinExpression joinExpr = new JoinExpression(this.symtbl, primExpr, (String)joinedAliasNode.getNodeValue(), joinTypeId);
                if (currentJoinExpr != null) {
                    currentJoinExpr.setJoinExpression(joinExpr);
                } else {
                    clsExpr.setJoinExpression(joinExpr);
                }
                currentJoinExpr = joinExpr;
            }
            return clsExpr;
        }
        return null;
    }

    public Expression compileExpression(Node node) {
        return this.compileConditionalOrExpression(node);
    }

    private Expression compileConditionalOrExpression(Node node) {
        if (this.isOperator(node, "||")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_OR, right);
        }
        return this.compileConditionalAndExpression(node);
    }

    private Expression compileConditionalAndExpression(Node node) {
        if (this.isOperator(node, "&&")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_AND, right);
        }
        return this.compileInclusiveOrExpression(node);
    }

    private Expression compileInclusiveOrExpression(Node node) {
        if (this.isOperator(node, "|")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_OR, right);
        }
        return this.compileExclusiveOrExpression(node);
    }

    private Expression compileExclusiveOrExpression(Node node) {
        if (this.isOperator(node, "^")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_OR, right);
        }
        return this.compileAndExpression(node);
    }

    private Expression compileAndExpression(Node node) {
        if (this.isOperator(node, "&")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_AND, right);
        }
        return this.compileRelationalExpression(node);
    }

    private Expression compileRelationalExpression(Node node) {
        if (this.isOperator(node, "==")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_EQ, right);
        }
        if (this.isOperator(node, "!=")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_NOTEQ, right);
        }
        if (this.isOperator(node, "LIKE")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_LIKE, right);
        }
        if (this.isOperator(node, "<=")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_LTEQ, right);
        }
        if (this.isOperator(node, ">=")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_GTEQ, right);
        }
        if (this.isOperator(node, "<")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_LT, right);
        }
        if (this.isOperator(node, ">")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_GT, right);
        }
        if (this.isOperator(node, "instanceof")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_IS, right);
        }
        return this.compileAdditiveExpression(node);
    }

    private Expression compileAdditiveExpression(Node node) {
        if (this.isOperator(node, "+")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_ADD, right);
        }
        if (this.isOperator(node, "-")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_SUB, right);
        }
        return this.compileMultiplicativeExpression(node);
    }

    private Expression compileMultiplicativeExpression(Node node) {
        if (this.isOperator(node, "*")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_MUL, right);
        }
        if (this.isOperator(node, "/")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_DIV, right);
        }
        if (this.isOperator(node, "%")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_MOD, right);
        }
        return this.compileUnaryExpression(node);
    }

    private Expression compileUnaryExpression(Node node) {
        if (this.isOperator(node, "NEG")) {
            Expression left = this.compileExpression(node.getFirstChild());
            return new DyadicExpression(Expression.OP_NEG, left);
        }
        return this.compileUnaryExpressionNotPlusMinus(node);
    }

    private Expression compileUnaryExpressionNotPlusMinus(Node node) {
        if (this.isOperator(node, "~")) {
            Expression left = this.compileExpression(node.getFirstChild());
            return new DyadicExpression(Expression.OP_COM, left);
        }
        if (this.isOperator(node, "!")) {
            Expression left = this.compileExpression(node.getFirstChild());
            return new DyadicExpression(Expression.OP_NOT, left);
        }
        if (this.isOperator(node, "DISTINCT")) {
            Expression left = this.compileExpression(node.getFirstChild());
            return new DyadicExpression(Expression.OP_DISTINCT, left);
        }
        return this.compilePrimaryExpression(node);
    }

    private Expression compilePrimaryExpression(Node node) {
        if (node.getNodeType() == 3) {
            Node currentNode = node;
            ArrayList<Object> tupple = new ArrayList<Object>();
            Expression currentExpr = null;
            while (currentNode != null) {
                tupple.add(currentNode.getNodeValue());
                if (currentNode.getNodeType() == 1) {
                    if (currentExpr == null && tupple.size() > 1) {
                        currentExpr = new PrimaryExpression(this.symtbl, tupple.subList(0, tupple.size() - 1));
                    }
                    String methodName = (String)tupple.get(tupple.size() - 1);
                    List<Expression> parameterExprs = this.getExpressionsForPropertiesOfNode(currentNode);
                    currentExpr = new InvokeExpression(this.symtbl, currentExpr, methodName, parameterExprs);
                    currentNode = currentNode.getFirstChild();
                    tupple = new ArrayList();
                    continue;
                }
                if (currentNode.getNodeType() == 8) {
                    if (currentExpr == null && tupple.size() > 1) {
                        currentExpr = new PrimaryExpression(this.symtbl, tupple.subList(0, tupple.size() - 1));
                    }
                    String className = (String)tupple.get(tupple.size() - 1);
                    currentExpr = new CastExpression(this.symtbl, currentExpr, className);
                    currentNode = currentNode.getFirstChild();
                    tupple = new ArrayList();
                    continue;
                }
                currentNode = currentNode.getFirstChild();
            }
            if (currentExpr != null && tupple.size() > 0) {
                currentExpr = new PrimaryExpression(this.symtbl, currentExpr, tupple);
            }
            if (currentExpr == null) {
                PrimaryExpression expr = new PrimaryExpression(this.symtbl, tupple);
                Symbol sym = this.symtbl.getSymbol(expr.getId());
                if (sym != null) {
                    if (sym.getType() == 1) {
                        return new ParameterExpression(this.symtbl, expr.getId(), -1);
                    }
                    if (sym.getType() == 2) {
                        return new VariableExpression(this.symtbl, expr.getId());
                    }
                }
                return expr;
            }
            return currentExpr;
        }
        if (node.getNodeType() == 7) {
            Object val = node.getNodeValue();
            if (val instanceof Integer) {
                return new ParameterExpression(this.symtbl, "" + node.getNodeValue(), ((ParameterNode)node).getPosition());
            }
            return new ParameterExpression(this.symtbl, (String)node.getNodeValue(), ((ParameterNode)node).getPosition());
        }
        if (node.getNodeType() == 1) {
            Node currentNode = node;
            ArrayList<Object> tupple = new ArrayList<Object>();
            InvokeExpression currentExpr = null;
            while (currentNode != null) {
                tupple.add(currentNode.getNodeValue());
                if (currentNode.getNodeType() == 1) {
                    String methodName = (String)tupple.get(tupple.size() - 1);
                    List<Expression> parameterExprs = this.getExpressionsForPropertiesOfNode(currentNode);
                    currentExpr = new InvokeExpression(this.symtbl, currentExpr, methodName, parameterExprs);
                    if ((currentNode = currentNode.getFirstChild()) == null) continue;
                    tupple = new ArrayList();
                    tupple.add(currentExpr);
                    continue;
                }
                currentNode = currentNode.getFirstChild();
            }
            return currentExpr;
        }
        if (node.getNodeType() == 5) {
            Node currentNode;
            ArrayList<Object> tupple = new ArrayList<Object>();
            boolean method = false;
            for (currentNode = node.getFirstChild(); currentNode != null; currentNode = currentNode.getFirstChild()) {
                tupple.add(currentNode.getNodeValue());
                if (currentNode.getNodeType() != 1) continue;
                method = true;
                break;
            }
            List<Expression> parameterExprs = null;
            parameterExprs = method ? this.getExpressionsForPropertiesOfNode(currentNode) : new ArrayList<Expression>();
            return new CreatorExpression(this.symtbl, tupple, parameterExprs);
        }
        if (node.getNodeType() == 0) {
            return new Literal(node.getNodeValue());
        }
        return null;
    }

    private List<Expression> getExpressionsForPropertiesOfNode(Node node) {
        if (node.hasProperties()) {
            ArrayList<Expression> parameterExprs = new ArrayList<Expression>();
            List propNodes = node.getProperties();
            for (int i = 0; i < propNodes.size(); ++i) {
                parameterExprs.add(this.compileExpression((Node)propNodes.get(i)));
            }
            return parameterExprs;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isOperator(Node node, String operator) {
        return node.getNodeType() == 4 && node.getNodeValue().equals(operator);
    }
}

