/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.JDK14Logger;
import org.datanucleus.util.Log4JLogger;
import org.datanucleus.util.NullLogger;

public abstract class NucleusLogger {
    private static Class LOGGER_CLASS = null;
    public static final NucleusLogger JDO;
    public static final NucleusLogger JPA;
    public static final NucleusLogger PERSISTENCE;
    public static final NucleusLogger LIFECYCLE;
    public static final NucleusLogger QUERY;
    public static final NucleusLogger REACHABILITY;
    public static final NucleusLogger METADATA;
    public static final NucleusLogger MANAGEMENT;
    public static final NucleusLogger CACHE;
    public static final NucleusLogger GENERAL;
    public static final NucleusLogger TRANSACTION;
    public static final NucleusLogger CONNECTION;
    public static final NucleusLogger CLASSLOADING;
    public static final NucleusLogger PLUGIN;
    public static final NucleusLogger VALUEGENERATION;
    public static final NucleusLogger NAMING;
    public static final NucleusLogger DATASTORE;
    public static final NucleusLogger DATASTORE_PERSIST;
    public static final NucleusLogger DATASTORE_RETRIEVE;
    public static final NucleusLogger DATASTORE_SCHEMA;
    public static final NucleusLogger JCA;

    public static NucleusLogger getLoggerInstance(String logCategory) {
        return (NucleusLogger)ClassUtils.newInstance(LOGGER_CLASS, new Class[]{String.class}, new Object[]{logCategory});
    }

    public abstract void debug(Object var1);

    public abstract void debug(Object var1, Throwable var2);

    public abstract void info(Object var1);

    public abstract void info(Object var1, Throwable var2);

    public abstract void warn(Object var1);

    public abstract void warn(Object var1, Throwable var2);

    public abstract void error(Object var1);

    public abstract void error(Object var1, Throwable var2);

    public abstract void fatal(Object var1);

    public abstract void fatal(Object var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    static {
        Class loggerClass = NullLogger.class;
        try {
            NucleusLogger.class.getClassLoader().loadClass("org.apache.log4j.Logger");
            loggerClass = Log4JLogger.class;
        }
        catch (Exception e) {
            loggerClass = JDK14Logger.class;
        }
        LOGGER_CLASS = loggerClass;
        JDO = NucleusLogger.getLoggerInstance("DataNucleus.JDO");
        JPA = NucleusLogger.getLoggerInstance("DataNucleus.JPA");
        PERSISTENCE = NucleusLogger.getLoggerInstance("DataNucleus.Persistence");
        LIFECYCLE = NucleusLogger.getLoggerInstance("DataNucleus.Lifecycle");
        QUERY = NucleusLogger.getLoggerInstance("DataNucleus.Query");
        REACHABILITY = NucleusLogger.getLoggerInstance("DataNucleus.Reachability");
        METADATA = NucleusLogger.getLoggerInstance("DataNucleus.MetaData");
        CACHE = NucleusLogger.getLoggerInstance("DataNucleus.Cache");
        GENERAL = NucleusLogger.getLoggerInstance("DataNucleus.General");
        TRANSACTION = NucleusLogger.getLoggerInstance("DataNucleus.Transaction");
        PLUGIN = NucleusLogger.getLoggerInstance("DataNucleus.Plugin");
        VALUEGENERATION = NucleusLogger.getLoggerInstance("DataNucleus.Store.Poid");
        CLASSLOADING = NucleusLogger.getLoggerInstance("DataNucleus.ClassLoading");
        NAMING = NucleusLogger.getLoggerInstance("DataNucleus.Naming");
        MANAGEMENT = NucleusLogger.getLoggerInstance("DataNucleus.Management");
        CONNECTION = NucleusLogger.getLoggerInstance("DataNucleus.Connection");
        DATASTORE = NucleusLogger.getLoggerInstance("DataNucleus.Datastore");
        DATASTORE_PERSIST = NucleusLogger.getLoggerInstance("DataNucleus.Datastore.Persist");
        DATASTORE_RETRIEVE = NucleusLogger.getLoggerInstance("DataNucleus.Datastore.Retrieve");
        DATASTORE_SCHEMA = NucleusLogger.getLoggerInstance("DataNucleus.Datastore.Schema");
        JCA = NucleusLogger.getLoggerInstance("DataNucleus.JCA");
    }
}

