/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;

public class QueryCompiler {
    public static final int COMPILE_EXPLICIT_PARAMETERS = 1;
    public static final int COMPILE_EXPLICIT_VARIABLES = 2;
    public static final int COMPILE_SYNTAX = 3;
    public static final int COMPILE_EXECUTION = 4;
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected String language;
    protected Query query;
    protected Imports imports;
    protected Map parameters;
    protected boolean executionCompile = true;
    protected Class candidateClass = null;
    protected String candidateAlias = "this";
    protected List<String> parameterNames = null;
    protected Map<String, Class> parameterTypesByName = null;
    protected List<String> variableNames = null;
    protected Map<String, Class> variableTypesByName = null;

    public QueryCompiler(Query query, Imports imports, Map parameters) {
        this.query = query;
        this.imports = imports;
        this.parameters = parameters;
        this.candidateClass = query.getCandidateClass();
    }

    public void close() {
        this.query = null;
        this.imports = null;
        this.variableNames = null;
        this.parameterNames = null;
        this.variableTypesByName = null;
        this.parameterTypesByName = null;
        this.parameters = null;
    }

    public Object compile(int type) {
        switch (type) {
            case 1: {
                this.compileExplicitParameters();
                return null;
            }
            case 2: {
                this.compileExplicitVariables();
                return null;
            }
        }
        throw new NucleusException("Query Compiler doesnt support compilation of type " + type);
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public String getCandidateAlias() {
        return this.candidateAlias;
    }

    public String[] getParameterNames() {
        if (this.parameterNames == null) {
            return null;
        }
        return this.parameterNames.toArray(new String[this.parameterNames.size()]);
    }

    public Map getParameterTypesByName() {
        return this.parameterTypesByName;
    }

    protected void compileExplicitParameters() {
        this.parameterNames = new ArrayList<String>();
        this.parameterTypesByName = new HashMap<String, Class>();
        String explicitParameters = this.query.getExplicitParameters();
        if (explicitParameters != null && explicitParameters.length() > 0) {
            StringTokenizer t1 = new StringTokenizer(explicitParameters, ",");
            while (t1.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(t1.nextToken(), " ");
                if (t2.countTokens() != 2) {
                    throw new NucleusUserException(LOCALISER.msg("021101", (Object)explicitParameters));
                }
                String classDecl = t2.nextToken();
                String parameterName = t2.nextToken();
                if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL(parameterName)) {
                    throw new NucleusUserException(LOCALISER.msg("021102", (Object)parameterName));
                }
                if (this.parameterNames.contains(parameterName)) {
                    throw new NucleusUserException(LOCALISER.msg("021103", (Object)parameterName));
                }
                this.parameterNames.add(parameterName);
                this.parameterTypesByName.put(parameterName, this.query.resolveClassDeclaration(classDecl));
            }
        }
    }

    protected void compileExplicitVariables() {
        this.variableNames = new ArrayList<String>();
        this.variableTypesByName = new HashMap<String, Class>();
        String explicitVariables = this.query.getExplicitVariables();
        if (explicitVariables != null && explicitVariables.length() > 0) {
            StringTokenizer t1 = new StringTokenizer(explicitVariables, ";");
            while (t1.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(t1.nextToken(), " ");
                if (t2.countTokens() != 2) {
                    throw new NucleusUserException(LOCALISER.msg("021104", (Object)explicitVariables));
                }
                String classDecl = t2.nextToken();
                String variableName = t2.nextToken();
                if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL(variableName)) {
                    throw new NucleusUserException(LOCALISER.msg("021105", (Object)variableName));
                }
                if (this.parameterNames.contains(variableName)) {
                    throw new NucleusUserException(LOCALISER.msg("021106", (Object)variableName));
                }
                if (this.variableNames.contains(variableName)) {
                    throw new NucleusUserException(LOCALISER.msg("021107", (Object)variableName));
                }
                this.variableNames.add(variableName);
                this.variableTypesByName.put(variableName, this.query.resolveClassDeclaration(classDecl));
            }
        }
    }
}

