/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;

public class KeyMetaData
extends AbstractElementMetaData {
    public KeyMetaData(KeyMetaData kmd) {
        super(kmd);
    }

    public KeyMetaData() {
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary) {
        AbstractMemberMetaData fmd = (AbstractMemberMetaData)this.parent;
        if (fmd.getMap() == null) {
            throw new NucleusUserException("The field " + fmd.getFullFieldName() + " is defined with <key>, however no <map> definition was found.").setFatal();
        }
        fmd.getMap().key.populate(fmd.getAbstractClassMetaData().getPackageName(), clr, primary);
        String keyType = fmd.getMap().getKeyType();
        Class keyTypeClass = null;
        try {
            keyTypeClass = clr.classForName(keyType, primary);
        }
        catch (ClassNotResolvedException cnre) {
            throw new InvalidMetaDataException(LOCALISER, "044147", (Object)fmd.getFullFieldName(), (Object)fmd.getClassName(false), keyType);
        }
        if (this.embeddedMetaData != null && (keyTypeClass.isInterface() || keyTypeClass.getName().equals("java.lang.Object"))) {
            throw new InvalidMetaDataException(LOCALISER, "044152", (Object)fmd.getFullFieldName(), keyTypeClass.getName());
        }
        if (this.embeddedMetaData == null && ((AbstractMemberMetaData)this.parent).hasMap() && ((AbstractMemberMetaData)this.parent).getMap().isEmbeddedKey() && ((AbstractMemberMetaData)this.parent).getJoinMetaData() != null && ((AbstractMemberMetaData)this.parent).getMap().getKeyClassMetaData() != null) {
            this.embeddedMetaData = new EmbeddedMetaData();
            this.embeddedMetaData.parent = this;
        }
        super.populate(clr, primary);
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<key");
        if (this.mappedBy != null) {
            sb.append(" mapped-by=\"" + this.mappedBy + "\"");
        }
        if (this.columnName != null) {
            sb.append("\n");
            sb.append(prefix).append("     column=\"" + this.columnName + "\"");
        }
        sb.append(">\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnMetaData colmd = (ColumnMetaData)this.columns.get(i);
            sb.append(colmd.toString(prefix + indent, indent));
        }
        if (this.indexMetaData != null) {
            sb.append(this.indexMetaData.toString(prefix + indent, indent));
        }
        if (this.uniqueMetaData != null) {
            sb.append(this.uniqueMetaData.toString(prefix + indent, indent));
        }
        if (this.embeddedMetaData != null) {
            sb.append(this.embeddedMetaData.toString(prefix + indent, indent));
        }
        if (this.foreignKeyMetaData != null) {
            sb.append(this.foreignKeyMetaData.toString(prefix + indent, indent));
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</key>\n");
        return sb.toString();
    }
}

